/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.mtl;

import com.sun.glass.ui.Screen;
import com.sun.glass.utils.NativeLibLoader;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.ResourceFactory;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.mtl.MTLLog;
import com.sun.prism.mtl.MTLResourceFactory;
import java.security.AccessController;
import java.util.HashMap;
import java.util.List;

public class MTLPipeline
extends GraphicsPipeline {
    private static MTLPipeline theInstance;
    private static MTLResourceFactory mtlResourceFactory;

    private MTLPipeline() {
    }

    public static MTLPipeline getInstance() {
        MTLLog.Debug("MTLPipeline.getInstance()");
        return theInstance;
    }

    @Override
    public boolean init() {
        MTLLog.Debug("MTLPipeline.init()");
        HashMap hashMap = new HashMap();
        this.setDeviceDetails(hashMap);
        return true;
    }

    @Override
    public int getAdapterOrdinal(Screen screen) {
        return 0;
    }

    @Override
    public ResourceFactory getDefaultResourceFactory(List<Screen> list) {
        return this.getResourceFactory(Screen.getMainScreen());
    }

    @Override
    public ResourceFactory getResourceFactory(Screen screen) {
        if (mtlResourceFactory == null) {
            mtlResourceFactory = new MTLResourceFactory(screen);
            HashMap hashMap = (HashMap)MTLPipeline.getInstance().getDeviceDetails();
            hashMap.put("mtlCommandQueue", mtlResourceFactory.getContext().getMetalCommandQueue());
        }
        return mtlResourceFactory;
    }

    @Override
    public void dispose() {
        if (mtlResourceFactory != null) {
            mtlResourceFactory.dispose();
            mtlResourceFactory = null;
        }
        super.dispose();
    }

    @Override
    public boolean is3DSupported() {
        return true;
    }

    @Override
    public final boolean isMSAASupported() {
        return true;
    }

    @Override
    public boolean isVsyncSupported() {
        return true;
    }

    @Override
    public boolean supportsShaderType(GraphicsPipeline.ShaderType shaderType) {
        switch (shaderType) {
            case MSL: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsShaderModel(GraphicsPipeline.ShaderModel shaderModel) {
        switch (shaderModel) {
            case SM3: {
                return true;
            }
        }
        return false;
    }

    static {
        AccessController.doPrivileged(() -> {
            String string = "prism_mtl";
            if (PrismSettings.verbose) {
                MTLLog.Debug("Loading native metal library, named: " + string);
            }
            NativeLibLoader.loadLibrary(string);
            if (PrismSettings.verbose) {
                MTLLog.Debug("Succeeded: Loading native metal library.");
            }
            theInstance = new MTLPipeline();
            return null;
        });
    }
}

