/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.mtl;

import com.sun.glass.ui.Screen;
import com.sun.prism.Graphics;
import com.sun.prism.Image;
import com.sun.prism.MediaFrame;
import com.sun.prism.PixelFormat;
import com.sun.prism.RTTexture;
import com.sun.prism.ReadbackRenderTarget;
import com.sun.prism.Texture;
import com.sun.prism.mtl.MTLContext;
import com.sun.prism.mtl.MTLFBOTextureData;
import com.sun.prism.mtl.MTLGraphics;
import com.sun.prism.mtl.MTLLog;
import com.sun.prism.mtl.MTLRTTextureData;
import com.sun.prism.mtl.MTLTexture;
import com.sun.prism.mtl.MTLTextureData;
import com.sun.prism.mtl.MTLTextureResource;
import java.nio.Buffer;
import java.nio.IntBuffer;

public class MTLRTTexture
extends MTLTexture<MTLTextureData>
implements RTTexture,
ReadbackRenderTarget {
    private int[] pixels;
    private int rttWidth;
    private int rttHeight;
    private long nTexPtr;
    private boolean opaque;
    private boolean MSAA;

    private MTLRTTexture(MTLContext mTLContext, MTLTextureResource<MTLTextureData> mTLTextureResource, Texture.WrapMode wrapMode, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        super(mTLContext, mTLTextureResource, PixelFormat.BYTE_BGRA_PRE, wrapMode, n, n2, n3, n4, n5, n6, n7, n8, false);
        this.rttWidth = n5;
        this.rttHeight = n6;
        this.pixels = new int[this.rttWidth * this.rttHeight];
        this.nTexPtr = ((MTLTextureData)mTLTextureResource.getResource()).getResource();
        this.opaque = false;
        this.MSAA = bl;
        MTLRTTexture.nInitRTT(this.nTexPtr, this.pixels);
        MTLLog.Debug("MTLRTTexture(): context = " + String.valueOf(mTLContext) + ", resource = " + String.valueOf(mTLTextureResource) + ", wrapMode = " + String.valueOf((Object)wrapMode) + ", physicalWidth = " + n + ", physicalHeight = " + n2 + ", contentX = " + n3 + ", contentY = " + n4 + ", contentWidth = " + n5 + ", contentHeight = " + n6 + ", maxContentWidth = " + n7 + ", maxContentHeight = " + n8);
    }

    static MTLRTTexture create(MTLContext mTLContext, int n, int n2, int n3, int n4, Texture.WrapMode wrapMode, boolean bl, long l) {
        MTLLog.Debug("MTLRTTexture.create()  physicalWidth = " + n + ", physicalHeight = " + n2 + ", contentWidth = " + n3 + ", contentHeight = " + n4 + ", wrapMode = " + String.valueOf((Object)wrapMode) + ", msaa = " + bl);
        long l2 = MTLRTTexture.nCreateRT(mTLContext.getContextHandle(), n, n2, n3, n4, wrapMode, bl);
        MTLRTTextureData mTLRTTextureData = new MTLRTTextureData(mTLContext, l2, l);
        MTLTextureResource<MTLTextureData> mTLTextureResource = new MTLTextureResource<MTLTextureData>(mTLRTTextureData, true);
        return new MTLRTTexture(mTLContext, mTLTextureResource, wrapMode, n, n2, 0, 0, n3, n4, n3, n4, bl);
    }

    static MTLRTTexture create(MTLContext mTLContext, long l, int n, int n2, long l2) {
        long l3 = MTLRTTexture.nCreateRT2(mTLContext.getContextHandle(), l, n, n2);
        MTLFBOTextureData mTLFBOTextureData = new MTLFBOTextureData(mTLContext, l3, l2);
        MTLTextureResource<MTLTextureData> mTLTextureResource = new MTLTextureResource<MTLTextureData>(mTLFBOTextureData, false);
        return new MTLRTTexture(mTLContext, mTLTextureResource, Texture.WrapMode.CLAMP_NOT_NEEDED, n, n2, 0, 0, n, n2, n, n2, false);
    }

    @Override
    public long getNativeHandle() {
        return this.nTexPtr;
    }

    @Override
    public Texture getBackBuffer() {
        return this;
    }

    @Override
    public void setContentWidth(int n) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void setContentHeight(int n) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean getUseMipmap() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Texture getSharedTexture(Texture.WrapMode wrapMode) {
        throw new UnsupportedOperationException("Not implemented");
    }

    private static native long nCreateRT(long var0, int var2, int var3, int var4, int var5, Texture.WrapMode var6, boolean var7);

    private static native long nCreateRT2(long var0, long var2, int var4, int var5);

    private static native void nReadPixels(long var0, int[] var2);

    private static native void nReadPixelsFromRTT(long var0, IntBuffer var2);

    private static native long nGetPixelDataPtr(long var0);

    private static native void nInitRTT(long var0, int[] var2);

    @Override
    public int[] getPixels() {
        this.getContext().flushVertexBuffer();
        MTLRTTexture.nReadPixels(this.nTexPtr, this.pixels);
        return this.pixels;
    }

    @Override
    public boolean readPixels(Buffer buffer) {
        if (buffer instanceof IntBuffer) {
            MTLRTTexture.nReadPixelsFromRTT(this.nTexPtr, (IntBuffer)buffer);
            return true;
        }
        return false;
    }

    @Override
    public boolean readPixels(Buffer buffer, int n, int n2, int n3, int n4) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean isVolatile() {
        return false;
    }

    @Override
    public Screen getAssociatedScreen() {
        return this.getContext().getAssociatedScreen();
    }

    @Override
    public Graphics createGraphics() {
        return MTLGraphics.create(this.getContext(), this);
    }

    @Override
    public boolean isOpaque() {
        return this.opaque;
    }

    @Override
    public void setOpaque(boolean bl) {
        this.opaque = bl;
    }

    @Override
    public boolean isMSAA() {
        return this.MSAA;
    }

    @Override
    public void update(Image image) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Image image, int n, int n2) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Image image, int n, int n2, int n3, int n4) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Image image, int n, int n2, int n3, int n4, boolean bl) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Buffer buffer, PixelFormat pixelFormat, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(MediaFrame mediaFrame, boolean bl) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }
}

