/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.mtl;

import com.sun.prism.MediaFrame;
import com.sun.prism.PixelFormat;
import com.sun.prism.Texture;
import com.sun.prism.impl.BaseTexture;
import com.sun.prism.mtl.MTLContext;
import com.sun.prism.mtl.MTLLog;
import com.sun.prism.mtl.MTLTextureData;
import com.sun.prism.mtl.MTLTextureResource;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class MTLTexture<T extends MTLTextureData>
extends BaseTexture<MTLTextureResource<T>> {
    private final MTLContext context;
    private long texPtr;

    MTLTexture(MTLContext mTLContext, MTLTextureResource<T> mTLTextureResource, PixelFormat pixelFormat, Texture.WrapMode wrapMode, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        super(mTLTextureResource, pixelFormat, wrapMode, n, n2, n3, n4, n5, n6, bl);
        this.context = mTLContext;
        this.texPtr = ((MTLTextureData)mTLTextureResource.getResource()).getResource();
        MTLLog.Debug("MTLTexture(): context = " + String.valueOf(mTLContext) + ", resource = " + String.valueOf(mTLTextureResource) + ", format = " + String.valueOf((Object)pixelFormat) + ", wrapMode = " + String.valueOf((Object)wrapMode) + ", physicalWidth = " + n + ", physicalHeight = " + n2 + ", contentX = " + n3 + ", contentY = " + n4 + ", contentWidth = " + n5 + ", contentHeight = " + n6 + ", useMipmap = " + bl);
    }

    MTLTexture(MTLContext mTLContext, MTLTextureResource<T> mTLTextureResource, PixelFormat pixelFormat, Texture.WrapMode wrapMode, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        super(mTLTextureResource, pixelFormat, wrapMode, n, n2, n3, n4, n5, n6, n7, n8, bl);
        this.context = mTLContext;
        this.texPtr = ((MTLTextureData)mTLTextureResource.getResource()).getResource();
        MTLLog.Debug("MTLTexture(): context = " + String.valueOf(mTLContext) + ", resource = " + String.valueOf(mTLTextureResource) + ", format = " + String.valueOf((Object)pixelFormat) + ", wrapMode = " + String.valueOf((Object)wrapMode) + ", physicalWidth = " + n + ", physicalHeight = " + n2 + ", contentX = " + n3 + ", contentY = " + n4 + ", contentWidth = " + n5 + ", contentHeight = " + n6 + ", maxContentWidth = " + n7 + ", maxContentHeight = " + n8 + ", useMipmap = " + bl);
    }

    public long getNativeHandle() {
        return this.texPtr;
    }

    public MTLContext getContext() {
        return this.context;
    }

    private MTLTexture(MTLTexture mTLTexture, Texture.WrapMode wrapMode) {
        super(mTLTexture, wrapMode, false);
        this.context = mTLTexture.context;
        this.texPtr = mTLTexture.texPtr;
    }

    @Override
    protected Texture createSharedTexture(Texture.WrapMode wrapMode) {
        return new MTLTexture<T>(this, wrapMode);
    }

    private static native void nUpdate(long var0, long var2, ByteBuffer var4, byte[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

    private static native void nUpdateFloat(long var0, long var2, FloatBuffer var4, float[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

    private static native void nUpdateInt(long var0, long var2, IntBuffer var4, int[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

    private static native void nUpdateYUV422(long var0, long var2, byte[] var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void update(Buffer buffer, PixelFormat pixelFormat, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        if (pixelFormat.getDataType() == PixelFormat.DataType.INT) {
            if (pixelFormat != PixelFormat.INT_ARGB_PRE) throw new IllegalArgumentException("Unsupported INT PixelFormat" + String.valueOf((Object)pixelFormat));
            IntBuffer intBuffer = (IntBuffer)buffer;
            int[] nArray = intBuffer.hasArray() ? intBuffer.array() : null;
            MTLTexture.nUpdateInt(this.context.getContextHandle(), this.getNativeHandle(), intBuffer, nArray, n, n2, n3, n4, n5, n6, n7);
            return;
        } else if (pixelFormat.getDataType() == PixelFormat.DataType.FLOAT) {
            if (pixelFormat != PixelFormat.FLOAT_XYZW) throw new IllegalArgumentException("Unsupported FLOAT PixelFormat" + String.valueOf((Object)pixelFormat));
            MTLLog.Debug("FLOAT_XYZW - data type of buffer is : " + buffer.getClass().getName());
            MTLLog.Debug("Buffer capacity : " + buffer.capacity());
            MTLLog.Debug("Buffer limit : " + buffer.limit());
            MTLLog.Debug("srcscan  = " + n7);
            MTLLog.Debug("srcw  = " + n5);
            MTLLog.Debug("srch  = " + n6);
            FloatBuffer floatBuffer = (FloatBuffer)buffer;
            float[] fArray = floatBuffer.hasArray() ? floatBuffer.array() : null;
            MTLTexture.nUpdateFloat(this.context.getContextHandle(), this.getNativeHandle(), floatBuffer, fArray, n, n2, n3, n4, n5, n6, n7);
            return;
        } else {
            byte[] byArray;
            if (pixelFormat.getDataType() != PixelFormat.DataType.BYTE) throw new IllegalArgumentException("Unsupported PixelFormat DataType : " + String.valueOf((Object)pixelFormat));
            ByteBuffer byteBuffer = (ByteBuffer)buffer;
            byteBuffer.rewind();
            byte[] byArray2 = byArray = byteBuffer.hasArray() ? byteBuffer.array() : null;
            if (pixelFormat == PixelFormat.BYTE_BGRA_PRE || pixelFormat == PixelFormat.BYTE_ALPHA) {
                MTLTexture.nUpdate(this.context.getContextHandle(), this.getNativeHandle(), byteBuffer, byArray, n, n2, n3, n4, n5, n6, n7);
                return;
            } else if (pixelFormat == PixelFormat.BYTE_RGB) {
                byte[] byArray3 = new byte[n5 * n6 * 4];
                int n8 = 0;
                int n9 = 0;
                int n10 = n5 * 3;
                int n11 = n6 * n10;
                for (int i = 0; i < n11; i += n10) {
                    for (int j = 0; j < n10; j += 3) {
                        n9 = i + j;
                        byArray3[n8++] = byArray[n9 + 2];
                        byArray3[n8++] = byArray[n9 + 1];
                        byArray3[n8++] = byArray[n9];
                        byArray3[n8++] = -1;
                    }
                }
                MTLTexture.nUpdate(this.context.getContextHandle(), this.getNativeHandle(), null, byArray3, n, n2, n3, n4, n5, n6, n5 * 4);
                return;
            } else if (pixelFormat == PixelFormat.BYTE_GRAY) {
                byte[] byArray4 = new byte[n5 * n6 * 4];
                int n12 = 0;
                int n13 = 0;
                int n14 = n6 * n5;
                for (int i = 0; i < n14; i += n5) {
                    for (int j = 0; j < n5; ++j) {
                        n13 = i + j;
                        byArray4[n12++] = byArray[n13];
                        byArray4[n12++] = byArray[n13];
                        byArray4[n12++] = byArray[n13];
                        byArray4[n12++] = -1;
                    }
                }
                MTLTexture.nUpdate(this.context.getContextHandle(), this.getNativeHandle(), null, byArray4, n, n2, n3, n4, n5, n6, n5 * 4);
                return;
            } else {
                if (pixelFormat != PixelFormat.MULTI_YCbCr_420 && pixelFormat != PixelFormat.BYTE_APPLE_422) return;
                throw new IllegalArgumentException("Format not yet supported by Metal pipeline :" + String.valueOf((Object)pixelFormat));
            }
        }
    }

    @Override
    public void update(MediaFrame mediaFrame, boolean bl) {
        byte[] byArray;
        MTLLog.Debug("MTLTexture - update for MediaFrame.");
        if (mediaFrame.getPixelFormat() == PixelFormat.MULTI_YCbCr_420 || mediaFrame.getPixelFormat() != PixelFormat.BYTE_APPLE_422) {
            throw new IllegalArgumentException("Unsupported format " + String.valueOf((Object)mediaFrame.getPixelFormat()));
        }
        mediaFrame.holdFrame();
        ByteBuffer byteBuffer = mediaFrame.getBufferForPlane(0);
        byte[] byArray2 = byArray = byteBuffer.hasArray() ? byteBuffer.array() : null;
        if (byArray == null) {
            byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
        }
        MTLTexture.nUpdateYUV422(this.context.getContextHandle(), this.getNativeHandle(), byArray, 0, 0, 0, 0, mediaFrame.getEncodedWidth(), mediaFrame.getEncodedHeight(), mediaFrame.strideForPlane(0));
        mediaFrame.releaseFrame();
    }
}

