/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.mtl;

import com.sun.prism.impl.Disposer;
import com.sun.prism.mtl.MTLContext;
import com.sun.prism.mtl.MTLLog;
import com.sun.prism.mtl.MTLResourceFactory;
import java.util.Objects;

public class MTLTextureData
implements Disposer.Record {
    protected final MTLContext mtlContext;
    protected long pTexture;
    private long size;

    private MTLTextureData() {
        this.mtlContext = null;
    }

    MTLTextureData(MTLContext mTLContext, long l, long l2) {
        Objects.requireNonNull(mTLContext);
        if (l <= 0L) {
            throw new IllegalArgumentException("Texture cannot be null");
        }
        this.mtlContext = mTLContext;
        this.pTexture = l;
        this.size = l2;
    }

    public void setResource(long l) {
        this.pTexture = l;
    }

    public long getResource() {
        return this.pTexture;
    }

    public long getSize() {
        return this.size;
    }

    @Override
    public void dispose() {
        if (this.pTexture != 0L) {
            MTLLog.Debug("MTLTextureData.dispose()");
            MTLResourceFactory.releaseTexture(this.mtlContext, this.pTexture);
            this.pTexture = 0L;
        }
    }
}

