/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.mtl;

import com.sun.prism.PixelFormat;
import com.sun.prism.impl.BaseResourcePool;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.TextureResourcePool;
import com.sun.prism.mtl.MTLTextureData;

class MTLVramPool
extends BaseResourcePool<MTLTextureData>
implements TextureResourcePool<MTLTextureData> {
    private static MTLVramPool theInstance = new MTLVramPool();

    public static MTLVramPool getInstance() {
        return theInstance;
    }

    private MTLVramPool() {
        super(PrismSettings.targetVram, PrismSettings.maxVram);
    }

    @Override
    public long estimateTextureSize(int n, int n2, PixelFormat pixelFormat) {
        return (long)n * (long)n2 * (long)pixelFormat.getBytesPerPixelUnit();
    }

    @Override
    public long estimateRTTextureSize(int n, int n2, boolean bl) {
        return (long)n * (long)n2 * 4L;
    }

    @Override
    public long size(MTLTextureData mTLTextureData) {
        return mTLTextureData.getSize();
    }

    public String toString() {
        return "MTL Vram Pool";
    }
}

