/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.mtl;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.prism.Image;
import com.sun.prism.PhongMaterial;
import com.sun.prism.Texture;
import com.sun.prism.TextureMap;
import com.sun.prism.impl.BasePhongMaterial;
import com.sun.prism.impl.Disposer;
import com.sun.prism.mtl.MTLContext;
import com.sun.prism.mtl.MTLTexture;

class MTLPhongMaterial
extends BasePhongMaterial
implements PhongMaterial {
    static int count = 0;
    private final MTLContext context;
    private final long nativeHandle;
    private TextureMap[] maps = new TextureMap[MAX_MAP_TYPE];

    private MTLPhongMaterial(MTLContext mTLContext, long l, Disposer.Record record) {
        super(record);
        this.context = mTLContext;
        this.nativeHandle = l;
        ++count;
    }

    static MTLPhongMaterial create(MTLContext mTLContext) {
        long l = mTLContext.createMTLPhongMaterial();
        return new MTLPhongMaterial(mTLContext, l, new MTLPhongMaterialDisposerRecord(mTLContext, l));
    }

    long getNativeHandle() {
        return this.nativeHandle;
    }

    @Override
    public void setDiffuseColor(float f, float f2, float f3, float f4) {
        this.context.setDiffuseColor(this.nativeHandle, f, f2, f3, f4);
    }

    @Override
    public void setSpecularColor(boolean bl, float f, float f2, float f3, float f4) {
        this.context.setSpecularColor(this.nativeHandle, bl, f, f2, f3, f4);
    }

    @Override
    public void setTextureMap(TextureMap textureMap) {
        this.maps[textureMap.getType().ordinal()] = textureMap;
    }

    private Texture setupTexture(TextureMap textureMap, boolean bl) {
        Image image = textureMap.getImage();
        Texture texture = image == null ? null : this.context.getResourceFactory().getCachedTexture(image, Texture.WrapMode.REPEAT, bl);
        long l = texture != null ? ((MTLTexture)texture).getNativeHandle() : 0L;
        this.context.setMap(this.nativeHandle, textureMap.getType().ordinal(), l);
        return texture;
    }

    @Override
    public void lockTextureMaps() {
        for (int i = 0; i < MAX_MAP_TYPE; ++i) {
            Texture texture = this.maps[i].getTexture();
            if (!this.maps[i].isDirty() && texture != null) {
                texture.lock();
                if (!texture.isSurfaceLost()) continue;
            }
            boolean bl = !PlatformUtil.isEmbedded() && (i == PhongMaterial.DIFFUSE || i == PhongMaterial.SELF_ILLUM);
            texture = this.setupTexture(this.maps[i], bl);
            this.maps[i].setTexture(texture);
            this.maps[i].setDirty(false);
            if (this.maps[i].getImage() == null || texture != null) continue;
            String string = PhongMaterial.class.getName();
            PlatformLogger.getLogger((String)string).warning("Warning: Low on texture resources. Cannot create texture.");
        }
    }

    @Override
    public void unlockTextureMaps() {
        for (int i = 0; i < MAX_MAP_TYPE; ++i) {
            Texture texture = this.maps[i].getTexture();
            if (texture == null) continue;
            texture.unlock();
        }
    }

    @Override
    public boolean isValid() {
        return !this.context.isDisposed();
    }

    @Override
    public void dispose() {
        this.disposerRecord.dispose();
        --count;
    }

    public int getCount() {
        return count;
    }

    static class MTLPhongMaterialDisposerRecord
    implements Disposer.Record {
        private final MTLContext context;
        private long nativeHandle;

        MTLPhongMaterialDisposerRecord(MTLContext mTLContext, long l) {
            this.context = mTLContext;
            this.nativeHandle = l;
        }

        void traceDispose() {
        }

        @Override
        public void dispose() {
            if (this.nativeHandle != 0L) {
                this.traceDispose();
                this.context.releaseMTLPhongMaterial(this.nativeHandle);
                this.nativeHandle = 0L;
            }
        }
    }
}

