/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.mtl;

import com.sun.prism.Texture;
import com.sun.prism.mtl.MTLContext;
import com.sun.prism.mtl.MTLLog;
import com.sun.prism.mtl.MTLTexture;
import com.sun.prism.ps.Shader;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;

public class MTLShader
implements Shader {
    private final MTLContext context;
    private final String fragmentFunctionName;
    private long nMetalShaderRef;
    private final Map<Integer, String> samplers = new HashMap<Integer, String>();
    private final Map<String, Integer> uniformNameIdMap;
    private static Map<String, MTLShader> shaderMap = new HashMap<String, MTLShader>();
    private static MTLShader currentEnabledShader;

    private static native long nCreateMetalShader(long var0, String var2);

    private static native Map nGetUniformNameIdMap(long var0);

    private static native long nEnable(long var0);

    private static native long nDisable(long var0);

    private static native long nSetTexture(long var0, int var2, int var3, long var4, boolean var6, int var7);

    private static native long nSetInt(long var0, int var2, int var3);

    private static native long nSetFloat1(long var0, int var2, float var3);

    private static native long nSetFloat2(long var0, int var2, float var3, float var4);

    private static native long nSetFloat3(long var0, int var2, float var3, float var4, float var5);

    private static native long nSetFloat4(long var0, int var2, float var3, float var4, float var5, float var6);

    private static native long nSetConstants(long var0, int var2, float[] var3, int var4);

    private MTLShader(MTLContext mTLContext, String string) {
        MTLLog.Debug(">>> MTLShader(): fragFuncName = " + string);
        this.fragmentFunctionName = string;
        this.context = mTLContext;
        this.nMetalShaderRef = MTLShader.nCreateMetalShader(mTLContext.getContextHandle(), string);
        if (this.nMetalShaderRef == 0L) {
            throw new AssertionError((Object)"Failed to create Shader");
        }
        shaderMap.put(string, this);
        this.uniformNameIdMap = MTLShader.nGetUniformNameIdMap(this.nMetalShaderRef);
        MTLLog.Debug("    uniformNameIdMap: " + String.valueOf(this.uniformNameIdMap));
        MTLLog.Debug("    shaderMap.size(): " + shaderMap.size());
        MTLLog.Debug("    shaderMap" + String.valueOf(shaderMap));
        MTLLog.Debug("<<< MTLShader(): nMetalShaderRef = " + this.nMetalShaderRef);
    }

    public static Shader createShader(MTLContext mTLContext, String string, Map<String, Integer> map, Map<String, Integer> map2, int n, boolean bl, boolean bl2) {
        MTLLog.Debug(">>> MTLShader.createShader()1");
        MTLLog.Debug("    fragFuncName= " + string);
        MTLLog.Debug("    samplers= " + String.valueOf(map));
        MTLLog.Debug("    params= " + String.valueOf(map2));
        MTLLog.Debug("    maxTexCoordIndex= " + n);
        MTLLog.Debug("    isPixcoordUsed= " + bl);
        MTLLog.Debug("    isPerVertexColorUsed= " + bl2);
        if (shaderMap.containsKey(string)) {
            MTLLog.Debug("    The shader was already created and exists in map");
            MTLLog.Debug("<<< MTLShader.createShader()1");
            return shaderMap.get(string);
        }
        MTLShader mTLShader = new MTLShader(mTLContext, string);
        mTLShader.storeSamplers(map);
        MTLLog.Debug("<<< MTLShader.createShader()1");
        return mTLShader;
    }

    public static MTLShader createShader(MTLContext mTLContext, String string) {
        MTLShader mTLShader;
        MTLLog.Debug(">>> MTLShader.createShader()2");
        MTLLog.Debug("    fragmentFunctionName= " + string);
        if (shaderMap.containsKey(string)) {
            MTLLog.Debug("    The shader was already created and exists in map");
            mTLShader = shaderMap.get(string);
        } else {
            mTLShader = new MTLShader(mTLContext, string);
        }
        MTLLog.Debug("<<< MTLShader.createShader()2");
        return mTLShader;
    }

    private void storeSamplers(Map<String, Integer> map) {
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            this.samplers.put(entry.getValue(), entry.getKey());
        }
    }

    @Override
    public void enable() {
        MTLLog.Debug(">> MTLShader.enable()  fragFuncName = " + this.fragmentFunctionName);
        currentEnabledShader = this;
        MTLShader.nEnable(this.nMetalShaderRef);
    }

    @Override
    public void disable() {
        MTLLog.Debug("MTLShader.disable()  fragFuncName = " + this.fragmentFunctionName);
        MTLShader.nDisable(this.nMetalShaderRef);
    }

    @Override
    public boolean isValid() {
        MTLLog.Debug("MTLShader.isValid()");
        return this.nMetalShaderRef != 0L;
    }

    public static void setTexture(int n, Texture texture, boolean bl, int n2) {
        MTLTexture mTLTexture = (MTLTexture)texture;
        MTLShader.nSetTexture(MTLShader.currentEnabledShader.nMetalShaderRef, n, MTLShader.currentEnabledShader.uniformNameIdMap.get(MTLShader.currentEnabledShader.samplers.get(n)), mTLTexture.getNativeHandle(), bl, n2);
    }

    @Override
    public void setConstant(String string, int n) {
        MTLShader.nSetInt(this.nMetalShaderRef, this.uniformNameIdMap.get(string), n);
    }

    @Override
    public void setConstant(String string, int n, int n2) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void setConstant(String string, int n, int n2, int n3) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void setConstant(String string, int n, int n2, int n3, int n4) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void setConstants(String string, IntBuffer intBuffer, int n, int n2) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void setConstant(String string, float f) {
        MTLShader.nSetFloat1(this.nMetalShaderRef, this.uniformNameIdMap.get(string), f);
    }

    @Override
    public void setConstant(String string, float f, float f2) {
        MTLShader.nSetFloat2(this.nMetalShaderRef, this.uniformNameIdMap.get(string), f, f2);
    }

    @Override
    public void setConstant(String string, float f, float f2, float f3) {
        MTLShader.nSetFloat3(this.nMetalShaderRef, this.uniformNameIdMap.get(string), f, f2, f3);
    }

    @Override
    public void setConstant(String string, float f, float f2, float f3, float f4) {
        MTLShader.nSetFloat4(this.nMetalShaderRef, this.uniformNameIdMap.get(string), f, f2, f3, f4);
    }

    @Override
    public void setConstants(String string, FloatBuffer floatBuffer, int n, int n2) {
        n2 = 4 * n2;
        float[] fArray = new float[n2];
        floatBuffer.get(n, fArray, 0, n2);
        MTLShader.nSetConstants(this.nMetalShaderRef, this.uniformNameIdMap.get(string), fArray, n2);
    }

    @Override
    public void dispose() {
        MTLLog.Debug(">>> MTLShader.dispose() : fragmentFunctionName : " + this.fragmentFunctionName);
        if (this.isValid()) {
            this.context.disposeShader(this.nMetalShaderRef);
            this.nMetalShaderRef = 0L;
        }
    }
}

