/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_si extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_HT = "හයිටි";
        final String metaValue_TO = "ටොංගා";
        final String metaValue_ar = "අරාබි";
        final String metaValue_hy = "ආර්මේනියානු";
        final String metaValue_bn = "බෙංගාලි";
        final String metaValue_ccp = "චක්මා";
        final String metaValue_ka = "ජෝර්ජියානු";
        final String metaValue_el = "ග්‍රීක";
        final String metaValue_gu = "ගුජරාටි";
        final String metaValue_he = "හීබෲ";
        final String metaValue_ja = "ජපන්";
        final String metaValue_km = "කමර්";
        final String metaValue_kn = "කණ්ණඩ";
        final String metaValue_ko = "කොරියානු";
        final String metaValue_lo = "ලාඕ";
        final String metaValue_la = "ලතින්";
        final String metaValue_ml = "මලයාලම්";
        final String metaValue_nqo = "එන්‘කෝ";
        final String metaValue_si = "සිංහල";
        final String metaValue_ta = "දෙමළ";
        final String metaValue_te = "තෙළිඟු";
        final String metaValue_th = "තායි";
        final String metaValue_type_hc_h11 = "පැය 12 ක්‍රමය";
        final String metaValue_type_hc_h23 = "පැය 24 ක්‍රමය";
        final Object[][] data = new Object[][] {
            { "001", "ලෝකය" },
            { "002", "අප්‍රිකාව" },
            { "003", "උතුරු ඇමෙරිකාව" },
            { "005", "දකුණු ඇමෙරිකාව" },
            { "009", "ඕෂනියාව" },
            { "011", "බටහිරදිග අප්‍රිකාව" },
            { "013", "මධ්‍යම ඇමෙරිකාව" },
            { "014", "පෙරදිග අප්‍රිකාව" },
            { "015", "උතුරුදිග අප්‍රිකාව" },
            { "017", "මධ්‍යම අප්‍රිකාව" },
            { "018", "දකුණුදිග අප්‍රිකාව" },
            { "019", "ඇමරිකාව" },
            { "021", "උතුරුදිග ඇමෙරිකාව" },
            { "029", "කැරීබියන්" },
            { "030", "නැගෙනහිර ආසියාව" },
            { "034", "දකුණු ආසියාව" },
            { "035", "අග්නිදිග ආසියාව" },
            { "039", "දකුණුදිග යුරෝපය" },
            { "053", "ඕස්ට්‍රලේෂියාව" },
            { "054", "මෙලනීසියාව" },
            { "057", "මයික්‍රෝනීසියානු කළාපය" },
            { "061", "පොලිනීසියාව" },
            { "142", "ආසියාව" },
            { "143", "මධ්‍යම ආසියාව" },
            { "145", "බටහිර ආසියාව" },
            { "150", "යුරෝපය" },
            { "151", "නැගෙනහිර යුරෝපය" },
            { "154", "උතුරු යුරෝපය" },
            { "155", "බටහිර යුරෝපය" },
            { "202", "උප-සහරානු අප්‍රිකාව" },
            { "419", "ලතින් ඇමෙරිකාව" },
            { "AC", "ඇසෙන්ෂන් දිවයින" },
            { "AD", "ඇන්ඩෝරාව" },
            { "AE", "එක්සත් අරාබි එමිර් රාජ්‍යය" },
            { "AF", "ඇෆ්ගනිස්ථානය" },
            { "AG", "ඇන්ටිගුවා සහ බාබියුඩාව" },
            { "AI", "ඇන්ගුයිලාව" },
            { "AL", "ඇල්බේනියාව" },
            { "AM", "ආර්මේනියාව" },
            { "AO", "ඇන්ගෝලාව" },
            { "AQ", "ඇන්ටාක්ටිකාව" },
            { "AR", "ආර්ජෙන්ටිනාව" },
            { "AS", "ඇමරිකානු සැමෝවා" },
            { "AT", "ඔස්ට්‍රියාව" },
            { "AU", "ඕස්ට්‍රේලියාව" },
            { "AW", "අරූබා" },
            { "AX", "ඕලන්ඩ් දූපත්" },
            { "AZ", "අසර්බයිජානය" },
            { "BA", "බොස්නියාව සහ හර්සගොවීනාව" },
            { "BB", "බාබඩෝස්" },
            { "BD", "බංග්ලාදේශය" },
            { "BE", "බෙල්ජියම" },
            { "BF", "බර්කිනා ෆාසෝ" },
            { "BG", "බල්ගේරියාව" },
            { "BH", "බහරේන්" },
            { "BI", "බුරුන්දි" },
            { "BJ", "බෙනින්" },
            { "BL", "ශාන්ත බර්තලෙමි" },
            { "BM", "බර්මියුඩා" },
            { "BN", "බෲනායි" },
            { "BO", "බොලීවියාව" },
            { "BQ", "කැරිබියානු නෙදර්ලන්තය" },
            { "BR", "බ්‍රසීලය" },
            { "BS", "බහමාස්" },
            { "BT", "භූතානය" },
            { "BV", "බුවට් දුපත්" },
            { "BW", "බොට්ස්වානා" },
            { "BY", "බෙලරුස්" },
            { "BZ", "බෙලීස්" },
            { "CA", "කැනඩාව" },
            { "CC", "කොකෝස් දූපත්" },
            { "CD", "කොංගෝව (ඩීආර්සී)" },
            { "CF", "මධ්‍යම අප්‍රිකානු ජනරජය" },
            { "CG", "කොංගො - බ්‍රසාවිල්" },
            { "CH", "ස්විස්ටර්ලන්තය" },
            { "CI", "කෝට් දි අයිවරි" },
            { "CK", "කුක් දූපත්" },
            { "CL", "චිලී" },
            { "CM", "කැමරූන්" },
            { "CN", "චීනය" },
            { "CO", "කොළොම්බියාව" },
            { "CP", "ක්ලීපර්ටන් දූපත" },
            { "CR", "කොස්ටරිකාව" },
            { "CU", "කියුබාව" },
            { "CV", "කේප් වර්ඩ්" },
            { "CW", "කුරකාවෝ" },
            { "CX", "ක්‍රිස්මස් දූපත" },
            { "CY", "සයිප්‍රසය" },
            { "CZ", "චෙචියාව" },
            { "DE", "ජර්මනිය" },
            { "DG", "දියාගෝ ගාර්සියා" },
            { "DJ", "ජිබුටි" },
            { "DK", "ඩෙන්මාර්කය" },
            { "DM", "ඩොමිනිකාව" },
            { "DO", "ඩොමිනිකා ජනරජය" },
            { "DZ", "ඇල්ජීරියාව" },
            { "EA", "සෙයුටා සහ මෙලිල්ලා" },
            { "EC", "ඉක්වදෝරය" },
            { "EE", "එස්තෝනියාව" },
            { "EG", "ඊජිප්තුව" },
            { "EH", "බටහිර සහරාව" },
            { "ER", "එරිත්‍රියාව" },
            { "ES", "ස්පාඤ්ඤය" },
            { "ET", "ඉතියෝපියාව" },
            { "EU", "යුරෝපා සංගමය" },
            { "EZ", "යුරෝ කලාපය" },
            { "FI", "ෆින්ලන්තය" },
            { "FJ", "ෆීජී" },
            { "FK", "ෆෝක්ලන්ත දූපත්" },
            { "FM", "මයික්‍රොනීසියාව" },
            { "FO", "ෆැරෝ දූපත්" },
            { "FR", "ප්‍රංශය" },
            { "GA", "ගැබොන්" },
            { "GB", "එක්සත් රාජධානිය" },
            { "GD", "ග්‍රැනඩාව" },
            { "GE", "ජෝර්ජියාව" },
            { "GF", "ප්‍රංශ ගයනාව" },
            { "GG", "ගර්න්සිය" },
            { "GH", "ඝානාව" },
            { "GI", "ජිබ්‍රෝල්ටාව" },
            { "GL", "ග්‍රීන්ලන්තය" },
            { "GM", "ගැම්බියාව" },
            { "GN", "ගිණියාව" },
            { "GP", "ග්වෝඩලෝප්" },
            { "GQ", "සමක ගිනියාව" },
            { "GR", "ග්‍රීසිය" },
            { "GS", "දකුණු ජෝර්ජියාව සහ දකුණු සැන්ඩ්විච් දූපත්" },
            { "GT", "ගෝතමාලාව" },
            { "GU", "ගුවාම්" },
            { "GW", "ගිනි බිසව්" },
            { "GY", "ගයනාව" },
            { "HK", "හොංකොං විශේෂ පරිපාලන කලාපය චීනය" },
            { "HM", "හර්ඩ් දූපත සහ මැක්ඩොනල්ඩ් දූපත්" },
            { "HN", "හොන්ඩුරාස්" },
            { "HR", "ක්‍රොඒෂියාව" },
            { "HT", metaValue_HT },
            { "HU", "හන්ගේරියාව" },
            { "IC", "කැනරි සූපත්" },
            { "ID", "ඉන්දුනීසියාව" },
            { "IE", "අයර්ලන්තය" },
            { "IL", "ඊශ්‍රායලය" },
            { "IM", "අයිල් ඔෆ් මෑන්" },
            { "IN", "ඉන්දියාව" },
            { "IO", "බ්‍රිතාන්‍ය ඉන්දීය සාගර බල ප්‍රදේශය" },
            { "IQ", "ඉරාකය" },
            { "IR", "ඉරානය" },
            { "IS", "අයිස්ලන්තය" },
            { "IT", "ඉතාලිය" },
            { "JE", "ජර්සි" },
            { "JM", "ජැමෙයිකාව" },
            { "JO", "ජෝර්දානය" },
            { "JP", "ජපානය" },
            { "KE", "කෙන්යාව" },
            { "KG", "කිර්ගිස්තානය" },
            { "KH", "කාම්බෝජය" },
            { "KI", "කිරිබති" },
            { "KM", "කොමොරෝස්" },
            { "KN", "ශාන්ත කිට්ස් සහ නේවිස්" },
            { "KP", "උතුරු කොරියාව" },
            { "KR", "දකුණු කොරියාව" },
            { "KW", "කුවේටය" },
            { "KY", "කේමන් දූපත්" },
            { "KZ", "කසකස්තානය" },
            { "LA", "ලාඕසය" },
            { "LB", "ලෙබනනය" },
            { "LC", "ශාන්ත ලුසියා" },
            { "LI", "ලික්ටන්ස්ටයින්" },
            { "LK", "ශ්‍රී ලංකාව" },
            { "LR", "ලයිබීරියාව" },
            { "LS", "ලෙසතෝ" },
            { "LT", "ලිතුවේනියාව" },
            { "LU", "ලක්ශම්බර්ග්" },
            { "LV", "ලැට්වියාව" },
            { "LY", "ලිබියාව" },
            { "MA", "මොරොක්කෝව" },
            { "MC", "මොනාකෝව" },
            { "MD", "මොල්ඩෝවාව" },
            { "ME", "මොන්ටෙනීග්‍රෝ" },
            { "MF", "ශාන්ත මාර්ටින්" },
            { "MG", "මැඩගස්කරය" },
            { "MH", "මාෂල් දූපත්" },
            { "MK", "උතුරු මැසිඩෝනියාව" },
            { "ML", "මාලි" },
            { "MM", "මියන්මාරය (බුරුමය)" },
            { "MN", "මොන්ගෝලියාව" },
            { "MO", "මැකාවු විශේෂ පරිපාලන කලාපය චීනය" },
            { "MP", "උතුරු මරියානා දූපත්" },
            { "MQ", "මර්ටිනික්" },
            { "MR", "මොරිටේනියාව" },
            { "MS", "මොන්සෙරාට්" },
            { "MT", "මෝල්ටාව" },
            { "MU", "මුරුසිය" },
            { "MV", "මාල දිවයින" },
            { "MW", "මලාවි" },
            { "MX", "මෙක්සිකෝව" },
            { "MY", "මැලේසියාව" },
            { "MZ", "මොසැම්බික්" },
            { "NA", "නැමීබියාව" },
            { "NC", "නව කැලිඩෝනියාව" },
            { "NE", "නයිජර්" },
            { "NF", "නෝෆෝක් දූපත" },
            { "NG", "නයිජීරියාව" },
            { "NI", "නිකරගුවාව" },
            { "NL", "නෙදර්ලන්තය" },
            { "NO", "නෝර්වේ" },
            { "NP", "නේපාලය" },
            { "NR", "නාවුරු" },
            { "NU", "නියූ" },
            { "NZ", "නවසීලන්තය" },
            { "OM", "ඕමානය" },
            { "PA", "පැනමාව" },
            { "PE", "පේරු" },
            { "PF", "ප්‍රංශ පොලිනීසියාව" },
            { "PG", "පැපුවා නිව් ගිනියාව" },
            { "PH", "පිලිපීනය" },
            { "PK", "පාකිස්තානය" },
            { "PL", "පෝලන්තය" },
            { "PM", "ශාන්ත පියරේ සහ මැකෝලන්" },
            { "PN", "පිට්කෙය්න් දූපත්" },
            { "PR", "පුවර්ටෝ රිකෝ" },
            { "PS", "පලස්තීන රාජ්‍යය" },
            { "PT", "පෘතුගාලය" },
            { "PW", "පලාවු" },
            { "PY", "පැරගුවේ" },
            { "QA", "කටාර්" },
            { "QO", "ඈත ඕෂනියාව" },
            { "RE", "රීයුනියන්" },
            { "RO", "රුමේනියාව" },
            { "RS", "සර්බියාව" },
            { "RU", "රුසියාව" },
            { "RW", "රුවන්ඩාව" },
            { "SA", "සෞදි අරාබිය" },
            { "SB", "සොලමන් දූපත්" },
            { "SC", "සීශෙල්ස්" },
            { "SD", "සූඩානය" },
            { "SE", "ස්වීඩනය" },
            { "SG", "සිංගප්පූරුව" },
            { "SH", "ශාන්ත හෙලේනා" },
            { "SI", "ස්ලෝවේනියාව" },
            { "SJ", "ස්වෙල්බර්ඩ් සහ ජේන් මයේන්" },
            { "SK", "ස්ලෝවැකියාව" },
            { "SL", "සියරාලියෝන්" },
            { "SM", "සැන් මැරිනෝ" },
            { "SN", "සෙනගාලය" },
            { "SO", "සෝමාලියාව" },
            { "SR", "සුරිනාමය" },
            { "SS", "දකුණු සුඩානය" },
            { "ST", "සාඕ තෝම් සහ ප්‍රින්සිප්" },
            { "SV", "එල් සැල්වදෝරය" },
            { "SX", "ශාන්ත මාර්ටෙන්" },
            { "SY", "සිරියාව" },
            { "SZ", "එස්වාටිනි" },
            { "TA", "ට්‍රිස්ටන් ද කුන්හා" },
            { "TC", "ටර්ක්ස් සහ කයිකොස් දූපත්" },
            { "TD", "චැච්" },
            { "TF", "දකුණු ප්‍රංශ දූපත් සමූහය" },
            { "TG", "ටොගෝ" },
            { "TH", "තායිලන්තය" },
            { "TJ", "ටජිකිස්තානය" },
            { "TK", "ටොකලාවු" },
            { "TL", "ටිමෝර් - ලෙස්ත්" },
            { "TM", "ටර්ක්මෙනිස්ථානය" },
            { "TN", "ටියුනීසියාව" },
            { "TO", metaValue_TO },
            { "TR", "තුර්කිය" },
            { "TT", "ට්‍රිනිඩෑඩ් සහ ටොබැගෝ" },
            { "TV", "ටුවාලූ" },
            { "TW", "තායිවානය" },
            { "TZ", "ටැන්සානියාව" },
            { "UA", "යුක්රේනය" },
            { "UG", "උගන්ඩාව" },
            { "UM", "එක්සත් ජනපද ඈත දූපත්" },
            { "UN", "එක්සත් ජාතීන්" },
            { "US", "එක්සත් ජනපදය" },
            { "UY", "උරුගුවේ" },
            { "UZ", "උස්බෙකිස්ථානය" },
            { "VA", "වතිකානු නගරය" },
            { "VC", "ශාන්ත වින්සන්ට් සහ ග්‍රෙනඩින්ස්" },
            { "VE", "වෙනිසියුලාව" },
            { "VG", "බ්‍රිතාන්‍ය වර්ජින් දූපත්" },
            { "VI", "ඇමරිකානු වර්ජින් දූපත්" },
            { "VN", "වියට්නාමය" },
            { "VU", "වනුවාටු" },
            { "WF", "වැලිස් සහ ෆුටුනා" },
            { "WS", "සැමෝවා" },
            { "XA", "ව්‍යාජ-උච්චාරණ" },
            { "XB", "ව්‍යාජ-බිඩි" },
            { "XK", "කොසෝවෝ" },
            { "YE", "යේමනය" },
            { "YT", "මයෝට්" },
            { "ZA", "දකුණු අප්‍රිකාව" },
            { "ZM", "සැම්බියාව" },
            { "ZW", "සිම්බාබ්වේ" },
            { "ZZ", "හඳුනා නොගත් කළාපය" },
            { "aa", "අෆාර්" },
            { "ab", "ඇබ්කාසියානු" },
            { "af", "අෆ්‍රිකාන්ස්" },
            { "ak", "අකාන්" },
            { "am", "ඇම්හාරික්" },
            { "an", "ඇරගොනීස්" },
            { "ar", metaValue_ar },
            { "as", "ඇසෑම්" },
            { "av", "ඇවරික්" },
            { "ay", "අයිමරා" },
            { "az", "අසර්බයිජාන්" },
            { "ba", "බාෂ්කිර්" },
            { "be", "බෙලරුසියානු" },
            { "bg", "බල්ගේරියානු" },
            { "bi", "බිස්ලමා" },
            { "bm", "බම්බරා" },
            { "bn", metaValue_bn },
            { "bo", "ටිබෙට්" },
            { "br", "බ්‍රේටොන්" },
            { "bs", "බොස්නියානු" },
            { "ca", "කැටලන්" },
            { "ce", "චෙච්නියානු" },
            { "ch", "චමොරො" },
            { "co", "කෝසිකානු" },
            { "cs", "චෙක්" },
            { "cu", "චර්ච් ස්ලැවික්" },
            { "cv", "චවේෂ්" },
            { "cy", "වෙල්ෂ්" },
            { "da", "ඩැනිශ්" },
            { "de", "ජර්මන්" },
            { "dv", "ඩිවෙහි" },
            { "dz", "ඩිසොන්කා" },
            { "ee", "ඉව්" },
            { "el", metaValue_el },
            { "en", "ඉංග්‍රීසි" },
            { "eo", "එස්පැරන්ටෝ" },
            { "es", "ස්පාඤ්ඤ" },
            { "et", "එස්තෝනියානු" },
            { "eu", "බාස්ක්" },
            { "fa", "පර්සියානු" },
            { "ff", "ෆුලාහ්" },
            { "fi", "ෆින්ලන්ත" },
            { "fj", "ෆීජි" },
            { "fo", "ෆාරෝස්" },
            { "fr", "ප්‍රංශ" },
            { "fy", "බටහිර ෆ්‍රිසියානු" },
            { "ga", "අයර්ලන්ත" },
            { "gd", "ස්කොට්ටිශ් ගෙලික්" },
            { "gl", "ගැලීසියානු" },
            { "gn", "ගුවාරනි" },
            { "gu", metaValue_gu },
            { "gv", "මැන්ක්ස්" },
            { "ha", "හෝසා" },
            { "he", metaValue_he },
            { "hi", "හින්දි" },
            { "hr", "කෝඒෂියානු" },
            { "ht", metaValue_HT },
            { "hu", "හන්ගේරියානු" },
            { "hy", metaValue_hy },
            { "hz", "හෙරෙරො" },
            { "ia", "ඉන්ටලින්ගුආ" },
            { "id", "ඉන්දුනීසියානු" },
            { "ie", "ඉන්ටර්ලින්ග්" },
            { "ig", "ඉග්බෝ" },
            { "ii", "සිචුආන් යී" },
            { "io", "ඉඩො" },
            { "is", "අයිස්ලන්ත" },
            { "it", "ඉතාලි" },
            { "iu", "ඉනුක්ටිටුට්" },
            { "ja", metaValue_ja },
            { "jv", "ජාවා" },
            { "ka", metaValue_ka },
            { "ki", "කිකුයු" },
            { "kj", "කුයන්යමා" },
            { "kk", "කසාඛ්" },
            { "kl", "කලාලිසට්" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "කනුරි" },
            { "ks", "කාෂ්මීර්" },
            { "ku", "කුර්දි" },
            { "kv", "කොමි" },
            { "kw", "කෝනීසියානු" },
            { "ky", "කිර්ගිස්" },
            { "la", metaValue_la },
            { "lb", "ලක්සැම්බර්ග්" },
            { "lg", "ගන්ඩා" },
            { "li", "ලිම්බර්ගිශ්" },
            { "ln", "ලින්ගලා" },
            { "lo", metaValue_lo },
            { "lt", "ලිතුවේනියානු" },
            { "lu", "ලුබා-කටන්ගා" },
            { "lv", "ලැට්වියානු" },
            { "mg", "මලගාසි" },
            { "mh", "මාශලීස්" },
            { "mi", "මාවොරි" },
            { "mk", "මැසිඩෝනියානු" },
            { "ml", metaValue_ml },
            { "mn", "මොංගෝලියානු" },
            { "mr", "මරාති" },
            { "ms", "මැලේ" },
            { "mt", "මොල්ටිස්" },
            { "my", "බුරුම" },
            { "na", "නෞරු" },
            { "nb", "නෝර්වීජියානු බොක්මල්" },
            { "nd", "උතුරු එන්ඩිබෙලෙ" },
            { "ne", "නේපාල" },
            { "ng", "න්ඩොන්ගා" },
            { "nl", "ලන්දේසි" },
            { "nn", "නෝර්වීජියානු නයිනෝර්ස්ක්" },
            { "no", "නෝර්වීජියානු" },
            { "nr", "සෞත් ඩ්බේල්" },
            { "nv", "නවාජො" },
            { "ny", "න්යන්ජා" },
            { "oc", "ඔසිටාන්" },
            { "om", "ඔරොමෝ" },
            { "or", "ඔඩියා" },
            { "os", "ඔසිටෙක්" },
            { "pa", "පන්ජාබි" },
            { "pl", "පෝලන්ත" },
            { "ps", "පෂ්ටො" },
            { "pt", "පෘතුගීසි" },
            { "qu", "ක්වීචුවා" },
            { "rm", "රොමෑන්ශ්" },
            { "rn", "රුන්ඩි" },
            { "ro", "රොමේනියානු" },
            { "ru", "රුසියානු" },
            { "rw", "කින්යර්වන්ඩා" },
            { "sa", "සංස්කෘත" },
            { "sc", "සාර්ඩිනිඅන්" },
            { "sd", "සින්ධි" },
            { "se", "උතුරු සාමි" },
            { "sg", "සන්ග්‍රෝ" },
            { "si", metaValue_si },
            { "sk", "ස්ලෝවැක්" },
            { "sl", "ස්ලෝවේනියානු" },
            { "sm", "සෑමොඅන්" },
            { "sn", "ශෝනා" },
            { "so", "සෝමාලි" },
            { "sq", "ඇල්බේනියානු" },
            { "sr", "සර්බියානු" },
            { "ss", "ස්වති" },
            { "st", "සතර්න් සොතො" },
            { "su", "සන්ඩනීසියානු" },
            { "sv", "ස්වීඩන්" },
            { "sw", "ස්වාහිලි" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "ටජික්" },
            { "th", metaValue_th },
            { "ti", "ටිග්‍රින්යා" },
            { "tk", "ටර්ක්මෙන්" },
            { "tn", "ස්වනා" },
            { "to", metaValue_TO },
            { "tr", "තුර්කි" },
            { "ts", "සොන්ග" },
            { "tt", "ටාටර්" },
            { "ty", "ටහිටියන්" },
            { "ug", "උයිගර්" },
            { "uk", "යුක්රේනියානු" },
            { "ur", "උර්දු" },
            { "uz", "උස්බෙක්" },
            { "ve", "වෙන්ඩා" },
            { "vi", "වියට්නාම්" },
            { "vo", "වොලපූක්" },
            { "wa", "වෑලූන්" },
            { "wo", "වොලොෆ්" },
            { "xh", "ශෝසා" },
            { "yi", "යිඩිශ්" },
            { "yo", "යොරූබා" },
            { "za", "ෂුවාං" },
            { "zh", "චීන" },
            { "zu", "සුලු" },
            { "ace", "අචයිනිස්" },
            { "ada", "අඩන්ග්මෙ" },
            { "ady", "අඩිඝෙ" },
            { "aeb", "ටියුනිසියනු අරාබි" },
            { "agq", "ඇගම්" },
            { "ain", "අයිනු" },
            { "ale", "ඇලුඑට්" },
            { "alt", "සතර්න් අල්ටය්" },
            { "ann", "ඔබලෝ" },
            { "anp", "අන්ගික" },
            { "arn", "මපුචෙ" },
            { "arp", "ඇරපහො" },
            { "ars", "නජ්ඩි අරාබි" },
            { "asa", "අසු" },
            { "ast", "ඇස්ටියුරියන්" },
            { "atj", "ඇටිකමෙක්ව්" },
            { "awa", "අවදි" },
            { "ban", "බැලිනීස්" },
            { "bas", "බසා" },
            { "bem", "බෙම්බා" },
            { "bez", "බෙනා" },
            { "bgc", "හර්යාන්වි" },
            { "bgn", "බටහිර බලොචි" },
            { "bho", "බොජ්පුරි" },
            { "bin", "බිනි" },
            { "bla", "සික්සිකා" },
            { "blo", "අනී" },
            { "brx", "බොඩො" },
            { "bug", "බුගිනීස්" },
            { "byn", "බ්ලින්" },
            { "cay", "කයුගා" },
            { "ccp", metaValue_ccp },
            { "ceb", "සෙබුඅනො" },
            { "cgg", "චිගා" },
            { "chk", "චූකීස්" },
            { "chm", "මරි" },
            { "cho", "චොක්ටොව්" },
            { "chp", "චිපෙවියන්" },
            { "chr", "චෙරොකී" },
            { "chy", "චෙයෙන්නෙ" },
            { "ckb", "සොරානි කුර්දිෂ්" },
            { "clc", "චිල්කොටින්" },
            { "crg", "මිචිෆ්" },
            { "crj", "දකුණු නැගෙනහිර ක්‍රී" },
            { "crk", "ප්ලේන්ස් ක්‍රී" },
            { "crl", "උතුරු නැගෙනහිර ක්‍රී" },
            { "crm", "මූස් ක්‍රී" },
            { "crr", "කැරොලිනා ඇල්ගොන්කියන්" },
            { "crs", "සෙසෙල්ව ක්‍රොල් ෆ්‍රෙන්ච්" },
            { "csw", "මඩ වගුරු ක්‍රී" },
            { "dak", "ඩකොටා" },
            { "dar", "ඩාර්ග්වා" },
            { "dav", "ටයිටා" },
            { "dgr", "ඩොග්‍රිබ්" },
            { "dje", "සර්මා" },
            { "doi", "ඩොග්රි" },
            { "dsb", "පහළ සෝබියානු" },
            { "dua", "ඩුආලා" },
            { "dyo", "ජොල-ෆෝනියි" },
            { "dzg", "ඩසාගා" },
            { "ebu", "එම්බු" },
            { "efi", "එෆික්" },
            { "eka", "එකජුක්" },
            { "ewo", "එවොන්ඩො" },
            { "fil", "පිලිපීන" },
            { "fon", "ෆොන්" },
            { "frc", "කජුන් ප්‍රංශ" },
            { "frr", "උතුරු ෆ්‍රිසියානු" },
            { "fur", "ෆ්‍රියුලියන්" },
            { "gaa", "ගා" },
            { "gag", "ගගාස්" },
            { "gan", "ගැන් චයිනිස්" },
            { "gez", "ගීස්" },
            { "gil", "ගිල්බර්ටීස්" },
            { "gor", "ගොරොන්ටාලො" },
            { "gsw", "ස්විස් ජර්මානු" },
            { "guz", "ගුසී" },
            { "gwi", "ග්විචින්" },
            { "hai", "හයිඩා" },
            { "hak", "හකා චයිනිස්" },
            { "haw", "හවායි" },
            { "hax", "දකුණු හයිඩා" },
            { "hil", "හිලිගෙනන්" },
            { "hmn", "මොන්ග්" },
            { "hsb", "ඉහළ සෝබියානු" },
            { "hsn", "සියැන් චීන" },
            { "hup", "හුපා" },
            { "hur", "හල්කොමලෙම්" },
            { "iba", "ඉබන්" },
            { "ibb", "ඉබිබියො" },
            { "ikt", "බටහිර කැනේඩියානු ඉනුක්ටිටුට්" },
            { "ilo", "ඉලොකො" },
            { "inh", "ඉන්ගුෂ්" },
            { "jbo", "ලොජ්බන්" },
            { "jgo", "නොම්බා" },
            { "jmc", "මැකාමී" },
            { "kab", "කාබිල්" },
            { "kac", "කචින්" },
            { "kaj", "ජ්ජු" },
            { "kam", "කැම්බා" },
            { "kbd", "කබාර්ඩියන්" },
            { "kcg", "ට්යප්" },
            { "kde", "මැකොන්ඩ්" },
            { "kea", "කබුවෙර්ඩියානු" },
            { "kfo", "කොරො" },
            { "kgp", "කයිංගං" },
            { "kha", "ඛසි" },
            { "khq", "කොයිරා චිනි" },
            { "kkj", "කකො" },
            { "kln", "කලෙන්ජන්" },
            { "kmb", "කිම්බුන්ඩු" },
            { "koi", "කොමි-පර්මියාක්" },
            { "kok", "කොන්කනි" },
            { "kpe", "ක්පෙලෙ" },
            { "krc", "කරන්චි-බාකර්" },
            { "krl", "කැරෙලියන්" },
            { "kru", "කුරුඛ්" },
            { "ksb", "ශාම්බලා" },
            { "ksf", "බාෆියා" },
            { "ksh", "කොලොග්නියන්" },
            { "kum", "කුමික්" },
            { "kwk", "ක්වාක්වාලා" },
            { "kxv", "කුවි" },
            { "lad", "ලඩිනො" },
            { "lag", "ලංගි" },
            { "lez", "ලෙස්ගියන්" },
            { "lij", "ලිගුරියන්" },
            { "lil", "ලිලූට්" },
            { "lkt", "ලකොට" },
            { "lmo", "ලොම්බාර්ඩ්" },
            { "lou", "ලුසියානා ක්‍රියෝල්" },
            { "loz", "ලොසි" },
            { "lrc", "උතුරු ලුරි" },
            { "lsm", "සාමියා" },
            { "lua", "ලුබ-ලුලුඅ" },
            { "lun", "ලුන්ඩ" },
            { "luo", "ලුඔ" },
            { "lus", "මිසො" },
            { "luy", "ලුයියා" },
            { "mad", "මදුරීස්" },
            { "mag", "මඝහි" },
            { "mai", "මයිතිලි" },
            { "mak", "මකාසාර්" },
            { "mas", "මසායි" },
            { "mdf", "මොක්ශා" },
            { "men", "මෙන්ඩෙ" },
            { "mer", "මෙරු" },
            { "mfe", "මොරිස්යෙම්" },
            { "mgh", "මඛුවා-මීටෝ" },
            { "mgo", "මෙටා" },
            { "mic", "මික්මැක්" },
            { "min", "මිනන්ග්කබාවු" },
            { "mni", "මනිපුරි" },
            { "moe", "ඉනු-අයිමුන්" },
            { "moh", "මොහොව්ක්" },
            { "mos", "මොස්සි" },
            { "mua", "මුන්ඩන්" },
            { "mul", "බහු භාෂා" },
            { "mus", "ක්‍රීක්" },
            { "mwl", "මිරන්ඩීස්" },
            { "myv", "එර්ස්යා" },
            { "mzn", "මැසන්ඩරනි" },
            { "nan", "මින් නන් චයිනිස්" },
            { "nap", "නියාපොලිටන්" },
            { "naq", "නාමා" },
            { "nds", "පහළ ජර්මන්" },
            { "new", "නෙවාරි" },
            { "nia", "නියාස්" },
            { "niu", "නියුඑන්" },
            { "nmg", "කුවාසිඔ" },
            { "nnh", "න්ගියාම්බූන්" },
            { "nog", "නොගායි" },
            { "nqo", metaValue_nqo },
            { "nso", "නොදර්න් සොතො" },
            { "nus", "නොයර්" },
            { "nyn", "නයන්කෝලෙ" },
            { "ojb", "වයඹ ඔජිබ්වා" },
            { "ojc", "මධ්‍යම ඔජිබ්වා" },
            { "ojs", "ඔජි-ක්‍රී" },
            { "ojw", "බටහිර ඔජිබ්වා" },
            { "oka", "ඔකනගන්" },
            { "pag", "පන්ගසීනන්" },
            { "pam", "පන්පන්ග" },
            { "pap", "පපියමෙන්ටො" },
            { "pau", "පලවුවන්" },
            { "pcm", "නෛජීරියන් පෙන්ගින්" },
            { "pis", "පිජින්" },
            { "pqm", "මලිසීට්-පස්සමකුඩි" },
            { "prg", "පෘශියන්" },
            { "quc", "කියිචේ" },
            { "raj", "රාජස්ථානි" },
            { "rap", "රපනුයි" },
            { "rar", "රරොටොන්ගන්" },
            { "rhg", "රෝහින්ග්‍යා" },
            { "rof", "රෝම්බෝ" },
            { "rup", "ඇරොමානියානු" },
            { "rwk", "ර්වා" },
            { "sad", "සන්ඩවෙ" },
            { "sah", "සඛා" },
            { "saq", "සම්බුරු" },
            { "sat", "සෑන්ටලි" },
            { "sba", "න්ගම්බෙ" },
            { "sbp", "සංගු" },
            { "scn", "සිසිලියන්" },
            { "sco", "ස්කොට්ස්" },
            { "sdh", "දකුණු කුර්දි" },
            { "seh", "සෙනා" },
            { "ses", "කෝයිරාබොරො සෙන්නි" },
            { "shi", "ටචේල්හිට්" },
            { "shn", "ශාන්" },
            { "slh", "දකුණු ලුෂූට්සීඩ්" },
            { "sma", "දකුණු සාමි" },
            { "smj", "ලුලේ සාමි" },
            { "smn", "ඉනාරි සාමි" },
            { "sms", "ස්කොල්ට් සාමි" },
            { "snk", "සොනින්කෙ" },
            { "srn", "ස්‍රන් ටොන්ගො" },
            { "ssy", "සහො" },
            { "str", "සාලිෂ්ස මුද්ර සන්ධිය" },
            { "suk", "සුකුමා" },
            { "swb", "කොමොරියන්" },
            { "syr", "ස්‍රයෑක්" },
            { "szl", "සිලේසියානු" },
            { "tce", "දකුණු ටචෝන්" },
            { "tem", "ටිම්නෙ" },
            { "teo", "ටෙසෝ" },
            { "tet", "ටේටම්" },
            { "tgx", "ටැගිෂ්" },
            { "tht", "ටැල්ටන්" },
            { "tig", "ටීග්‍රෙ" },
            { "tlh", "ක්ලින්ගොන්" },
            { "tli", "ට්ලින්ගිට්" },
            { "tok", "ටෝකි පොනා" },
            { "tpi", "ටොක් පිසින්" },
            { "trv", "ටරොකො" },
            { "ttm", "උතුරු ටචෝන්" },
            { "tum", "ටුම්බුකා" },
            { "tvl", "ටුවාලු" },
            { "twq", "ටසවාක්" },
            { "tyv", "ටුවිනියන්" },
            { "tzm", "මධ්‍යම ඇට්ලස් ටමසිට්" },
            { "udm", "අඩ්මර්ට්" },
            { "umb", "උබුන්ඩු" },
            { "und", "නොදන්නා භාෂාව" },
            { "vai", "වයි" },
            { "vec", "වැනේසියානු" },
            { "vmw", "මකුවා" },
            { "vun", "වුන්ජෝ" },
            { "wae", "වොල්සර්" },
            { "wal", "වොලෙට්ට" },
            { "war", "වොරෙය්" },
            { "wbp", "වොපිරි" },
            { "wuu", "වූ චයිනිස්" },
            { "xal", "කල්මික්" },
            { "xnr", "කැන්ග්‍රි" },
            { "xog", "සොගා" },
            { "yav", "යන්ග්බෙන්" },
            { "ybb", "යෙම්බා" },
            { "yrl", "නොහීඟටු" },
            { "yue", "කැන්ටොනීස්" },
            { "zgh", "සම්මත මොරොක්කෝ ටමසිග්ත්" },
            { "zun", "සුනි" },
            { "zxx", "වාග් විද්‍යා අන්තර්ගතයක් නැත" },
            { "zza", "සාසා" },
            { "Adlm", "ඇඩ්ලම්" },
            { "Arab", metaValue_ar },
            { "Aran", "නස්ටාලික්" },
            { "Armn", metaValue_hy },
            { "Beng", metaValue_bn },
            { "Bopo", "බොපොමොෆෝ" },
            { "Brai", "බ්‍රේල්" },
            { "Cakm", metaValue_ccp },
            { "Cans", "ඒකාබද්ධ කැනේඩියානු ආදිවාසී විෂය නිර්දේශ" },
            { "Cher", "චෙරෝකී" },
            { "Cyrl", "සිරිලික්" },
            { "Deva", "දේවනාගරී" },
            { "Ethi", "ඉතියෝපියානු" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "ගුර්මුඛි" },
            { "Hanb", "හැන්ඩ්බ්" },
            { "Hang", "හැන්ගුල්" },
            { "Hani", "හන්" },
            { "Hans", "සුළුකළ" },
            { "Hant", "සාම්ප්‍රදායික" },
            { "Hebr", metaValue_he },
            { "Hira", "හිරඟනා" },
            { "Hrkt", "ජෑපනීස් සිලබරීස්" },
            { "Jamo", "ජාමො" },
            { "Jpan", metaValue_ja },
            { "Kana", "කතකනා" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", metaValue_la },
            { "Mlym", metaValue_ml },
            { "Mong", "මොන්ගෝලියානු" },
            { "Mtei", "මෙයිටෙයි මයක්" },
            { "Mymr", "මියන්මාර" },
            { "Nkoo", metaValue_nqo },
            { "Olck", "ඔල් චිකි" },
            { "Orya", "ඔරියා" },
            { "Rohg", "හනිෆි" },
            { "Sinh", metaValue_si },
            { "Sund", "සන්ඩනීස්" },
            { "Syrc", "සිරියැක්" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Tfng", "ටිෆිනාග්" },
            { "Thaa", "තාන" },
            { "Thai", metaValue_th },
            { "Tibt", "ටි‍බෙට්" },
            { "Vaii", "වායි" },
            { "Yiii", "යී" },
            { "Zmth", "ගණිතමය සංකේත" },
            { "Zsye", "ඉමොජි" },
            { "Zsym", "සංකේත" },
            { "Zxxx", "අලිඛිත" },
            { "Zyyy", "පොදු" },
            { "Zzzz", "නොදත් අකුරු මාලාව" },
            { "de_AT", "ඔස්ට්‍රියානු ජර්මන්" },
            { "de_CH", "ස්විස් උසස් ජර්මන්" },
            { "en_AU", "ඕස්ට්‍රේලියානු ඉංග්‍රීසි" },
            { "en_CA", "කැනේඩියානු ඉංග්‍රීසි" },
            { "en_GB", "බ්‍රිතාන්‍ය ඉංග්‍රීසි" },
            { "en_US", "ඇමෙරිකානු ඉංග්‍රීසි" },
            { "es_ES", "යුරෝපීය ස්පාඤ්ඤ" },
            { "es_MX", "මෙක්සිකානු ස්පාඤ්ඤ" },
            { "fa_AF", "ඩාරි" },
            { "fr_CA", "කැනේඩියානු ප්‍රංශ" },
            { "fr_CH", "ස්විස් ප්‍රංශ" },
            { "nl_BE", "ෆ්ලෙමිශ්" },
            { "pt_BR", "බ්‍රසීල පෘතුගීසි" },
            { "pt_PT", "යුරෝපීය පෘතුගීසි" },
            { "ro_MD", "මොල්ඩවිආනු" },
            { "sw_CD", "කොංගෝ ස්වාහිලි" },
            { "ar_001", "නූතන සම්මත අරාබි" },
            { "es_419", "ලතින් ඇමරිකානු ස්පාඤ්ඤ" },
            { "key.ca", "දින දර්ශනය" },
            { "key.cf", "මුදල් ආකෘති" },
            { "key.co", "පෙළගැස්ම" },
            { "key.cu", "විනිමය" },
            { "key.hc", "පැය චක්‍රය" },
            { "key.lb", "පේළි කඩන විලාසය" },
            { "key.ms", "මිනුම් ක්‍රමය" },
            { "key.nu", "ඉලක්කම්" },
            { "nds_NL", "පහළ සැක්සන්" },
            { "zh_Hans", "සරල චීන" },
            { "zh_Hant", "සාම්ප්‍රදායික චීන" },
            { "type.ca.roc", "මින්ගා දින දර්ශනය" },
            { "type.hc.h11", metaValue_type_hc_h11 },
            { "type.hc.h12", metaValue_type_hc_h11 },
            { "type.hc.h23", metaValue_type_hc_h23 },
            { "type.hc.h24", metaValue_type_hc_h23 },
            { "type.nu.arab", "ඉන්දු අරාබි ඉලක්කම්" },
            { "type.nu.armn", "ඇමරිකානු සංඛ්‍යාංකන" },
            { "type.nu.beng", "බෙංගාලි ඉලක්කම්" },
            { "type.nu.cakm", "චක්මා ඉලක්කම්" },
            { "type.nu.deva", "දේවනාගරී ඉලක්කම්" },
            { "type.nu.ethi", "ඉතියෝපියානු සංඛ්‍යාංකන" },
            { "type.nu.geor", "ජෝජියානු සංඛ්‍යාංකන" },
            { "type.nu.grek", "ග්‍රීක සංඛ්‍යාංකන" },
            { "type.nu.gujr", "ගුජරාටි ඉලක්කම්" },
            { "type.nu.guru", "ගුර්මුකී ඉලක්කම්" },
            { "type.nu.hans", "සුළුකළ චීන සංඛ්‍යාංකන" },
            { "type.nu.hant", "සාම්ප්‍රදායික චීන සංඛ්‍යාංකන" },
            { "type.nu.hebr", "හීබෲ සංඛ්‍යාංකන" },
            { "type.nu.java", "ජාවානු ඉලක්කම්" },
            { "type.nu.jpan", "ජපාන සංඛ්‍යාංකන" },
            { "type.nu.khmr", "කමර් ඉලක්කම්" },
            { "type.nu.knda", "කන්නඩ ඉලක්කම්" },
            { "type.nu.laoo", "ලාඕ ඉලක්කම්" },
            { "type.nu.latn", "බටහිර ඉලක්කම්" },
            { "type.nu.mlym", "මලයාලම් ඉලක්කම්" },
            { "type.nu.mtei", "මීටේයි මයෙක් ඉලක්කම්" },
            { "type.nu.mymr", "බුරුම ඉලක්කම්" },
            { "type.nu.olck", "ඔල් චිකි ඉලක්කම්" },
            { "type.nu.orya", "ඔරියා ඉලක්කම්" },
            { "type.nu.taml", "සාම්ප්‍රදායික දෙමළ සංඛ්‍යාංකන" },
            { "type.nu.telu", "තෙළිඟු ඉලක්කම්" },
            { "type.nu.thai", "තායි ඉලක්කම්" },
            { "type.nu.tibt", "ටිබෙට ඉලක්කම්" },
            { "type.nu.vaii", "වායි ඉලක්කම්" },
            { "type.ca.dangi", "ඩැන්ගී දින දර්ශනය" },
            { "type.co.ducet", "යුනිකේත පෙරනිමි පෙළගැස්ම" },
            { "type.lb.loose", "ලිහිල් කඩන විලාසය" },
            { "type.nu.roman", "රෝමානු සංඛ්‍යාංකන" },
            { "type.ca.coptic", "කොප්ටික් දින දර්ශනය" },
            { "type.ca.hebrew", "හීබෲ දින දර්ශනය" },
            { "type.co.search", "සාමාන්‍ය සෙවීම" },
            { "type.lb.normal", "සාමාන්‍ය පේළි කඩන විලාසය" },
            { "type.lb.strict", "තද පේළි කඩන විලාසය" },
            { "type.ms.metric", "මෙට්‍රික් ක්‍රමය" },
            { "type.ca.chinese", "චීන දින දර්ශනය" },
            { "type.ca.islamic", "හිජ්රි දින දර්ශනය" },
            { "type.ca.iso8601", "අඑස්ඔ-8601 දින දර්ශනය" },
            { "type.ca.persian", "පර්සියානු දින දර්ශනය" },
            { "type.cf.account", "ගිණුම්කරණ මුදල් ආකෘති" },
            { "type.nu.arabext", "වැඩි කළ ඉන්දු අරාබි ඉලක්කම්" },
            { "type.nu.armnlow", "ඇමරිකානු කුඩා සංඛ්‍යාංකන" },
            { "type.nu.greklow", "ග්‍රීක කුඩා සංඛ්‍යාංකන" },
            { "type.nu.hanidec", "චීන දශමය සංඛ්‍යාංකන" },
            { "type.nu.hansfin", "සුළුකළ චීන මුල්‍යමය සංඛ්‍යාංකන" },
            { "type.nu.hantfin", "සාම්ප්‍රදායික චීන මුල්‍යමය සංඛ්‍යාංකන" },
            { "type.nu.jpanfin", "ජපාන මුල්‍යමය සංඛ්‍යාංකන" },
            { "type.nu.tamldec", "දෙමළ ඉලක්කම්" },
            { "type.ca.buddhist", "බොදු දින දර්ශනය" },
            { "type.ca.ethiopic", "ඉතියෝපියානු දින දර්ශනය" },
            { "type.ca.japanese", "ජපන් දින දර්ශනය" },
            { "type.cf.standard", "සම්මත මුදල් ආකෘති" },
            { "type.co.standard", "සම්මත පෙළගැස්ම" },
            { "type.ms.uksystem", "රාජකීය මිනුම් ක්‍රමය" },
            { "type.ms.ussystem", "එජ මිනුම් ක්‍රමය" },
            { "type.nu.fullwide", "සම්පූර්ණ පළල ඉලක්කම්" },
            { "type.nu.romanlow", "රෝමානු කුඩා සංඛ්‍යාංකන" },
            { "type.ca.gregorian", "ග්‍රෙගරියානු දින දර්ශනය" },
            { "type.co.dictionary", "ශබ්දකෝෂ පෙළගැස්ම" },
            { "type.ca.islamic-civil", "හිජ්රි දින දර්ශනය (වගුව, සිවිල් වීර කාව්‍යය)" },
            { "type.ca.islamic-umalqura", "හිජ්රි දින දර්ශනය (උම් අල් කුරා)" },
            { "type.ca.ethiopic-amete-alem", "ඉතියෝපික් ඇමේට් ඇලම් දින දර්ශනය" },
        };
        return data;
    }
}
