/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_is extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwich-staðaltími",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Staðaltími í Apía",
               "",
               "Sumartími í Apía",
               "",
               "Tími í Apía",
               "",
            };
        final String[] Cook = new String[] {
               "Staðaltími á Cooks-eyjum",
               "",
               "Hálfsumartími á Cooks-eyjum",
               "",
               "Cooks-eyjatími",
               "",
            };
        final String[] Cuba = new String[] {
               "Staðaltími á Kúbu",
               "CST",
               "Sumartími á Kúbu",
               "CDT",
               "Kúbutími",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Staðaltími á Fídjíeyjum",
               "",
               "Sumartími á Fídjíeyjum",
               "",
               "Fídjíeyjatími",
               "",
            };
        final String[] Gulf = new String[] {
               "Staðaltími við Persaflóa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Staðaltími í Hovd",
               "",
               "Sumartími í Hovd",
               "",
               "Hovd-tími",
               "",
            };
        final String[] Iran = new String[] {
               "Staðaltími í Íran",
               "",
               "Sumartími í Íran",
               "",
               "Íranstími",
               "",
            };
        final String[] Niue = new String[] {
               "Niue-tími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Staðaltími í Omsk",
               "",
               "Sumartími í Omsk",
               "",
               "Tími í Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Staðaltími í Perú",
               "",
               "Sumartími í Perú",
               "",
               "Perútími",
               "",
            };
        final String[] Truk = new String[] {
               "Chuuk-tími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Tími á Wake-eyju",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Staðaltími í Síle",
               "",
               "Sumartími í Síle",
               "",
               "Síletími",
               "",
            };
        final String[] China = new String[] {
               "Staðaltími í Kína",
               "CST",
               "Sumartími í Kína",
               "CDT",
               "Kínatími",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Kókoseyjatími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Davis-tími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Indlandstími",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Staðaltími í Japan",
               "JST",
               "Sumartími í Japan",
               "JDT",
               "Japanstími",
               "JT",
            };
        final String[] Korea = new String[] {
               "Staðaltími í Kóreu",
               "KST",
               "Sumartími í Kóreu",
               "KST",
               "Kóreutími",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Nárú-tími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepaltími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palátími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Staðaltími á Samóa",
               "SST",
               "Sumartími á Samóa",
               "SST",
               "Samóa-tími",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Syowa-tími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Staðaltími á Tonga",
               "",
               "Sumartími á Tonga",
               "",
               "Tongatími",
               "",
            };
        final String[] Yukon = new String[] {
               "Tími í Júkon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Staðaltími í Alaska",
               "AKST",
               "Sumartími í Alaska",
               "AKDT",
               "Tími í Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Staðaltími á Amasónsvæðinu",
               "",
               "Sumartími á Amasónsvæðinu",
               "",
               "Amasóntími",
               "",
            };
        final String[] Anadyr = new String[] {
               "Staðaltími í Anadyr",
               "",
               "Sumartími í Anadyr",
               "",
               "Tími í Anadyr",
               "",
            };
        final String[] Azores = new String[] {
               "Staðaltími á Asóreyjum",
               "",
               "Sumartími á Asóreyjum",
               "",
               "Asóreyjatími",
               "",
            };
        final String[] Bhutan = new String[] {
               "Bútantími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brúneitími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Staðaltími á Páskaeyju",
               "",
               "Sumartími á Páskaeyju",
               "",
               "Páskaeyjutími",
               "",
            };
        final String[] Guyana = new String[] {
               "Gvæjanatími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Staðaltími í Ísrael",
               "IST",
               "Sumartími í Ísrael",
               "IDT",
               "Ísraelstími",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae-tími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawson-tími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Staðaltími í Moskvu",
               "MSK",
               "Sumartími í Moskvu",
               "MSK",
               "Moskvutími",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ponape-tími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Staðaltími í Samara",
               "",
               "Sumartími í Samara",
               "",
               "Tími í Samara",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahítí-tími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Staðaltími í Taipei",
               "CST",
               "Sumartími í Taipei",
               "CDT",
               "Taipei-tími",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Túvalútími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostok-tími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Tími á Wallis- og Fútúnaeyjum",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Staðaltími í Arabíu",
               "",
               "Sumartími í Arabíu",
               "",
               "Arabíutími",
               "",
            };
        final String[] Armenia = new String[] {
               "Staðaltími í Armeníu",
               "",
               "Sumartími í Armeníu",
               "",
               "Armeníutími",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bólivíutími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Staðaltími í Chatham",
               "",
               "Sumartími í Chatham",
               "",
               "Chatham-tími",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Samræmdur alþjóðlegur tími",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ekvadortími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambier-tími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Staðaltími í Georgíu",
               "",
               "Sumartími í Georgíu",
               "",
               "Georgíutími",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Staðaltími í Irkutsk",
               "",
               "Sumartími í Irkutsk",
               "",
               "Tími í Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Staðaltími í Magadan",
               "",
               "Sumartími í Magadan",
               "",
               "Tími í Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Mjanmar-tími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Staðaltími á Norfolk-eyju",
               "",
               "Sumartími á Norfolk-eyju",
               "",
               "Tími á Norfolk-eyju",
               "",
            };
        final String[] Noronha = new String[] {
               "Staðaltími í Fernando de Noronha",
               "",
               "Sumartími í Fernando de Noronha",
               "",
               "Tími í Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Réunion-tími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rothera-tími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Salómonseyjatími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tókelá-tími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Staðaltími í Úrúgvæ",
               "",
               "Sumartími í Úrúgvæ",
               "",
               "Úrúgvætími",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Staðaltími á Vanúatú",
               "",
               "Sumartími á Vanúatú",
               "",
               "Vanúatú-tími",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Staðaltími í Yakutsk",
               "",
               "Sumartími í Yakutsk",
               "",
               "Tími í Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Staðaltími á Atlantshafssvæðinu",
               "AST",
               "Sumartími á Atlantshafssvæðinu",
               "AST",
               "Tími á Atlantshafssvæðinu",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Staðaltími í Brasilíu",
               "",
               "Sumartími í Brasilíu",
               "",
               "Brasilíutími",
               "",
            };
        final String[] Chamorro = new String[] {
               "Chamorro-staðaltími",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Staðaltími í Kólumbíu",
               "",
               "Sumartími í Kólumbíu",
               "",
               "Kólumbíutími",
               "",
            };
        final String[] Falkland = new String[] {
               "Staðaltími á Falklandseyjum",
               "",
               "Sumartími á Falklandseyjum",
               "",
               "Falklandseyjatími",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malasíutími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldíveyja-tími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Staðaltími í Úlan Bator",
               "",
               "Sumartími í Úlan Bator",
               "",
               "Tími í Úlan Bator",
               "",
            };
        final String[] Pakistan = new String[] {
               "Staðaltími í Pakistan",
               "PKT",
               "Sumartími í Pakistan",
               "PKST",
               "Pakistantími",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Staðaltími í Paragvæ",
               "",
               "Sumartími í Paragvæ",
               "",
               "Paragvætími",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairn-tími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Staðaltími á Sakhalin",
               "",
               "Sumartími á Sakhalin",
               "",
               "Tími á Sakhalin",
               "",
            };
        final String[] Suriname = new String[] {
               "Súrinamtími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Staðaltími í Argentínu",
               "",
               "Sumartími í Argentínu",
               "",
               "Argentínutími",
               "",
            };
        final String[] Christmas = new String[] {
               "Jólaeyjartími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagos-tími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Staðaltími í Hong Kong",
               "HKT",
               "Sumartími í Hong Kong",
               "HKST",
               "Hong Kong-tími",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Indókínatími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Staðaltími í Petropavlovsk-Kamchatski",
               "",
               "Sumartími í Petropavlovsk-Kamchatski",
               "",
               "Tími í Petropavlovsk-Kamchatski",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgistan-tími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Staðaltími á Lord Howe-eyju",
               "",
               "Sumartími á Lord Howe-eyju",
               "",
               "Tími á Lord Howe-eyju",
               "",
            };
        final String[] Marquesas = new String[] {
               "Tími á Markgreifafrúreyjum",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Staðaltími á Máritíus",
               "",
               "Sumartími á Máritíus",
               "",
               "Máritíustími",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapúrtími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venesúelatími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Staðaltími í Volgograd",
               "MSK",
               "Sumartími í Volgograd",
               "MSK",
               "Tími í Volgograd",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Staðaltími í Aserbaídsjan",
               "",
               "Sumartími í Aserbaídsjan",
               "",
               "Aserbaídsjantími",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Staðaltími í Bangladess",
               "",
               "Sumartími í Bangladess",
               "",
               "Bangladess-tími",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Staðaltími á Grænhöfðaeyjum",
               "",
               "Sumartími á Grænhöfðaeyjum",
               "",
               "Grænhöfðaeyjatími",
               "",
            };
        final String[] East_Timor = new String[] {
               "Tími á Tímor-Leste",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Tími í Kasakstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seychelles-eyjatími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tadsjíkistan-tími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Staðaltími í Úsbekistan",
               "",
               "Sumartími í Úsbekistan",
               "",
               "Úsbekistan-tími",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afganistantími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Staðaltími í Krasnoyarsk",
               "",
               "Sumartími í Krasnoyarsk",
               "",
               "Tími í Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Staðaltími á Nýja-Sjálandi",
               "NZST",
               "Sumartími á Nýja-Sjálandi",
               "NZDT",
               "Tími á Nýja-Sjálandi",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Staðaltími í Novosibirsk",
               "",
               "Sumartími í Novosibirsk",
               "",
               "Tími í Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Staðaltími á Filippseyjum",
               "PST",
               "Sumartími á Filippseyjum",
               "PDT",
               "Filippseyjatími",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Staðaltími í Vladivostok",
               "",
               "Sumartími í Vladivostok",
               "",
               "Tími í Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Indlandshafstími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Línueyja-tími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Staðaltími á Nýfundnalandi",
               "NST",
               "Sumartími á Nýfundnalandi",
               "NDT",
               "Tími á Nýfundnalandi",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Staðaltími í Túrkmenistan",
               "",
               "Sumartími í Túrkmenistan",
               "",
               "Túrkmenistan-tími",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Tími í Frönsku Gvæjana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Staðaltími í Nýju-Kaledóníu",
               "",
               "Sumartími í Nýju-Kaledóníu",
               "",
               "Tími í Nýju-Kaledóníu",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Suður-Georgíutími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Staðaltími í Yekaterinborg",
               "",
               "Sumartími í Yekaterinburg",
               "",
               "Tími í Yekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Mið-Afríkutími",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Austur-Afríkutími",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Staðaltími í Vestur-Afríku",
               "WAT",
               "Sumartími í Vestur-Afríku",
               "WAT",
               "Vestur-Afríkutími",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Tími á Dumont-d’Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Staðaltími í Mið-Evrópu",
               "CET",
               "Sumartími í Mið-Evrópu",
               "CEST",
               "Mið-Evróputími",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Staðaltími í Austur-Evrópu",
               "EET",
               "Sumartími í Austur-Evrópu",
               "EEST",
               "Austur-Evróputími",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Staðaltími í Vestur-Evrópu",
               "WET",
               "Sumartími í Vestur-Evrópu",
               "WEST",
               "Vestur-Evróputími",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Staðaltími í Mexíkó á Kyrrahafssvæðinu",
               "MST",
               "Sumartími í Mexíkó á Kyrrahafssvæðinu",
               "MDT",
               "Kyrrahafstími í Mexíkó",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Suður-Afríkutími",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Staðaltími í miðhluta Bandaríkjanna og Kanada",
               "CST",
               "Sumartími í miðhluta Bandaríkjanna og Kanada",
               "CDT",
               "Tími í miðhluta Bandaríkjanna og Kanada",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Staðaltími í austurhluta Bandaríkjanna og Kanada",
               "EST",
               "Sumartími í austurhluta Bandaríkjanna og Kanada",
               "EST",
               "Tími í austurhluta Bandaríkjanna og Kanada",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Staðaltími á Kyrrahafssvæðinu",
               "PST",
               "Sumartími á Kyrrahafssvæðinu",
               "PDT",
               "Tími á Kyrrahafssvæðinu",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Tími á frönsku suðurhafssvæðum og Suðurskautslandssvæði",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Tími á Gilbert-eyjum",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Staðaltími á Havaí og Aleúta",
               "HST",
               "Sumartími á Havaí og Aleúta",
               "HST",
               "Tími á Havaí og Aleúta",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Fönixeyjatími",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Staðaltími á Sankti Pierre og Miquelon",
               "",
               "Sumartími á Sankti Pierre og Miquelon",
               "",
               "Tími á Sankti Pierre og Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Staðaltími í Klettafjöllum",
               "MST",
               "Sumartími í Klettafjöllum",
               "MST",
               "Tími í Klettafjöllum",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Tími á Marshall-eyjum",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Tími á Papúa Nýju-Gíneu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Staðaltími í Mið-Ástralíu",
               "ACST",
               "Sumartími í Mið-Ástralíu",
               "ACDT",
               "Tími í Mið-Ástralíu",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Staðaltími í Austur-Ástralíu",
               "AEST",
               "Sumartími í Austur-Ástralíu",
               "AEDT",
               "Tími í Austur-Ástralíu",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Staðaltími í Vestur-Ástralíu",
               "AWST",
               "Sumartími í Vestur-Ástralíu",
               "AWDT",
               "Tími í Vestur-Ástralíu",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Mið-Indónesíutími",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Austur-Indónesíutími",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Vestur-Indónesíutími",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Staðaltími í miðvesturhluta Ástralíu",
               "",
               "Sumartími í miðvesturhluta Ástralíu",
               "",
               "Tími í miðvesturhluta Ástralíu",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Greenwich-staðaltími",
                    "GMT",
                    "Sumartími í Bretlandi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Samræmdur alþjóðlegur tími",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Greenwich-staðaltími",
                    "GMT",
                    "Sumartími á Írlandi",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Samræmdur alþjóðlegur tími",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Samræmdur alþjóðlegur tími",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Greenwich-staðaltími",
                    "GMT",
                    "Sumartími í Bretlandi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Samræmdur alþjóðlegur tími",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Samræmdur alþjóðlegur tími",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Samræmdur alþjóðlegur tími",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich-staðaltími",
                    "GMT",
                    "Sumartími á Írlandi",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Greenwich-staðaltími",
                    "GMT",
                    "Sumartími í Bretlandi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Greenwich-staðaltími",
                    "GMT",
                    "Sumartími í Bretlandi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Greenwich-staðaltími",
                    "GMT",
                    "Sumartími í Bretlandi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Greenwich-staðaltími",
                    "GMT",
                    "Sumartími í Bretlandi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Greenwich-staðaltími",
                    "GMT",
                    "Sumartími í Bretlandi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Baku", "Bakú" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Dhaka", "Dakka" },
            { "timezone.excity.Asia/Kabul", "Kabúl" },
            { "timezone.excity.Asia/Macau", "Makaó" },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.Asia/Seoul", "Seúl" },
            { "timezone.excity.Asia/Tokyo", "Tókýó" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Beirut", "Beirút" },
            { "timezone.excity.Asia/Brunei", "Brúnei" },
            { "timezone.excity.Asia/Kuwait", "Kúveit" },
            { "timezone.excity.Asia/Riyadh", "Ríjad" },
            { "timezone.excity.Asia/Saigon", "Ho Chi Minh-borg" },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Etc/Unknown", "Óþekkt borg" },
            { "timezone.excity.Europe/Kiev", "Kænugarður" },
            { "timezone.excity.Europe/Oslo", "Osló" },
            { "timezone.excity.Europe/Rome", "Róm" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Cairo", "Kaíró" },
            { "timezone.excity.Africa/Tunis", "Túnisborg" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bahrain", "Barein" },
            { "timezone.excity.Asia/Colombo", "Kólombó" },
            { "timezone.excity.Asia/Jakarta", "Djakarta" },
            { "timezone.excity.Asia/Nicosia", "Níkósía" },
            { "timezone.excity.Asia/Rangoon", "Rangún" },
            { "timezone.excity.Asia/Yerevan", "Jerevan" },
            { "timezone.excity.Europe/Paris", "París" },
            { "timezone.excity.Europe/Sofia", "Sófía" },
            { "timezone.excity.Indian/Cocos", "Kókoseyjar" },
            { "timezone.excity.Pacific/Fiji", "Fídjí" },
            { "timezone.excity.Pacific/Guam", "Gvam" },
            { "timezone.excity.Africa/Bissau", "Bissá" },
            { "timezone.excity.America/Aruba", "Arúba" },
            { "timezone.excity.Asia/Calcutta", "Kalkútta" },
            { "timezone.excity.Asia/Damascus", "Damaskus" },
            { "timezone.excity.Asia/Katmandu", "Katmandú" },
            { "timezone.excity.Asia/Qostanay", "Kostanay" },
            { "timezone.excity.Asia/Shanghai", "Sjanghæ" },
            { "timezone.excity.Europe/Athens", "Aþena" },
            { "timezone.excity.Europe/Berlin", "Berlín" },
            { "timezone.excity.Europe/Lisbon", "Lissabon" },
            { "timezone.excity.Europe/London", "Lundúnir" },
            { "timezone.excity.Europe/Madrid", "Madríd" },
            { "timezone.excity.Europe/Monaco", "Mónakó" },
            { "timezone.excity.Europe/Moscow", "Moskva" },
            { "timezone.excity.Europe/Prague", "Prag" },
            { "timezone.excity.Europe/Tirane", "Tírana" },
            { "timezone.excity.Europe/Vienna", "Vín" },
            { "timezone.excity.Europe/Warsaw", "Varsjá" },
            { "timezone.excity.Pacific/Nauru", "Nárú" },
            { "timezone.excity.Pacific/Palau", "Palá" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Algeirsborg" },
            { "timezone.excity.Africa/Tripoli", "Trípólí" },
            { "timezone.excity.America/Belize", "Belís" },
            { "timezone.excity.America/Cancun", "Kankún" },
            { "timezone.excity.America/Cayman", "Cayman-eyjar" },
            { "timezone.excity.America/Guyana", "Gvæjana" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.Asia/Jerusalem", "Jerúsalem" },
            { "timezone.excity.Asia/Kamchatka", "Kamtsjatka" },
            { "timezone.excity.Asia/Pyongyang", "Pjongjang" },
            { "timezone.excity.Asia/Singapore", "Singapúr" },
            { "timezone.excity.Europe/Vatican", "Vatíkanið" },
            { "timezone.excity.Europe/Vilnius", "Vilníus" },
            { "timezone.excity.Pacific/Easter", "Páskaeyja" },
            { "timezone.excity.Pacific/Tahiti", "Tahítí" },
            { "timezone.excity.Africa/Djibouti", "Djibútí" },
            { "timezone.excity.Africa/Sao_Tome", "Saó Tóme" },
            { "timezone.excity.America/Antigua", "Antígva" },
            { "timezone.excity.America/Jamaica", "Jamaíka" },
            { "timezone.excity.America/Tortola", "Tortóla" },
            { "timezone.excity.Atlantic/Azores", "Azoreyjar" },
            { "timezone.excity.Atlantic/Canary", "Kanaríeyjar" },
            { "timezone.excity.Atlantic/Faeroe", "Færeyjar" },
            { "timezone.excity.Europe/Belgrade", "Belgrad" },
            { "timezone.excity.Europe/Brussels", "Brussel" },
            { "timezone.excity.Europe/Budapest", "Búdapest" },
            { "timezone.excity.Europe/Istanbul", "Istanbúl" },
            { "timezone.excity.Europe/Sarajevo", "Sarajevó" },
            { "timezone.excity.Indian/Maldives", "Maldíveyjar" },
            { "timezone.excity.America/Anguilla", "Angvilla" },
            { "timezone.excity.America/Dominica", "Dóminíka" },
            { "timezone.excity.America/St_Kitts", "Sankti Kitts" },
            { "timezone.excity.America/St_Lucia", "Sankti Lúsía" },
            { "timezone.excity.Asia/Ulaanbaatar", "Úlan Bator" },
            { "timezone.excity.Atlantic/Bermuda", "Bermúda" },
            { "timezone.excity.Europe/Bucharest", "Búkarest" },
            { "timezone.excity.Europe/Gibraltar", "Gíbraltar" },
            { "timezone.excity.Europe/Mariehamn", "Maríuhöfn" },
            { "timezone.excity.Europe/Stockholm", "Stokkhólmur" },
            { "timezone.excity.Indian/Christmas", "Jólaey" },
            { "timezone.excity.Indian/Mauritius", "Máritíus" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.America/Guatemala", "Gvatemala" },
            { "timezone.excity.America/St_Thomas", "Sankti Thomas" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kúala Lúmpúr" },
            { "timezone.excity.Europe/Copenhagen", "Kaupmannahöfn" },
            { "timezone.excity.Europe/Luxembourg", "Lúxemborg" },
            { "timezone.excity.Europe/San_Marino", "San Marínó" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Marquesas", "Marquesas-eyjar" },
            { "timezone.excity.America/Costa_Rica", "Kostaríka" },
            { "timezone.excity.America/Guadeloupe", "Gvadelúp" },
            { "timezone.excity.America/Martinique", "Martiník" },
            { "timezone.excity.America/St_Vincent", "Sankti Vinsent" },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjavík" },
            { "timezone.excity.Atlantic/St_Helena", "Sankti Helena" },
            { "timezone.excity.Europe/Isle_of_Man", "Mön" },
            { "timezone.excity.Africa/Johannesburg", "Jóhannesarborg" },
            { "timezone.excity.America/Mexico_City", "Mexíkóborg" },
            { "timezone.excity.America/Puerto_Rico", "Púertó Ríkó" },
            { "timezone.excity.Atlantic/Cape_Verde", "Grænhöfðaeyjar" },
            { "timezone.excity.America/St_Barthelemy", "Sankti Bartólómeusareyjar" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.Atlantic/South_Georgia", "Suður-Georgía" },
        };
        return data;
    }
}
