/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ps_PK extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Apia = new String[] {
               "اپیا معياري وخت",
               "",
               "د اپیا د ورځے وخت",
               "",
               "اپیا وخت",
               "",
            };
        final String[] Cuba = new String[] {
               "کیوبا معياري وخت",
               "CST",
               "کیوبا د رڼا ورځے وخت",
               "CDT",
               "کيوبا وخت",
               "CT",
            };
        final String[] Iran = new String[] {
               "ایران معياري وخت",
               "",
               "د ایران د ورځے وخت",
               "",
               "ایران وخت",
               "",
            };
        final String[] China = new String[] {
               "چین معیاري وخت",
               "CST",
               "د چين د رڼا ورځے وخت",
               "CDT",
               "چين وخت",
               "CT",
            };
        final String[] Japan = new String[] {
               "جاپان معياري وخت",
               "JST",
               "جاپان د رڼا ورځے وخت",
               "JDT",
               "جاپان وخت",
               "JT",
            };
        final String[] Korea = new String[] {
               "کوريايي معياري وخت",
               "KST",
               "د کوریا د ورځے د ورځے وخت",
               "KST",
               "کوريايي وخت",
               "KST",
            };
        final String[] Samoa = new String[] {
               "سموا معياري وخت",
               "SST",
               "د سموا د ورځے روښانه کول",
               "SST",
               "سموا وخت",
               "SST",
            };
        final String[] Alaska = new String[] {
               "الاسکا معياري وخت",
               "AKST",
               "د الاسکا د ورځے روښانه کول",
               "AKDT",
               "الاسکا وخت",
               "AKT",
            };
        final String[] Israel = new String[] {
               "اسراییل معياري وخت",
               "IST",
               "د اسراییلو د ورځے وخت",
               "IDT",
               "اسراییل وخت",
               "IT",
            };
        final String[] Arabian = new String[] {
               "عربي معیاري وخت",
               "",
               "د عربي ورځپاڼے وخت",
               "",
               "عربي وخت",
               "",
            };
        final String[] Atlantic = new String[] {
               "اتلانتیک معياري وخت",
               "AST",
               "اتلانتیک د رڼا ورځے وخت",
               "AST",
               "اتلانتیک وخت",
               "AST",
            };
        final String[] Lord_Howe = new String[] {
               "لارډ هوي معياري وخت",
               "",
               "رب هاو د ورځے د رڼا وخت",
               "",
               "لارډ هوي وخت",
               "",
            };
        final String[] EMPTY_ZONE = new String[] {
               "",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Zealand = new String[] {
               "نيوزي لېنډ معياري وخت",
               "NZST",
               "د نیوزی لینڈ د ورځے د رڼا وخت",
               "NZDT",
               "نيوزي لېنډ وخت",
               "NZT",
            };
        final String[] Line_Islands = new String[] {
               "د کرښے ټاټوبي وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "د نوي فیلډلینډ معیاری وخت",
               "NST",
               "د نوي فیلډلینډ رڼا ورځے وخت",
               "NDT",
               "نيو فاونډلېنډ وخت",
               "NT",
            };
        final String[] Europe_Western = new String[] {
               "د لودیځے اروپا معیاري وخت",
               "WET",
               "د لودیځے اورپا د اوړي وخت",
               "WEST",
               "لوېديزے اروپا وخت",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "مکسیکن پیسفک معیاری وخت",
               "MST",
               "مکسیکن پیسفک رڼا ورځے وخت",
               "MDT",
               "مکسیکن پیسفک وخت",
               "MT",
            };
        final String[] America_Central = new String[] {
               "مرکزي معياري وخت",
               "CST",
               "مرکزي رڼا ورځے وخت",
               "CDT",
               "مرکزي وخت",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "ختيځ معياري وخت",
               "EST",
               "ختيځ د رڼا ورځے وخت",
               "EST",
               "ختیځ وخت",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "د پیسفک معياري وخت",
               "PST",
               "پیسفک د رڼا ورځے وخت",
               "PDT",
               "پیسفک وخت",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "د فرانسے سویل او انټارټيک وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "هوایی الیوتین معیاری وخت",
               "HST",
               "هوایی الیوتین رڼا ورځے وخت",
               "HST",
               "هوایی الیوتین وخت",
               "HST",
            };
        final String[] Pierre_Miquelon = new String[] {
               "سینټ پییرا و ميکلين معیاری وخت",
               "",
               "سینټ پییرا و ميکلين رڼا ورځے وخت",
               "",
               "سینټ پییرا و ميکلين وخت",
               "",
            };
        final String[] America_Mountain = new String[] {
               "د غره معياري وخت",
               "MST",
               "د غره د رڼا ورځے وخت",
               "MST",
               "د غره د وخت",
               "MST",
            };
        final String[] Australia_Western = new String[] {
               "آسترالوي لوېديځ معياري وخت",
               "AWST",
               "د اسټرالیا لویدیځ د ورځے وخت",
               "AWDT",
               "لوېديځ آستراليا وخت",
               "AWT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Asia/Shanghai", China },
            { "UTC", EMPTY_ZONE },
            { "NZ", New_Zealand },
            { "AST", Alaska },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "JST", Japan },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NST", New_Zealand },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Iran", Iran },
            { "Japan", Japan },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Asia/Harbin", China },
            { "Asia/Kuwait", Arabian },
            { "Asia/Riyadh", Arabian },
            { "Asia/Tehran", Iran },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Pacific/Apia", Apia },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "America/Aruba", Atlantic },
            { "America/Boise", America_Mountain },
            { "America/Thule", Atlantic },
            { "Asia/Tel_Aviv", Israel },
            { "Australia/LHI", Lord_Howe },
            { "Europe/Lisbon", Europe_Western },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "America/Belize", America_Central },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Pyongyang", Korea },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Midway", Samoa },
            { "America/Antigua", Atlantic },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Perth", Australia_Western },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Indian/Maldives", French_Southern },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "America/Anguilla", Atlantic },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Indian/Kerguelen", French_Southern },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "America/Chihuahua", America_Central },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Pacific/Pago_Pago", Samoa },
            { "US/Indiana-Starke", America_Central },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montserrat", Atlantic },
            { "America/St_Vincent", Atlantic },
            { "Antarctica/McMurdo", New_Zealand },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Harare", "هرارے" },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.America/Lower_Princes", "د کمتر شهزاده درے میاشتنۍ" },
        };
        return data;
    }
}
