/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.text.resources.cldr.ext;

import java.util.ListResourceBundle;

public class FormatData_nqo extends ListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] metaValue_generic_narrow_AmPmMarkers = new String[] {
            "ߛ",
            "ߥ",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
        };
        final String[] metaValue_MonthNames = new String[] {
            "ߓߌ߲ߠߊߥߎߟߋ߲",
            "ߞߏ߲ߞߏߜߍ",
            "ߕߙߊߓߊ",
            "ߞߏ߲ߞߏߘߌ߬ߓߌ",
            "ߘߓߊ߬ߕߊ",
            "ߥߊ߬ߛߌ߬ߥߙߊ",
            "ߞߊ߬ߙߌߝߐ߭",
            "ߘߓߊ߬ߓߌߟߊ",
            "ߕߎߟߊߝߌ߲",
            "ߞߏ߲ߓߌߕߌ߮",
            "ߣߍߣߍߓߊ",
            "ߞߏߟߌ߲ߞߏߟߌ߲",
            "",
        };
        final String[] metaValue_MonthAbbreviations = new String[] {
            "ߓߌ߲ߠ",
            "ߞߏ߲ߞ",
            "ߕߙߊ",
            "ߞߏ߲ߘ",
            "ߘߓߊ߬ߕ",
            "ߥߊ߬ߛ",
            "ߞߊ߬ߙ",
            "ߘߓߊ߬ߓ",
            "ߕߎߟߊߝߌ߲",
            "ߞߏ߲ߓ",
            "ߣߍߣ",
            "ߞߏߟ",
            "",
        };
        final String[] metaValue_MonthNarrows = new String[] {
            "ߓ",
            "ߞ",
            "ߕ",
            "ߞ",
            "ߘ",
            "ߥ",
            "ߞ",
            "ߘ",
            "ߕ",
            "ߞ",
            "ߣ",
            "ߞ",
            "",
        };
        final String[] metaValue_generic_DayNames = new String[] {
            "ߞߊ߯ߙߌߟߏ߲",
            "ߞߐ߬ߓߊ߬ߟߏ߲",
            "ߞߐ߬ߟߏ߲",
            "ߞߎߣߎ߲ߟߏ߲",
            "ߓߌߟߏ߲",
            "ߛߌ߬ߣߌ߲߬ߟߏ߲",
            "ߞߍ߲ߘߍߟߏ߲",
        };
        final String[] metaValue_generic_DayAbbreviations = new String[] {
            "ߞߊ߯ߙ",
            "ߞߐ߬ߓ",
            "ߞߐ߬ߟߏ߲",
            "ߞߎߣ",
            "ߓߌߟ",
            "ߛߌ߬ߣ",
            "ߞߍ߲ߘ",
        };
        final String[] metaValue_generic_DayNarrows = new String[] {
            "ߞ",
            "ߞ",
            "ߞ",
            "ߞ",
            "ߓ",
            "ߛ",
            "ߞ",
        };
        final String[] metaValue_generic_QuarterNames = new String[] {
            "ߞߊߙߏߛߓߊ߫ ߁߭",
            "ߞߊߙߏߛߓߊ߫ ߂߲",
            "ߞߊߙߏߛߓߊ߫ ߃߲",
            "ߞߊߙߏߛߓߊ߫ ߄߲",
        };
        final String[] metaValue_generic_QuarterAbbreviations = new String[] {
            "ߞߛ߁",
            "ߞߛ߂",
            "ߞߛ߃",
            "ߞߛ߄",
        };
        final String[] metaValue_QuarterNarrows = new String[] {
            "߁",
            "߂",
            "߃",
            "߄",
        };
        final String[] metaValue_java_time_long_Eras = new String[] {
            "ߌߛߊ߫ ߡߏߦߌ ߢߍ߫",
            "ߌߛߊ߫ ߡߏߦߌ ߞߐ߫",
        };
        final String[] metaValue_java_time_Eras = new String[] {
            "ߌߛ. ߡ. ߢߍ߫",
            "ߌߛ. ߡ. ߞߐ߫",
        };
        final String[] metaValue_java_time_narrow_Eras = new String[] {
            "ߌߛ. ߢߍ߫",
            "ߌߛ. ߞߐ߫",
        };
        final String metaValue_generic_DateFormatItem_yMMMd = "y / dd MMM";
        final String metaValue_generic_DateFormatItem_yMd = "y / dd / MM";
        final String[] metaValue_latn_NumberPatterns = new String[] {
            "#,##0.###",
            "¤ #,##0.00",
            "#,##0%",
            "",
        };
        final Object[][] data = new Object[][] {
            { "generic.DayNames", metaValue_generic_DayNames },
            { "generic.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "generic.DayNarrows", metaValue_generic_DayNarrows },
            { "generic.QuarterNames", metaValue_generic_QuarterNames },
            { "generic.QuarterAbbreviations", metaValue_generic_QuarterAbbreviations },
            { "generic.narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "generic.abbreviated.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "generic.DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "generic.DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "MonthNames", metaValue_MonthNames },
            { "standalone.MonthNames", metaValue_MonthNames },
            { "MonthAbbreviations", metaValue_MonthAbbreviations },
            { "standalone.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "MonthNarrows", metaValue_MonthNarrows },
            { "standalone.MonthNarrows", metaValue_MonthNarrows },
            { "DayNames", metaValue_generic_DayNames },
            { "standalone.DayNames", metaValue_generic_DayNames },
            { "DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "standalone.DayAbbreviations",
                new String[] {
                    "ߞߊ߯ߙ",
                    "ߞߐ߬ߓ",
                    "ߞߐ߬ߟ",
                    "ߞߎߣ",
                    "ߓߌߟ",
                    "ߛߌ߬ߣ",
                    "ߞߍ߲ߘ",
                }
            },
            { "DayNarrows", metaValue_generic_DayNarrows },
            { "standalone.DayNarrows", metaValue_generic_DayNarrows },
            { "QuarterNames", metaValue_generic_QuarterNames },
            { "standalone.QuarterNames", metaValue_generic_QuarterNames },
            { "QuarterAbbreviations", metaValue_generic_QuarterAbbreviations },
            { "standalone.QuarterAbbreviations", metaValue_generic_QuarterAbbreviations },
            { "QuarterNarrows", metaValue_QuarterNarrows },
            { "standalone.QuarterNarrows", metaValue_QuarterNarrows },
            { "AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "abbreviated.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "java.time.long.Eras", metaValue_java_time_long_Eras },
            { "long.Eras", metaValue_java_time_long_Eras },
            { "java.time.Eras", metaValue_java_time_Eras },
            { "Eras", metaValue_java_time_Eras },
            { "java.time.narrow.Eras", metaValue_java_time_narrow_Eras },
            { "narrow.Eras", metaValue_java_time_narrow_Eras },
            { "field.era", "ߕߎ߬ߡߊ" },
            { "field.year", "ߛߊ߲߭" },
            { "field.month", "ߞߊߙߏ" },
            { "field.week", "ߟߐ߯ߕߍ" },
            { "field.weekday", "ߟߐ߯ߕߍ ߟߏ߲ ߠߎ߬" },
            { "field.dayperiod", "ߛ/ߥ" },
            { "field.hour", "ߕߎ߬ߡߊ߬ߙߋ߲" },
            { "timezone.gmtFormat", "ߜ߭ߕߖ{0}" },
            { "timezone.gmtZeroFormat", "ߜ߭ߕߖ" },
            { "timezone.regionFormat", "{0} ߕߎ߬ߡߊ" },
            { "timezone.regionFormat.daylight", "{0} ߕߎ߬ߡߊ߬-ߦߟߍߡߊ߲" },
            { "timezone.regionFormat.standard", "{0} ߕߎ߬ߡߊ߬-ߦߟߍߡߊ߲ߓߊߟߌ" },
            { "field.minute", "ߡߌ߬ߛߍ߲" },
            { "field.second", "ߝߌ߬ߟߊ߲" },
            { "field.zone", "ߝߊ߲߬ߕߙߊ߬ ߕߎߡߊ" },
            { "DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "buddhist.MonthNames", metaValue_MonthNames },
            { "buddhist.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "buddhist.DayNames", metaValue_generic_DayNames },
            { "buddhist.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "buddhist.QuarterNames", metaValue_generic_QuarterNames },
            { "buddhist.QuarterAbbreviations", metaValue_generic_QuarterAbbreviations },
            { "buddhist.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "buddhist.narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "buddhist.abbreviated.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "buddhist.DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "buddhist.DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "japanese.MonthNames", metaValue_MonthNames },
            { "japanese.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "japanese.DayNames", metaValue_generic_DayNames },
            { "japanese.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "japanese.QuarterNames", metaValue_generic_QuarterNames },
            { "japanese.QuarterAbbreviations", metaValue_generic_QuarterAbbreviations },
            { "japanese.QuarterNarrows", metaValue_QuarterNarrows },
            { "japanese.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "japanese.abbreviated.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "japanese.DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "japanese.DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "roc.MonthNames", metaValue_MonthNames },
            { "roc.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "roc.DayNames", metaValue_generic_DayNames },
            { "roc.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "roc.DayNarrows", metaValue_generic_DayNarrows },
            { "roc.QuarterNames", metaValue_generic_QuarterNames },
            { "roc.QuarterAbbreviations", metaValue_generic_QuarterAbbreviations },
            { "roc.QuarterNarrows", metaValue_QuarterNarrows },
            { "roc.abbreviated.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "roc.DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "roc.DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "islamic.DayNames", metaValue_generic_DayNames },
            { "islamic.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "islamic.QuarterNames", metaValue_generic_QuarterNames },
            { "islamic.QuarterAbbreviations", metaValue_generic_QuarterAbbreviations },
            { "islamic.abbreviated.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "islamic.DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "islamic.DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "islamic-civil.DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "islamic-civil.DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "islamic-umalqura.DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "islamic-umalqura.DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "DefaultNumberingSystem", "nkoo" },
            { "latn.NumberElements",
                new String[] {
                    ".",
                    "،",
                    ";",
                    "%",
                    "0",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "NaN",
                    "",
                    "",
                }
            },
            { "latn.NumberPatterns", metaValue_latn_NumberPatterns },
            { "nkoo.NumberElements",
                new String[] {
                    ".",
                    "،",
                    ";",
                    "%",
                    "߀",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "NaN",
                    "",
                    "",
                }
            },
            { "nkoo.NumberPatterns", metaValue_latn_NumberPatterns },
        };
        return data;
    }
}
