/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_yi extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_FJ = "פֿידזשי";
        final String metaValue_ar = "אַראַביש";
        final String metaValue_el = "גריכיש";
        final Object[][] data = new Object[][] {
            { "001", "וועלט" },
            { "002", "אַפֿריקע" },
            { "003", "צפון־אַמעריקע" },
            { "005", "דרום־אַמעריקע" },
            { "009", "אקעאַניע" },
            { "013", "צענטראַל־אַמעריקע" },
            { "019", "אַמעריקע" },
            { "021", "צפונדיקע אַמעריקע" },
            { "029", "קאַראַאיבע" },
            { "030", "מזרח אַזיע" },
            { "034", "דרום־אַזיע" },
            { "035", "דרום־מזרח אַזיע" },
            { "039", "דרום־אייראפּע" },
            { "061", "פּאלינעזיע" },
            { "142", "אַזיע" },
            { "143", "צענטראַל־אַזיע" },
            { "145", "מערב־אַזיע" },
            { "150", "אייראפּע" },
            { "151", "מזרח־אייראפּע" },
            { "154", "צפֿון־אייראפּע" },
            { "155", "מערב־אייראפּע" },
            { "419", "לאַטיין־אַמעריקע" },
            { "AD", "אַנדארע" },
            { "AF", "אַפֿגהאַניסטאַן" },
            { "AG", "אַנטיגוע און באַרבודע" },
            { "AL", "אַלבאַניע" },
            { "AM", "אַרמעניע" },
            { "AO", "אַנגאלע" },
            { "AQ", "אַנטאַרקטיקע" },
            { "AR", "אַרגענטינע" },
            { "AT", "עסטרייך" },
            { "AU", "אויסטראַליע" },
            { "AW", "אַרובאַ" },
            { "BA", "באסניע הערצעגאווינע" },
            { "BB", "באַרבאַדאס" },
            { "BD", "באַנגלאַדעש" },
            { "BE", "בעלגיע" },
            { "BF", "בורקינע פֿאַסא" },
            { "BG", "בולגאַריע" },
            { "BI", "בורונדי" },
            { "BJ", "בענין" },
            { "BM", "בערמודע" },
            { "BN", "ברוניי" },
            { "BO", "באליוויע" },
            { "BR", "בראַזיל" },
            { "BS", "באַהאַמאַס" },
            { "BT", "בהוטאַן" },
            { "BW", "באצוואַנע" },
            { "BY", "בעלאַרוס" },
            { "BZ", "בעליז" },
            { "CA", "קאַנאַדע" },
            { "CD", "קאנגא־קינשאַזע" },
            { "CF", "צענטראַל־אַפֿריקאַנישע רעפּובליק" },
            { "CH", "שווייץ" },
            { "CI", "העלפֿאַ נדביין בארטן" },
            { "CK", "קוק אינזלען" },
            { "CL", "טשילע" },
            { "CM", "קאַמערון" },
            { "CN", "כינע" },
            { "CO", "קאלאמביע" },
            { "CR", "קאסטאַ ריקאַ" },
            { "CU", "קובאַ" },
            { "CV", "קאַפּווערדישע אינזלען" },
            { "CW", "קוראַסאַא" },
            { "CZ", "טשעכיי" },
            { "DE", "דייטשלאַנד" },
            { "DJ", "דזשיבוטי" },
            { "DK", "דענמאַרק" },
            { "DM", "דאמיניקע" },
            { "DO", "דאמיניקאַנישע רעפּובליק" },
            { "EC", "עקוואַדאר" },
            { "EE", "עסטלאַנד" },
            { "EG", "עגיפּטן" },
            { "ER", "עריטרעע" },
            { "ES", "שפּאַניע" },
            { "ET", "עטיאפּיע" },
            { "EU", "אייראפּעישער פֿאַרבאַנד" },
            { "FI", "פֿינלאַנד" },
            { "FJ", metaValue_FJ },
            { "FK", "פֿאַלקלאַנד אינזלען" },
            { "FM", "מיקראנעזיע" },
            { "FO", "פֿאַרא אינזלען" },
            { "FR", "פֿראַנקרייך" },
            { "GA", "גאַבאן" },
            { "GB", "פֿאַראייניגטע קעניגרייך" },
            { "GD", "גרענאַדאַ" },
            { "GE", "גרוזיע" },
            { "GF", "פֿראַנצויזישע גויאַנע" },
            { "GG", "גערנזי" },
            { "GH", "גהאַנע" },
            { "GI", "גיבראַלטאַר" },
            { "GL", "גרינלאַנד" },
            { "GM", "גאַמביע" },
            { "GN", "גינע" },
            { "GP", "גוואַדעלופ" },
            { "GQ", "עקוואַטארישע גינע" },
            { "GR", "גריכנלאַנד" },
            { "GT", "גוואַטעמאַלע" },
            { "GU", "גוואַם" },
            { "GW", "גינע־ביסאַו" },
            { "GY", "גויאַנע" },
            { "HN", "האנדוראַס" },
            { "HR", "קראאַטיע" },
            { "HT", "האַיטי" },
            { "HU", "אונגערן" },
            { "IC", "קאַנאַרישע אינזלען" },
            { "ID", "אינדאנעזיע" },
            { "IE", "אירלאַנד" },
            { "IL", "ישראל" },
            { "IN", "אינדיע" },
            { "IR", "איראַן" },
            { "IS", "איסלאַנד" },
            { "IT", "איטאַליע" },
            { "JE", "דזשערזי" },
            { "JM", "דזשאַמייקע" },
            { "JP", "יאַפּאַן" },
            { "KE", "קעניע" },
            { "KH", "קאַמבאדיע" },
            { "KI", "קיריבאַטי" },
            { "KM", "קאמאראס" },
            { "KY", "קיימאַן אינזלען" },
            { "LA", "לאַאס" },
            { "LB", "לבנון" },
            { "LI", "ליכטנשטיין" },
            { "LK", "סרי־לאַנקאַ" },
            { "LR", "ליבעריע" },
            { "LS", "לעסאטא" },
            { "LT", "ליטע" },
            { "LU", "לוקסעמבורג" },
            { "LV", "לעטלאַנד" },
            { "LY", "ליביע" },
            { "MA", "מאַראקא" },
            { "MC", "מאנאַקא" },
            { "MD", "מאלדאווע" },
            { "ME", "מאנטענעגרא" },
            { "MG", "מאַדאַגאַסקאַר" },
            { "MH", "מאַרשאַל אינזלען" },
            { "ML", "מאַלי" },
            { "MM", "מיאַנמאַר" },
            { "MN", "מאנגאליי" },
            { "MQ", "מאַרטיניק" },
            { "MR", "מאַריטאַניע" },
            { "MS", "מאנטסעראַט" },
            { "MT", "מאַלטאַ" },
            { "MU", "מאריציוס" },
            { "MV", "מאַלדיוון" },
            { "MW", "מאַלאַווי" },
            { "MX", "מעקסיקע" },
            { "MY", "מאַלייזיע" },
            { "MZ", "מאזאַמביק" },
            { "NA", "נאַמיביע" },
            { "NC", "נײַ קאַלעדאניע" },
            { "NE", "ניזשער" },
            { "NF", "נארפֿאלק אינזל" },
            { "NG", "ניגעריע" },
            { "NI", "ניקאַראַגוע" },
            { "NL", "האלאַנד" },
            { "NO", "נארוועגיע" },
            { "NP", "נעפּאַל" },
            { "NZ", "ניו זילאַנד" },
            { "PA", "פּאַנאַמאַ" },
            { "PE", "פּערו" },
            { "PF", "פֿראַנצויזישע פּאלינעזיע" },
            { "PG", "פּאַפּואַ נײַ גינע" },
            { "PH", "פֿיליפּינען" },
            { "PK", "פּאַקיסטאַן" },
            { "PL", "פּוילן" },
            { "PN", "פּיטקערן אינזלען" },
            { "PR", "פּארטא־ריקא" },
            { "PT", "פּארטוגאַל" },
            { "PY", "פּאַראַגווײַ" },
            { "QA", "קאַטאַר" },
            { "RE", "רעאוניאן" },
            { "RO", "רומעניע" },
            { "RS", "סערביע" },
            { "RU", "רוסלאַנד" },
            { "RW", "רוואַנדע" },
            { "SB", "סאלאמאן אינזלען" },
            { "SC", "סיישעל" },
            { "SD", "סודאַן" },
            { "SE", "שוועדן" },
            { "SG", "סינגאַפּור" },
            { "SH", "סט העלענע" },
            { "SI", "סלאוועניע" },
            { "SK", "סלאוואַקיי" },
            { "SL", "סיערע לעאנע" },
            { "SM", "סאַן מאַרינא" },
            { "SN", "סענעגאַל" },
            { "SO", "סאמאַליע" },
            { "SR", "סורינאַם" },
            { "SS", "דרום־סודאַן" },
            { "ST", "סאַא טאמע און פּרינסיפּע" },
            { "SV", "על סאַלוואַדאר" },
            { "SY", "סיריע" },
            { "SZ", "סוואַזילאַנד" },
            { "TD", "טשאַד" },
            { "TG", "טאגא" },
            { "TH", "טיילאַנד" },
            { "TL", "מזרח טימאר" },
            { "TM", "טורקמעניסטאַן" },
            { "TN", "טוניסיע" },
            { "TO", "טאנגאַ" },
            { "TR", "טערקיי" },
            { "TT", "טרינידאַד און טאבאַגא" },
            { "TV", "טואוואַלו" },
            { "TZ", "טאַנזאַניע" },
            { "UA", "אוקראַינע" },
            { "UG", "אוגאַנדע" },
            { "US", "פֿאַראייניגטע שטאַטן" },
            { "UY", "אורוגוויי" },
            { "VA", "וואַטיקאַן שטאָט" },
            { "VE", "ווענעזועלע" },
            { "VN", "וויעטנאַם" },
            { "VU", "וואַנואַטו" },
            { "WS", "סאַמאאַ" },
            { "XK", "קאסאווא" },
            { "YE", "תימן" },
            { "YT", "מאַיאט" },
            { "ZA", "דרום־אַפֿריקע" },
            { "ZM", "זאַמביע" },
            { "ZW", "זימבאַבווע" },
            { "ZZ", "אומבאַוואוסטער ראַיאן" },
            { "aa", "אַפֿאַר" },
            { "af", "אַפֿריקאַנס" },
            { "am", "אַמהאַריש" },
            { "an", "אַראַגאניש" },
            { "ar", metaValue_ar },
            { "as", "אַסאַמיש" },
            { "az", "אַזערביידזשאַניש" },
            { "be", "בעלאַרוסיש" },
            { "bg", "בולגאַריש" },
            { "bn", "בענגאַליש" },
            { "bo", "טיבעטיש" },
            { "br", "ברעטאניש" },
            { "bs", "באסניש" },
            { "ca", "קאַטאַלאניש" },
            { "cs", "טשעכיש" },
            { "cu", "קלויסטער־סלאַוויש" },
            { "cy", "וועלשיש" },
            { "da", "דעניש" },
            { "de", "דײַטש" },
            { "el", metaValue_el },
            { "en", "ענגליש" },
            { "eo", "עספּעראַנטא" },
            { "es", "שפּאַניש" },
            { "et", "עסטיש" },
            { "eu", "באַסקיש" },
            { "fa", "פּערסיש" },
            { "fi", "פֿיניש" },
            { "fj", metaValue_FJ },
            { "fo", "פֿאַראיש" },
            { "fr", "פֿראַנצויזיש" },
            { "fy", "מערב־פֿריזיש" },
            { "ga", "איריש" },
            { "gd", "סקאטיש געליש" },
            { "gl", "גאַלישיש" },
            { "gv", "מאַנקס" },
            { "ha", "האַוסאַ" },
            { "he", "העברעאיש" },
            { "hi", "הינדי" },
            { "hr", "קראאַטיש" },
            { "hu", "אונגעריש" },
            { "hy", "אַרמעניש" },
            { "id", "אינדאנעזיש" },
            { "io", "אידא" },
            { "is", "איסלאַנדיש" },
            { "it", "איטאַליעניש" },
            { "ja", "יאַפּאַניש" },
            { "jv", "יאַוואַנעזיש" },
            { "ka", "גרוזיניש" },
            { "kk", "קאַזאַכיש" },
            { "km", "כמער" },
            { "kn", "קאַנאַדאַ" },
            { "ko", "קארעאיש" },
            { "ku", "קורדיש" },
            { "kw", "קארניש" },
            { "ky", "קירגיזיש" },
            { "la", "לאטייניש" },
            { "lb", "לוקסעמבורגיש" },
            { "lo", "לאַא" },
            { "lt", "ליטוויש" },
            { "lv", "לעטיש" },
            { "mi", "מאַאריש" },
            { "mk", "מאַקעדאניש" },
            { "ml", "מאַלאַיאַלאַם" },
            { "mn", "מאנגאליש" },
            { "mt", "מאַלטעזיש" },
            { "my", "בירמאַניש" },
            { "ne", "נעפּאַליש" },
            { "nl", "האלענדיש" },
            { "nn", "נײַ־נארוועגיש" },
            { "no", "נארוועגיש" },
            { "oc", "אקסיטאַניש" },
            { "os", "אסעטיש" },
            { "pl", "פּויליש" },
            { "ps", "פּאַשטאָ" },
            { "pt", "פּארטוגעזיש" },
            { "ro", "רומעניש" },
            { "ru", "רוסיש" },
            { "sa", "סאַנסקריט" },
            { "sc", "סאַרדיש" },
            { "sd", "סינדהי" },
            { "se", "נארדסאַמיש" },
            { "sh", "סערבא־קראאַטיש" },
            { "si", "סינהאַליש" },
            { "sk", "סלאוואַקיש" },
            { "sl", "סלאוועניש" },
            { "sm", "סאַמאאַניש" },
            { "sn", "שאנאַ" },
            { "so", "סאמאַליש" },
            { "sq", "אַלבאַניש" },
            { "sr", "סערביש" },
            { "sv", "שוועדיש" },
            { "sw", "סוואַהיליש" },
            { "ta", "טאַמיל" },
            { "tk", "טורקמעניש" },
            { "tl", "טאַגאַלאג" },
            { "tt", "טאָטעריש" },
            { "uk", "אוקראַאיניש" },
            { "ur", "אורדו" },
            { "uz", "אוזבעקיש" },
            { "vi", "וויעטנאַמעזיש" },
            { "vo", "וואלאַפּוק" },
            { "yi", "ייִדיש" },
            { "zh", "כינעזיש" },
            { "zu", "זולו" },
            { "akk", "אַקאַדיש" },
            { "ang", "אַלט ענגליש" },
            { "arc", "אַראַמיש" },
            { "ban", "באַלינעזיש" },
            { "bar", "בײַעריש" },
            { "ceb", "סעבואַניש" },
            { "crh", "קרים־טערקיש" },
            { "csb", "קאַשוביש" },
            { "dsb", "אונטער־סארביש" },
            { "dyo", "זשאלא־פֿאני" },
            { "enm", "מיטל ענגליש" },
            { "fil", "פֿיליפּינא" },
            { "fro", "אַלט־פֿראַנצויזיש" },
            { "frr", "דרום־פֿריזיש" },
            { "frs", "מזרח־פֿריזיש" },
            { "gmh", "מיטל הויכדויטש" },
            { "goh", "אַלט־ הויכדויטש" },
            { "got", "גאטיש" },
            { "grc", "אוראַלט־גריכיש" },
            { "hif", "פידזשי הינדי" },
            { "hsb", "אייבער־סארביש" },
            { "jbo", "לאזשבאָן" },
            { "jpr", "יידיש־פערסיש" },
            { "lad", "לאַדינא" },
            { "liv", "ליוויש" },
            { "lus", "מיזא" },
            { "nap", "נאַפּאליטַניש" },
            { "nds", "נידערדײַטש" },
            { "peo", "אַלט פּערסיש" },
            { "prg", "פּרייסיש" },
            { "rue", "רוסיניש" },
            { "scn", "סיציליאַניש" },
            { "sco", "סקאטס" },
            { "sga", "אַלט־איריש" },
            { "sli", "אונטער שלעזיש" },
            { "sux", "סומעריש" },
            { "swb", "קאמאריש" },
            { "szl", "שלעזיש" },
            { "tig", "טיגרע" },
            { "und", "אומבאַוואוסטע שפּראַך" },
            { "vls", "מערב פֿלעמיש" },
            { "Arab", metaValue_ar },
            { "Cyrl", "ציריליש" },
            { "Deva", "דעוואַנאַגאַרי" },
            { "Grek", metaValue_el },
            { "Hebr", "העברעיש" },
            { "Latn", "גַלחיש" },
            { "nl_BE", "פֿלעמיש" },
            { "sw_CD", "קאנגא־סוואַהיליש" },
            { "key.nu", "נומערן" },
            { "type.ca.gregorian", "גרעגארישער קאַלענדאַר" },
        };
        return data;
    }
}
