/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ha extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Lokacin Greenwich a Ingila",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Tsayayyen Lokacin Apia",
               "",
               "Lokacin Rana na Apia",
               "",
               "Lokacin Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Tsayayyen Lokacin Cook Islands",
               "",
               "Rabin Lokacin Bazara na Cook Islands",
               "",
               "Lokacin Cook Islands",
               "",
            };
        final String[] Cuba = new String[] {
               "Tsayayyen Lokacin Kuba",
               "CST",
               "Lokacin Rana na Kuba",
               "CDT",
               "Lokaci na Kuba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Tsayayyen Lokacin Fiji",
               "",
               "Lokacin Bazara na Fiji",
               "",
               "Lokacin Fiji",
               "",
            };
        final String[] Gulf = new String[] {
               "Tsayayyen lokacin Gulf",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Tsayayyen Lokacin Hovd",
               "",
               "Lokacin Bazara na Hovd",
               "",
               "Lokacin Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Tsayayyen Lokacin Iran",
               "",
               "Lokacin Rana na Iran",
               "",
               "Lokacin Iran",
               "",
            };
        final String[] Niue = new String[] {
               "Lokacin Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Tsayayyen Lokacin Omsk",
               "",
               "Lokacin Bazara na Omsk",
               "",
               "Lokacin Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Tsayayyen Lokacin Peru",
               "",
               "Lokacin Bazara na Peru",
               "",
               "Lokacin Peru",
               "",
            };
        final String[] Truk = new String[] {
               "Lokacin Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Lokacin Wake Island",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Tsayayyen Lokacin Chile",
               "",
               "Lokacin Bazara na Chile",
               "",
               "Lokacin Chile",
               "",
            };
        final String[] China = new String[] {
               "Tsayayyen Lokacin Sin",
               "CST",
               "Lokacin Rana na Sin",
               "CDT",
               "Lokacin Sin",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Lokacin Cocos Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Lokacin Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Tsayayyen lokacin Indiya",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Tsayayyen lokacin Japan",
               "JST",
               "Lokacin Hasken Rana na Japan",
               "JDT",
               "Lokacin Japan",
               "JT",
            };
        final String[] Korea = new String[] {
               "Tsayayyen Lokacin Koriya",
               "KST",
               "Lokacin Rana na Koriya",
               "KST",
               "Lokacin Koriya",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Lokacin Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Lokacin Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Lokacin Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Tsayayyen Lokacin Samoa",
               "SST",
               "Lokacin Rana na Vote Samoa",
               "SST",
               "Lokacin Samoa",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Lokacin Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tsayayyen Lokacin Tonga",
               "",
               "Lokacin Bazara na Tonga",
               "",
               "Lokacin Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "Lokacin Yukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Tsayayyen Lokacin Alaska",
               "AKST",
               "Lokacin Rana na Alaska",
               "AKDT",
               "Lokacin Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Tsayayyen Lokacin Amazon",
               "",
               "Lokacin Bazara na Amazon",
               "",
               "Lokacin Amazon",
               "",
            };
        final String[] Azores = new String[] {
               "Lokacin Azores Daidaitacce",
               "",
               "Lokacin Azure na Bazara",
               "",
               "Lokacin Azores",
               "",
            };
        final String[] Bhutan = new String[] {
               "Lokacin Bhutan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Lokacin Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Tsayayyen Lokacin Easter Island",
               "",
               "Lokacin Bazara na Easter Island",
               "",
               "Lokacin Easter Island",
               "",
            };
        final String[] Guyana = new String[] {
               "Lokacin Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Tsayayyen lokacin Israʼila",
               "IST",
               "Lokacin Hasken Rana na Israʼila",
               "IDT",
               "Lokacin Israʼila",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Lokacin Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Lokacin Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Tsayayyen Lokacin Moscow",
               "MSK",
               "Lokacin Bazara na Moscow",
               "MSK",
               "Lokacin Moscow",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Lokacin Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Lokacin Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Tsayayyen Lokacin Taipei",
               "CST",
               "Lokacin Rana na Taipei",
               "CDT",
               "Lokacin Taipei",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Lokacin Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Lokacin Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Lokacin Wallis da Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Tsayayyen lokacin Arebiya",
               "",
               "Lokacin Rana na Arebiya",
               "",
               "Lokacin Arebiya",
               "",
            };
        final String[] Armenia = new String[] {
               "Tsayayyen Lokacin Armenia",
               "",
               "Lokacin Bazara na Armenia",
               "",
               "Lokacin Armenia",
               "",
            };
        final String[] Bolivia = new String[] {
               "Lokacin Bolivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Tsayayyen Lokacin Chatham",
               "",
               "Lokacin Rana na Chatham",
               "",
               "Lokacin Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Hadewa Lokaci na Duniya",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Lokacin Ecuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Lokacin Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Tsayayyen Lokacin Georgia",
               "",
               "Lokacin Bazara na Georgia",
               "",
               "Lokacin Georgia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Tsayayyen Lokacin Irkutsk",
               "",
               "Lokacin Bazara na Irkutsk",
               "",
               "Lokacin Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Tsayayyen Lokacin Magadan",
               "",
               "Lokacin Bazara na Magadan",
               "",
               "Lokacin Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Lokacin Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Tsayayyen Lokacin Norfolk Island",
               "",
               "Lokacin Rana na Norfolk Island",
               "",
               "Lokacin Norfolk Island",
               "",
            };
        final String[] Noronha = new String[] {
               "Tsayayyen Lokacin Fernando de Noronha",
               "",
               "Lokacin Bazara na Fernando de Noronha",
               "",
               "Lokacin Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Lokacin Réunion",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Lokacin Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Lokacin Rana na Solomon",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Lokacin Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Tsayayyen Lokacin Uruguay",
               "",
               "Lokacin Bazara na Uruguay",
               "",
               "Lokacin Uruguay",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Tsayayyen Lokacin Vanuatu",
               "",
               "Lokacin Bazara na Vanuatu",
               "",
               "Lokacin Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Tsayayyen Lokacin Yakutsk",
               "",
               "Lokacin Bazara na Yakutsk",
               "",
               "Lokacin Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Tsayayyen Lokacin Kanada, Puerto Rico da Virgin Islands",
               "AST",
               "Lokacin Rana na Kanada, Puerto Rico da Virgin Islands",
               "AST",
               "Lokacin Kanada, Puerto Rico da Virgin Islands",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Tsayayyen Lokacin Brasillia",
               "",
               "Lokacin Bazara na Brasillia",
               "",
               "Lokacin Brasillia",
               "",
            };
        final String[] Chamorro = new String[] {
               "Tsayayyen Lokacin Chamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Tsayayyen Lokacin Colombia",
               "",
               "Lokacin Bazara na Colombia",
               "",
               "Lokacin Colombia",
               "",
            };
        final String[] Falkland = new String[] {
               "Tsayayyen Lokacin Falkland Islands",
               "",
               "Lokacin Bazara na Falkland Islands",
               "",
               "Lokacin Falkland Islands",
               "",
            };
        final String[] Malaysia = new String[] {
               "Lokacin Malaysia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Lokacin Maldives",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Tsayayyen Lokacin Ulaanbaatar",
               "",
               "Lokacin Bazara na Ulaanbaatar",
               "",
               "Lokacin Ulaanbaatar",
               "",
            };
        final String[] Pakistan = new String[] {
               "Tsayayyen Lokacin Pakistan",
               "PKT",
               "Lokacin Bazara na Pakistan",
               "PKST",
               "Lokacin Pakistan",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Tsayayyen Lokacin Paraguay",
               "",
               "Lokacin Bazara na Paraguay",
               "",
               "Lokacin Paraguay",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Lokacin Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Tsayayyen Lokacin Sakhalin",
               "",
               "Lokacin Bazara na Sakhalin",
               "",
               "Lokacin Sakhalin",
               "",
            };
        final String[] Suriname = new String[] {
               "Lokacin Suriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Tsayayyen Lokacin Argentina",
               "",
               "Lokacin Bazara na Argentina",
               "",
               "Lokacin Argentina",
               "",
            };
        final String[] Christmas = new String[] {
               "Lokacin Christmas Island",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Lokacin Galapagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Tsayayyen Lokacin Hong Kong",
               "HKT",
               "Lokacin Bazara na Hong Kong",
               "HKST",
               "Lokacin Hong Kong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Lokacin Indochina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Lokacin Kyrgyzstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Tsayayyen Lokacin Lord Howe",
               "",
               "Lokacin Rana na Vote Lord Howe",
               "",
               "Lokacin Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Lokacin Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Tsayayyen Lokacin Mauritius",
               "",
               "Lokacin Bazara na Mauritius",
               "",
               "Lokacin Mauritius",
               "",
            };
        final String[] Singapore = new String[] {
               "Tsayayyen Lokacin Singapore",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Lokacin Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Tsayayyen Lokacin Volgograd",
               "MSK",
               "Lokacin Bazara na Volgograd",
               "MSK",
               "Lokacin Volgograd",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Tsayayyen Lokacin Azerbaijan",
               "",
               "Lokacin Bazara na Azerbaijan",
               "",
               "Lokacin Azerbaijan",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Tsayayyen Lokacin Bangladesh",
               "",
               "Lokacin Bazara na Bangladesh",
               "",
               "Lokacin Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Tsayayyen lokacin Cape Verde",
               "",
               "Lokacin Bazara na Cape Verde",
               "",
               "Lokacin Cape Verde",
               "",
            };
        final String[] East_Timor = new String[] {
               "Lokacin East Timor",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Lokacin Kazakhstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Lokacin Seychelles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Lokacin Tajikistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Tsayayyen Lokacin Uzbekistan",
               "",
               "Lokacin Bazara na Uzbekistan",
               "",
               "Lokacin Uzbekistan",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Lokacin Afghanistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Tsayayyen Lokacin Krasnoyarsk",
               "",
               "Lokacin Bazara na Krasnoyarsk",
               "",
               "Lokacin Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Tsayayyen Lokacin New Zealand",
               "NZST",
               "Lokacin Rana na New Zealand",
               "NZDT",
               "Lokacin New Zealand",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk Standard Time",
               "",
               "Lokacin Bazara na Novosibirsk",
               "",
               "Lokacin Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Tsayayyen Lokacin Philippine",
               "PST",
               "Lokacin Bazara na Philippine",
               "PDT",
               "Lokacin Philippine",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Tsayayyen Lokacin Vladivostok",
               "",
               "Lokacin Bazara na Vladivostok",
               "",
               "Lokacin Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Lokacin Tekun Indiya",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Lokacin Line Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Lokaci Tsayayye ta Newfoundland",
               "NST",
               "Lokaci rana ta Newfoundland",
               "NDT",
               "Lokacin Newfoundland",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Tsayayyen Lokacin Turkmenistan",
               "",
               "Lokacin Bazara na Turkmenistan",
               "",
               "Lokacin Turkmenistan",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Lokacin French Guiana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Tsayayyen Lokacin New Caledonia",
               "",
               "Lokacin Bazara na New Caledonia",
               "",
               "Lokacin New Caledonia",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Lokacin Kudancin Georgia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Tsayayyen Lokacin Yekaterinburg",
               "",
               "Lokacin Bazara na Yekaterinburg",
               "",
               "Lokacin Yekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Lokacin Afirka ta Tsakiya",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Lokacin Gabashin Afirka",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Tsayayyen Lokacin Afirka ta Yamma",
               "WAT",
               "Lokacin Bazara na Afirka ta Yamma",
               "WAT",
               "Lokacin Afirka ta Yamma",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Lokacin Dumont-d’Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Ida Tsakiyar a Lokaci Turai",
               "CET",
               "Tsakiyar bazara a lokaci turai",
               "CEST",
               "Tsakiyar a lokaci turai",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Ida lokaci a turai gabas",
               "EET",
               "Gabas a lokaci turai da bazara",
               "EEST",
               "Lokaci a turai gabas",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Ida lokaci ta yammacin turai",
               "WET",
               "Ida lokaci ta yammacin turai da bazara",
               "WEST",
               "Lokaci ta yammacin turai",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Tsayayyen Lokacin Mekziko Pacific",
               "MST",
               "Lokacin Rana na Mekziko Pacific",
               "MDT",
               "Lokacin Mekziko Pacific",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Tsayayyen Lokacin Afirka ta Kudu",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Tsayayyen Lokaci dake Arewacin Amurika ta Tsakiya",
               "CST",
               "Lokacin Rana dake Arewacin Amurika ta Tsakiya",
               "CDT",
               "Lokaci dake Amurika arewa ta tsakiyar",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Tsayayyen Lokacin Gabas dake Arewacin Amurika",
               "EST",
               "Lokacin Rana ta Gabas dake Arewacin Amurika",
               "EST",
               "Lokacin Gabas dake Arewacin Amurikaa",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Lokaci Tsayayye na Arewacin Amurika",
               "PST",
               "Lokacin Rana na Arewacin Amurka",
               "PDT",
               "Lokacin Arewacin Amurika",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Lokacin Kudancin Faransa da Antarctic",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Lokacin Gilbert Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Tsayayyen Lokacin Hawaii-Aleutian",
               "HST",
               "Lokacin Rana na Hawaii-Aleutian",
               "HST",
               "Lokaci na Hawaii-Aleutian",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Lokacin Phoenix Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Tsayayyen Lokacin St. Pierre da Miquelon",
               "",
               "Lokacin Rana na St. Pierre da Miquelon",
               "",
               "Lokacin St. Pierre da Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Lokaci tsayayye na tsauni a Arewacin Amurica",
               "MST",
               "Lokacin Rana na Tsaunin Arewacin Amurka",
               "MST",
               "Lokacin Tsauni na Arewacin Amurka",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Lokacin Marshall Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Lokacin Papua New Guinea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Tsayayyen Lokacin Tsakiyar Austiraliya",
               "ACST",
               "Lokacin Rana na Tsakiyar Austiraliya",
               "ACDT",
               "Lokacin Tsakiyar Australiya",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Tsayayyen lokacin Gabashin Australia",
               "AEST",
               "Lokacin Rana na Gabashin Austiraliya",
               "AEDT",
               "Lokacin Gabashin Austiraliya",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Tsayayyen Lokacin Yammacin Austiralia",
               "AWST",
               "Lokacin Rana na Yammacin Austiralia",
               "AWDT",
               "Lokacin Yammacin Austiralia",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Lokacin Indonesia ta Tsakiya",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Lokacin Gabashin Indonesia",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Lokacin Yammacin Indonesia",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Tsayayyen Lokacin Yammacin Tsakiyar Austiraliya",
               "",
               "Lokacin Rana na Yammacin Tsakiyar Austiraliya",
               "",
               "Lokacin Yammacin Tsakiyar Austiraliya",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Lokacin Greenwich a Ingila",
                    "GMT",
                    "Lokacin Bazara na Birtaniya",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Hadewa Lokaci na Duniya",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Lokacin Greenwich a Ingila",
                    "GMT",
                    "Tsayayyen Lokacin Irish",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Hadewa Lokaci na Duniya",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Hadewa Lokaci na Duniya",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Lokacin Greenwich a Ingila",
                    "GMT",
                    "Lokacin Bazara na Birtaniya",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Hadewa Lokaci na Duniya",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Hadewa Lokaci na Duniya",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Hadewa Lokaci na Duniya",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Lokacin Greenwich a Ingila",
                    "GMT",
                    "Tsayayyen Lokacin Irish",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Lokacin Greenwich a Ingila",
                    "GMT",
                    "Lokacin Bazara na Birtaniya",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Lokacin Greenwich a Ingila",
                    "GMT",
                    "Lokacin Bazara na Birtaniya",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Lokacin Greenwich a Ingila",
                    "GMT",
                    "Lokacin Bazara na Birtaniya",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Lokacin Greenwich a Ingila",
                    "GMT",
                    "Lokacin Bazara na Birtaniya",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Lokacin Greenwich a Ingila",
                    "GMT",
                    "Lokacin Bazara na Birtaniya",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Etc/Unknown", "Birni da ba a sani ba" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Arewacin Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Arewacin Dakota" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Arewacin Dakota" },
        };
        return data;
    }
}
