/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ast extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Hora media de Greenwich",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "hora estándar d’Acre",
               "",
               "hora braniega d’Acre",
               "",
               "hora d’Acre",
               "",
            };
        final String[] Apia = new String[] {
               "Hora estándar d’Apia",
               "",
               "Hora braniega d’Apia",
               "",
               "Hora d’Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Hora estándar de les Islles Cook",
               "",
               "Hora media braniega de les Islles Cook",
               "",
               "Hora de les Islles Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "Hora estándar de Cuba",
               "CST",
               "Hora braniega de Cuba",
               "CDT",
               "Hora de Cuba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Hora estándar de Fixi",
               "",
               "Hora braniega de Fixi",
               "",
               "Hora de Fixi",
               "",
            };
        final String[] Gulf = new String[] {
               "Hora estándar del Golfu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hora estándar de Hovd",
               "",
               "Hora braniega de Hovd",
               "",
               "Hora de Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Hora estándar d’Irán",
               "",
               "Hora braniega d’Irán",
               "",
               "Hora d’Irán",
               "",
            };
        final String[] Niue = new String[] {
               "Hora de Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Hora estándar d’Omsk",
               "",
               "Hora braniega d’Omsk",
               "",
               "Hora d’Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Hora estándar del Perú",
               "",
               "Hora braniega del Perú",
               "",
               "Hora del Perú",
               "",
            };
        final String[] Truk = new String[] {
               "Hora de Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Hora de la Islla Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Hora estándar de Chile",
               "",
               "Hora braniega de Chile",
               "",
               "Hora de Chile",
               "",
            };
        final String[] China = new String[] {
               "Hora estándar de China",
               "CST",
               "Hora braniega de China",
               "CDT",
               "Hora de China",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Hora de les Islles Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Hora de Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Hora estándar de la India",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Hora estándar de Xapón",
               "JST",
               "Hora braniega de Xapón",
               "JDT",
               "Hora de Xapón",
               "JT",
            };
        final String[] Korea = new String[] {
               "Hora estándar de Corea",
               "KST",
               "Hora braniega de Corea",
               "KST",
               "Hora de Corea",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Hora de Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Hora del Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Hora de Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Hora estándar de Samoa",
               "SST",
               "Hora braniega de Samoa",
               "SST",
               "Hora de Samoa",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Hora de Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Hora estándar de Tonga",
               "",
               "Hora braniega de Tonga",
               "",
               "Hora de Tonga",
               "",
            };
        final String[] Alaska = new String[] {
               "Hora estándar d’Alaska",
               "AKST",
               "Hora braniega d’Alaska",
               "AKDT",
               "Hora d’Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Hora estándar del Amazonas",
               "",
               "Hora braniega del Amazonas",
               "",
               "Hora del Amazonas",
               "",
            };
        final String[] Anadyr = new String[] {
               "hora estándar d’Anadyr",
               "",
               "hora braniega d’Anadyr",
               "",
               "hora d’Anadyr",
               "",
            };
        final String[] Azores = new String[] {
               "Hora estándar de les Azores",
               "",
               "Hora braniega de Les Azores",
               "",
               "Hora de les Azores",
               "",
            };
        final String[] Bhutan = new String[] {
               "Hora de Bután",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Hora de Brunéi Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Hora estándar de la Islla de Pascua",
               "",
               "Hora braniega de la Islla de Pascua",
               "",
               "Hora de la Islla de Pascua",
               "",
            };
        final String[] Guyana = new String[] {
               "Hora de La Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Hora estándar d’Israel",
               "IST",
               "Hora braniega d’Israel",
               "IDT",
               "Hora d’Israel",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Hora de Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Hora de Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Hora estándar de Moscú",
               "MSK",
               "Hora braniega de Moscú",
               "MSK",
               "Hora de Moscú",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Hora de Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Hora estándar de Samara",
               "",
               "Hora braniega de Samara",
               "",
               "Hora de Samara",
               "",
            };
        final String[] Tahiti = new String[] {
               "Hora de Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Hora estándar de Taipéi",
               "CST",
               "Hora braniega de Taipéi",
               "CDT",
               "Hora de Taipéi",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Hora de Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Hora de Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Hora de Wallis y Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Hora estándar d’Arabia",
               "",
               "Hora braniega d’Arabia",
               "",
               "Hora d’Arabia",
               "",
            };
        final String[] Armenia = new String[] {
               "Hora estándar d’Armenia",
               "",
               "Hora braniega d’Armenia",
               "",
               "Hora d’Armenia",
               "",
            };
        final String[] Bolivia = new String[] {
               "Hora de Bolivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Hora estándar de Chatham",
               "",
               "Hora braniega de Chatham",
               "",
               "Hora de Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Hora coordinada universal",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Hora d’Ecuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Hora de Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Hora estándar de Xeorxa",
               "",
               "Hora braniega de Xeorxa",
               "",
               "Hora de Xeorxa",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Hora estándar d’Irkutsk",
               "",
               "Hora braniega d’Irkutsk",
               "",
               "Hora d’Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Hora estándar de Magadán",
               "",
               "Hora braniega de Magadán",
               "",
               "Hora de Magadán",
               "",
            };
        final String[] Myanmar = new String[] {
               "Hora de Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Hora estándar de la Islla Norfolk",
               "",
               "Hora braniega de la Islla Norfolk",
               "",
               "Hora de la Islla Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "Hora estándar de Fernando de Noronha",
               "",
               "Hora braniega de Fernando de Noronha",
               "",
               "Hora de Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Hora de Reunión",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Hora de Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Hora de les Islles Salomón",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Hora de Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Hora estándar del Uruguái",
               "",
               "Hora braniega del Uruguái",
               "",
               "Hora del Uruguái",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Hora estándar de Vanuatu",
               "",
               "Hora braniega de Vanuatu",
               "",
               "Hora de Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Hora estándar de Yakutsk",
               "",
               "Hora braniega de Yakutsk",
               "",
               "Hora de Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Hora estándar del Atlánticu",
               "AST",
               "Hora braniega del Atlánticu",
               "ADT",
               "Hora del Atlánticu",
               "AT",
            };
        final String[] Brasilia = new String[] {
               "Hora estándar de Brasilia",
               "",
               "Hora braniega de Brasilia",
               "",
               "Hora de Brasilia",
               "",
            };
        final String[] Chamorro = new String[] {
               "Hora estándar de Chamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Hora estándar de Colombia",
               "",
               "Hora braniega de Colombia",
               "",
               "Hora de Colombia",
               "",
            };
        final String[] Falkland = new String[] {
               "Hora estándar de les Islles Falkland",
               "",
               "Hora braniega de les Islles Falkland",
               "",
               "Hora de les Islles Falkland",
               "",
            };
        final String[] Malaysia = new String[] {
               "Hora de Malasia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Hora de Les Maldives",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Hora estándar d’Ulán Bátor",
               "",
               "Hora braniega d’Ulán Bátor",
               "",
               "Hora d’Ulán Bátor",
               "",
            };
        final String[] Pakistan = new String[] {
               "Hora estándar del Paquistán",
               "PKT",
               "Hora braniega del Paquistán",
               "PKST",
               "Hora del Paquistán",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Hora estándar del Paraguái",
               "",
               "Hora braniega del Paraguái",
               "",
               "Hora del Paraguái",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Hora de Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Hora estándar de Saxalín",
               "",
               "Hora braniega de Saxalín",
               "",
               "Hora de Saxalín",
               "",
            };
        final String[] Suriname = new String[] {
               "Hora del Surinam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Hora estándar d’Arxentina",
               "",
               "Hora braniega d’Arxentina",
               "",
               "Hora d’Arxentina",
               "",
            };
        final String[] Christmas = new String[] {
               "Hora estándar de la Islla Christmas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Hora de Galápagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hora estándar de Ḥong Kong",
               "HKT",
               "Hora braniega de Ḥong Kong",
               "HKST",
               "Hora de Ḥong Kong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Hora d’Indochina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "hora estandar de Petropavlovsk-Kamchatski",
               "",
               "hora braniega de Petropavlovsk-Kamchatski",
               "",
               "hora de Petropavlovsk-Kamchatski",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Hora del Kirguistán",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Hora estándar de Lord Howe",
               "",
               "Hora braniega de Lord Howe",
               "",
               "Hora de Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Hora de les Marqueses",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Hora estándar de Mauriciu",
               "",
               "Hora braniega de Mauriciu",
               "",
               "Hora de Mauriciu",
               "",
            };
        final String[] Singapore = new String[] {
               "Hora estándar de Singapur",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Hora de Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Hora estándar de Volgográu",
               "MSK",
               "Hora braniega de Volgográu",
               "MSK",
               "Hora de Volgográu",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Hora estándar d’Azerbaixán",
               "",
               "Hora braniega d’Azerbaixán",
               "",
               "Hora d’Azerbaixán",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Hora estándar de Bangladex",
               "",
               "Hora braniega de Bangladex",
               "",
               "Hora de Bangladex",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Hora estándar de Cabu Verde",
               "",
               "Hora braniega de Cabu Verde",
               "",
               "Hora de Cabu Verde",
               "",
            };
        final String[] East_Timor = new String[] {
               "Hora de Timor Oriental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Hora de Les Seixeles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Hora del Taxiquistán",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Hora estándar del Uzbequistán",
               "",
               "Hora braniega del Uzbequistán",
               "",
               "Hora del Uzbequistán",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Hora d’Afganistán",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Hora estándar de Krasnoyarsk",
               "",
               "Hora braniega de Krasnoyarsk",
               "",
               "Hora de Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Hora estándar de Nueva Zelanda",
               "NZST",
               "Hora braniega de Nueva Zelanda",
               "NZDT",
               "Hora de Nueva Zelanda",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Hora estándar de Novosibirsk",
               "",
               "Hora braniega de Novosibirsk",
               "",
               "Hora de Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Hora estándar de Filipines",
               "PST",
               "Hora de branu de Filipines",
               "PDT",
               "Hora de Filipines",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Hora estándar de Vladivostok",
               "",
               "Hora braniega de Vladivostok",
               "",
               "Hora de Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Hora del Océanu Índicu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Hora de les Islles Line",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Hora estándar de Newfoundland",
               "NST",
               "Hora braniega de Newfoundland",
               "NDT",
               "Hora de Newfoundland",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Hora estándar del Turkmenistán",
               "",
               "Hora braniega del Turkmenistán",
               "",
               "Hora del Turkmenistán",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Hora de La Guyana Francesa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Hora estándar de Nueva Caledonia",
               "",
               "Hora braniega de Nueva Caledonia",
               "",
               "Hora de Nueva Caledonia",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Hora de Xeorxa del Sur",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Hora estándar de Yekaterimburgu",
               "",
               "Hora braniega de Yekaterimburgu",
               "",
               "Hora de Yekaterimburgu",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Hora d’África central",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Hora d’África del este",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Hora estándar d’África del oeste",
               "WAT",
               "Hora braniega d’África del oeste",
               "WAT",
               "Hora d’África del oeste",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Hora de Dumont-d’Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Hora estándar d’Europa Central",
               "CET",
               "Hora braniega d’Europa Central",
               "CEST",
               "Hora d’Europa Central",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Hora estándar d’Europa del Este",
               "EET",
               "Hora braniega d’Europa del Este",
               "EEST",
               "Hora d’Europa del Este",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Hora estándar d’Europa Occidental",
               "WET",
               "Hora braniega d’Europa Occidental",
               "WEST",
               "Hora d’Europa Occidental",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Hora estándar del Pacíficu de Méxicu",
               "MST",
               "Hora braniega del Pacíficu de Méxicu",
               "MDT",
               "Hora del Pacíficu de Méxicu",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Hora de Sudáfrica",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Hora estándar central norteamericana",
               "CST",
               "Hora braniega central norteamericana",
               "CDT",
               "Hora central norteamericana",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Hora estándar del este norteamericanu",
               "EST",
               "Hora braniega del este norteamericanu",
               "EDT",
               "Hora del este norteamericanu",
               "ET",
            };
        final String[] America_Pacific = new String[] {
               "Hora estándar del Pacíficu norteamericanu",
               "PST",
               "Hora braniega del Pacíficu norteamericanu",
               "PDT",
               "Hora del Pacíficu norteamericanu",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Hora del sur y l’antárticu francés",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Hora de les Islles Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hora estándar de Hawaii-Aleutianes",
               "HAST",
               "Hora braniega de Hawaii-Aleutianes",
               "HADT",
               "Hora de Hawaii-Aleutianes",
               "HAT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Hora de les Islles Phoenix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Hora estándar de Saint Pierre y Miquelon",
               "",
               "Hora braniega de Saint Pierre y Miquelon",
               "",
               "Hora de Saint Pierre y Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Hora estándar de les montañes norteamericanes",
               "MST",
               "Hora braniega de les montañes norteamericanes",
               "MDT",
               "Hora de les montañes norteamericanes",
               "MT",
            };
        final String[] Marshall_Islands = new String[] {
               "Hora de les Islles Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Hora de Papúa Nueva Guinea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Hora estándar d’Australia central",
               "ACST",
               "Hora braniega d’Australia central",
               "ACDT",
               "Hora d’Australia central",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Hora estándar d’Australia del este",
               "AEST",
               "Hora braniega d’Australia del este",
               "AEDT",
               "Hora d’Australia del este",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Hora estándar d’Australia del oeste",
               "AWST",
               "Hora braniega d’Australia del oeste",
               "AWDT",
               "Hora d’Australia del oeste",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Hora d’Indonesia central",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Hora d’Indonesia del este",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Hora d’Indonesia del oeste",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Hora estándar d’Australia central del oeste",
               "",
               "Hora braniega d’Australia central del oeste",
               "",
               "Hora d’Australia central del oeste",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu",
                new String[] {
                    "Hora estándar de Hawaii-Aleutianes",
                    "HST",
                    "Hora braniega de Hawaii-Aleutianes",
                    "HDT",
                    "Hora de Hawaii-Aleutianes",
                    "HST",
                }
            },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Hora media de Greenwich",
                    "GMT",
                    "Hora braniega británica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST",
                new String[] {
                    "Hora estándar de Hawaii-Aleutianes",
                    "HST",
                    "Hora braniega de Hawaii-Aleutianes",
                    "HDT",
                    "Hora de Hawaii-Aleutianes",
                    "HST",
                }
            },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Hora coordinada universal",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Hora media de Greenwich",
                    "GMT",
                    "Hora estándar irlandesa",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Hora coordinada universal",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Hora coordinada universal",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Hora media de Greenwich",
                    "GMT",
                    "Hora braniega británica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Hora coordinada universal",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii",
                new String[] {
                    "Hora estándar de Hawaii-Aleutianes",
                    "HST",
                    "Hora braniega de Hawaii-Aleutianes",
                    "HDT",
                    "Hora de Hawaii-Aleutianes",
                    "HST",
                }
            },
            { "Universal",
                new String[] {
                    "Hora coordinada universal",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Hora coordinada universal",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Hora media de Greenwich",
                    "GMT",
                    "Hora estándar irlandesa",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Hora media de Greenwich",
                    "GMT",
                    "Hora braniega británica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Hora media de Greenwich",
                    "GMT",
                    "Hora braniega británica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10",
                new String[] {
                    "Hora estándar de Hawaii-Aleutianes",
                    "HST",
                    "Hora braniega de Hawaii-Aleutianes",
                    "HDT",
                    "Hora de Hawaii-Aleutianes",
                    "HST",
                }
            },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Hora media de Greenwich",
                    "GMT",
                    "Hora braniega británica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Hora media de Greenwich",
                    "GMT",
                    "Hora braniega británica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston",
                new String[] {
                    "Hora estándar de Hawaii-Aleutianes",
                    "HST",
                    "Hora braniega de Hawaii-Aleutianes",
                    "HDT",
                    "Hora de Hawaii-Aleutianes",
                    "HST",
                }
            },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Hora media de Greenwich",
                    "GMT",
                    "Hora braniega británica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Baku", "Bakú" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Amán" },
            { "timezone.excity.Asia/Macau", "Macáu" },
            { "timezone.excity.Asia/Seoul", "Seúl" },
            { "timezone.excity.Asia/Tokyo", "Tokiu" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Lome", "Lomé" },
            { "timezone.excity.Asia/Brunei", "Brunéi" },
            { "timezone.excity.Asia/Hebron", "Hebrón" },
            { "timezone.excity.Asia/Muscat", "Mascate" },
            { "timezone.excity.Asia/Riyadh", "Riyad" },
            { "timezone.excity.Asia/Saigon", "Ciudá de Ho Chi Minh" },
            { "timezone.excity.Asia/Tehran", "Teḥrán" },
            { "timezone.excity.Etc/Unknown", "Ciudá desconocida" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Cairo", "El Cairu" },
            { "timezone.excity.Africa/Tunis", "Túnez" },
            { "timezone.excity.Asia/Baghdad", "Bagdag" },
            { "timezone.excity.Asia/Bahrain", "Baḥréin" },
            { "timezone.excity.Asia/Jakarta", "Xakarta" },
            { "timezone.excity.Asia/Magadan", "Magadán" },
            { "timezone.excity.Asia/Rangoon", "Rangún" },
            { "timezone.excity.Europe/Paris", "París" },
            { "timezone.excity.Europe/Sofia", "Sofía" },
            { "timezone.excity.Pacific/Fiji", "Fixi" },
            { "timezone.excity.Africa/Niamey", "Niaméi" },
            { "timezone.excity.America/Bahia", "Bahía" },
            { "timezone.excity.Asia/Calcutta", "Calcuta" },
            { "timezone.excity.Asia/Damascus", "Damascu" },
            { "timezone.excity.Asia/Dushanbe", "Duxanbé" },
            { "timezone.excity.Asia/Jayapura", "Xayapura" },
            { "timezone.excity.Asia/Katmandu", "Katmandú" },
            { "timezone.excity.Asia/Sakhalin", "Saxalín" },
            { "timezone.excity.Europe/Athens", "Atenes" },
            { "timezone.excity.Europe/Berlin", "Berlín" },
            { "timezone.excity.Europe/Dublin", "Dublín" },
            { "timezone.excity.Europe/Lisbon", "Lisboa" },
            { "timezone.excity.Europe/London", "Londres" },
            { "timezone.excity.Europe/Monaco", "Mónacu" },
            { "timezone.excity.Europe/Moscow", "Moscú" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Viena" },
            { "timezone.excity.Europe/Warsaw", "Varsovia" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Arxel" },
            { "timezone.excity.Africa/Tripoli", "Trípoli" },
            { "timezone.excity.America/Bogota", "Bogotá" },
            { "timezone.excity.America/Cayman", "Caimán" },
            { "timezone.excity.America/Havana", "La Habana" },
            { "timezone.excity.America/Panama", "Panamá" },
            { "timezone.excity.Asia/Hong_Kong", "Ḥong Kong" },
            { "timezone.excity.Asia/Jerusalem", "Xerusalén" },
            { "timezone.excity.Asia/Pyongyang", "Pyong Yang" },
            { "timezone.excity.Asia/Samarkand", "Samarcanda" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "timezone.excity.Asia/Vientiane", "Vientián" },
            { "timezone.excity.Europe/Vatican", "El Vaticanu" },
            { "timezone.excity.Indian/Reunion", "Reunión" },
            { "timezone.excity.Pacific/Easter", "Pascua" },
            { "timezone.excity.Africa/Djibouti", "Xibuti" },
            { "timezone.excity.Africa/Khartoum", "Ḥartum" },
            { "timezone.excity.Africa/Ndjamena", "Xamena" },
            { "timezone.excity.Africa/Sao_Tome", "Santu Tomé" },
            { "timezone.excity.America/Cordoba", "Córdoba" },
            { "timezone.excity.America/Grenada", "Granada" },
            { "timezone.excity.America/Jamaica", "Xamaica" },
            { "timezone.excity.America/Tortola", "Tórtola" },
            { "timezone.excity.Atlantic/Azores", "Les Azores" },
            { "timezone.excity.Atlantic/Canary", "Canaries" },
            { "timezone.excity.Atlantic/Faeroe", "Islles Feroe" },
            { "timezone.excity.Europe/Belgrade", "Belgráu" },
            { "timezone.excity.Europe/Brussels", "Bruxeles" },
            { "timezone.excity.Europe/Helsinki", "Ḥélsinki" },
            { "timezone.excity.Africa/Mogadishu", "Mogadixu" },
            { "timezone.excity.America/Anguilla", "Anguila" },
            { "timezone.excity.America/New_York", "Nueva York" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulán Bátor" },
            { "timezone.excity.Europe/Astrakhan", "Astracán" },
            { "timezone.excity.Europe/Bucharest", "Bucarest" },
            { "timezone.excity.Europe/Gibraltar", "Xibraltar" },
            { "timezone.excity.Europe/Ljubljana", "Liubliana" },
            { "timezone.excity.Europe/Stockholm", "Estocolmu" },
            { "timezone.excity.Europe/Volgograd", "Volgográu" },
            { "timezone.excity.Indian/Mauritius", "Mauriciu" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Africa/Nouakchott", "Nuakxot" },
            { "timezone.excity.Europe/Copenhagen", "Copenhague" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburgu" },
            { "timezone.excity.Europe/San_Marino", "San Marín" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Galapagos", "Galápagos" },
            { "timezone.excity.Africa/Addis_Ababa", "Adís Abeba" },
            { "timezone.excity.Africa/Ouagadougou", "Uagadugú" },
            { "timezone.excity.America/Guadeloupe", "Guadalupe" },
            { "timezone.excity.America/Martinique", "La Martinica" },
            { "timezone.excity.Asia/Yekaterinburg", "Yekaterimburgu" },
            { "timezone.excity.Atlantic/Reykjavik", "Reikiavik" },
            { "timezone.excity.Atlantic/St_Helena", "Santa Lena" },
            { "timezone.excity.Australia/Adelaide", "Adelaida" },
            { "timezone.excity.Europe/Isle_of_Man", "Islla de Man" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningráu" },
            { "timezone.excity.Africa/Johannesburg", "Johannesburgu" },
            { "timezone.excity.America/Mexico_City", "Ciudá de Méxicu" },
            { "timezone.excity.America/Puerto_Rico", "Puertu Ricu" },
            { "timezone.excity.Atlantic/Cape_Verde", "Cabu Verde" },
            { "timezone.excity.America/Port_of_Spain", "Puertu España" },
            { "timezone.excity.America/Santo_Domingo", "Santu Domingu" },
            { "timezone.excity.America/Bahia_Banderas", "Bahía Banderas" },
            { "timezone.excity.America/Port-au-Prince", "Puertu Príncipe" },
            { "timezone.excity.Atlantic/South_Georgia", "Xeorxa del Sur" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucumán" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Dakota del Norte" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Dakota del Norte" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Nueva Salem, Dakota del Norte" },
        };
        return data;
    }
}
