/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_gl extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "árabe";
        final String metaValue_hy = "armenio";
        final String metaValue_bn = "bengalí";
        final String metaValue_ccp = "chakma";
        final String metaValue_chr = "cherokee";
        final String metaValue_ka = "xeorxiano";
        final String metaValue_el = "grego";
        final String metaValue_gu = "guxarati";
        final String metaValue_he = "hebreo";
        final String metaValue_ja = "xaponés";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannará";
        final String metaValue_ko = "coreano";
        final String metaValue_lo = "laosiano";
        final String metaValue_ml = "malabar";
        final String metaValue_mn = "mongol";
        final String metaValue_my = "birmano";
        final String metaValue_nqo = "n’ko";
        final String metaValue_or = "odiá";
        final String metaValue_si = "cingalés";
        final String metaValue_su = "sundanés";
        final String metaValue_syr = "siríaco";
        final String metaValue_ta = "támil";
        final String metaValue_te = "telugu";
        final String metaValue_th = "tailandés";
        final String metaValue_bo = "tibetano";
        final Object[][] data = new Object[][] {
            { "001", "Mundo" },
            { "002", "África" },
            { "003", "América do Norte" },
            { "005", "América do Sur" },
            { "009", "Oceanía" },
            { "011", "África Occidental" },
            { "013", "América Central" },
            { "014", "África Oriental" },
            { "015", "África Setentrional" },
            { "017", "África Central" },
            { "018", "África Meridional" },
            { "019", "América" },
            { "021", "América Setentrional" },
            { "029", "Caribe" },
            { "030", "Asia Oriental" },
            { "034", "Asia Meridional" },
            { "035", "Sueste Asiático" },
            { "039", "Europa Meridional" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "057", "Rexión de Micronesia" },
            { "061", "Polinesia" },
            { "142", "Asia" },
            { "143", "Asia Central" },
            { "145", "Asia Occidental" },
            { "150", "Europa" },
            { "151", "Europa do Leste" },
            { "154", "Europa Setentrional" },
            { "155", "Europa Occidental" },
            { "202", "África subsahariana" },
            { "419", "América Latina" },
            { "AC", "Illa de Ascensión" },
            { "AD", "Andorra" },
            { "AE", "Emiratos Árabes Unidos" },
            { "AF", "Afganistán" },
            { "AG", "Antigua e Barbuda" },
            { "AI", "Anguila" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antártida" },
            { "AR", "Arxentina" },
            { "AS", "Samoa Americana" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Illas Åland" },
            { "AZ", "Acerbaixán" },
            { "BA", "Bosnia e Hercegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Bélxica" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benín" },
            { "BL", "Saint Barthélemy" },
            { "BM", "Illas Bermudas" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Caribe Neerlandés" },
            { "BR", "Brasil" },
            { "BS", "Bahamas" },
            { "BT", "Bután" },
            { "BV", "Illa Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Belarús" },
            { "BZ", "Belize" },
            { "CA", "Canadá" },
            { "CC", "Illas Cocos (Keeling)" },
            { "CD", "República Democrática do Congo" },
            { "CF", "República Centroafricana" },
            { "CG", "República do Congo" },
            { "CH", "Suíza" },
            { "CI", "Côte d’Ivoire" },
            { "CK", "Illas Cook" },
            { "CL", "Chile" },
            { "CM", "Camerún" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "CP", "Illa Clipperton" },
            { "CQ", "Sark" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cabo Verde" },
            { "CW", "Curaçao" },
            { "CX", "Illa Christmas" },
            { "CY", "Chipre" },
            { "CZ", "Chequia" },
            { "DE", "Alemaña" },
            { "DG", "Diego García" },
            { "DJ", "Djibuti" },
            { "DK", "Dinamarca" },
            { "DM", "Dominica" },
            { "DO", "República Dominicana" },
            { "DZ", "Alxeria" },
            { "EA", "Ceuta e Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estonia" },
            { "EG", "Exipto" },
            { "EH", "Sáhara Occidental" },
            { "ER", "Eritrea" },
            { "ES", "España" },
            { "ET", "Etiopía" },
            { "EU", "Unión Europea" },
            { "EZ", "Eurozona" },
            { "FI", "Finlandia" },
            { "FJ", "Fixi" },
            { "FK", "Illas Malvinas" },
            { "FM", "Micronesia" },
            { "FO", "Illas Feroe" },
            { "FR", "Francia" },
            { "GA", "Gabón" },
            { "GB", "Reino Unido" },
            { "GD", "Granada" },
            { "GE", "Xeorxia" },
            { "GF", "Güiana Francesa" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Xibraltar" },
            { "GL", "Groenlandia" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadalupe" },
            { "GQ", "Guinea Ecuatorial" },
            { "GR", "Grecia" },
            { "GS", "Illas Xeorxia do Sur e Sandwich do Sur" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea Bissau" },
            { "GY", "Güiana" },
            { "HK", "Hong Kong RAE da China" },
            { "HM", "Illa Heard e Illas McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croacia" },
            { "HT", "Haití" },
            { "HU", "Hungría" },
            { "IC", "Illas Canarias" },
            { "ID", "Indonesia" },
            { "IE", "Irlanda" },
            { "IL", "Israel" },
            { "IM", "Illa de Man" },
            { "IN", "India" },
            { "IO", "Territorio Británico do Océano Índico" },
            { "IQ", "Iraq" },
            { "IR", "Irán" },
            { "IS", "Islandia" },
            { "IT", "Italia" },
            { "JE", "Jersey" },
            { "JM", "Xamaica" },
            { "JO", "Xordania" },
            { "JP", "Xapón" },
            { "KE", "Kenya" },
            { "KG", "Kirguizistán" },
            { "KH", "Camboxa" },
            { "KI", "Kiribati" },
            { "KM", "Comores" },
            { "KN", "Saint Kitts e Nevis" },
            { "KP", "Corea do Norte" },
            { "KR", "Corea do Sur" },
            { "KW", "Kuwait" },
            { "KY", "Illas Caimán" },
            { "KZ", "Kazakistán" },
            { "LA", "Laos" },
            { "LB", "Líbano" },
            { "LC", "Santa Lucía" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lituania" },
            { "LU", "Luxemburgo" },
            { "LV", "Letonia" },
            { "LY", "Libia" },
            { "MA", "Marrocos" },
            { "MC", "Mónaco" },
            { "MD", "República Moldova" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "MG", "Madagascar" },
            { "MH", "Illas Marshall" },
            { "MK", "Macedonia do Norte" },
            { "ML", "Malí" },
            { "MM", "Myanmar (Birmania)" },
            { "MN", "Mongolia" },
            { "MO", "Macau RAE da China" },
            { "MP", "Illas Marianas do Norte" },
            { "MQ", "Martinica" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauricio" },
            { "MV", "Maldivas" },
            { "MW", "Malawi" },
            { "MX", "México" },
            { "MY", "Malaisia" },
            { "MZ", "Mozambique" },
            { "NA", "Namibia" },
            { "NC", "Nova Caledonia" },
            { "NE", "Níxer" },
            { "NF", "Illa Norfolk" },
            { "NG", "Nixeria" },
            { "NI", "Nicaragua" },
            { "NL", "Países Baixos" },
            { "NO", "Noruega" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nova Zelandia" },
            { "OM", "Omán" },
            { "PA", "Panamá" },
            { "PE", "Perú" },
            { "PF", "Polinesia Francesa" },
            { "PG", "Papúa-Nova Guinea" },
            { "PH", "Filipinas" },
            { "PK", "Paquistán" },
            { "PL", "Polonia" },
            { "PM", "Saint Pierre et Miquelon" },
            { "PN", "Illas Pitcairn" },
            { "PR", "Porto Rico" },
            { "PS", "Territorios Palestinos" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguai" },
            { "QA", "Qatar" },
            { "QO", "Territorios afastados de Oceanía" },
            { "RE", "Reunión" },
            { "RO", "Romanía" },
            { "RS", "Serbia" },
            { "RU", "Rusia" },
            { "RW", "Ruanda" },
            { "SA", "Arabia Saudita" },
            { "SB", "Illas Salomón" },
            { "SC", "Seychelles" },
            { "SD", "Sudán" },
            { "SE", "Suecia" },
            { "SG", "Singapur" },
            { "SH", "Santa Helena" },
            { "SI", "Eslovenia" },
            { "SJ", "Svalbard e Jan Mayen" },
            { "SK", "Eslovaquia" },
            { "SL", "Serra Leoa" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Suriname" },
            { "SS", "Sudán do Sur" },
            { "ST", "San Tomé e Príncipe" },
            { "SV", "O Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Siria" },
            { "SZ", "Eswatini" },
            { "TA", "Tristán da Cunha" },
            { "TC", "Illas Turks e Caicos" },
            { "TD", "Chad" },
            { "TF", "Territorios Austrais Franceses" },
            { "TG", "Togo" },
            { "TH", "Tailandia" },
            { "TJ", "Taxiquistán" },
            { "TK", "Tokelau" },
            { "TL", "Timor Leste" },
            { "TM", "Turkmenistán" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Turquía" },
            { "TT", "Trinidad e Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwán" },
            { "TZ", "Tanzania" },
            { "UA", "Ucraína" },
            { "UG", "Uganda" },
            { "UM", "Illas Menores Distantes dos Estados Unidos" },
            { "UN", "Nacións Unidas" },
            { "US", "Estados Unidos" },
            { "UY", "Uruguai" },
            { "UZ", "Uzbekistán" },
            { "VA", "Cidade do Vaticano" },
            { "VC", "San Vicente e as Granadinas" },
            { "VE", "Venezuela" },
            { "VG", "Illas Virxes Británicas" },
            { "VI", "Illas Virxes Estadounidenses" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis e Futuna" },
            { "WS", "Samoa" },
            { "XA", "Pseudoacentos" },
            { "XB", "Pseudobidireccional" },
            { "XK", "Kosovo" },
            { "YE", "Iemen" },
            { "YT", "Mayotte" },
            { "ZA", "Suráfrica" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Rexión descoñecida" },
            { "aa", "afar" },
            { "ab", "abkhazo" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amhárico" },
            { "an", "aragonés" },
            { "ar", metaValue_ar },
            { "as", "assamés" },
            { "av", "avar" },
            { "ay", "aimará" },
            { "az", "acerbaixano" },
            { "ba", "baxkir" },
            { "be", "belaruso" },
            { "bg", "búlgaro" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "bretón" },
            { "bs", "bosníaco" },
            { "ca", "catalán" },
            { "ce", "checheno" },
            { "ch", "chamorro" },
            { "co", "corso" },
            { "cs", "checo" },
            { "cu", "eslavo eclesiástico" },
            { "cv", "chuvaxo" },
            { "cy", "galés" },
            { "da", "dinamarqués" },
            { "de", "alemán" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", metaValue_el },
            { "en", "inglés" },
            { "eo", "esperanto" },
            { "es", "español" },
            { "et", "estoniano" },
            { "eu", "éuscaro" },
            { "fa", "persa" },
            { "ff", "fula" },
            { "fi", "finés" },
            { "fj", "fixiano" },
            { "fo", "feroés" },
            { "fr", "francés" },
            { "fy", "frisón occidental" },
            { "ga", "irlandés" },
            { "gd", "gaélico escocés" },
            { "gl", "galego" },
            { "gn", "guaraní" },
            { "gu", metaValue_gu },
            { "gv", "manx" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "hr", "croata" },
            { "ht", "crioulo haitiano" },
            { "hu", "húngaro" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonesio" },
            { "ie", "occidental" },
            { "ig", "igbo" },
            { "ii", "yi sichuanés" },
            { "io", "ido" },
            { "is", "islandés" },
            { "it", "italiano" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", "xavanés" },
            { "ka", metaValue_ka },
            { "kg", "kongo" },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "kazako" },
            { "kl", "kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "caxemirés" },
            { "ku", "kurdo setentrional" },
            { "kv", "komi" },
            { "kw", "córnico" },
            { "ky", "kirguiz" },
            { "la", "latín" },
            { "lb", "luxemburgués" },
            { "lg", "ganda" },
            { "li", "limburgués" },
            { "ln", "lingala" },
            { "lo", metaValue_lo },
            { "lt", "lituano" },
            { "lu", "luba-katanga" },
            { "lv", "letón" },
            { "mg", "malgaxe" },
            { "mh", "marshalés" },
            { "mi", "maorí" },
            { "mk", "macedonio" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malaio" },
            { "mt", "maltés" },
            { "my", metaValue_my },
            { "na", "nauruano" },
            { "nb", "noruegués bokmål" },
            { "nd", "ndebele setentrional" },
            { "ne", "nepalí" },
            { "ng", "ndonga" },
            { "nl", "neerlandés" },
            { "nn", "noruegués nynorsk" },
            { "no", "noruegués" },
            { "nr", "ndebele meridional" },
            { "nv", "navajo" },
            { "ny", "chewa" },
            { "oc", "occitano" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "ossetio" },
            { "pa", "panxabí" },
            { "pl", "polaco" },
            { "ps", "paxto" },
            { "pt", "portugués" },
            { "qu", "quechua" },
            { "rm", "romanche" },
            { "rn", "rundi" },
            { "ro", "romanés" },
            { "ru", "ruso" },
            { "rw", "kiñaruanda" },
            { "sa", "sánscrito" },
            { "sc", "sardo" },
            { "sd", "sindhi" },
            { "se", "saami setentrional" },
            { "sg", "sango" },
            { "sh", "serbocroata" },
            { "si", metaValue_si },
            { "sk", "eslovaco" },
            { "sl", "esloveno" },
            { "sm", "samoano" },
            { "sn", "shona" },
            { "so", "somalí" },
            { "sq", "albanés" },
            { "sr", "serbio" },
            { "ss", "suazi" },
            { "st", "sesotho" },
            { "su", metaValue_su },
            { "sv", "sueco" },
            { "sw", "suahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "taxico" },
            { "th", metaValue_th },
            { "ti", "tigriña" },
            { "tk", "turkmeno" },
            { "tl", "tagalo" },
            { "tn", "tswana" },
            { "to", "tongano" },
            { "tr", "turco" },
            { "ts", "tsonga" },
            { "tt", "tártaro" },
            { "tw", "twi" },
            { "ty", "tahitiano" },
            { "ug", "uigur" },
            { "uk", "ucraíno" },
            { "ur", "urdú" },
            { "uz", "uzbeko" },
            { "ve", "venda" },
            { "vi", "vietnamita" },
            { "vo", "volapuk" },
            { "wa", "valón" },
            { "wo", "wólof" },
            { "xh", "xhosa" },
            { "yi", "yiddish" },
            { "yo", "ioruba" },
            { "za", "zhuang" },
            { "zh", "chinés" },
            { "zu", "zulú" },
            { "ace", "achinés" },
            { "ach", "acholí" },
            { "ada", "adangme" },
            { "ady", "adigueo" },
            { "agq", "aghem" },
            { "ain", "ainu" },
            { "ale", "aleutiano" },
            { "alt", "altai meridional" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", "arameo" },
            { "arn", "mapuche" },
            { "arp", "arapaho" },
            { "ars", "árabe najdi" },
            { "asa", "asu" },
            { "ast", "asturiano" },
            { "atj", "atikamekw" },
            { "awa", "awadhi" },
            { "bal", "baluchi" },
            { "ban", "balinés" },
            { "bas", "basaa" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bgc", "hariani" },
            { "bgn", "baluchi occidental" },
            { "bho", "bhojpuri" },
            { "bin", "bini" },
            { "bla", "siksiká" },
            { "blo", "anii" },
            { "brx", "bodo" },
            { "bug", "buginés" },
            { "byn", "blin" },
            { "cay", "cayuga" },
            { "ccp", metaValue_ccp },
            { "ceb", "cebuano" },
            { "cgg", "kiga" },
            { "chk", "chuuk" },
            { "chm", "mari" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "cheyenne" },
            { "ckb", "kurdo central" },
            { "clc", "chilcotin" },
            { "crg", "michif" },
            { "crj", "cree do sueste" },
            { "crk", "cree das chairas" },
            { "crl", "cree do nordeste" },
            { "crm", "cree de Moose" },
            { "crr", "algonquino de Carolina" },
            { "crs", "seselwa (crioulo das Seychelles)" },
            { "csw", "cree dos pantanos" },
            { "dak", "dakota" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "dgr", "dogrib" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "baixo sorbio" },
            { "dua", "duala" },
            { "dyo", "jola-fonyi" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "egy", "exipcio antigo" },
            { "eka", "ekajuk" },
            { "ewo", "ewondo" },
            { "fil", "filipino" },
            { "fon", "fon" },
            { "frc", "francés cajun" },
            { "frr", "frisón setentrional" },
            { "fur", "friulano" },
            { "gaa", "ga" },
            { "gag", "gagauz" },
            { "gez", "ge’ez" },
            { "gil", "kiribatiano" },
            { "gor", "gorontalo" },
            { "grc", "grego antigo" },
            { "gsw", "alemán suízo" },
            { "guz", "gusii" },
            { "gwi", "gwichʼin" },
            { "hai", "haida" },
            { "haw", "hawaiano" },
            { "hax", "haida do sur" },
            { "hil", "hiligaynon" },
            { "hmn", "hmong" },
            { "hsb", "alto sorbio" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "inuktitut canadense occidental" },
            { "ilo", "ilocano" },
            { "inh", "inguxo" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "kab", "cabila" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kbd", "cabardiano" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "caboverdiano" },
            { "kfo", "koro" },
            { "kgp", "caingangue" },
            { "kha", "khasi" },
            { "khq", "koyra chiini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundu" },
            { "koi", "komi permio" },
            { "kok", "konkani" },
            { "kpe", "kpelle" },
            { "krc", "carachaio-bálcara" },
            { "krl", "carelio" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "ksf", "bafia" },
            { "ksh", "kölsch" },
            { "kum", "kumyk" },
            { "kwk", "kwakiutl" },
            { "kxv", "kuvi" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lez", "lezguio" },
            { "lij", "lígur" },
            { "lil", "lillooet" },
            { "lkt", "lakota" },
            { "lmo", "lombardo" },
            { "lou", "crioulo de Luisiana" },
            { "loz", "lozi" },
            { "lrc", "luri setentrional" },
            { "lsm", "saamia" },
            { "lua", "luba-lulua" },
            { "lun", "lunda" },
            { "lus", "mizo" },
            { "luy", "luyia" },
            { "mad", "madurés" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makasar" },
            { "mas", "masai" },
            { "mdf", "moksha" },
            { "men", "mende" },
            { "mer", "meru" },
            { "mfe", "crioulo mauriciano" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta’" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mni", "manipuri" },
            { "moe", "innu-aimun" },
            { "moh", "mohawk" },
            { "mos", "mossi" },
            { "mua", "mundang" },
            { "mul", "varias linguas" },
            { "mus", "creek" },
            { "mwl", "mirandés" },
            { "myv", "erzya" },
            { "mzn", "mazandaraní" },
            { "nap", "napolitano" },
            { "naq", "nama" },
            { "nds", "baixo alemán" },
            { "new", "newari" },
            { "nia", "nias" },
            { "niu", "niueano" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogai" },
            { "nqo", metaValue_nqo },
            { "nso", "sesotho do norte" },
            { "nus", "nuer" },
            { "nyn", "nyankole" },
            { "ojb", "ojibwa do noroeste" },
            { "ojc", "ojibwa" },
            { "ojs", "oji-cree" },
            { "ojw", "ojibwa do oeste" },
            { "oka", "okanagan" },
            { "pag", "pangasinan" },
            { "pam", "pampanga" },
            { "pap", "papiamento" },
            { "pau", "palauano" },
            { "pcm", "pidgin nixeriano" },
            { "pis", "pijin" },
            { "pqm", "malecite-passamaquoddy" },
            { "prg", "prusiano" },
            { "quc", "quiché" },
            { "raj", "rajasthani" },
            { "rap", "rapanui" },
            { "rar", "rarotongano" },
            { "rhg", "rohingya" },
            { "rof", "rombo" },
            { "rup", "aromanés" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "iacuto" },
            { "saq", "samburu" },
            { "sat", "santali" },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "siciliano" },
            { "sco", "escocés" },
            { "sdh", "kurdo meridional" },
            { "seh", "sena" },
            { "ses", "koyraboro senni" },
            { "shi", "tachelhit" },
            { "shn", "shan" },
            { "slh", "lushootseed do sur" },
            { "sma", "saami meridional" },
            { "smj", "saami de Lule" },
            { "smn", "saami de Inari" },
            { "sms", "saami skolt" },
            { "snk", "soninke" },
            { "srn", "sranan tongo" },
            { "ssy", "saho" },
            { "str", "salish dos estreitos" },
            { "suk", "sukuma" },
            { "swb", "comoriano" },
            { "syr", metaValue_syr },
            { "szl", "silesiano" },
            { "tce", "tutchone do sur" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "tet", "tetun" },
            { "tgx", "tagish" },
            { "tht", "tahltan" },
            { "tig", "tigré" },
            { "tlh", "klingon" },
            { "tli", "tlingit" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "trv", "taroko" },
            { "ttm", "tutchone do norte" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalés" },
            { "twq", "tasawaq" },
            { "tyv", "tuvaniano" },
            { "tzm", "tamazight de Marrocos central" },
            { "udm", "udmurto" },
            { "umb", "umbundu" },
            { "und", "lingua descoñecida" },
            { "vec", "véneto" },
            { "vmw", "makua" },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "wolaytta" },
            { "war", "waray-waray" },
            { "wbp", "walrpiri" },
            { "wuu", "chinés wu" },
            { "xal", "calmuco" },
            { "xnr", "kangri" },
            { "xog", "soga" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nheengatu" },
            { "yue", "cantonés" },
            { "zgh", "tamazight marroquí estándar" },
            { "zun", "zuni" },
            { "zxx", "sen contido lingüístico" },
            { "zza", "zazaki" },
            { "Adlm", "adlam" },
            { "Arab", metaValue_ar },
            { "Aran", "nastaliq" },
            { "Armn", metaValue_hy },
            { "Beng", metaValue_bn },
            { "Bopo", "bopomofo" },
            { "Brai", "braille" },
            { "Cakm", metaValue_ccp },
            { "Cans", "silabario aborixe canadense unificado" },
            { "Cher", metaValue_chr },
            { "Cyrl", "cirílico" },
            { "Deva", "devanágari" },
            { "Ethi", "etíope" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmukhi" },
            { "Hanb", "han con bopomofo" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hans", "simplificado" },
            { "Hant", "tradicional" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hrkt", "silabarios xaponeses" },
            { "Jamo", "jamo" },
            { "Jpan", metaValue_ja },
            { "Kana", "katakana" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", "latino" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Mtei", "meitei mayek" },
            { "Mymr", metaValue_my },
            { "Nkoo", metaValue_nqo },
            { "Olck", "ol chiki" },
            { "Orya", metaValue_or },
            { "Rohg", "hanifi" },
            { "Sinh", metaValue_si },
            { "Sund", metaValue_su },
            { "Syrc", metaValue_syr },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Tfng", "tifinagh" },
            { "Thaa", "thaana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Vaii", "vai" },
            { "Yiii", "yi" },
            { "Zmth", "notación matemática" },
            { "Zsye", "emojis" },
            { "Zsym", "símbolos" },
            { "Zxxx", "non escrito" },
            { "Zyyy", "común" },
            { "Zzzz", "sistema de escritura descoñecido" },
            { "de_AT", "alemán austríaco" },
            { "de_CH", "alto alemán suízo" },
            { "en_AU", "inglés australiano" },
            { "en_CA", "inglés canadense" },
            { "en_GB", "inglés británico" },
            { "en_US", "inglés estadounidense" },
            { "es_ES", "español de España" },
            { "es_MX", "español de México" },
            { "fa_AF", "dari" },
            { "fr_CA", "francés canadense" },
            { "fr_CH", "francés suízo" },
            { "nl_BE", "flamengo" },
            { "pt_BR", "portugués do Brasil" },
            { "pt_PT", "portugués de Portugal" },
            { "ro_MD", "moldavo" },
            { "sw_CD", "suahili congolés" },
            { "ar_001", "árabe estándar moderno" },
            { "es_419", "español de América" },
            { "key.ca", "calendario" },
            { "key.cf", "formato de moeda" },
            { "key.co", "criterio de ordenación" },
            { "key.cu", "moeda" },
            { "key.em", "representación como emoji" },
            { "key.hc", "ciclo horario (12 ou 24)" },
            { "key.lb", "estilo de quebra de liña" },
            { "key.lw", "quebra de liña dentro das palabras" },
            { "key.ms", "sistema internacional de unidades" },
            { "key.nu", "números" },
            { "key.ss", "quebra de liña tras as abreviaturas" },
            { "key.tz", "fuso horario" },
            { "key.va", "variante rexional" },
            { "nds_NL", "baixo saxón" },
            { "hi_Latn", "hindi (alfabeto latino)" },
            { "zh_Hans", "chinés simplificado" },
            { "zh_Hant", "chinés tradicional" },
            { "type.ca.roc", "calendario Minguo" },
            { "type.hc.h11", "sistema de 12 horas (0–11)" },
            { "type.hc.h12", "sistema de 12 horas (1–12)" },
            { "type.hc.h23", "sistema de 24 horas (0–23)" },
            { "type.hc.h24", "sistema de 24 horas (1–24)" },
            { "type.m0.bgn", "transliteración do BGN" },
            { "type.nu.arab", "díxitos indoarábigos" },
            { "type.nu.armn", "numeración armenia" },
            { "type.nu.beng", "díxitos bengalís" },
            { "type.nu.cakm", "díxitos chakmas" },
            { "type.nu.deva", "díxitos devanagáricos" },
            { "type.nu.ethi", "numeración etíope" },
            { "type.nu.geor", "numeración xeorxiana" },
            { "type.nu.grek", "numeración grega" },
            { "type.nu.gujr", "díxitos guxaratis" },
            { "type.nu.guru", "díxitos gurmukhis" },
            { "type.nu.hans", "numeración chinesa simplificada" },
            { "type.nu.hant", "numeración chinesa tradicional" },
            { "type.nu.hebr", "numeración hebrea" },
            { "type.nu.java", "díxitos xavaneses" },
            { "type.nu.jpan", "numeración xaponesa" },
            { "type.nu.khmr", "díxitos khmer" },
            { "type.nu.knda", "díxitos kannarás" },
            { "type.nu.laoo", "díxitos laosianos" },
            { "type.nu.latn", "díxitos occidentais" },
            { "type.nu.mlym", "díxitos malabares" },
            { "type.nu.mong", "Díxitos mongoles" },
            { "type.nu.mtei", "díxitos meitei mayek" },
            { "type.nu.mymr", "díxitos birmanos" },
            { "type.nu.olck", "díxitos ol chiki" },
            { "type.nu.orya", "díxitos odiá" },
            { "type.nu.taml", "numeración támil tradicional" },
            { "type.nu.telu", "díxitos telugus" },
            { "type.nu.thai", "díxitos tailandeses" },
            { "type.nu.tibt", "díxitos tibetanos" },
            { "type.nu.vaii", "díxitos vai" },
            { "type.ca.dangi", "calendario dangi" },
            { "type.co.ducet", "criterio de ordenación Unicode predeterminado" },
            { "type.lb.loose", "estilo de quebra de liña flexible" },
            { "type.nu.roman", "numeración romana" },
            { "type.ca.coptic", "calendario copto" },
            { "type.ca.hebrew", "calendario hebreo" },
            { "type.ca.indian", "Calendario nacional indio" },
            { "type.co.pinyin", "Orde de clasificación pinyin" },
            { "type.co.search", "busca de carácter xeral" },
            { "type.co.stroke", "Orde de clasificación polo número de trazos" },
            { "type.co.unihan", "Criterio de ordenación radical-trazo" },
            { "type.d0.fwidth", "ancho completo" },
            { "type.d0.hwidth", "ancho medio" },
            { "type.lb.normal", "estilo de quebra de liña normal" },
            { "type.lb.strict", "estilo de quebra de liña estrito" },
            { "type.m0.ungegn", "transliteración do UNGEGN" },
            { "type.ms.metric", "sistema métrico decimal" },
            { "type.nu.native", "díxitos nativos" },
            { "type.ca.chinese", "calendario chinés" },
            { "type.ca.islamic", "calendario da héxira" },
            { "type.ca.iso8601", "calendario ISO-8601" },
            { "type.ca.persian", "calendario persa" },
            { "type.cf.account", "formato de moeda contable" },
            { "type.d0.npinyin", "Numérico" },
            { "type.nu.arabext", "díxitos indoarábigos ampliados" },
            { "type.nu.armnlow", "numeración armenia en minúscula" },
            { "type.nu.finance", "Números financeiros" },
            { "type.nu.greklow", "numeración grega en minúscula" },
            { "type.nu.hanidec", "numeración decimal chinesa" },
            { "type.nu.hansfin", "numeración financeira chinesa simplificada" },
            { "type.nu.hantfin", "numeración financeira chinesa tradicional" },
            { "type.nu.jpanfin", "numeración financeira xaponesa" },
            { "type.nu.tamldec", "díxitos támiles" },
            { "type.ca.buddhist", "calendario budista" },
            { "type.ca.ethiopic", "calendario etíope" },
            { "type.ca.japanese", "calendario xaponés" },
            { "type.cf.standard", "formato de moeda estándar" },
            { "type.co.phonetic", "Orde de clasificación fonética" },
            { "type.co.searchjl", "Clasificar por consonante inicial hangul" },
            { "type.co.standard", "criterio de ordenación estándar" },
            { "type.ms.uksystem", "sistema imperial de unidades" },
            { "type.ms.ussystem", "sistema estadounidense de unidades" },
            { "type.nu.fullwide", "díxitos de ancho completo" },
            { "type.nu.romanlow", "numeración romana en minúsculas" },
            { "type.ca.gregorian", "calendario gregoriano" },
            { "type.co.phonebook", "orde de clasificación da guía telefónica" },
            { "type.co.dictionary", "Criterio de ordenación do dicionario" },
            { "type.co.traditional", "Orde de clasificación tradicional" },
            { "type.nu.traditional", "Numeros tradicionais" },
            { "type.ca.islamic-civil", "calendario da héxira (tabular, época civil)" },
            { "type.ca.islamic-umalqura", "calendario da héxira (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "calendario etíope amete alem" },
        };
        return data;
    }
}
