/*
 * Copyright (c) 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package jdk.jpackage.internal.util;

import jdk.jpackage.internal.util.function.ExceptionBox;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.function.Supplier;

public final class MemoizingSupplier<T> implements Supplier<T> {

    public MemoizingSupplier(Supplier<T> supplier) {
        this.future = new FutureTask<>(Objects.requireNonNull(supplier)::get);
    }

    @Override
    public T get() {
        try {
            future.run();
            return future.get();
        } catch (InterruptedException ex) {
            throw ExceptionBox.toUnchecked(ex);
        } catch (ExecutionException ex) {
            throw ExceptionBox.toUnchecked(ExceptionBox.unbox(ex.getCause()));
        }
    }

    public static <T> Supplier<T> runOnce(Supplier<T> supplier) {
        return new MemoizingSupplier<>(supplier);
    }

    private final FutureTask<T> future;
}
