/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_fr_CA extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Acre = new String[] {
               "heure normale de l’Acre",
               "",
               "heure avancée de l’Acre",
               "",
               "heure de l’Acre",
               "",
            };
        final String[] Apia = new String[] {
               "heure normale d’Apia",
               "",
               "heure avancée d’Apia",
               "",
               "heure d’Apia",
               "",
            };
        final String[] Cook = new String[] {
               "heure normale des îles Cook",
               "",
               "heure avancée des îles Cook",
               "",
               "heure des îles Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "heure normale de Cuba",
               "CST",
               "heure avancée de Cuba",
               "CDT",
               "heure de Cuba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "heure normale des îles Fidji",
               "",
               "heure avancée des îles Fidji",
               "",
               "heure des îles Fidji",
               "",
            };
        final String[] Hovd = new String[] {
               "heure normale de Hovd",
               "",
               "heure avancée de Hovd",
               "",
               "heure de Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "heure normale d’Iran",
               "",
               "heure avancée d’Iran",
               "",
               "heure de l’Iran",
               "",
            };
        final String[] Niue = new String[] {
               "heure de Nioué",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "heure normale d’Omsk",
               "",
               "heure avancée d’Omsk",
               "",
               "heure d’Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "heure normale du Pérou",
               "",
               "heure avancée du Pérou",
               "",
               "heure du Pérou",
               "",
            };
        final String[] Chile = new String[] {
               "heure normale du Chili",
               "",
               "heure avancée du Chili",
               "",
               "heure du Chili",
               "",
            };
        final String[] China = new String[] {
               "heure normale de Chine",
               "CST",
               "heure avancée de Chine",
               "CDT",
               "heure de Chine",
               "CT",
            };
        final String[] Japan = new String[] {
               "heure normale du Japon",
               "JST",
               "heure avancée du Japon",
               "JDT",
               "heure du Japon",
               "JT",
            };
        final String[] Korea = new String[] {
               "heure normale de la Corée",
               "KST",
               "heure avancée de Corée",
               "KST",
               "heure de la Corée",
               "KST",
            };
        final String[] Samoa = new String[] {
               "heure normale des Samoa",
               "SST",
               "heure avancée des Samoa",
               "SST",
               "heure des Samoa",
               "SST",
            };
        final String[] Tonga = new String[] {
               "heure normale des Tonga",
               "",
               "heure avancée de Tonga",
               "",
               "heure des Tonga",
               "",
            };
        final String[] Alaska = new String[] {
               "heure normale de l’Alaska",
               "AKST",
               "heure avancée de l’Alaska",
               "AKDT",
               "heure de l’Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "heure normale de l’Amazonie",
               "",
               "heure avancée de l’Amazonie",
               "",
               "heure de l’Amazonie",
               "",
            };
        final String[] Azores = new String[] {
               "heure normale des Açores",
               "",
               "heure avancée des Açores",
               "",
               "heure des Açores",
               "",
            };
        final String[] Brunei = new String[] {
               "heure du Brunéi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "heure normale de l’île de Pâques",
               "",
               "heure avancée de l’île de Pâques",
               "",
               "heure de l’île de Pâques",
               "",
            };
        final String[] Hawaii = new String[] {
               "heure normale d’Hawaï-Aléoutiennes",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "heure normale d’Israël",
               "IST",
               "heure avancée d’Israël",
               "IDT",
               "heure d’Israël",
               "IT",
            };
        final String[] Moscow = new String[] {
               "heure normale de Moscou",
               "MSK",
               "heure avancée de Moscou",
               "MSK",
               "heure de Moscou",
               "MSK",
            };
        final String[] Taipei = new String[] {
               "heure normale de Taipei",
               "CST",
               "heure avancée de Taipei",
               "CDT",
               "heure de Taipei",
               "CT",
            };
        final String[] Arabian = new String[] {
               "heure normale de l’Arabie",
               "",
               "heure avancée de l’Arabie",
               "",
               "heure de l’Arabie",
               "",
            };
        final String[] Armenia = new String[] {
               "heure normale de l’Arménie",
               "",
               "heure avancée d’Arménie",
               "",
               "heure de l’Arménie",
               "",
            };
        final String[] Georgia = new String[] {
               "heure normale de la Géorgie",
               "",
               "heure avancée de Géorgie",
               "",
               "heure de la Géorgie",
               "",
            };
        final String[] Irkutsk = new String[] {
               "heure normale d’Irkoutsk",
               "",
               "heure avancée d’Irkoutsk",
               "",
               "heure d’Irkoutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "heure normale de Magadan",
               "",
               "heure avancée de Magadan",
               "",
               "heure de Magadan",
               "",
            };
        final String[] Norfolk = new String[] {
               "heure normale de l’île Norfolk",
               "",
               "heure avancée de l’île Norfolk",
               "",
               "heure de l’île Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "heure normale de Fernando de Noronha",
               "",
               "heure avancée de Fernando de Noronha",
               "",
               "heure de Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "heure de la Réunion",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "heure normale de l’Uruguay",
               "",
               "heure avancée de l’Uruguay",
               "",
               "heure de l’Uruguay",
               "",
            };
        final String[] Vanuatu = new String[] {
               "heure normale du Vanuatu",
               "",
               "heure avancée de Vanuatu",
               "",
               "heure du Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "heure normale de Iakoutsk",
               "",
               "heure avancée de Iakoutsk",
               "",
               "heure de Iakoutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "heure normale de l’Atlantique",
               "HNA",
               "heure avancée de l’Atlantique",
               "HAA",
               "heure de l’Atlantique",
               "HA",
            };
        final String[] Brasilia = new String[] {
               "heure normale de Brasilia",
               "",
               "heure avancée de Brasilia",
               "",
               "heure de Brasilia",
               "",
            };
        final String[] Colombia = new String[] {
               "heure normale de Colombie",
               "",
               "heure avancée de Colombie",
               "",
               "heure de Colombie",
               "",
            };
        final String[] Falkland = new String[] {
               "heure normale des îles Malouines",
               "",
               "heure avancée des îles Malouines",
               "",
               "heure des îles Malouines",
               "",
            };
        final String[] Mongolia = new String[] {
               "heure normale d’Oulan-Bator",
               "",
               "heure avancée d’Oulan-Bator",
               "",
               "heure d’Oulan-Bator",
               "",
            };
        final String[] Pakistan = new String[] {
               "heure normale du Pakistan",
               "PKT",
               "heure avancée du Pakistan",
               "PKST",
               "heure du Pakistan",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "heure normale du Paraguay",
               "",
               "heure avancée du Paraguay",
               "",
               "heure du Paraguay",
               "",
            };
        final String[] Argentina = new String[] {
               "heure normale d’Argentine",
               "",
               "heure avancée de l’Argentine",
               "",
               "heure de l’Argentine",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "heure normale de Hong Kong",
               "HKT",
               "heure avancée de Hong Kong",
               "HKST",
               "heure de Hong Kong",
               "HKT",
            };
        final String[] Kamchatka = new String[] {
               "heure normale de Petropavlovsk-Kamchatski",
               "",
               "heure avancée de Petropavlovsk-Kamchatski",
               "",
               "heure de Petropavlovsk-Kamchatski",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "heure normale de Lord Howe",
               "",
               "heure avancée de Lord Howe",
               "",
               "heure de Lord Howe",
               "",
            };
        final String[] Mauritius = new String[] {
               "heure normale de Maurice",
               "",
               "heure avancée de Maurice",
               "",
               "heure de Maurice",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "heure normale de l’Azerbaïdjan",
               "",
               "heure avancée d’Azerbaïdjan",
               "",
               "heure de l’Azerbaïdjan",
               "",
            };
        final String[] Bangladesh = new String[] {
               "heure normale du Bangladesh",
               "",
               "heure avancée du Bangladesh",
               "",
               "heure du Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "heure normale du Cap-Vert",
               "",
               "heure avancée du Cap-Vert",
               "",
               "heure du Cap-Vert",
               "",
            };
        final String[] EMPTY_ZONE = new String[] {
               "",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "heure normale de l’Ouzbékistan",
               "",
               "heure avancée de l’Ouzbékistan",
               "",
               "heure de l’Ouzbékistan",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "heure normale de Krasnoïarsk",
               "",
               "heure avancée de Krasnoïarsk",
               "",
               "heure de Krasnoïarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "heure normale de la Nouvelle-Zélande",
               "NZST",
               "heure avancée de la Nouvelle-Zélande",
               "NZDT",
               "heure de la Nouvelle-Zélande",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "heure normale des Philippines",
               "PST",
               "heure avancée des Philippines",
               "PDT",
               "heure des Philippines",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "heure normale de Vladivostok",
               "",
               "heure avancée de Vladivostok",
               "",
               "heure de Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "heure de l’océan Indien",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "heure normale de Terre-Neuve",
               "HNT",
               "heure avancée de Terre-Neuve",
               "HAT",
               "heure de Terre-Neuve",
               "HT",
            };
        final String[] Turkmenistan = new String[] {
               "heure normale du Turkménistan",
               "",
               "heure avancée du Turkménistan",
               "",
               "heure du Turkménistan",
               "",
            };
        final String[] French_Guiana = new String[] {
               "heure de Guyane française",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "heure normale de la Nouvelle-Calédonie",
               "",
               "heure avancée de Nouvelle-Calédonie",
               "",
               "heure de la Nouvelle-Calédonie",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "heure normale d’Ekaterinbourg",
               "",
               "heure avancée d’Ekaterinbourg",
               "",
               "heure d’Ekaterinbourg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "heure d’Afrique centrale",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "heure d’Afrique orientale",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Europe_Central = new String[] {
               "heure normale de l’Europe centrale",
               "CET",
               "heure avancée de l’Europe centrale",
               "CEST",
               "heure de l’Europe centrale",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "heure normale de l’Europe de l’Est",
               "EET",
               "heure avancée de l’Europe de l’Est",
               "EEST",
               "heure de l’Europe de l’Est",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "heure normale de l’Europe de l’Ouest",
               "WET",
               "heure avancée de l’Europe de l’Ouest",
               "WEST",
               "heure de l’Europe de l’Ouest",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "heure normale du Pacifique mexicain",
               "MST",
               "heure avancée du Pacifique mexicain",
               "MDT",
               "heure du Pacifique mexicain",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "heure normale d’Afrique du Sud",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "heure normale du Centre",
               "HNC",
               "heure avancée du Centre",
               "HAC",
               "heure du Centre",
               "HC",
            };
        final String[] America_Eastern = new String[] {
               "heure normale de l’Est",
               "HNE",
               "heure avancée de l’Est",
               "HAE",
               "heure de l’Est",
               "HE",
            };
        final String[] America_Pacific = new String[] {
               "heure normale du Pacifique",
               "HNP",
               "heure avancée du Pacifique",
               "HAP",
               "heure du Pacifique",
               "HP",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "heure normale d’Hawaï-Aléoutiennes",
               "HST",
               "heure avancée d’Hawaï-Aléoutiennes",
               "HDT",
               "heure d’Hawaï-Aléoutiennes",
               "HT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "heure normale de Saint-Pierre-et-Miquelon",
               "HNPM",
               "heure avancée de Saint-Pierre-et-Miquelon",
               "HAPM",
               "heure de Saint-Pierre-et-Miquelon",
               "HPM",
            };
        final String[] America_Mountain = new String[] {
               "heure normale des Rocheuses",
               "HNR",
               "heure avancée des Rocheuses",
               "HAR",
               "heure des Rocheuses",
               "HR",
            };
        final String[] Australia_Central = new String[] {
               "heure normale du centre de l’Australie",
               "ACST",
               "heure avancée du centre de l’Australie",
               "ACDT",
               "heure du centre de l’Australie",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "heure normale de l’Est de l’Australie",
               "AEST",
               "heure avancée de l’Est de l’Australie",
               "AEDT",
               "heure de l’Est de l’Australie",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "heure normale de l’Ouest de l’Australie",
               "AWST",
               "heure avancée de l’Ouest de l’Australie",
               "AWDT",
               "heure de l’Ouest de l’Australie",
               "AWT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "heure normale du centre-ouest de l’Australie",
               "",
               "heure avancée du centre-ouest de l’Australie",
               "",
               "heure du centre-ouest de l’Australie",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", EMPTY_ZONE },
            { "GB",
                new String[] {
                    "",
                    "GMT",
                    "heure avancée britannique",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "",
                    "GMT",
                    "heure avancée irlandaise",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "GB-Eire",
                new String[] {
                    "",
                    "GMT",
                    "heure avancée britannique",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Reunion },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Asia/Anadyr", Kamchatka },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Riyadh", Arabian },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Niue", Niue },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "",
                    "GMT",
                    "heure avancée irlandaise",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "",
                    "GMT",
                    "heure avancée britannique",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "",
                    "GMT",
                    "heure avancée britannique",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Pyongyang", Korea },
            { "Asia/Samarkand", Uzbekistan },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "",
                    "GMT",
                    "heure avancée britannique",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "",
                    "GMT",
                    "heure avancée britannique",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Johnston", Hawaii },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "Antarctica/McMurdo", New_Zealand },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "",
                    "GMT",
                    "heure avancée britannique",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Dhaka", "Dacca" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Asia/Thimphu", "Thimphou" },
            { "timezone.excity.Pacific/Palau", "Palau" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Tripoli", "Tripoli [Libye]" },
            { "timezone.excity.America/Cayman", "îles Caïmans" },
            { "timezone.excity.Europe/Vatican", "Vatican" },
            { "timezone.excity.Pacific/Easter", "île de Pâques" },
            { "timezone.excity.Africa/Ndjamena", "Ndjamena" },
            { "timezone.excity.Atlantic/Canary", "îles Canaries" },
            { "timezone.excity.Atlantic/Faeroe", "îles Féroé" },
            { "timezone.excity.America/Barbados", "Barbade (La)" },
            { "timezone.excity.America/St_Johns", "St. John’s" },
            { "timezone.excity.America/St_Kitts", "Saint-Christophe-et-Niévès" },
            { "timezone.excity.America/St_Thomas", "Saint Thomas" },
            { "timezone.excity.Europe/Isle_of_Man", "île de Man" },
            { "timezone.excity.Antarctica/DumontDUrville", "Dumont d’Urville" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah [Dakota du Nord]" },
            { "timezone.excity.America/North_Dakota/Center", "Center [Dakota du Nord]" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem [Dakota du Nord]" },
        };
        return data;
    }
}
