/*
 * Copyright (c) 2006, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package netscape.javascript;

/**
 * Thrown when an exception is raised in the JavaScript engine. This is merely
 * a marker class to indicate an exception relating to the JavaScript
 * interface.
 * @since 1.5
 * @deprecated The jdk.jsobject module will be delivered with JavaFX.
 */
@Deprecated(since = "24", forRemoval = true)
@SuppressWarnings("removal")
public class JSException extends RuntimeException {
    private static final long serialVersionUID = 2778103758223661489L;

    /**
     * Constructs a new JavaScript exception with null as it's detail message.
     */
    public JSException() {
        super();
    }

    /**
     * Construct a new JavaScript exception with the specified detail message.
     *
     * @param s The detail message
     */
    public JSException(String s) {
        super(s);
    }

    /**
     * Construct a new JavaScript exception with the specified cause.
     *
     * @param t Throwable cause
     */
    public JSException(Throwable t) {
        super(t);
    }
}
