/*
 * Copyright (c) 2021, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package jdk.incubator.concurrent;

/**
 * Thrown when a structure violation is detected.
 *
 * @see StructuredTaskScope#fork(Callable)
 * @see StructuredTaskScope#close()
 * @see ScopeLocal.Carrier#run(Runnable)
 * @see ScopeLocal.Carrier#call(Callable)
 *
 * @since 19
 */
public class StructureViolationException extends RuntimeException {
    @java.io.Serial
    private static final long serialVersionUID = -7705327650798235468L;

    /**
     * Constructs an {@code StructureViolationException} with no detail message.
     */
    public StructureViolationException() {
        super();
    }

    /**
     * Constructs an {@code StructureViolationException} with the specified
     * detail message.
     *
     * @param  message the detail message, can be null
     */
    public StructureViolationException(String message) {
        super(message);
    }
}
