/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.text.resources.cldr.ext;

import java.util.ListResourceBundle;

public class FormatData_ff_Adlm extends ListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] metaValue_generic_DayNames = new String[] {
               "\ud83a\udd08\ud83a\udd2b\ud83a\udd2c\ud83a\udd26\ud83a\udd2d\ud83a\udd2a\ud83a\udd46\ud83a\udd2b",
               "\ud83a\udd00\ud83a\udd44\ud83a\udd29\ud83a\udd35\ud83a\udd32\ud83a\udd4b\ud83a\udd23\ud83a\udd2b",
               "\ud83a\udd03\ud83a\udd22\ud83a\udd31\ud83a\udd26\ud83a\udd22\ud83a\udd44\ud83a\udd2a\ud83a\udd2b",
               "\ud83a\udd10\ud83a\udd36\ud83a\udd2b\ud83a\udd27\ud83a\udd24\ud83a\udd22\ud83a\udd44\ud83a\udd2a\ud83a\udd2b",
               "\ud83a\udd10\ud83a\udd22\ud83a\udd44\ud83a\udd27\ud83a\udd22\ud83a\udd44\ud83a\udd32\ud83a\udd23\ud83a\udd2b",
               "\ud83a\udd03\ud83a\udd22\ud83a\udd31\ud83a\udd32\ud83a\udd23\ud83a\udd2b",
               "\ud83a\udd16\ud83a\udd2e\ud83a\udd2a\ud83a\udd26\ud83a\udd2d\ud83a\udd2a\ud83a\udd46\ud83a\udd2b",
            };
        final String[] metaValue_generic_DayAbbreviations = new String[] {
               "\ud83a\udd08\ud83a\udd2b\ud83a\udd2c",
               "\ud83a\udd00\ud83a\udd44\ud83a\udd29\ud83a\udd35",
               "\ud83a\udd03\ud83a\udd22\ud83a\udd26",
               "\ud83a\udd14\ud83a\udd2b\ud83a\udd27",
               "\ud83a\udd10\ud83a\udd22\ud83a\udd44\ud83a\udd27",
               "\ud83a\udd03\ud83a\udd22\ud83a\udd23",
               "\ud83a\udd16\ud83a\udd2e\ud83a\udd2a",
            };
        final String[] metaValue_generic_DayNarrows = new String[] {
               "\ud83a\udd08",
               "\ud83a\udd00\ud83a\udd44",
               "\ud83a\udd03",
               "\ud83a\udd14",
               "\ud83a\udd10",
               "\ud83a\udd03",
               "\ud83a\udd16",
            };
        final String[] metaValue_generic_QuarterNames = new String[] {
               "\ud83a\udd10\ud83a\udd51",
               "\ud83a\udd10\ud83a\udd52",
               "\ud83a\udd10\ud83a\udd53",
               "\ud83a\udd10\ud83a\udd54",
            };
        final String[] metaValue_generic_QuarterNarrows = new String[] {
               "\ud83a\udd51",
               "\ud83a\udd52",
               "\ud83a\udd53",
               "\ud83a\udd54",
            };
        final String[] metaValue_generic_AmPmMarkers = new String[] {
               "\ud83a\udd00\ud83a\udd0e",
               "\ud83a\udd07\ud83a\udd0e",
               "",
               "",
               "",
               "",
               "",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] metaValue_generic_narrow_AmPmMarkers = new String[] {
               "\ud83a\udd22",
               "\ud83a\udd29",
               "",
               "",
               "",
               "",
               "",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] metaValue_generic_TimePatterns = new String[] {
               "HH:mm:ss zzzz",
               "HH:mm:ss z",
               "HH:mm:ss",
               "HH:mm",
            };
        final String metaValue_generic_DateFormatItem_MMMMW = "\ud83a\udd34\ud83a\udd2e\ud83a\udd32\ud83a\udd3c\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b W \ud83a\udd32\ud83a\udd23\ud83a\udd2b\ud83a\udd2a MMMM";
        final String metaValue_generic_DateFormatItem_yw = "\ud83a\udd34\ud83a\udd2e\ud83a\udd32\ud83a\udd3c\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b w \ud83a\udd32\ud83a\udd23\ud83a\udd2b\ud83a\udd2a Y";
        final String[] metaValue_MonthNames = new String[] {
               "\ud83a\udd05\ud83a\udd2d\ud83a\udd45\ud83a\udd24\ud83a\udd2e",
               "\ud83a\udd15\ud83a\udd2e\ud83a\udd24\ud83a\udd3c\ud83a\udd2e",
               "\ud83a\udd10\ud83a\udd26\ud83a\udd2e\ud83a\udd45\ud83a\udd34\ud83a\udd2e",
               "\ud83a\udd05\ud83a\udd2b\ud83a\udd45\ud83a\udd3c\ud83a\udd2e",
               "\ud83a\udd01\ud83a\udd35\ud83a\udd45\ud83a\udd36\ud83a\udd2e",
               "\ud83a\udd11\ud83a\udd2e\ud83a\udd2a\ud83a\udd27\ud83a\udd2e",
               "\ud83a\udd03\ud83a\udd2e\ud83a\udd2a\ud83a\udd27\ud83a\udd2e",
               "\ud83a\udd14\ud83a\udd35\ud83a\udd33\ud83a\udd2e",
               "\ud83a\udd05\ud83a\udd2d\ud83a\udd24\ud83a\udd3c\ud83a\udd2e",
               "\ud83a\udd12\ud83a\udd22\ud83a\udd2a\ud83a\udd33\ud83a\udd2e",
               "\ud83a\udd14\ud83a\udd2e\ud83a\udd24\ud83a\udd2e",
               "\ud83a\udd10\ud83a\udd26\ud83a\udd2e\ud83a\udd31\ud83a\udd3c\ud83a\udd2e",
               "",
            };
        final String[] metaValue_MonthNarrows = new String[] {
               "\ud83a\udd05",
               "\ud83a\udd15",
               "\ud83a\udd04",
               "\ud83a\udd05",
               "\ud83a\udd01",
               "\ud83a\udd11",
               "\ud83a\udd03",
               "\ud83a\udd14",
               "\ud83a\udd05",
               "\ud83a\udd12",
               "\ud83a\udd14",
               "\ud83a\udd04",
               "",
            };
        final String[] metaValue_Eras = new String[] {
               "\ud83a\udd00\ud83a\udd00\ud83a\udd0b",
               "\ud83a\udd07\ud83a\udd00\ud83a\udd0b",
            };
        final String[] metaValue_java_time_islamic_long_Eras = new String[] {
               "",
               "\ud83a\udd07\ud83a\udd0a",
            };
        final String metaValue_calendarname_gregorian = "\ud83a\udd19\ud83a\udd22\ud83a\udd24\ud83a\udd2f\ud83a\udd2d\ud83a\udd25\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b \ud83a\udd18\ud83a\udd2b\ud83a\udd2a\ud83a\udd3a\ud83a\udd2e\ud83a\udd2a\ud83a\udd2d\ud83a\udd34\ud83a\udd22\ud83a\udd32\ud83a\udd33\ud83a\udd2e";
        final Object[][] data = new Object[][] {
            { "MonthNames", metaValue_MonthNames },
            { "field.year", "\ud83a\udd38\ud83a\udd2d\ud83a\udd3c\ud83a\udd22\ud83a\udd44\ud83a\udd32\ud83a\udd23\ud83a\udd2b" },
            { "japanese.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "japanese.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "timezone.gmtFormat", "\ud83a\udd11\ud83a\udd16\ud83a\udd18{0}" },
            { "standalone.QuarterAbbreviations", metaValue_generic_QuarterNames },
            { "roc.QuarterNames", metaValue_generic_QuarterNames },
            { "generic.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "generic.QuarterNarrows", metaValue_generic_QuarterNarrows },
            { "roc.MonthNarrows", metaValue_MonthNarrows },
            { "calendarname.islamic-civil", "\ud83a\udd19\ud83a\udd22\ud83a\udd24\ud83a\udd2f\ud83a\udd2d\ud83a\udd25\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b \ud83a\udd02\ud83a\udd2d\ud83a\udd27\ud83a\udd24\ud83a\udd22\ud83a\udd44\ud83a\udd25\ud83a\udd34\ud83a\udd22\ud83a\udd32\ud83a\udd33\ud83a\udd2e (\ud83a\udd22\ud83a\udd24\ud83a\udd46\ud83a\udd35\ud83a\udd31\ud83a\udd22\ud83a\udd24, \ud83a\udd2c\ud83a\udd2b\ud83a\udd31\ud83a\udd32\ud83a\udd4b\ud83a\udd23\ud83a\udd2e \ud83a\udd32\ud83a\udd4b\ud83a\udd26\ud83a\udd2b\ud83a\udd2f\ud83a\udd46\ud83a\udd22\ud83a\udd44\ud83a\udd33\ud83a\udd35)" },
            { "islamic.narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "japanese.TimePatterns", metaValue_generic_TimePatterns },
            { "narrow.Eras", metaValue_Eras },
            { "islamic-umalqura.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "abbreviated.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "timezone.regionFormat.standard", "{0} \ud83a\udd11\ud83a\udd2d\ud83a\udd36\ud83a\udd2e\ud83a\udd45\ud83a\udd2a\ud83a\udd2b \ud83a\udd16\ud83a\udd22\ud83a\udd31\ud83a\udd2a\ud83a\udd2d\ud83a\udd3c\ud83a\udd35\ud83a\udd32\ud83a\udd4b\ud83a\udd23\ud83a\udd2b" },
            { "DefaultNumberingSystem", "adlm" },
            { "japanese.abbreviated.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "calendarname.japanese", "\ud83a\udd19\ud83a\udd22\ud83a\udd24\ud83a\udd2f\ud83a\udd2d\ud83a\udd25\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b \ud83a\udd14\ud83a\udd22\ud83a\udd44\ud83a\udd28\ud83a\udd2e\ud83a\udd32\ud83a\udd2d\ud83a\udd32\ud83a\udd33\ud83a\udd2e" },
            { "islamic.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "timezone.gmtZeroFormat", "\ud83a\udd11\ud83a\udd16\ud83a\udd18" },
            { "DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "japanese.MonthNames", metaValue_MonthNames },
            { "standalone.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "roc.MonthAbbreviations", metaValue_MonthNames },
            { "java.time.islamic.narrow.Eras", metaValue_java_time_islamic_long_Eras },
            { "islamic-umalqura.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "long.Eras",
                new String[] {
                    "\ud83a\udd00\ud83a\udd23\ud83a\udd2e \ud83a\udd00\ud83a\udd32\ud83a\udd46\ud83a\udd22\ud83a\udd26\ud83a\udd2d \ud83a\udd0b\ud83a\udd45\ud83a\udd27\ud83a\udd22\ud83a\udd44",
                    "\ud83a\udd07\ud83a\udd22\ud83a\udd44\ud83a\udd31\ud83a\udd2e \ud83a\udd00\ud83a\udd32\ud83a\udd46\ud83a\udd22\ud83a\udd26\ud83a\udd2d \ud83a\udd0b\ud83a\udd45\ud83a\udd27\ud83a\udd22\ud83a\udd44",
                }
            },
            { "roc.QuarterNarrows", metaValue_generic_QuarterNarrows },
            { "islamic.DayNames", metaValue_generic_DayNames },
            { "DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "buddhist.MonthAbbreviations", metaValue_MonthNames },
            { "buddhist.MonthNames", metaValue_MonthNames },
            { "DateTimePatterns",
                new String[] {
                    "{1}{0}",
                    "{1} {0}",
                    "{1} {0}",
                    "{1} {0}",
                }
            },
            { "narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "latn.NumberElements",
                new String[] {
                    ".",
                    "\u2e41",
                    ";",
                    "%",
                    "0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "\ud83a\udd0f\ud83a\udd2e\ud83a\udd08",
                    "",
                    "",
                }
            },
            { "MonthNarrows", metaValue_MonthNarrows },
            { "buddhist.DayNames", metaValue_generic_DayNames },
            { "field.minute", "\ud83a\udd38\ud83a\udd2e\ud83a\udd36\ud83a\udd2e\ud83a\udd25\ud83a\udd22\ud83a\udd44\ud83a\udd2a\ud83a\udd2b" },
            { "field.era", "\ud83a\udd3a\ud83a\udd2d\ud83a\udd2a\ud83a\udd22\ud83a\udd24" },
            { "buddhist.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "field.dayperiod", "\ud83a\udd00\ud83a\udd0e/\ud83a\udd07\ud83a\udd0e" },
            { "standalone.MonthNarrows",
                new String[] {
                    "\ud83a\udd05",
                    "\ud83a\udd15",
                    "\ud83a\udd04",
                    "\ud83a\udd05",
                    "\ud83a\udd01",
                    "\ud83a\udd11",
                    "\ud83a\udd03",
                    "\ud83a\udd14",
                    "\ud83a\udd05",
                    "\ud83a\udd12",
                    "\ud83a\udd04",
                    "\ud83a\udd04",
                    "",
                }
            },
            { "islamic.MonthNames",
                new String[] {
                    "\ud83a\udd14\ud83a\udd2e\ud83a\udd25\ud83a\udd26\ud83a\udd2b\ud83a\udd32\ud83a\udd3c\ud83a\udd2b",
                    "\ud83a\udd05\ud83a\udd22\ud83a\udd26\ud83a\udd46\ud83a\udd2e\ud83a\udd2a\ud83a\udd23\ud83a\udd35-\ud83a\udd06\ud83a\udd22\ud83a\udd2a\ud83a\udd22\ud83a\udd32",
                    "\ud83a\udd06\ud83a\udd22\ud83a\udd2a\ud83a\udd22\ud83a\udd32",
                    "\ud83a\udd03\ud83a\udd2d\ud83a\udd25\ud83a\udd28\ud83a\udd22\ud83a\udd2a\ud83a\udd22\ud83a\udd32",
                    "\ud83a\udd04\ud83a\udd22\ud83a\udd28\ud83a\udd46\ud83a\udd22\ud83a\udd2a\ud83a\udd22\ud83a\udd32",
                    "\ud83a\udd05\ud83a\udd22\ud83a\udd26\ud83a\udd46\ud83a\udd2e\ud83a\udd2a\ud83a\udd23\ud83a\udd35-\ud83a\udd08\ud83a\udd22\ud83a\udd44\ud83a\udd36\ud83a\udd2d\ud83a\udd26\ud83a\udd2d",
                    "\ud83a\udd08\ud83a\udd22\ud83a\udd44\ud83a\udd36\ud83a\udd2d\ud83a\udd26\ud83a\udd2d",
                    "\ud83a\udd05\ud83a\udd22\ud83a\udd26\ud83a\udd46\ud83a\udd2e\ud83a\udd2a\ud83a\udd23\ud83a\udd35-\ud83a\udd05\ud83a\udd35\ud83a\udd45\ud83a\udd25\ud83a\udd22\ud83a\udd34\ud83a\udd2b\ud83a\udd45",
                    "\ud83a\udd05\ud83a\udd35\ud83a\udd45\ud83a\udd25\ud83a\udd22\ud83a\udd34\ud83a\udd2b\ud83a\udd45",
                    "\ud83a\udd14\ud83a\udd35\ud83a\udd45\ud83a\udd24\ud83a\udd23\ud83a\udd22\ud83a\udd44\ud83a\udd32\ud83a\udd4b\ud83a\udd23\ud83a\udd35",
                    "\ud83a\udd05\ud83a\udd22\ud83a\udd26\ud83a\udd46\ud83a\udd2e\ud83a\udd2a\ud83a\udd23\ud83a\udd35-\ud83a\udd01\ud83a\udd2e\ud83a\udd32\ud83a\udd33\ud83a\udd2d\ud83a\udd32",
                    "\ud83a\udd01\ud83a\udd35\ud83a\udd32\ud83a\udd33\ud83a\udd2d\ud83a\udd32",
                    "",
                }
            },
            { "japanese.QuarterNarrows", metaValue_generic_QuarterNarrows },
            { "calendarname.roc", "\ud83a\udd19\ud83a\udd22\ud83a\udd24\ud83a\udd2f\ud83a\udd2d\ud83a\udd25\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b \ud83a\udd18\ud83a\udd2b\ud83a\udd32\ud83a\udd23\ud83a\udd2d\ud83a\udd34\ud83a\udd22\ud83a\udd32\ud83a\udd33\ud83a\udd2e \ud83a\udd05\ud83a\udd2d\ud83a\udd45\ud83a\udd32" },
            { "roc.QuarterAbbreviations", metaValue_generic_QuarterNames },
            { "generic.abbreviated.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "islamic.Eras", metaValue_java_time_islamic_long_Eras },
            { "field.month", "\ud83a\udd24\ud83a\udd2b\ud83a\udd31\ud83a\udd2a\ud83a\udd35" },
            { "field.second", "\ud83a\udd33\ud83a\udd2d\ud83a\udd32\ud83a\udd30\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b" },
            { "islamic.MonthNarrows",
                new String[] {
                    "\ud83a\udd51",
                    "\ud83a\udd52",
                    "\ud83a\udd53",
                    "\ud83a\udd54",
                    "\ud83a\udd55",
                    "\ud83a\udd56",
                    "\ud83a\udd57",
                    "\ud83a\udd58",
                    "\ud83a\udd59",
                    "\ud83a\udd51\ud83a\udd50",
                    "\ud83a\udd51\ud83a\udd51",
                    "\ud83a\udd51\ud83a\udd52",
                    "",
                }
            },
            { "DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "DayNarrows", metaValue_generic_DayNarrows },
            { "islamic-civil.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "islamic.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "calendarname.islamic", "\ud83a\udd19\ud83a\udd22\ud83a\udd24\ud83a\udd25\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b \ud83a\udd02\ud83a\udd2d\ud83a\udd27\ud83a\udd24\ud83a\udd22\ud83a\udd44\ud83a\udd25\ud83a\udd34\ud83a\udd22\ud83a\udd32\ud83a\udd33\ud83a\udd2e" },
            { "generic.TimePatterns", metaValue_generic_TimePatterns },
            { "roc.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "japanese.narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "generic.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "buddhist.TimePatterns", metaValue_generic_TimePatterns },
            { "buddhist.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "generic.QuarterAbbreviations", metaValue_generic_QuarterNames },
            { "standalone.MonthAbbreviations",
                new String[] {
                    "\ud83a\udd05\ud83a\udd2d\ud83a\udd45\ud83a\udd24",
                    "\ud83a\udd15\ud83a\udd2e\ud83a\udd24",
                    "\ud83a\udd04\ud83a\udd2e\ud83a\udd45\ud83a\udd34",
                    "\ud83a\udd05\ud83a\udd2b\ud83a\udd45\ud83a\udd3c",
                    "\ud83a\udd01\ud83a\udd35\ud83a\udd45\ud83a\udd36",
                    "\ud83a\udd11\ud83a\udd2e\ud83a\udd2a",
                    "\ud83a\udd03\ud83a\udd2e\ud83a\udd2a",
                    "\ud83a\udd14\ud83a\udd35\ud83a\udd33",
                    "\ud83a\udd05\ud83a\udd2d\ud83a\udd24",
                    "\ud83a\udd12\ud83a\udd22\ud83a\udd2a",
                    "\ud83a\udd14\ud83a\udd2e\ud83a\udd24",
                    "\ud83a\udd04\ud83a\udd2e\ud83a\udd31",
                    "",
                }
            },
            { "timezone.regionFormat", "{0} \ud83a\udd11\ud83a\udd2d\ud83a\udd36\ud83a\udd2e\ud83a\udd45\ud83a\udd2a\ud83a\udd2b" },
            { "buddhist.QuarterNarrows", metaValue_generic_QuarterNarrows },
            { "roc.narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "standalone.QuarterNames",
                new String[] {
                    "\ud83a\udd10\ud83a\udd22\ud83a\udd34\ud83a\udd29\ud83a\udd2d\ud83a\udd45\ud83a\udd2a\ud83a\udd2b \ud83a\udd51\ud83a\udd2a\ud83a\udd2b",
                    "\ud83a\udd10\ud83a\udd22\ud83a\udd34\ud83a\udd29\ud83a\udd2d\ud83a\udd45\ud83a\udd2a\ud83a\udd2b \ud83a\udd52\ud83a\udd2a\ud83a\udd2b",
                    "\ud83a\udd10\ud83a\udd22\ud83a\udd34\ud83a\udd29\ud83a\udd2d\ud83a\udd45\ud83a\udd2a\ud83a\udd2b \ud83a\udd53\ud83a\udd2a\ud83a\udd2b",
                    "\ud83a\udd10\ud83a\udd22\ud83a\udd34\ud83a\udd29\ud83a\udd2d\ud83a\udd45\ud83a\udd2a\ud83a\udd2b \ud83a\udd54\ud83a\udd2a\ud83a\udd2b",
                }
            },
            { "japanese.MonthNarrows", metaValue_MonthNarrows },
            { "islamic.QuarterAbbreviations", metaValue_generic_QuarterNames },
            { "roc.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "standalone.DayNarrows", metaValue_generic_DayNarrows },
            { "islamic.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "TimePatterns", metaValue_generic_TimePatterns },
            { "islamic.DayNarrows", metaValue_generic_DayNarrows },
            { "islamic-civil.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "field.zone", "\ud83a\udd33\ud83a\udd2d\ud83a\udd36\ud83a\udd2e\ud83a\udd45\ud83a\udd2a\ud83a\udd2b \ud83a\udd32\ud83a\udd2e\ud83a\udd33\ud83a\udd46\ud83a\udd35\ud83a\udd45\ud83a\udd2a\ud83a\udd2b" },
            { "generic.DayNarrows", metaValue_generic_DayNarrows },
            { "japanese.QuarterAbbreviations", metaValue_generic_QuarterNames },
            { "buddhist.narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "buddhist.abbreviated.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "Eras", metaValue_Eras },
            { "roc.DayNames", metaValue_generic_DayNames },
            { "islamic.QuarterNames", metaValue_generic_QuarterNames },
            { "QuarterNarrows", metaValue_generic_QuarterNarrows },
            { "islamic.abbreviated.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "standalone.QuarterNarrows", metaValue_generic_QuarterNarrows },
            { "field.weekday", "\ud83a\udd3b\ud83a\udd22\ud83a\udd24\ud83a\udd46\ud83a\udd22\ud83a\udd24 \ud83a\udd33\ud83a\udd22 \ud83a\udd34\ud83a\udd2e\ud83a\udd32\ud83a\udd3c\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b" },
            { "roc.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "buddhist.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "japanese.MonthAbbreviations", metaValue_MonthNames },
            { "generic.DayNames", metaValue_generic_DayNames },
            { "islamic.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "islamic.long.Eras", metaValue_java_time_islamic_long_Eras },
            { "java.time.islamic.Eras", metaValue_java_time_islamic_long_Eras },
            { "japanese.QuarterNames", metaValue_generic_QuarterNames },
            { "buddhist.QuarterAbbreviations", metaValue_generic_QuarterNames },
            { "japanese.DayNames", metaValue_generic_DayNames },
            { "japanese.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "DayNames", metaValue_generic_DayNames },
            { "roc.MonthNames", metaValue_MonthNames },
            { "field.week", "\ud83a\udd34\ud83a\udd2e\ud83a\udd32\ud83a\udd3c\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b" },
            { "generic.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "buddhist.QuarterNames", metaValue_generic_QuarterNames },
            { "islamic.QuarterNarrows", metaValue_generic_QuarterNarrows },
            { "buddhist.MonthNarrows", metaValue_MonthNarrows },
            { "roc.DayNarrows", metaValue_generic_DayNarrows },
            { "roc.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "generic.QuarterNames", metaValue_generic_QuarterNames },
            { "calendarname.gregorian", metaValue_calendarname_gregorian },
            { "timezone.regionFormat.daylight", "{0} \ud83a\udd10\ud83a\udd36\ud83a\udd22\ud83a\udd25\ud83a\udd32\ud83a\udd23\ud83a\udd2d \ud83a\udd15\ud83a\udd2b\ud83a\udd45\ud83a\udd2f\ud83a\udd35" },
            { "DatePatterns",
                new String[] {
                    "y MMMM d, EEEE",
                    "y MMMM d",
                    "y MMM d",
                    "y-MM-dd",
                }
            },
            { "buddhist.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "islamic.TimePatterns", metaValue_generic_TimePatterns },
            { "standalone.DayNames", metaValue_generic_DayNames },
            { "MonthAbbreviations", metaValue_MonthNames },
            { "generic.narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "field.hour", "\ud83a\udd32\ud83a\udd4b\ud83a\udd36\ud83a\udd22\ud83a\udd25\ud83a\udd32\ud83a\udd4b\ud83a\udd23\ud83a\udd2d" },
            { "islamic.MonthAbbreviations",
                new String[] {
                    "\ud83a\udd14\ud83a\udd2e\ud83a\udd26.",
                    "\ud83a\udd05\ud83a\udd22\ud83a\udd28.",
                    "\ud83a\udd06\ud83a\udd22\ud83a\udd2a.",
                    "\ud83a\udd03\ud83a\udd2d\ud83a\udd28.",
                    "\ud83a\udd04\ud83a\udd22\ud83a\udd28.",
                    "\ud83a\udd05\ud83a\udd22\ud83a\udd2a.",
                    "\ud83a\udd08\ud83a\udd22\ud83a\udd36.",
                    "\ud83a\udd05\ud83a\udd22\ud83a\udd27.",
                    "\ud83a\udd05\ud83a\udd35\ud83a\udd25.",
                    "\ud83a\udd14\ud83a\udd35\ud83a\udd24.",
                    "\ud83a\udd05\ud83a\udd22\ud83a\udd23.",
                    "\ud83a\udd01\ud83a\udd2e\ud83a\udd32.",
                    "",
                }
            },
            { "islamic.narrow.Eras", metaValue_java_time_islamic_long_Eras },
            { "calendarname.buddhist", "\ud83a\udd19\ud83a\udd22\ud83a\udd24\ud83a\udd2f\ud83a\udd2d\ud83a\udd25\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b \ud83a\udd04\ud83a\udd35\ud83a\udd45\ud83a\udd23\ud83a\udd22\ud83a\udd34\ud83a\udd22\ud83a\udd32\ud83a\udd33\ud83a\udd2e" },
            { "generic.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "standalone.MonthNames", metaValue_MonthNames },
            { "latn.NumberPatterns",
                new String[] {
                    "#,##0.###",
                    "\u00a4\u00a0#,##0.00",
                    "#,##0%",
                    "",
                }
            },
            { "buddhist.DayNarrows", metaValue_generic_DayNarrows },
            { "japanese.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "java.time.islamic.long.Eras", metaValue_java_time_islamic_long_Eras },
            { "japanese.DayNarrows", metaValue_generic_DayNarrows },
            { "QuarterNames", metaValue_generic_QuarterNames },
            { "roc.TimePatterns", metaValue_generic_TimePatterns },
            { "QuarterAbbreviations", metaValue_generic_QuarterNames },
            { "roc.abbreviated.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "calendarname.gregory", metaValue_calendarname_gregorian },
        };
        return data;
    }
}
