/*
 *  Copyright (c) 2021, Oracle and/or its affiliates. All rights reserved.
 *  DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 *  This code is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License version 2 only, as
 *  published by the Free Software Foundation.  Oracle designates this
 *  particular file as subject to the "Classpath" exception as provided
 *  by Oracle in the LICENSE file that accompanied this code.
 *
 *  This code is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  version 2 for more details (a copy is included in the LICENSE file that
 *  accompanied this code).
 *
 *  You should have received a copy of the GNU General Public License version
 *  2 along with this work; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 *   Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 *  or visit www.oracle.com if you need additional information or have any
 *  questions.
 */

// Generated by jextract

package jdk.internal.clang.libclang;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import jdk.incubator.foreign.*;
import static jdk.incubator.foreign.CLinker.*;
public class Index_h  {

    // Manual change to handle platform specific library name difference
    private static String libName() {
        if (System.getProperty("os.name").startsWith("Windows")) {
            return "libclang";
        }
        return "clang";
    }

    static {
        System.loadLibrary(libName());
    }

    static final SymbolLookup LIBRARIES = RuntimeHelper.lookup();    /* package-private */ Index_h() {}
    public static int CXError_Success() {
        return (int)0L;
    }
    public static int CXError_Failure() {
        return (int)1L;
    }
    public static int CXError_Crashed() {
        return (int)2L;
    }
    public static int CXError_InvalidArguments() {
        return (int)3L;
    }
    public static int CXError_ASTReadError() {
        return (int)4L;
    }
    public static MethodHandle clang_getCString$MH() {
        return RuntimeHelper.requireNonNull(constants$0.clang_getCString$MH,"clang_getCString");
    }
    public static MemoryAddress clang_getCString ( MemorySegment string) {
        var mh$ = RuntimeHelper.requireNonNull(constants$0.clang_getCString$MH, "clang_getCString");
        try {
            return (jdk.incubator.foreign.MemoryAddress)mh$.invokeExact(string);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_disposeString$MH() {
        return RuntimeHelper.requireNonNull(constants$0.clang_disposeString$MH,"clang_disposeString");
    }
    public static void clang_disposeString ( MemorySegment string) {
        var mh$ = RuntimeHelper.requireNonNull(constants$0.clang_disposeString$MH, "clang_disposeString");
        try {
            mh$.invokeExact(string);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static int CXCursor_ExceptionSpecificationKind_None() {
        return (int)0L;
    }
    public static int CXCursor_ExceptionSpecificationKind_DynamicNone() {
        return (int)1L;
    }
    public static int CXCursor_ExceptionSpecificationKind_Dynamic() {
        return (int)2L;
    }
    public static int CXCursor_ExceptionSpecificationKind_MSAny() {
        return (int)3L;
    }
    public static int CXCursor_ExceptionSpecificationKind_BasicNoexcept() {
        return (int)4L;
    }
    public static int CXCursor_ExceptionSpecificationKind_ComputedNoexcept() {
        return (int)5L;
    }
    public static int CXCursor_ExceptionSpecificationKind_Unevaluated() {
        return (int)6L;
    }
    public static int CXCursor_ExceptionSpecificationKind_Uninstantiated() {
        return (int)7L;
    }
    public static int CXCursor_ExceptionSpecificationKind_Unparsed() {
        return (int)8L;
    }
    public static int CXCursor_ExceptionSpecificationKind_NoThrow() {
        return (int)9L;
    }
    public static MethodHandle clang_createIndex$MH() {
        return RuntimeHelper.requireNonNull(constants$0.clang_createIndex$MH,"clang_createIndex");
    }
    public static MemoryAddress clang_createIndex ( int excludeDeclarationsFromPCH,  int displayDiagnostics) {
        var mh$ = RuntimeHelper.requireNonNull(constants$0.clang_createIndex$MH, "clang_createIndex");
        try {
            return (jdk.incubator.foreign.MemoryAddress)mh$.invokeExact(excludeDeclarationsFromPCH, displayDiagnostics);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_disposeIndex$MH() {
        return RuntimeHelper.requireNonNull(constants$0.clang_disposeIndex$MH,"clang_disposeIndex");
    }
    public static void clang_disposeIndex ( Addressable index) {
        var mh$ = RuntimeHelper.requireNonNull(constants$0.clang_disposeIndex$MH, "clang_disposeIndex");
        try {
            mh$.invokeExact(index.address());
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_getFileName$MH() {
        return RuntimeHelper.requireNonNull(constants$0.clang_getFileName$MH,"clang_getFileName");
    }
    public static MemorySegment clang_getFileName ( SegmentAllocator allocator,  Addressable SFile) {
        var mh$ = RuntimeHelper.requireNonNull(constants$0.clang_getFileName$MH, "clang_getFileName");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, SFile.address());
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getFileName ( ResourceScope scope,  Addressable SFile) {
        return clang_getFileName(SegmentAllocator.ofScope(scope), SFile.address());
    }
    public static MethodHandle clang_getNullLocation$MH() {
        return RuntimeHelper.requireNonNull(constants$0.clang_getNullLocation$MH,"clang_getNullLocation");
    }
    public static MemorySegment clang_getNullLocation ( SegmentAllocator allocator) {
        var mh$ = RuntimeHelper.requireNonNull(constants$0.clang_getNullLocation$MH, "clang_getNullLocation");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getNullLocation ( ResourceScope scope) {
        return clang_getNullLocation(SegmentAllocator.ofScope(scope));
    }
    public static MethodHandle clang_equalLocations$MH() {
        return RuntimeHelper.requireNonNull(constants$1.clang_equalLocations$MH,"clang_equalLocations");
    }
    public static int clang_equalLocations ( MemorySegment loc1,  MemorySegment loc2) {
        var mh$ = RuntimeHelper.requireNonNull(constants$1.clang_equalLocations$MH, "clang_equalLocations");
        try {
            return (int)mh$.invokeExact(loc1, loc2);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_getLocation$MH() {
        return RuntimeHelper.requireNonNull(constants$1.clang_getLocation$MH,"clang_getLocation");
    }
    public static MemorySegment clang_getLocation ( SegmentAllocator allocator,  Addressable tu,  Addressable file,  int line,  int column) {
        var mh$ = RuntimeHelper.requireNonNull(constants$1.clang_getLocation$MH, "clang_getLocation");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, tu.address(), file.address(), line, column);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getLocation ( ResourceScope scope,  Addressable tu,  Addressable file,  int line,  int column) {
        return clang_getLocation(SegmentAllocator.ofScope(scope), tu.address(), file.address(), line, column);
    }
    public static MethodHandle clang_getLocationForOffset$MH() {
        return RuntimeHelper.requireNonNull(constants$1.clang_getLocationForOffset$MH,"clang_getLocationForOffset");
    }
    public static MemorySegment clang_getLocationForOffset ( SegmentAllocator allocator,  Addressable tu,  Addressable file,  int offset) {
        var mh$ = RuntimeHelper.requireNonNull(constants$1.clang_getLocationForOffset$MH, "clang_getLocationForOffset");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, tu.address(), file.address(), offset);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getLocationForOffset ( ResourceScope scope,  Addressable tu,  Addressable file,  int offset) {
        return clang_getLocationForOffset(SegmentAllocator.ofScope(scope), tu.address(), file.address(), offset);
    }
    public static MethodHandle clang_Location_isInSystemHeader$MH() {
        return RuntimeHelper.requireNonNull(constants$1.clang_Location_isInSystemHeader$MH,"clang_Location_isInSystemHeader");
    }
    public static int clang_Location_isInSystemHeader ( MemorySegment location) {
        var mh$ = RuntimeHelper.requireNonNull(constants$1.clang_Location_isInSystemHeader$MH, "clang_Location_isInSystemHeader");
        try {
            return (int)mh$.invokeExact(location);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_Location_isFromMainFile$MH() {
        return RuntimeHelper.requireNonNull(constants$1.clang_Location_isFromMainFile$MH,"clang_Location_isFromMainFile");
    }
    public static int clang_Location_isFromMainFile ( MemorySegment location) {
        var mh$ = RuntimeHelper.requireNonNull(constants$1.clang_Location_isFromMainFile$MH, "clang_Location_isFromMainFile");
        try {
            return (int)mh$.invokeExact(location);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_Range_isNull$MH() {
        return RuntimeHelper.requireNonNull(constants$1.clang_Range_isNull$MH,"clang_Range_isNull");
    }
    public static int clang_Range_isNull ( MemorySegment range) {
        var mh$ = RuntimeHelper.requireNonNull(constants$1.clang_Range_isNull$MH, "clang_Range_isNull");
        try {
            return (int)mh$.invokeExact(range);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_getExpansionLocation$MH() {
        return RuntimeHelper.requireNonNull(constants$2.clang_getExpansionLocation$MH,"clang_getExpansionLocation");
    }
    public static void clang_getExpansionLocation ( MemorySegment location,  Addressable file,  Addressable line,  Addressable column,  Addressable offset) {
        var mh$ = RuntimeHelper.requireNonNull(constants$2.clang_getExpansionLocation$MH, "clang_getExpansionLocation");
        try {
            mh$.invokeExact(location, file.address(), line.address(), column.address(), offset.address());
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_getSpellingLocation$MH() {
        return RuntimeHelper.requireNonNull(constants$2.clang_getSpellingLocation$MH,"clang_getSpellingLocation");
    }
    public static void clang_getSpellingLocation ( MemorySegment location,  Addressable file,  Addressable line,  Addressable column,  Addressable offset) {
        var mh$ = RuntimeHelper.requireNonNull(constants$2.clang_getSpellingLocation$MH, "clang_getSpellingLocation");
        try {
            mh$.invokeExact(location, file.address(), line.address(), column.address(), offset.address());
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_getFileLocation$MH() {
        return RuntimeHelper.requireNonNull(constants$2.clang_getFileLocation$MH,"clang_getFileLocation");
    }
    public static void clang_getFileLocation ( MemorySegment location,  Addressable file,  Addressable line,  Addressable column,  Addressable offset) {
        var mh$ = RuntimeHelper.requireNonNull(constants$2.clang_getFileLocation$MH, "clang_getFileLocation");
        try {
            mh$.invokeExact(location, file.address(), line.address(), column.address(), offset.address());
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_getRangeStart$MH() {
        return RuntimeHelper.requireNonNull(constants$2.clang_getRangeStart$MH,"clang_getRangeStart");
    }
    public static MemorySegment clang_getRangeStart ( SegmentAllocator allocator,  MemorySegment range) {
        var mh$ = RuntimeHelper.requireNonNull(constants$2.clang_getRangeStart$MH, "clang_getRangeStart");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, range);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getRangeStart ( ResourceScope scope,  MemorySegment range) {
        return clang_getRangeStart(SegmentAllocator.ofScope(scope), range);
    }
    public static MethodHandle clang_getRangeEnd$MH() {
        return RuntimeHelper.requireNonNull(constants$2.clang_getRangeEnd$MH,"clang_getRangeEnd");
    }
    public static MemorySegment clang_getRangeEnd ( SegmentAllocator allocator,  MemorySegment range) {
        var mh$ = RuntimeHelper.requireNonNull(constants$2.clang_getRangeEnd$MH, "clang_getRangeEnd");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, range);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getRangeEnd ( ResourceScope scope,  MemorySegment range) {
        return clang_getRangeEnd(SegmentAllocator.ofScope(scope), range);
    }
    public static int CXDiagnostic_Ignored() {
        return (int)0L;
    }
    public static int CXDiagnostic_Note() {
        return (int)1L;
    }
    public static int CXDiagnostic_Warning() {
        return (int)2L;
    }
    public static int CXDiagnostic_Error() {
        return (int)3L;
    }
    public static int CXDiagnostic_Fatal() {
        return (int)4L;
    }
    public static MethodHandle clang_getChildDiagnostics$MH() {
        return RuntimeHelper.requireNonNull(constants$2.clang_getChildDiagnostics$MH,"clang_getChildDiagnostics");
    }
    public static MemoryAddress clang_getChildDiagnostics ( Addressable D) {
        var mh$ = RuntimeHelper.requireNonNull(constants$2.clang_getChildDiagnostics$MH, "clang_getChildDiagnostics");
        try {
            return (jdk.incubator.foreign.MemoryAddress)mh$.invokeExact(D.address());
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_getNumDiagnostics$MH() {
        return RuntimeHelper.requireNonNull(constants$3.clang_getNumDiagnostics$MH,"clang_getNumDiagnostics");
    }
    public static int clang_getNumDiagnostics ( Addressable Unit) {
        var mh$ = RuntimeHelper.requireNonNull(constants$3.clang_getNumDiagnostics$MH, "clang_getNumDiagnostics");
        try {
            return (int)mh$.invokeExact(Unit.address());
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_getDiagnostic$MH() {
        return RuntimeHelper.requireNonNull(constants$3.clang_getDiagnostic$MH,"clang_getDiagnostic");
    }
    public static MemoryAddress clang_getDiagnostic ( Addressable Unit,  int Index) {
        var mh$ = RuntimeHelper.requireNonNull(constants$3.clang_getDiagnostic$MH, "clang_getDiagnostic");
        try {
            return (jdk.incubator.foreign.MemoryAddress)mh$.invokeExact(Unit.address(), Index);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_disposeDiagnostic$MH() {
        return RuntimeHelper.requireNonNull(constants$3.clang_disposeDiagnostic$MH,"clang_disposeDiagnostic");
    }
    public static void clang_disposeDiagnostic ( Addressable Diagnostic) {
        var mh$ = RuntimeHelper.requireNonNull(constants$3.clang_disposeDiagnostic$MH, "clang_disposeDiagnostic");
        try {
            mh$.invokeExact(Diagnostic.address());
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static int CXDiagnostic_DisplaySourceLocation() {
        return (int)1L;
    }
    public static int CXDiagnostic_DisplayColumn() {
        return (int)2L;
    }
    public static int CXDiagnostic_DisplaySourceRanges() {
        return (int)4L;
    }
    public static int CXDiagnostic_DisplayOption() {
        return (int)8L;
    }
    public static int CXDiagnostic_DisplayCategoryId() {
        return (int)16L;
    }
    public static int CXDiagnostic_DisplayCategoryName() {
        return (int)32L;
    }
    public static MethodHandle clang_formatDiagnostic$MH() {
        return RuntimeHelper.requireNonNull(constants$3.clang_formatDiagnostic$MH,"clang_formatDiagnostic");
    }
    public static MemorySegment clang_formatDiagnostic ( SegmentAllocator allocator,  Addressable Diagnostic,  int Options) {
        var mh$ = RuntimeHelper.requireNonNull(constants$3.clang_formatDiagnostic$MH, "clang_formatDiagnostic");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, Diagnostic.address(), Options);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_formatDiagnostic ( ResourceScope scope,  Addressable Diagnostic,  int Options) {
        return clang_formatDiagnostic(SegmentAllocator.ofScope(scope), Diagnostic.address(), Options);
    }
    public static MethodHandle clang_defaultDiagnosticDisplayOptions$MH() {
        return RuntimeHelper.requireNonNull(constants$3.clang_defaultDiagnosticDisplayOptions$MH,"clang_defaultDiagnosticDisplayOptions");
    }
    public static int clang_defaultDiagnosticDisplayOptions () {
        var mh$ = RuntimeHelper.requireNonNull(constants$3.clang_defaultDiagnosticDisplayOptions$MH, "clang_defaultDiagnosticDisplayOptions");
        try {
            return (int)mh$.invokeExact();
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_getDiagnosticSeverity$MH() {
        return RuntimeHelper.requireNonNull(constants$3.clang_getDiagnosticSeverity$MH,"clang_getDiagnosticSeverity");
    }
    public static int clang_getDiagnosticSeverity ( Addressable x0) {
        var mh$ = RuntimeHelper.requireNonNull(constants$3.clang_getDiagnosticSeverity$MH, "clang_getDiagnosticSeverity");
        try {
            return (int)mh$.invokeExact(x0.address());
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_getDiagnosticLocation$MH() {
        return RuntimeHelper.requireNonNull(constants$4.clang_getDiagnosticLocation$MH,"clang_getDiagnosticLocation");
    }
    public static MemorySegment clang_getDiagnosticLocation ( SegmentAllocator allocator,  Addressable x1) {
        var mh$ = RuntimeHelper.requireNonNull(constants$4.clang_getDiagnosticLocation$MH, "clang_getDiagnosticLocation");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, x1.address());
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getDiagnosticLocation ( ResourceScope scope,  Addressable x1) {
        return clang_getDiagnosticLocation(SegmentAllocator.ofScope(scope), x1.address());
    }
    public static MethodHandle clang_getDiagnosticSpelling$MH() {
        return RuntimeHelper.requireNonNull(constants$4.clang_getDiagnosticSpelling$MH,"clang_getDiagnosticSpelling");
    }
    public static MemorySegment clang_getDiagnosticSpelling ( SegmentAllocator allocator,  Addressable x1) {
        var mh$ = RuntimeHelper.requireNonNull(constants$4.clang_getDiagnosticSpelling$MH, "clang_getDiagnosticSpelling");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, x1.address());
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getDiagnosticSpelling ( ResourceScope scope,  Addressable x1) {
        return clang_getDiagnosticSpelling(SegmentAllocator.ofScope(scope), x1.address());
    }
    public static int CXTranslationUnit_None() {
        return (int)0L;
    }
    public static int CXTranslationUnit_DetailedPreprocessingRecord() {
        return (int)1L;
    }
    public static int CXTranslationUnit_Incomplete() {
        return (int)2L;
    }
    public static int CXTranslationUnit_PrecompiledPreamble() {
        return (int)4L;
    }
    public static int CXTranslationUnit_CacheCompletionResults() {
        return (int)8L;
    }
    public static int CXTranslationUnit_ForSerialization() {
        return (int)16L;
    }
    public static int CXTranslationUnit_CXXChainedPCH() {
        return (int)32L;
    }
    public static int CXTranslationUnit_SkipFunctionBodies() {
        return (int)64L;
    }
    public static int CXTranslationUnit_IncludeBriefCommentsInCodeCompletion() {
        return (int)128L;
    }
    public static int CXTranslationUnit_CreatePreambleOnFirstParse() {
        return (int)256L;
    }
    public static int CXTranslationUnit_KeepGoing() {
        return (int)512L;
    }
    public static int CXTranslationUnit_SingleFileParse() {
        return (int)1024L;
    }
    public static int CXTranslationUnit_LimitSkipFunctionBodiesToPreamble() {
        return (int)2048L;
    }
    public static int CXTranslationUnit_IncludeAttributedTypes() {
        return (int)4096L;
    }
    public static int CXTranslationUnit_VisitImplicitAttributes() {
        return (int)8192L;
    }
    public static int CXTranslationUnit_IgnoreNonErrorsFromIncludedFiles() {
        return (int)16384L;
    }
    public static int CXTranslationUnit_RetainExcludedConditionalBlocks() {
        return (int)32768L;
    }
    public static MethodHandle clang_parseTranslationUnit$MH() {
        return RuntimeHelper.requireNonNull(constants$4.clang_parseTranslationUnit$MH,"clang_parseTranslationUnit");
    }
    public static MemoryAddress clang_parseTranslationUnit ( Addressable CIdx,  Addressable source_filename,  Addressable command_line_args,  int num_command_line_args,  Addressable unsaved_files,  int num_unsaved_files,  int options) {
        var mh$ = RuntimeHelper.requireNonNull(constants$4.clang_parseTranslationUnit$MH, "clang_parseTranslationUnit");
        try {
            return (jdk.incubator.foreign.MemoryAddress)mh$.invokeExact(CIdx.address(), source_filename.address(), command_line_args.address(), num_command_line_args, unsaved_files.address(), num_unsaved_files, options);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_parseTranslationUnit2$MH() {
        return RuntimeHelper.requireNonNull(constants$4.clang_parseTranslationUnit2$MH,"clang_parseTranslationUnit2");
    }
    public static int clang_parseTranslationUnit2 ( Addressable CIdx,  Addressable source_filename,  Addressable command_line_args,  int num_command_line_args,  Addressable unsaved_files,  int num_unsaved_files,  int options,  Addressable out_TU) {
        var mh$ = RuntimeHelper.requireNonNull(constants$4.clang_parseTranslationUnit2$MH, "clang_parseTranslationUnit2");
        try {
            return (int)mh$.invokeExact(CIdx.address(), source_filename.address(), command_line_args.address(), num_command_line_args, unsaved_files.address(), num_unsaved_files, options, out_TU.address());
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static int CXSaveTranslationUnit_None() {
        return (int)0L;
    }
    public static int CXSaveError_None() {
        return (int)0L;
    }
    public static int CXSaveError_Unknown() {
        return (int)1L;
    }
    public static int CXSaveError_TranslationErrors() {
        return (int)2L;
    }
    public static int CXSaveError_InvalidTU() {
        return (int)3L;
    }
    public static MethodHandle clang_saveTranslationUnit$MH() {
        return RuntimeHelper.requireNonNull(constants$4.clang_saveTranslationUnit$MH,"clang_saveTranslationUnit");
    }
    public static int clang_saveTranslationUnit ( Addressable TU,  Addressable FileName,  int options) {
        var mh$ = RuntimeHelper.requireNonNull(constants$4.clang_saveTranslationUnit$MH, "clang_saveTranslationUnit");
        try {
            return (int)mh$.invokeExact(TU.address(), FileName.address(), options);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_disposeTranslationUnit$MH() {
        return RuntimeHelper.requireNonNull(constants$4.clang_disposeTranslationUnit$MH,"clang_disposeTranslationUnit");
    }
    public static void clang_disposeTranslationUnit ( Addressable x0) {
        var mh$ = RuntimeHelper.requireNonNull(constants$4.clang_disposeTranslationUnit$MH, "clang_disposeTranslationUnit");
        try {
            mh$.invokeExact(x0.address());
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static int CXReparse_None() {
        return (int)0L;
    }
    public static MethodHandle clang_defaultReparseOptions$MH() {
        return RuntimeHelper.requireNonNull(constants$5.clang_defaultReparseOptions$MH,"clang_defaultReparseOptions");
    }
    public static int clang_defaultReparseOptions ( Addressable TU) {
        var mh$ = RuntimeHelper.requireNonNull(constants$5.clang_defaultReparseOptions$MH, "clang_defaultReparseOptions");
        try {
            return (int)mh$.invokeExact(TU.address());
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_reparseTranslationUnit$MH() {
        return RuntimeHelper.requireNonNull(constants$5.clang_reparseTranslationUnit$MH,"clang_reparseTranslationUnit");
    }
    public static int clang_reparseTranslationUnit ( Addressable TU,  int num_unsaved_files,  Addressable unsaved_files,  int options) {
        var mh$ = RuntimeHelper.requireNonNull(constants$5.clang_reparseTranslationUnit$MH, "clang_reparseTranslationUnit");
        try {
            return (int)mh$.invokeExact(TU.address(), num_unsaved_files, unsaved_files.address(), options);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static int CXCursor_UnexposedDecl() {
        return (int)1L;
    }
    public static int CXCursor_StructDecl() {
        return (int)2L;
    }
    public static int CXCursor_UnionDecl() {
        return (int)3L;
    }
    public static int CXCursor_ClassDecl() {
        return (int)4L;
    }
    public static int CXCursor_EnumDecl() {
        return (int)5L;
    }
    public static int CXCursor_FieldDecl() {
        return (int)6L;
    }
    public static int CXCursor_EnumConstantDecl() {
        return (int)7L;
    }
    public static int CXCursor_FunctionDecl() {
        return (int)8L;
    }
    public static int CXCursor_VarDecl() {
        return (int)9L;
    }
    public static int CXCursor_ParmDecl() {
        return (int)10L;
    }
    public static int CXCursor_ObjCInterfaceDecl() {
        return (int)11L;
    }
    public static int CXCursor_ObjCCategoryDecl() {
        return (int)12L;
    }
    public static int CXCursor_ObjCProtocolDecl() {
        return (int)13L;
    }
    public static int CXCursor_ObjCPropertyDecl() {
        return (int)14L;
    }
    public static int CXCursor_ObjCIvarDecl() {
        return (int)15L;
    }
    public static int CXCursor_ObjCInstanceMethodDecl() {
        return (int)16L;
    }
    public static int CXCursor_ObjCClassMethodDecl() {
        return (int)17L;
    }
    public static int CXCursor_ObjCImplementationDecl() {
        return (int)18L;
    }
    public static int CXCursor_ObjCCategoryImplDecl() {
        return (int)19L;
    }
    public static int CXCursor_TypedefDecl() {
        return (int)20L;
    }
    public static int CXCursor_CXXMethod() {
        return (int)21L;
    }
    public static int CXCursor_Namespace() {
        return (int)22L;
    }
    public static int CXCursor_LinkageSpec() {
        return (int)23L;
    }
    public static int CXCursor_Constructor() {
        return (int)24L;
    }
    public static int CXCursor_Destructor() {
        return (int)25L;
    }
    public static int CXCursor_ConversionFunction() {
        return (int)26L;
    }
    public static int CXCursor_TemplateTypeParameter() {
        return (int)27L;
    }
    public static int CXCursor_NonTypeTemplateParameter() {
        return (int)28L;
    }
    public static int CXCursor_TemplateTemplateParameter() {
        return (int)29L;
    }
    public static int CXCursor_FunctionTemplate() {
        return (int)30L;
    }
    public static int CXCursor_ClassTemplate() {
        return (int)31L;
    }
    public static int CXCursor_ClassTemplatePartialSpecialization() {
        return (int)32L;
    }
    public static int CXCursor_NamespaceAlias() {
        return (int)33L;
    }
    public static int CXCursor_UsingDirective() {
        return (int)34L;
    }
    public static int CXCursor_UsingDeclaration() {
        return (int)35L;
    }
    public static int CXCursor_TypeAliasDecl() {
        return (int)36L;
    }
    public static int CXCursor_ObjCSynthesizeDecl() {
        return (int)37L;
    }
    public static int CXCursor_ObjCDynamicDecl() {
        return (int)38L;
    }
    public static int CXCursor_CXXAccessSpecifier() {
        return (int)39L;
    }
    public static int CXCursor_FirstDecl() {
        return (int)1L;
    }
    public static int CXCursor_LastDecl() {
        return (int)39L;
    }
    public static int CXCursor_FirstRef() {
        return (int)40L;
    }
    public static int CXCursor_ObjCSuperClassRef() {
        return (int)40L;
    }
    public static int CXCursor_ObjCProtocolRef() {
        return (int)41L;
    }
    public static int CXCursor_ObjCClassRef() {
        return (int)42L;
    }
    public static int CXCursor_TypeRef() {
        return (int)43L;
    }
    public static int CXCursor_CXXBaseSpecifier() {
        return (int)44L;
    }
    public static int CXCursor_TemplateRef() {
        return (int)45L;
    }
    public static int CXCursor_NamespaceRef() {
        return (int)46L;
    }
    public static int CXCursor_MemberRef() {
        return (int)47L;
    }
    public static int CXCursor_LabelRef() {
        return (int)48L;
    }
    public static int CXCursor_OverloadedDeclRef() {
        return (int)49L;
    }
    public static int CXCursor_VariableRef() {
        return (int)50L;
    }
    public static int CXCursor_LastRef() {
        return (int)50L;
    }
    public static int CXCursor_FirstInvalid() {
        return (int)70L;
    }
    public static int CXCursor_InvalidFile() {
        return (int)70L;
    }
    public static int CXCursor_NoDeclFound() {
        return (int)71L;
    }
    public static int CXCursor_NotImplemented() {
        return (int)72L;
    }
    public static int CXCursor_InvalidCode() {
        return (int)73L;
    }
    public static int CXCursor_LastInvalid() {
        return (int)73L;
    }
    public static int CXCursor_FirstExpr() {
        return (int)100L;
    }
    public static int CXCursor_UnexposedExpr() {
        return (int)100L;
    }
    public static int CXCursor_DeclRefExpr() {
        return (int)101L;
    }
    public static int CXCursor_MemberRefExpr() {
        return (int)102L;
    }
    public static int CXCursor_CallExpr() {
        return (int)103L;
    }
    public static int CXCursor_ObjCMessageExpr() {
        return (int)104L;
    }
    public static int CXCursor_BlockExpr() {
        return (int)105L;
    }
    public static int CXCursor_IntegerLiteral() {
        return (int)106L;
    }
    public static int CXCursor_FloatingLiteral() {
        return (int)107L;
    }
    public static int CXCursor_ImaginaryLiteral() {
        return (int)108L;
    }
    public static int CXCursor_StringLiteral() {
        return (int)109L;
    }
    public static int CXCursor_CharacterLiteral() {
        return (int)110L;
    }
    public static int CXCursor_ParenExpr() {
        return (int)111L;
    }
    public static int CXCursor_UnaryOperator() {
        return (int)112L;
    }
    public static int CXCursor_ArraySubscriptExpr() {
        return (int)113L;
    }
    public static int CXCursor_BinaryOperator() {
        return (int)114L;
    }
    public static int CXCursor_CompoundAssignOperator() {
        return (int)115L;
    }
    public static int CXCursor_ConditionalOperator() {
        return (int)116L;
    }
    public static int CXCursor_CStyleCastExpr() {
        return (int)117L;
    }
    public static int CXCursor_CompoundLiteralExpr() {
        return (int)118L;
    }
    public static int CXCursor_InitListExpr() {
        return (int)119L;
    }
    public static int CXCursor_AddrLabelExpr() {
        return (int)120L;
    }
    public static int CXCursor_StmtExpr() {
        return (int)121L;
    }
    public static int CXCursor_GenericSelectionExpr() {
        return (int)122L;
    }
    public static int CXCursor_GNUNullExpr() {
        return (int)123L;
    }
    public static int CXCursor_CXXStaticCastExpr() {
        return (int)124L;
    }
    public static int CXCursor_CXXDynamicCastExpr() {
        return (int)125L;
    }
    public static int CXCursor_CXXReinterpretCastExpr() {
        return (int)126L;
    }
    public static int CXCursor_CXXConstCastExpr() {
        return (int)127L;
    }
    public static int CXCursor_CXXFunctionalCastExpr() {
        return (int)128L;
    }
    public static int CXCursor_CXXTypeidExpr() {
        return (int)129L;
    }
    public static int CXCursor_CXXBoolLiteralExpr() {
        return (int)130L;
    }
    public static int CXCursor_CXXNullPtrLiteralExpr() {
        return (int)131L;
    }
    public static int CXCursor_CXXThisExpr() {
        return (int)132L;
    }
    public static int CXCursor_CXXThrowExpr() {
        return (int)133L;
    }
    public static int CXCursor_CXXNewExpr() {
        return (int)134L;
    }
    public static int CXCursor_CXXDeleteExpr() {
        return (int)135L;
    }
    public static int CXCursor_UnaryExpr() {
        return (int)136L;
    }
    public static int CXCursor_ObjCStringLiteral() {
        return (int)137L;
    }
    public static int CXCursor_ObjCEncodeExpr() {
        return (int)138L;
    }
    public static int CXCursor_ObjCSelectorExpr() {
        return (int)139L;
    }
    public static int CXCursor_ObjCProtocolExpr() {
        return (int)140L;
    }
    public static int CXCursor_ObjCBridgedCastExpr() {
        return (int)141L;
    }
    public static int CXCursor_PackExpansionExpr() {
        return (int)142L;
    }
    public static int CXCursor_SizeOfPackExpr() {
        return (int)143L;
    }
    public static int CXCursor_LambdaExpr() {
        return (int)144L;
    }
    public static int CXCursor_ObjCBoolLiteralExpr() {
        return (int)145L;
    }
    public static int CXCursor_ObjCSelfExpr() {
        return (int)146L;
    }
    public static int CXCursor_OMPArraySectionExpr() {
        return (int)147L;
    }
    public static int CXCursor_ObjCAvailabilityCheckExpr() {
        return (int)148L;
    }
    public static int CXCursor_FixedPointLiteral() {
        return (int)149L;
    }
    public static int CXCursor_LastExpr() {
        return (int)149L;
    }
    public static int CXCursor_FirstStmt() {
        return (int)200L;
    }
    public static int CXCursor_UnexposedStmt() {
        return (int)200L;
    }
    public static int CXCursor_LabelStmt() {
        return (int)201L;
    }
    public static int CXCursor_CompoundStmt() {
        return (int)202L;
    }
    public static int CXCursor_CaseStmt() {
        return (int)203L;
    }
    public static int CXCursor_DefaultStmt() {
        return (int)204L;
    }
    public static int CXCursor_IfStmt() {
        return (int)205L;
    }
    public static int CXCursor_SwitchStmt() {
        return (int)206L;
    }
    public static int CXCursor_WhileStmt() {
        return (int)207L;
    }
    public static int CXCursor_DoStmt() {
        return (int)208L;
    }
    public static int CXCursor_ForStmt() {
        return (int)209L;
    }
    public static int CXCursor_GotoStmt() {
        return (int)210L;
    }
    public static int CXCursor_IndirectGotoStmt() {
        return (int)211L;
    }
    public static int CXCursor_ContinueStmt() {
        return (int)212L;
    }
    public static int CXCursor_BreakStmt() {
        return (int)213L;
    }
    public static int CXCursor_ReturnStmt() {
        return (int)214L;
    }
    public static int CXCursor_GCCAsmStmt() {
        return (int)215L;
    }
    public static int CXCursor_AsmStmt() {
        return (int)215L;
    }
    public static int CXCursor_ObjCAtTryStmt() {
        return (int)216L;
    }
    public static int CXCursor_ObjCAtCatchStmt() {
        return (int)217L;
    }
    public static int CXCursor_ObjCAtFinallyStmt() {
        return (int)218L;
    }
    public static int CXCursor_ObjCAtThrowStmt() {
        return (int)219L;
    }
    public static int CXCursor_ObjCAtSynchronizedStmt() {
        return (int)220L;
    }
    public static int CXCursor_ObjCAutoreleasePoolStmt() {
        return (int)221L;
    }
    public static int CXCursor_ObjCForCollectionStmt() {
        return (int)222L;
    }
    public static int CXCursor_CXXCatchStmt() {
        return (int)223L;
    }
    public static int CXCursor_CXXTryStmt() {
        return (int)224L;
    }
    public static int CXCursor_CXXForRangeStmt() {
        return (int)225L;
    }
    public static int CXCursor_SEHTryStmt() {
        return (int)226L;
    }
    public static int CXCursor_SEHExceptStmt() {
        return (int)227L;
    }
    public static int CXCursor_SEHFinallyStmt() {
        return (int)228L;
    }
    public static int CXCursor_MSAsmStmt() {
        return (int)229L;
    }
    public static int CXCursor_NullStmt() {
        return (int)230L;
    }
    public static int CXCursor_DeclStmt() {
        return (int)231L;
    }
    public static int CXCursor_OMPParallelDirective() {
        return (int)232L;
    }
    public static int CXCursor_OMPSimdDirective() {
        return (int)233L;
    }
    public static int CXCursor_OMPForDirective() {
        return (int)234L;
    }
    public static int CXCursor_OMPSectionsDirective() {
        return (int)235L;
    }
    public static int CXCursor_OMPSectionDirective() {
        return (int)236L;
    }
    public static int CXCursor_OMPSingleDirective() {
        return (int)237L;
    }
    public static int CXCursor_OMPParallelForDirective() {
        return (int)238L;
    }
    public static int CXCursor_OMPParallelSectionsDirective() {
        return (int)239L;
    }
    public static int CXCursor_OMPTaskDirective() {
        return (int)240L;
    }
    public static int CXCursor_OMPMasterDirective() {
        return (int)241L;
    }
    public static int CXCursor_OMPCriticalDirective() {
        return (int)242L;
    }
    public static int CXCursor_OMPTaskyieldDirective() {
        return (int)243L;
    }
    public static int CXCursor_OMPBarrierDirective() {
        return (int)244L;
    }
    public static int CXCursor_OMPTaskwaitDirective() {
        return (int)245L;
    }
    public static int CXCursor_OMPFlushDirective() {
        return (int)246L;
    }
    public static int CXCursor_SEHLeaveStmt() {
        return (int)247L;
    }
    public static int CXCursor_OMPOrderedDirective() {
        return (int)248L;
    }
    public static int CXCursor_OMPAtomicDirective() {
        return (int)249L;
    }
    public static int CXCursor_OMPForSimdDirective() {
        return (int)250L;
    }
    public static int CXCursor_OMPParallelForSimdDirective() {
        return (int)251L;
    }
    public static int CXCursor_OMPTargetDirective() {
        return (int)252L;
    }
    public static int CXCursor_OMPTeamsDirective() {
        return (int)253L;
    }
    public static int CXCursor_OMPTaskgroupDirective() {
        return (int)254L;
    }
    public static int CXCursor_OMPCancellationPointDirective() {
        return (int)255L;
    }
    public static int CXCursor_OMPCancelDirective() {
        return (int)256L;
    }
    public static int CXCursor_OMPTargetDataDirective() {
        return (int)257L;
    }
    public static int CXCursor_OMPTaskLoopDirective() {
        return (int)258L;
    }
    public static int CXCursor_OMPTaskLoopSimdDirective() {
        return (int)259L;
    }
    public static int CXCursor_OMPDistributeDirective() {
        return (int)260L;
    }
    public static int CXCursor_OMPTargetEnterDataDirective() {
        return (int)261L;
    }
    public static int CXCursor_OMPTargetExitDataDirective() {
        return (int)262L;
    }
    public static int CXCursor_OMPTargetParallelDirective() {
        return (int)263L;
    }
    public static int CXCursor_OMPTargetParallelForDirective() {
        return (int)264L;
    }
    public static int CXCursor_OMPTargetUpdateDirective() {
        return (int)265L;
    }
    public static int CXCursor_OMPDistributeParallelForDirective() {
        return (int)266L;
    }
    public static int CXCursor_OMPDistributeParallelForSimdDirective() {
        return (int)267L;
    }
    public static int CXCursor_OMPDistributeSimdDirective() {
        return (int)268L;
    }
    public static int CXCursor_OMPTargetParallelForSimdDirective() {
        return (int)269L;
    }
    public static int CXCursor_OMPTargetSimdDirective() {
        return (int)270L;
    }
    public static int CXCursor_OMPTeamsDistributeDirective() {
        return (int)271L;
    }
    public static int CXCursor_OMPTeamsDistributeSimdDirective() {
        return (int)272L;
    }
    public static int CXCursor_OMPTeamsDistributeParallelForSimdDirective() {
        return (int)273L;
    }
    public static int CXCursor_OMPTeamsDistributeParallelForDirective() {
        return (int)274L;
    }
    public static int CXCursor_OMPTargetTeamsDirective() {
        return (int)275L;
    }
    public static int CXCursor_OMPTargetTeamsDistributeDirective() {
        return (int)276L;
    }
    public static int CXCursor_OMPTargetTeamsDistributeParallelForDirective() {
        return (int)277L;
    }
    public static int CXCursor_OMPTargetTeamsDistributeParallelForSimdDirective() {
        return (int)278L;
    }
    public static int CXCursor_OMPTargetTeamsDistributeSimdDirective() {
        return (int)279L;
    }
    public static int CXCursor_BuiltinBitCastExpr() {
        return (int)280L;
    }
    public static int CXCursor_OMPMasterTaskLoopDirective() {
        return (int)281L;
    }
    public static int CXCursor_OMPParallelMasterTaskLoopDirective() {
        return (int)282L;
    }
    public static int CXCursor_OMPMasterTaskLoopSimdDirective() {
        return (int)283L;
    }
    public static int CXCursor_OMPParallelMasterTaskLoopSimdDirective() {
        return (int)284L;
    }
    public static int CXCursor_LastStmt() {
        return (int)285L;
    }
    public static int CXCursor_TranslationUnit() {
        return (int)300L;
    }
    public static int CXCursor_FirstAttr() {
        return (int)400L;
    }
    public static int CXCursor_UnexposedAttr() {
        return (int)400L;
    }
    public static int CXCursor_IBActionAttr() {
        return (int)401L;
    }
    public static int CXCursor_IBOutletAttr() {
        return (int)402L;
    }
    public static int CXCursor_IBOutletCollectionAttr() {
        return (int)403L;
    }
    public static int CXCursor_CXXFinalAttr() {
        return (int)404L;
    }
    public static int CXCursor_CXXOverrideAttr() {
        return (int)405L;
    }
    public static int CXCursor_AnnotateAttr() {
        return (int)406L;
    }
    public static int CXCursor_AsmLabelAttr() {
        return (int)407L;
    }
    public static int CXCursor_PackedAttr() {
        return (int)408L;
    }
    public static int CXCursor_PureAttr() {
        return (int)409L;
    }
    public static int CXCursor_ConstAttr() {
        return (int)410L;
    }
    public static int CXCursor_NoDuplicateAttr() {
        return (int)411L;
    }
    public static int CXCursor_CUDAConstantAttr() {
        return (int)412L;
    }
    public static int CXCursor_CUDADeviceAttr() {
        return (int)413L;
    }
    public static int CXCursor_CUDAGlobalAttr() {
        return (int)414L;
    }
    public static int CXCursor_CUDAHostAttr() {
        return (int)415L;
    }
    public static int CXCursor_CUDASharedAttr() {
        return (int)416L;
    }
    public static int CXCursor_VisibilityAttr() {
        return (int)417L;
    }
    public static int CXCursor_DLLExport() {
        return (int)418L;
    }
    public static int CXCursor_DLLImport() {
        return (int)419L;
    }
    public static int CXCursor_NSReturnsRetained() {
        return (int)420L;
    }
    public static int CXCursor_NSReturnsNotRetained() {
        return (int)421L;
    }
    public static int CXCursor_NSReturnsAutoreleased() {
        return (int)422L;
    }
    public static int CXCursor_NSConsumesSelf() {
        return (int)423L;
    }
    public static int CXCursor_NSConsumed() {
        return (int)424L;
    }
    public static int CXCursor_ObjCException() {
        return (int)425L;
    }
    public static int CXCursor_ObjCNSObject() {
        return (int)426L;
    }
    public static int CXCursor_ObjCIndependentClass() {
        return (int)427L;
    }
    public static int CXCursor_ObjCPreciseLifetime() {
        return (int)428L;
    }
    public static int CXCursor_ObjCReturnsInnerPointer() {
        return (int)429L;
    }
    public static int CXCursor_ObjCRequiresSuper() {
        return (int)430L;
    }
    public static int CXCursor_ObjCRootClass() {
        return (int)431L;
    }
    public static int CXCursor_ObjCSubclassingRestricted() {
        return (int)432L;
    }
    public static int CXCursor_ObjCExplicitProtocolImpl() {
        return (int)433L;
    }
    public static int CXCursor_ObjCDesignatedInitializer() {
        return (int)434L;
    }
    public static int CXCursor_ObjCRuntimeVisible() {
        return (int)435L;
    }
    public static int CXCursor_ObjCBoxable() {
        return (int)436L;
    }
    public static int CXCursor_FlagEnum() {
        return (int)437L;
    }
    public static int CXCursor_ConvergentAttr() {
        return (int)438L;
    }
    public static int CXCursor_WarnUnusedAttr() {
        return (int)439L;
    }
    public static int CXCursor_WarnUnusedResultAttr() {
        return (int)440L;
    }
    public static int CXCursor_AlignedAttr() {
        return (int)441L;
    }
    public static int CXCursor_LastAttr() {
        return (int)441L;
    }
    public static int CXCursor_PreprocessingDirective() {
        return (int)500L;
    }
    public static int CXCursor_MacroDefinition() {
        return (int)501L;
    }
    public static int CXCursor_MacroExpansion() {
        return (int)502L;
    }
    public static int CXCursor_MacroInstantiation() {
        return (int)502L;
    }
    public static int CXCursor_InclusionDirective() {
        return (int)503L;
    }
    public static int CXCursor_FirstPreprocessing() {
        return (int)500L;
    }
    public static int CXCursor_LastPreprocessing() {
        return (int)503L;
    }
    public static int CXCursor_ModuleImportDecl() {
        return (int)600L;
    }
    public static int CXCursor_TypeAliasTemplateDecl() {
        return (int)601L;
    }
    public static int CXCursor_StaticAssert() {
        return (int)602L;
    }
    public static int CXCursor_FriendDecl() {
        return (int)603L;
    }
    public static int CXCursor_FirstExtraDecl() {
        return (int)600L;
    }
    public static int CXCursor_LastExtraDecl() {
        return (int)603L;
    }
    public static int CXCursor_OverloadCandidate() {
        return (int)700L;
    }
    public static MethodHandle clang_getNullCursor$MH() {
        return RuntimeHelper.requireNonNull(constants$5.clang_getNullCursor$MH,"clang_getNullCursor");
    }
    public static MemorySegment clang_getNullCursor ( SegmentAllocator allocator) {
        var mh$ = RuntimeHelper.requireNonNull(constants$5.clang_getNullCursor$MH, "clang_getNullCursor");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getNullCursor ( ResourceScope scope) {
        return clang_getNullCursor(SegmentAllocator.ofScope(scope));
    }
    public static MethodHandle clang_getTranslationUnitCursor$MH() {
        return RuntimeHelper.requireNonNull(constants$5.clang_getTranslationUnitCursor$MH,"clang_getTranslationUnitCursor");
    }
    public static MemorySegment clang_getTranslationUnitCursor ( SegmentAllocator allocator,  Addressable x1) {
        var mh$ = RuntimeHelper.requireNonNull(constants$5.clang_getTranslationUnitCursor$MH, "clang_getTranslationUnitCursor");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, x1.address());
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getTranslationUnitCursor ( ResourceScope scope,  Addressable x1) {
        return clang_getTranslationUnitCursor(SegmentAllocator.ofScope(scope), x1.address());
    }
    public static MethodHandle clang_equalCursors$MH() {
        return RuntimeHelper.requireNonNull(constants$5.clang_equalCursors$MH,"clang_equalCursors");
    }
    public static int clang_equalCursors ( MemorySegment x0,  MemorySegment x1) {
        var mh$ = RuntimeHelper.requireNonNull(constants$5.clang_equalCursors$MH, "clang_equalCursors");
        try {
            return (int)mh$.invokeExact(x0, x1);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_Cursor_isNull$MH() {
        return RuntimeHelper.requireNonNull(constants$5.clang_Cursor_isNull$MH,"clang_Cursor_isNull");
    }
    public static int clang_Cursor_isNull ( MemorySegment cursor) {
        var mh$ = RuntimeHelper.requireNonNull(constants$5.clang_Cursor_isNull$MH, "clang_Cursor_isNull");
        try {
            return (int)mh$.invokeExact(cursor);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_getCursorKind$MH() {
        return RuntimeHelper.requireNonNull(constants$6.clang_getCursorKind$MH,"clang_getCursorKind");
    }
    public static int clang_getCursorKind ( MemorySegment x0) {
        var mh$ = RuntimeHelper.requireNonNull(constants$6.clang_getCursorKind$MH, "clang_getCursorKind");
        try {
            return (int)mh$.invokeExact(x0);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_isDeclaration$MH() {
        return RuntimeHelper.requireNonNull(constants$6.clang_isDeclaration$MH,"clang_isDeclaration");
    }
    public static int clang_isDeclaration ( int x0) {
        var mh$ = RuntimeHelper.requireNonNull(constants$6.clang_isDeclaration$MH, "clang_isDeclaration");
        try {
            return (int)mh$.invokeExact(x0);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_isAttribute$MH() {
        return RuntimeHelper.requireNonNull(constants$6.clang_isAttribute$MH,"clang_isAttribute");
    }
    public static int clang_isAttribute ( int x0) {
        var mh$ = RuntimeHelper.requireNonNull(constants$6.clang_isAttribute$MH, "clang_isAttribute");
        try {
            return (int)mh$.invokeExact(x0);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_isInvalid$MH() {
        return RuntimeHelper.requireNonNull(constants$6.clang_isInvalid$MH,"clang_isInvalid");
    }
    public static int clang_isInvalid ( int x0) {
        var mh$ = RuntimeHelper.requireNonNull(constants$6.clang_isInvalid$MH, "clang_isInvalid");
        try {
            return (int)mh$.invokeExact(x0);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_isPreprocessing$MH() {
        return RuntimeHelper.requireNonNull(constants$6.clang_isPreprocessing$MH,"clang_isPreprocessing");
    }
    public static int clang_isPreprocessing ( int x0) {
        var mh$ = RuntimeHelper.requireNonNull(constants$6.clang_isPreprocessing$MH, "clang_isPreprocessing");
        try {
            return (int)mh$.invokeExact(x0);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_Cursor_getTranslationUnit$MH() {
        return RuntimeHelper.requireNonNull(constants$6.clang_Cursor_getTranslationUnit$MH,"clang_Cursor_getTranslationUnit");
    }
    public static MemoryAddress clang_Cursor_getTranslationUnit ( MemorySegment x0) {
        var mh$ = RuntimeHelper.requireNonNull(constants$6.clang_Cursor_getTranslationUnit$MH, "clang_Cursor_getTranslationUnit");
        try {
            return (jdk.incubator.foreign.MemoryAddress)mh$.invokeExact(x0);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_getCursorLocation$MH() {
        return RuntimeHelper.requireNonNull(constants$7.clang_getCursorLocation$MH,"clang_getCursorLocation");
    }
    public static MemorySegment clang_getCursorLocation ( SegmentAllocator allocator,  MemorySegment x1) {
        var mh$ = RuntimeHelper.requireNonNull(constants$7.clang_getCursorLocation$MH, "clang_getCursorLocation");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, x1);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getCursorLocation ( ResourceScope scope,  MemorySegment x1) {
        return clang_getCursorLocation(SegmentAllocator.ofScope(scope), x1);
    }
    public static MethodHandle clang_getCursorExtent$MH() {
        return RuntimeHelper.requireNonNull(constants$7.clang_getCursorExtent$MH,"clang_getCursorExtent");
    }
    public static MemorySegment clang_getCursorExtent ( SegmentAllocator allocator,  MemorySegment x1) {
        var mh$ = RuntimeHelper.requireNonNull(constants$7.clang_getCursorExtent$MH, "clang_getCursorExtent");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, x1);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getCursorExtent ( ResourceScope scope,  MemorySegment x1) {
        return clang_getCursorExtent(SegmentAllocator.ofScope(scope), x1);
    }
    public static int CXType_Invalid() {
        return (int)0L;
    }
    public static int CXType_Unexposed() {
        return (int)1L;
    }
    public static int CXType_Void() {
        return (int)2L;
    }
    public static int CXType_Bool() {
        return (int)3L;
    }
    public static int CXType_Char_U() {
        return (int)4L;
    }
    public static int CXType_UChar() {
        return (int)5L;
    }
    public static int CXType_Char16() {
        return (int)6L;
    }
    public static int CXType_Char32() {
        return (int)7L;
    }
    public static int CXType_UShort() {
        return (int)8L;
    }
    public static int CXType_UInt() {
        return (int)9L;
    }
    public static int CXType_ULong() {
        return (int)10L;
    }
    public static int CXType_ULongLong() {
        return (int)11L;
    }
    public static int CXType_UInt128() {
        return (int)12L;
    }
    public static int CXType_Char_S() {
        return (int)13L;
    }
    public static int CXType_SChar() {
        return (int)14L;
    }
    public static int CXType_WChar() {
        return (int)15L;
    }
    public static int CXType_Short() {
        return (int)16L;
    }
    public static int CXType_Int() {
        return (int)17L;
    }
    public static int CXType_Long() {
        return (int)18L;
    }
    public static int CXType_LongLong() {
        return (int)19L;
    }
    public static int CXType_Int128() {
        return (int)20L;
    }
    public static int CXType_Float() {
        return (int)21L;
    }
    public static int CXType_Double() {
        return (int)22L;
    }
    public static int CXType_LongDouble() {
        return (int)23L;
    }
    public static int CXType_NullPtr() {
        return (int)24L;
    }
    public static int CXType_Overload() {
        return (int)25L;
    }
    public static int CXType_Dependent() {
        return (int)26L;
    }
    public static int CXType_ObjCId() {
        return (int)27L;
    }
    public static int CXType_ObjCClass() {
        return (int)28L;
    }
    public static int CXType_ObjCSel() {
        return (int)29L;
    }
    public static int CXType_Float128() {
        return (int)30L;
    }
    public static int CXType_Half() {
        return (int)31L;
    }
    public static int CXType_Float16() {
        return (int)32L;
    }
    public static int CXType_ShortAccum() {
        return (int)33L;
    }
    public static int CXType_Accum() {
        return (int)34L;
    }
    public static int CXType_LongAccum() {
        return (int)35L;
    }
    public static int CXType_UShortAccum() {
        return (int)36L;
    }
    public static int CXType_UAccum() {
        return (int)37L;
    }
    public static int CXType_ULongAccum() {
        return (int)38L;
    }
    public static int CXType_FirstBuiltin() {
        return (int)2L;
    }
    public static int CXType_LastBuiltin() {
        return (int)38L;
    }
    public static int CXType_Complex() {
        return (int)100L;
    }
    public static int CXType_Pointer() {
        return (int)101L;
    }
    public static int CXType_BlockPointer() {
        return (int)102L;
    }
    public static int CXType_LValueReference() {
        return (int)103L;
    }
    public static int CXType_RValueReference() {
        return (int)104L;
    }
    public static int CXType_Record() {
        return (int)105L;
    }
    public static int CXType_Enum() {
        return (int)106L;
    }
    public static int CXType_Typedef() {
        return (int)107L;
    }
    public static int CXType_ObjCInterface() {
        return (int)108L;
    }
    public static int CXType_ObjCObjectPointer() {
        return (int)109L;
    }
    public static int CXType_FunctionNoProto() {
        return (int)110L;
    }
    public static int CXType_FunctionProto() {
        return (int)111L;
    }
    public static int CXType_ConstantArray() {
        return (int)112L;
    }
    public static int CXType_Vector() {
        return (int)113L;
    }
    public static int CXType_IncompleteArray() {
        return (int)114L;
    }
    public static int CXType_VariableArray() {
        return (int)115L;
    }
    public static int CXType_DependentSizedArray() {
        return (int)116L;
    }
    public static int CXType_MemberPointer() {
        return (int)117L;
    }
    public static int CXType_Auto() {
        return (int)118L;
    }
    public static int CXType_Elaborated() {
        return (int)119L;
    }
    public static int CXType_Pipe() {
        return (int)120L;
    }
    public static int CXType_OCLImage1dRO() {
        return (int)121L;
    }
    public static int CXType_OCLImage1dArrayRO() {
        return (int)122L;
    }
    public static int CXType_OCLImage1dBufferRO() {
        return (int)123L;
    }
    public static int CXType_OCLImage2dRO() {
        return (int)124L;
    }
    public static int CXType_OCLImage2dArrayRO() {
        return (int)125L;
    }
    public static int CXType_OCLImage2dDepthRO() {
        return (int)126L;
    }
    public static int CXType_OCLImage2dArrayDepthRO() {
        return (int)127L;
    }
    public static int CXType_OCLImage2dMSAARO() {
        return (int)128L;
    }
    public static int CXType_OCLImage2dArrayMSAARO() {
        return (int)129L;
    }
    public static int CXType_OCLImage2dMSAADepthRO() {
        return (int)130L;
    }
    public static int CXType_OCLImage2dArrayMSAADepthRO() {
        return (int)131L;
    }
    public static int CXType_OCLImage3dRO() {
        return (int)132L;
    }
    public static int CXType_OCLImage1dWO() {
        return (int)133L;
    }
    public static int CXType_OCLImage1dArrayWO() {
        return (int)134L;
    }
    public static int CXType_OCLImage1dBufferWO() {
        return (int)135L;
    }
    public static int CXType_OCLImage2dWO() {
        return (int)136L;
    }
    public static int CXType_OCLImage2dArrayWO() {
        return (int)137L;
    }
    public static int CXType_OCLImage2dDepthWO() {
        return (int)138L;
    }
    public static int CXType_OCLImage2dArrayDepthWO() {
        return (int)139L;
    }
    public static int CXType_OCLImage2dMSAAWO() {
        return (int)140L;
    }
    public static int CXType_OCLImage2dArrayMSAAWO() {
        return (int)141L;
    }
    public static int CXType_OCLImage2dMSAADepthWO() {
        return (int)142L;
    }
    public static int CXType_OCLImage2dArrayMSAADepthWO() {
        return (int)143L;
    }
    public static int CXType_OCLImage3dWO() {
        return (int)144L;
    }
    public static int CXType_OCLImage1dRW() {
        return (int)145L;
    }
    public static int CXType_OCLImage1dArrayRW() {
        return (int)146L;
    }
    public static int CXType_OCLImage1dBufferRW() {
        return (int)147L;
    }
    public static int CXType_OCLImage2dRW() {
        return (int)148L;
    }
    public static int CXType_OCLImage2dArrayRW() {
        return (int)149L;
    }
    public static int CXType_OCLImage2dDepthRW() {
        return (int)150L;
    }
    public static int CXType_OCLImage2dArrayDepthRW() {
        return (int)151L;
    }
    public static int CXType_OCLImage2dMSAARW() {
        return (int)152L;
    }
    public static int CXType_OCLImage2dArrayMSAARW() {
        return (int)153L;
    }
    public static int CXType_OCLImage2dMSAADepthRW() {
        return (int)154L;
    }
    public static int CXType_OCLImage2dArrayMSAADepthRW() {
        return (int)155L;
    }
    public static int CXType_OCLImage3dRW() {
        return (int)156L;
    }
    public static int CXType_OCLSampler() {
        return (int)157L;
    }
    public static int CXType_OCLEvent() {
        return (int)158L;
    }
    public static int CXType_OCLQueue() {
        return (int)159L;
    }
    public static int CXType_OCLReserveID() {
        return (int)160L;
    }
    public static int CXType_ObjCObject() {
        return (int)161L;
    }
    public static int CXType_ObjCTypeParam() {
        return (int)162L;
    }
    public static int CXType_Attributed() {
        return (int)163L;
    }
    public static int CXType_OCLIntelSubgroupAVCMcePayload() {
        return (int)164L;
    }
    public static int CXType_OCLIntelSubgroupAVCImePayload() {
        return (int)165L;
    }
    public static int CXType_OCLIntelSubgroupAVCRefPayload() {
        return (int)166L;
    }
    public static int CXType_OCLIntelSubgroupAVCSicPayload() {
        return (int)167L;
    }
    public static int CXType_OCLIntelSubgroupAVCMceResult() {
        return (int)168L;
    }
    public static int CXType_OCLIntelSubgroupAVCImeResult() {
        return (int)169L;
    }
    public static int CXType_OCLIntelSubgroupAVCRefResult() {
        return (int)170L;
    }
    public static int CXType_OCLIntelSubgroupAVCSicResult() {
        return (int)171L;
    }
    public static int CXType_OCLIntelSubgroupAVCImeResultSingleRefStreamout() {
        return (int)172L;
    }
    public static int CXType_OCLIntelSubgroupAVCImeResultDualRefStreamout() {
        return (int)173L;
    }
    public static int CXType_OCLIntelSubgroupAVCImeSingleRefStreamin() {
        return (int)174L;
    }
    public static int CXType_OCLIntelSubgroupAVCImeDualRefStreamin() {
        return (int)175L;
    }
    public static int CXType_ExtVector() {
        return (int)176L;
    }
    public static MethodHandle clang_getCursorType$MH() {
        return RuntimeHelper.requireNonNull(constants$7.clang_getCursorType$MH,"clang_getCursorType");
    }
    public static MemorySegment clang_getCursorType ( SegmentAllocator allocator,  MemorySegment C) {
        var mh$ = RuntimeHelper.requireNonNull(constants$7.clang_getCursorType$MH, "clang_getCursorType");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, C);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getCursorType ( ResourceScope scope,  MemorySegment C) {
        return clang_getCursorType(SegmentAllocator.ofScope(scope), C);
    }
    public static MethodHandle clang_getTypeSpelling$MH() {
        return RuntimeHelper.requireNonNull(constants$7.clang_getTypeSpelling$MH,"clang_getTypeSpelling");
    }
    public static MemorySegment clang_getTypeSpelling ( SegmentAllocator allocator,  MemorySegment CT) {
        var mh$ = RuntimeHelper.requireNonNull(constants$7.clang_getTypeSpelling$MH, "clang_getTypeSpelling");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, CT);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getTypeSpelling ( ResourceScope scope,  MemorySegment CT) {
        return clang_getTypeSpelling(SegmentAllocator.ofScope(scope), CT);
    }
    public static MethodHandle clang_getTypedefDeclUnderlyingType$MH() {
        return RuntimeHelper.requireNonNull(constants$7.clang_getTypedefDeclUnderlyingType$MH,"clang_getTypedefDeclUnderlyingType");
    }
    public static MemorySegment clang_getTypedefDeclUnderlyingType ( SegmentAllocator allocator,  MemorySegment C) {
        var mh$ = RuntimeHelper.requireNonNull(constants$7.clang_getTypedefDeclUnderlyingType$MH, "clang_getTypedefDeclUnderlyingType");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, C);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getTypedefDeclUnderlyingType ( ResourceScope scope,  MemorySegment C) {
        return clang_getTypedefDeclUnderlyingType(SegmentAllocator.ofScope(scope), C);
    }
    public static MethodHandle clang_getEnumDeclIntegerType$MH() {
        return RuntimeHelper.requireNonNull(constants$7.clang_getEnumDeclIntegerType$MH,"clang_getEnumDeclIntegerType");
    }
    public static MemorySegment clang_getEnumDeclIntegerType ( SegmentAllocator allocator,  MemorySegment C) {
        var mh$ = RuntimeHelper.requireNonNull(constants$7.clang_getEnumDeclIntegerType$MH, "clang_getEnumDeclIntegerType");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, C);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getEnumDeclIntegerType ( ResourceScope scope,  MemorySegment C) {
        return clang_getEnumDeclIntegerType(SegmentAllocator.ofScope(scope), C);
    }
    public static MethodHandle clang_getEnumConstantDeclValue$MH() {
        return RuntimeHelper.requireNonNull(constants$8.clang_getEnumConstantDeclValue$MH,"clang_getEnumConstantDeclValue");
    }
    public static long clang_getEnumConstantDeclValue ( MemorySegment C) {
        var mh$ = RuntimeHelper.requireNonNull(constants$8.clang_getEnumConstantDeclValue$MH, "clang_getEnumConstantDeclValue");
        try {
            return (long)mh$.invokeExact(C);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_getEnumConstantDeclUnsignedValue$MH() {
        return RuntimeHelper.requireNonNull(constants$8.clang_getEnumConstantDeclUnsignedValue$MH,"clang_getEnumConstantDeclUnsignedValue");
    }
    public static long clang_getEnumConstantDeclUnsignedValue ( MemorySegment C) {
        var mh$ = RuntimeHelper.requireNonNull(constants$8.clang_getEnumConstantDeclUnsignedValue$MH, "clang_getEnumConstantDeclUnsignedValue");
        try {
            return (long)mh$.invokeExact(C);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_getFieldDeclBitWidth$MH() {
        return RuntimeHelper.requireNonNull(constants$8.clang_getFieldDeclBitWidth$MH,"clang_getFieldDeclBitWidth");
    }
    public static int clang_getFieldDeclBitWidth ( MemorySegment C) {
        var mh$ = RuntimeHelper.requireNonNull(constants$8.clang_getFieldDeclBitWidth$MH, "clang_getFieldDeclBitWidth");
        try {
            return (int)mh$.invokeExact(C);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_Cursor_getNumArguments$MH() {
        return RuntimeHelper.requireNonNull(constants$8.clang_Cursor_getNumArguments$MH,"clang_Cursor_getNumArguments");
    }
    public static int clang_Cursor_getNumArguments ( MemorySegment C) {
        var mh$ = RuntimeHelper.requireNonNull(constants$8.clang_Cursor_getNumArguments$MH, "clang_Cursor_getNumArguments");
        try {
            return (int)mh$.invokeExact(C);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_Cursor_getArgument$MH() {
        return RuntimeHelper.requireNonNull(constants$8.clang_Cursor_getArgument$MH,"clang_Cursor_getArgument");
    }
    public static MemorySegment clang_Cursor_getArgument ( SegmentAllocator allocator,  MemorySegment C,  int i) {
        var mh$ = RuntimeHelper.requireNonNull(constants$8.clang_Cursor_getArgument$MH, "clang_Cursor_getArgument");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, C, i);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_Cursor_getArgument ( ResourceScope scope,  MemorySegment C,  int i) {
        return clang_Cursor_getArgument(SegmentAllocator.ofScope(scope), C, i);
    }
    public static MethodHandle clang_equalTypes$MH() {
        return RuntimeHelper.requireNonNull(constants$8.clang_equalTypes$MH,"clang_equalTypes");
    }
    public static int clang_equalTypes ( MemorySegment A,  MemorySegment B) {
        var mh$ = RuntimeHelper.requireNonNull(constants$8.clang_equalTypes$MH, "clang_equalTypes");
        try {
            return (int)mh$.invokeExact(A, B);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_getCanonicalType$MH() {
        return RuntimeHelper.requireNonNull(constants$9.clang_getCanonicalType$MH,"clang_getCanonicalType");
    }
    public static MemorySegment clang_getCanonicalType ( SegmentAllocator allocator,  MemorySegment T) {
        var mh$ = RuntimeHelper.requireNonNull(constants$9.clang_getCanonicalType$MH, "clang_getCanonicalType");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, T);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getCanonicalType ( ResourceScope scope,  MemorySegment T) {
        return clang_getCanonicalType(SegmentAllocator.ofScope(scope), T);
    }
    public static MethodHandle clang_isConstQualifiedType$MH() {
        return RuntimeHelper.requireNonNull(constants$9.clang_isConstQualifiedType$MH,"clang_isConstQualifiedType");
    }
    public static int clang_isConstQualifiedType ( MemorySegment T) {
        var mh$ = RuntimeHelper.requireNonNull(constants$9.clang_isConstQualifiedType$MH, "clang_isConstQualifiedType");
        try {
            return (int)mh$.invokeExact(T);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_Cursor_isMacroFunctionLike$MH() {
        return RuntimeHelper.requireNonNull(constants$9.clang_Cursor_isMacroFunctionLike$MH,"clang_Cursor_isMacroFunctionLike");
    }
    public static int clang_Cursor_isMacroFunctionLike ( MemorySegment C) {
        var mh$ = RuntimeHelper.requireNonNull(constants$9.clang_Cursor_isMacroFunctionLike$MH, "clang_Cursor_isMacroFunctionLike");
        try {
            return (int)mh$.invokeExact(C);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_isVolatileQualifiedType$MH() {
        return RuntimeHelper.requireNonNull(constants$9.clang_isVolatileQualifiedType$MH,"clang_isVolatileQualifiedType");
    }
    public static int clang_isVolatileQualifiedType ( MemorySegment T) {
        var mh$ = RuntimeHelper.requireNonNull(constants$9.clang_isVolatileQualifiedType$MH, "clang_isVolatileQualifiedType");
        try {
            return (int)mh$.invokeExact(T);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_getTypedefName$MH() {
        return RuntimeHelper.requireNonNull(constants$9.clang_getTypedefName$MH,"clang_getTypedefName");
    }
    public static MemorySegment clang_getTypedefName ( SegmentAllocator allocator,  MemorySegment CT) {
        var mh$ = RuntimeHelper.requireNonNull(constants$9.clang_getTypedefName$MH, "clang_getTypedefName");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, CT);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getTypedefName ( ResourceScope scope,  MemorySegment CT) {
        return clang_getTypedefName(SegmentAllocator.ofScope(scope), CT);
    }
    public static MethodHandle clang_getPointeeType$MH() {
        return RuntimeHelper.requireNonNull(constants$9.clang_getPointeeType$MH,"clang_getPointeeType");
    }
    public static MemorySegment clang_getPointeeType ( SegmentAllocator allocator,  MemorySegment T) {
        var mh$ = RuntimeHelper.requireNonNull(constants$9.clang_getPointeeType$MH, "clang_getPointeeType");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, T);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getPointeeType ( ResourceScope scope,  MemorySegment T) {
        return clang_getPointeeType(SegmentAllocator.ofScope(scope), T);
    }
    public static MethodHandle clang_getTypeDeclaration$MH() {
        return RuntimeHelper.requireNonNull(constants$10.clang_getTypeDeclaration$MH,"clang_getTypeDeclaration");
    }
    public static MemorySegment clang_getTypeDeclaration ( SegmentAllocator allocator,  MemorySegment T) {
        var mh$ = RuntimeHelper.requireNonNull(constants$10.clang_getTypeDeclaration$MH, "clang_getTypeDeclaration");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, T);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getTypeDeclaration ( ResourceScope scope,  MemorySegment T) {
        return clang_getTypeDeclaration(SegmentAllocator.ofScope(scope), T);
    }
    public static MethodHandle clang_getTypeKindSpelling$MH() {
        return RuntimeHelper.requireNonNull(constants$10.clang_getTypeKindSpelling$MH,"clang_getTypeKindSpelling");
    }
    public static MemorySegment clang_getTypeKindSpelling ( SegmentAllocator allocator,  int K) {
        var mh$ = RuntimeHelper.requireNonNull(constants$10.clang_getTypeKindSpelling$MH, "clang_getTypeKindSpelling");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, K);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getTypeKindSpelling ( ResourceScope scope,  int K) {
        return clang_getTypeKindSpelling(SegmentAllocator.ofScope(scope), K);
    }
    public static MethodHandle clang_getFunctionTypeCallingConv$MH() {
        return RuntimeHelper.requireNonNull(constants$10.clang_getFunctionTypeCallingConv$MH,"clang_getFunctionTypeCallingConv");
    }
    public static int clang_getFunctionTypeCallingConv ( MemorySegment T) {
        var mh$ = RuntimeHelper.requireNonNull(constants$10.clang_getFunctionTypeCallingConv$MH, "clang_getFunctionTypeCallingConv");
        try {
            return (int)mh$.invokeExact(T);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_getResultType$MH() {
        return RuntimeHelper.requireNonNull(constants$10.clang_getResultType$MH,"clang_getResultType");
    }
    public static MemorySegment clang_getResultType ( SegmentAllocator allocator,  MemorySegment T) {
        var mh$ = RuntimeHelper.requireNonNull(constants$10.clang_getResultType$MH, "clang_getResultType");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, T);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getResultType ( ResourceScope scope,  MemorySegment T) {
        return clang_getResultType(SegmentAllocator.ofScope(scope), T);
    }
    public static MethodHandle clang_getNumArgTypes$MH() {
        return RuntimeHelper.requireNonNull(constants$10.clang_getNumArgTypes$MH,"clang_getNumArgTypes");
    }
    public static int clang_getNumArgTypes ( MemorySegment T) {
        var mh$ = RuntimeHelper.requireNonNull(constants$10.clang_getNumArgTypes$MH, "clang_getNumArgTypes");
        try {
            return (int)mh$.invokeExact(T);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_getArgType$MH() {
        return RuntimeHelper.requireNonNull(constants$10.clang_getArgType$MH,"clang_getArgType");
    }
    public static MemorySegment clang_getArgType ( SegmentAllocator allocator,  MemorySegment T,  int i) {
        var mh$ = RuntimeHelper.requireNonNull(constants$10.clang_getArgType$MH, "clang_getArgType");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, T, i);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getArgType ( ResourceScope scope,  MemorySegment T,  int i) {
        return clang_getArgType(SegmentAllocator.ofScope(scope), T, i);
    }
    public static MethodHandle clang_isFunctionTypeVariadic$MH() {
        return RuntimeHelper.requireNonNull(constants$11.clang_isFunctionTypeVariadic$MH,"clang_isFunctionTypeVariadic");
    }
    public static int clang_isFunctionTypeVariadic ( MemorySegment T) {
        var mh$ = RuntimeHelper.requireNonNull(constants$11.clang_isFunctionTypeVariadic$MH, "clang_isFunctionTypeVariadic");
        try {
            return (int)mh$.invokeExact(T);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_getCursorResultType$MH() {
        return RuntimeHelper.requireNonNull(constants$11.clang_getCursorResultType$MH,"clang_getCursorResultType");
    }
    public static MemorySegment clang_getCursorResultType ( SegmentAllocator allocator,  MemorySegment C) {
        var mh$ = RuntimeHelper.requireNonNull(constants$11.clang_getCursorResultType$MH, "clang_getCursorResultType");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, C);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getCursorResultType ( ResourceScope scope,  MemorySegment C) {
        return clang_getCursorResultType(SegmentAllocator.ofScope(scope), C);
    }
    public static MethodHandle clang_getElementType$MH() {
        return RuntimeHelper.requireNonNull(constants$11.clang_getElementType$MH,"clang_getElementType");
    }
    public static MemorySegment clang_getElementType ( SegmentAllocator allocator,  MemorySegment T) {
        var mh$ = RuntimeHelper.requireNonNull(constants$11.clang_getElementType$MH, "clang_getElementType");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, T);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getElementType ( ResourceScope scope,  MemorySegment T) {
        return clang_getElementType(SegmentAllocator.ofScope(scope), T);
    }
    public static MethodHandle clang_getNumElements$MH() {
        return RuntimeHelper.requireNonNull(constants$11.clang_getNumElements$MH,"clang_getNumElements");
    }
    public static long clang_getNumElements ( MemorySegment T) {
        var mh$ = RuntimeHelper.requireNonNull(constants$11.clang_getNumElements$MH, "clang_getNumElements");
        try {
            return (long)mh$.invokeExact(T);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_getArrayElementType$MH() {
        return RuntimeHelper.requireNonNull(constants$11.clang_getArrayElementType$MH,"clang_getArrayElementType");
    }
    public static MemorySegment clang_getArrayElementType ( SegmentAllocator allocator,  MemorySegment T) {
        var mh$ = RuntimeHelper.requireNonNull(constants$11.clang_getArrayElementType$MH, "clang_getArrayElementType");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, T);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getArrayElementType ( ResourceScope scope,  MemorySegment T) {
        return clang_getArrayElementType(SegmentAllocator.ofScope(scope), T);
    }
    public static MethodHandle clang_getArraySize$MH() {
        return RuntimeHelper.requireNonNull(constants$11.clang_getArraySize$MH,"clang_getArraySize");
    }
    public static long clang_getArraySize ( MemorySegment T) {
        var mh$ = RuntimeHelper.requireNonNull(constants$11.clang_getArraySize$MH, "clang_getArraySize");
        try {
            return (long)mh$.invokeExact(T);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static int CXTypeNullability_NonNull() {
        return (int)0L;
    }
    public static int CXTypeNullability_Nullable() {
        return (int)1L;
    }
    public static int CXTypeNullability_Unspecified() {
        return (int)2L;
    }
    public static int CXTypeNullability_Invalid() {
        return (int)3L;
    }
    public static int CXTypeLayoutError_Invalid() {
        return (int)-1L;
    }
    public static int CXTypeLayoutError_Incomplete() {
        return (int)-2L;
    }
    public static int CXTypeLayoutError_Dependent() {
        return (int)-3L;
    }
    public static int CXTypeLayoutError_NotConstantSize() {
        return (int)-4L;
    }
    public static int CXTypeLayoutError_InvalidFieldName() {
        return (int)-5L;
    }
    public static int CXTypeLayoutError_Undeduced() {
        return (int)-6L;
    }
    public static MethodHandle clang_Type_getSizeOf$MH() {
        return RuntimeHelper.requireNonNull(constants$12.clang_Type_getSizeOf$MH,"clang_Type_getSizeOf");
    }
    public static long clang_Type_getSizeOf ( MemorySegment T) {
        var mh$ = RuntimeHelper.requireNonNull(constants$12.clang_Type_getSizeOf$MH, "clang_Type_getSizeOf");
        try {
            return (long)mh$.invokeExact(T);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_Type_getOffsetOf$MH() {
        return RuntimeHelper.requireNonNull(constants$12.clang_Type_getOffsetOf$MH,"clang_Type_getOffsetOf");
    }
    public static long clang_Type_getOffsetOf ( MemorySegment T,  Addressable S) {
        var mh$ = RuntimeHelper.requireNonNull(constants$12.clang_Type_getOffsetOf$MH, "clang_Type_getOffsetOf");
        try {
            return (long)mh$.invokeExact(T, S.address());
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_Cursor_isAnonymous$MH() {
        return RuntimeHelper.requireNonNull(constants$12.clang_Cursor_isAnonymous$MH,"clang_Cursor_isAnonymous");
    }
    public static int clang_Cursor_isAnonymous ( MemorySegment C) {
        var mh$ = RuntimeHelper.requireNonNull(constants$12.clang_Cursor_isAnonymous$MH, "clang_Cursor_isAnonymous");
        try {
            return (int)mh$.invokeExact(C);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_Cursor_isAnonymousRecordDecl$MH() {
        return RuntimeHelper.requireNonNull(constants$12.clang_Cursor_isAnonymousRecordDecl$MH,"clang_Cursor_isAnonymousRecordDecl");
    }
    public static int clang_Cursor_isAnonymousRecordDecl ( MemorySegment C) {
        var mh$ = RuntimeHelper.requireNonNull(constants$12.clang_Cursor_isAnonymousRecordDecl$MH, "clang_Cursor_isAnonymousRecordDecl");
        try {
            return (int)mh$.invokeExact(C);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_Cursor_isBitField$MH() {
        return RuntimeHelper.requireNonNull(constants$12.clang_Cursor_isBitField$MH,"clang_Cursor_isBitField");
    }
    public static int clang_Cursor_isBitField ( MemorySegment C) {
        var mh$ = RuntimeHelper.requireNonNull(constants$12.clang_Cursor_isBitField$MH, "clang_Cursor_isBitField");
        try {
            return (int)mh$.invokeExact(C);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static int CXChildVisit_Break() {
        return (int)0L;
    }
    public static int CXChildVisit_Continue() {
        return (int)1L;
    }
    public static int CXChildVisit_Recurse() {
        return (int)2L;
    }
    public static MethodHandle clang_visitChildren$MH() {
        return RuntimeHelper.requireNonNull(constants$13.clang_visitChildren$MH,"clang_visitChildren");
    }
    public static int clang_visitChildren ( MemorySegment parent,  Addressable visitor,  Addressable client_data) {
        var mh$ = RuntimeHelper.requireNonNull(constants$13.clang_visitChildren$MH, "clang_visitChildren");
        try {
            return (int)mh$.invokeExact(parent, visitor.address(), client_data.address());
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_getCursorUSR$MH() {
        return RuntimeHelper.requireNonNull(constants$13.clang_getCursorUSR$MH,"clang_getCursorUSR");
    }
    public static MemorySegment clang_getCursorUSR ( SegmentAllocator allocator,  MemorySegment x1) {
        var mh$ = RuntimeHelper.requireNonNull(constants$13.clang_getCursorUSR$MH, "clang_getCursorUSR");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, x1);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getCursorUSR ( ResourceScope scope,  MemorySegment x1) {
        return clang_getCursorUSR(SegmentAllocator.ofScope(scope), x1);
    }
    public static MethodHandle clang_getCursorSpelling$MH() {
        return RuntimeHelper.requireNonNull(constants$13.clang_getCursorSpelling$MH,"clang_getCursorSpelling");
    }
    public static MemorySegment clang_getCursorSpelling ( SegmentAllocator allocator,  MemorySegment x1) {
        var mh$ = RuntimeHelper.requireNonNull(constants$13.clang_getCursorSpelling$MH, "clang_getCursorSpelling");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, x1);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getCursorSpelling ( ResourceScope scope,  MemorySegment x1) {
        return clang_getCursorSpelling(SegmentAllocator.ofScope(scope), x1);
    }
    public static int CXPrintingPolicy_Indentation() {
        return (int)0L;
    }
    public static int CXPrintingPolicy_SuppressSpecifiers() {
        return (int)1L;
    }
    public static int CXPrintingPolicy_SuppressTagKeyword() {
        return (int)2L;
    }
    public static int CXPrintingPolicy_IncludeTagDefinition() {
        return (int)3L;
    }
    public static int CXPrintingPolicy_SuppressScope() {
        return (int)4L;
    }
    public static int CXPrintingPolicy_SuppressUnwrittenScope() {
        return (int)5L;
    }
    public static int CXPrintingPolicy_SuppressInitializers() {
        return (int)6L;
    }
    public static int CXPrintingPolicy_ConstantArraySizeAsWritten() {
        return (int)7L;
    }
    public static int CXPrintingPolicy_AnonymousTagLocations() {
        return (int)8L;
    }
    public static int CXPrintingPolicy_SuppressStrongLifetime() {
        return (int)9L;
    }
    public static int CXPrintingPolicy_SuppressLifetimeQualifiers() {
        return (int)10L;
    }
    public static int CXPrintingPolicy_SuppressTemplateArgsInCXXConstructors() {
        return (int)11L;
    }
    public static int CXPrintingPolicy_Bool() {
        return (int)12L;
    }
    public static int CXPrintingPolicy_Restrict() {
        return (int)13L;
    }
    public static int CXPrintingPolicy_Alignof() {
        return (int)14L;
    }
    public static int CXPrintingPolicy_UnderscoreAlignof() {
        return (int)15L;
    }
    public static int CXPrintingPolicy_UseVoidForZeroParams() {
        return (int)16L;
    }
    public static int CXPrintingPolicy_TerseOutput() {
        return (int)17L;
    }
    public static int CXPrintingPolicy_PolishForDeclaration() {
        return (int)18L;
    }
    public static int CXPrintingPolicy_Half() {
        return (int)19L;
    }
    public static int CXPrintingPolicy_MSWChar() {
        return (int)20L;
    }
    public static int CXPrintingPolicy_IncludeNewlines() {
        return (int)21L;
    }
    public static int CXPrintingPolicy_MSVCFormatting() {
        return (int)22L;
    }
    public static int CXPrintingPolicy_ConstantsAsWritten() {
        return (int)23L;
    }
    public static int CXPrintingPolicy_SuppressImplicitBase() {
        return (int)24L;
    }
    public static int CXPrintingPolicy_FullyQualifiedName() {
        return (int)25L;
    }
    public static int CXPrintingPolicy_LastProperty() {
        return (int)25L;
    }
    public static MethodHandle clang_PrintingPolicy_getProperty$MH() {
        return RuntimeHelper.requireNonNull(constants$13.clang_PrintingPolicy_getProperty$MH,"clang_PrintingPolicy_getProperty");
    }
    public static int clang_PrintingPolicy_getProperty ( Addressable Policy,  int Property) {
        var mh$ = RuntimeHelper.requireNonNull(constants$13.clang_PrintingPolicy_getProperty$MH, "clang_PrintingPolicy_getProperty");
        try {
            return (int)mh$.invokeExact(Policy.address(), Property);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_PrintingPolicy_setProperty$MH() {
        return RuntimeHelper.requireNonNull(constants$13.clang_PrintingPolicy_setProperty$MH,"clang_PrintingPolicy_setProperty");
    }
    public static void clang_PrintingPolicy_setProperty ( Addressable Policy,  int Property,  int Value) {
        var mh$ = RuntimeHelper.requireNonNull(constants$13.clang_PrintingPolicy_setProperty$MH, "clang_PrintingPolicy_setProperty");
        try {
            mh$.invokeExact(Policy.address(), Property, Value);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_getCursorPrintingPolicy$MH() {
        return RuntimeHelper.requireNonNull(constants$14.clang_getCursorPrintingPolicy$MH,"clang_getCursorPrintingPolicy");
    }
    public static MemoryAddress clang_getCursorPrintingPolicy ( MemorySegment x0) {
        var mh$ = RuntimeHelper.requireNonNull(constants$14.clang_getCursorPrintingPolicy$MH, "clang_getCursorPrintingPolicy");
        try {
            return (jdk.incubator.foreign.MemoryAddress)mh$.invokeExact(x0);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_PrintingPolicy_dispose$MH() {
        return RuntimeHelper.requireNonNull(constants$14.clang_PrintingPolicy_dispose$MH,"clang_PrintingPolicy_dispose");
    }
    public static void clang_PrintingPolicy_dispose ( Addressable Policy) {
        var mh$ = RuntimeHelper.requireNonNull(constants$14.clang_PrintingPolicy_dispose$MH, "clang_PrintingPolicy_dispose");
        try {
            mh$.invokeExact(Policy.address());
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_getCursorPrettyPrinted$MH() {
        return RuntimeHelper.requireNonNull(constants$14.clang_getCursorPrettyPrinted$MH,"clang_getCursorPrettyPrinted");
    }
    public static MemorySegment clang_getCursorPrettyPrinted ( SegmentAllocator allocator,  MemorySegment Cursor,  Addressable Policy) {
        var mh$ = RuntimeHelper.requireNonNull(constants$14.clang_getCursorPrettyPrinted$MH, "clang_getCursorPrettyPrinted");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, Cursor, Policy.address());
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getCursorPrettyPrinted ( ResourceScope scope,  MemorySegment Cursor,  Addressable Policy) {
        return clang_getCursorPrettyPrinted(SegmentAllocator.ofScope(scope), Cursor, Policy.address());
    }
    public static MethodHandle clang_getCursorDisplayName$MH() {
        return RuntimeHelper.requireNonNull(constants$14.clang_getCursorDisplayName$MH,"clang_getCursorDisplayName");
    }
    public static MemorySegment clang_getCursorDisplayName ( SegmentAllocator allocator,  MemorySegment x1) {
        var mh$ = RuntimeHelper.requireNonNull(constants$14.clang_getCursorDisplayName$MH, "clang_getCursorDisplayName");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, x1);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getCursorDisplayName ( ResourceScope scope,  MemorySegment x1) {
        return clang_getCursorDisplayName(SegmentAllocator.ofScope(scope), x1);
    }
    public static MethodHandle clang_getCursorReferenced$MH() {
        return RuntimeHelper.requireNonNull(constants$14.clang_getCursorReferenced$MH,"clang_getCursorReferenced");
    }
    public static MemorySegment clang_getCursorReferenced ( SegmentAllocator allocator,  MemorySegment x1) {
        var mh$ = RuntimeHelper.requireNonNull(constants$14.clang_getCursorReferenced$MH, "clang_getCursorReferenced");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, x1);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getCursorReferenced ( ResourceScope scope,  MemorySegment x1) {
        return clang_getCursorReferenced(SegmentAllocator.ofScope(scope), x1);
    }
    public static MethodHandle clang_getCursorDefinition$MH() {
        return RuntimeHelper.requireNonNull(constants$14.clang_getCursorDefinition$MH,"clang_getCursorDefinition");
    }
    public static MemorySegment clang_getCursorDefinition ( SegmentAllocator allocator,  MemorySegment x1) {
        var mh$ = RuntimeHelper.requireNonNull(constants$14.clang_getCursorDefinition$MH, "clang_getCursorDefinition");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, x1);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getCursorDefinition ( ResourceScope scope,  MemorySegment x1) {
        return clang_getCursorDefinition(SegmentAllocator.ofScope(scope), x1);
    }
    public static MethodHandle clang_isCursorDefinition$MH() {
        return RuntimeHelper.requireNonNull(constants$15.clang_isCursorDefinition$MH,"clang_isCursorDefinition");
    }
    public static int clang_isCursorDefinition ( MemorySegment x0) {
        var mh$ = RuntimeHelper.requireNonNull(constants$15.clang_isCursorDefinition$MH, "clang_isCursorDefinition");
        try {
            return (int)mh$.invokeExact(x0);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_Cursor_isVariadic$MH() {
        return RuntimeHelper.requireNonNull(constants$15.clang_Cursor_isVariadic$MH,"clang_Cursor_isVariadic");
    }
    public static int clang_Cursor_isVariadic ( MemorySegment C) {
        var mh$ = RuntimeHelper.requireNonNull(constants$15.clang_Cursor_isVariadic$MH, "clang_Cursor_isVariadic");
        try {
            return (int)mh$.invokeExact(C);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_Cursor_getMangling$MH() {
        return RuntimeHelper.requireNonNull(constants$15.clang_Cursor_getMangling$MH,"clang_Cursor_getMangling");
    }
    public static MemorySegment clang_Cursor_getMangling ( SegmentAllocator allocator,  MemorySegment x1) {
        var mh$ = RuntimeHelper.requireNonNull(constants$15.clang_Cursor_getMangling$MH, "clang_Cursor_getMangling");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, x1);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_Cursor_getMangling ( ResourceScope scope,  MemorySegment x1) {
        return clang_Cursor_getMangling(SegmentAllocator.ofScope(scope), x1);
    }
    public static int CXToken_Punctuation() {
        return (int)0L;
    }
    public static int CXToken_Keyword() {
        return (int)1L;
    }
    public static int CXToken_Identifier() {
        return (int)2L;
    }
    public static int CXToken_Literal() {
        return (int)3L;
    }
    public static int CXToken_Comment() {
        return (int)4L;
    }
    public static MethodHandle clang_getTokenKind$MH() {
        return RuntimeHelper.requireNonNull(constants$15.clang_getTokenKind$MH,"clang_getTokenKind");
    }
    public static int clang_getTokenKind ( MemorySegment x0) {
        var mh$ = RuntimeHelper.requireNonNull(constants$15.clang_getTokenKind$MH, "clang_getTokenKind");
        try {
            return (int)mh$.invokeExact(x0);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_getTokenSpelling$MH() {
        return RuntimeHelper.requireNonNull(constants$15.clang_getTokenSpelling$MH,"clang_getTokenSpelling");
    }
    public static MemorySegment clang_getTokenSpelling ( SegmentAllocator allocator,  Addressable x1,  MemorySegment x2) {
        var mh$ = RuntimeHelper.requireNonNull(constants$15.clang_getTokenSpelling$MH, "clang_getTokenSpelling");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, x1.address(), x2);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getTokenSpelling ( ResourceScope scope,  Addressable x1,  MemorySegment x2) {
        return clang_getTokenSpelling(SegmentAllocator.ofScope(scope), x1.address(), x2);
    }
    public static MethodHandle clang_getTokenLocation$MH() {
        return RuntimeHelper.requireNonNull(constants$15.clang_getTokenLocation$MH,"clang_getTokenLocation");
    }
    public static MemorySegment clang_getTokenLocation ( SegmentAllocator allocator,  Addressable x1,  MemorySegment x2) {
        var mh$ = RuntimeHelper.requireNonNull(constants$15.clang_getTokenLocation$MH, "clang_getTokenLocation");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, x1.address(), x2);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getTokenLocation ( ResourceScope scope,  Addressable x1,  MemorySegment x2) {
        return clang_getTokenLocation(SegmentAllocator.ofScope(scope), x1.address(), x2);
    }
    public static MethodHandle clang_getTokenExtent$MH() {
        return RuntimeHelper.requireNonNull(constants$16.clang_getTokenExtent$MH,"clang_getTokenExtent");
    }
    public static MemorySegment clang_getTokenExtent ( SegmentAllocator allocator,  Addressable x1,  MemorySegment x2) {
        var mh$ = RuntimeHelper.requireNonNull(constants$16.clang_getTokenExtent$MH, "clang_getTokenExtent");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, x1.address(), x2);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getTokenExtent ( ResourceScope scope,  Addressable x1,  MemorySegment x2) {
        return clang_getTokenExtent(SegmentAllocator.ofScope(scope), x1.address(), x2);
    }
    public static MethodHandle clang_tokenize$MH() {
        return RuntimeHelper.requireNonNull(constants$16.clang_tokenize$MH,"clang_tokenize");
    }
    public static void clang_tokenize ( Addressable TU,  MemorySegment Range,  Addressable Tokens,  Addressable NumTokens) {
        var mh$ = RuntimeHelper.requireNonNull(constants$16.clang_tokenize$MH, "clang_tokenize");
        try {
            mh$.invokeExact(TU.address(), Range, Tokens.address(), NumTokens.address());
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_disposeTokens$MH() {
        return RuntimeHelper.requireNonNull(constants$16.clang_disposeTokens$MH,"clang_disposeTokens");
    }
    public static void clang_disposeTokens ( Addressable TU,  Addressable Tokens,  int NumTokens) {
        var mh$ = RuntimeHelper.requireNonNull(constants$16.clang_disposeTokens$MH, "clang_disposeTokens");
        try {
            mh$.invokeExact(TU.address(), Tokens.address(), NumTokens);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_getCursorKindSpelling$MH() {
        return RuntimeHelper.requireNonNull(constants$16.clang_getCursorKindSpelling$MH,"clang_getCursorKindSpelling");
    }
    public static MemorySegment clang_getCursorKindSpelling ( SegmentAllocator allocator,  int Kind) {
        var mh$ = RuntimeHelper.requireNonNull(constants$16.clang_getCursorKindSpelling$MH, "clang_getCursorKindSpelling");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator, Kind);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getCursorKindSpelling ( ResourceScope scope,  int Kind) {
        return clang_getCursorKindSpelling(SegmentAllocator.ofScope(scope), Kind);
    }
    public static MethodHandle clang_getClangVersion$MH() {
        return RuntimeHelper.requireNonNull(constants$16.clang_getClangVersion$MH,"clang_getClangVersion");
    }
    public static MemorySegment clang_getClangVersion ( SegmentAllocator allocator) {
        var mh$ = RuntimeHelper.requireNonNull(constants$16.clang_getClangVersion$MH, "clang_getClangVersion");
        try {
            return (jdk.incubator.foreign.MemorySegment)mh$.invokeExact(allocator);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MemorySegment clang_getClangVersion ( ResourceScope scope) {
        return clang_getClangVersion(SegmentAllocator.ofScope(scope));
    }
    public static MethodHandle clang_toggleCrashRecovery$MH() {
        return RuntimeHelper.requireNonNull(constants$16.clang_toggleCrashRecovery$MH,"clang_toggleCrashRecovery");
    }
    public static void clang_toggleCrashRecovery ( int isEnabled) {
        var mh$ = RuntimeHelper.requireNonNull(constants$16.clang_toggleCrashRecovery$MH, "clang_toggleCrashRecovery");
        try {
            mh$.invokeExact(isEnabled);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_Cursor_Evaluate$MH() {
        return RuntimeHelper.requireNonNull(constants$17.clang_Cursor_Evaluate$MH,"clang_Cursor_Evaluate");
    }
    public static MemoryAddress clang_Cursor_Evaluate ( MemorySegment C) {
        var mh$ = RuntimeHelper.requireNonNull(constants$17.clang_Cursor_Evaluate$MH, "clang_Cursor_Evaluate");
        try {
            return (jdk.incubator.foreign.MemoryAddress)mh$.invokeExact(C);
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_EvalResult_getKind$MH() {
        return RuntimeHelper.requireNonNull(constants$17.clang_EvalResult_getKind$MH,"clang_EvalResult_getKind");
    }
    public static int clang_EvalResult_getKind ( Addressable E) {
        var mh$ = RuntimeHelper.requireNonNull(constants$17.clang_EvalResult_getKind$MH, "clang_EvalResult_getKind");
        try {
            return (int)mh$.invokeExact(E.address());
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_EvalResult_getAsInt$MH() {
        return RuntimeHelper.requireNonNull(constants$17.clang_EvalResult_getAsInt$MH,"clang_EvalResult_getAsInt");
    }
    public static int clang_EvalResult_getAsInt ( Addressable E) {
        var mh$ = RuntimeHelper.requireNonNull(constants$17.clang_EvalResult_getAsInt$MH, "clang_EvalResult_getAsInt");
        try {
            return (int)mh$.invokeExact(E.address());
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_EvalResult_getAsLongLong$MH() {
        return RuntimeHelper.requireNonNull(constants$17.clang_EvalResult_getAsLongLong$MH,"clang_EvalResult_getAsLongLong");
    }
    public static long clang_EvalResult_getAsLongLong ( Addressable E) {
        var mh$ = RuntimeHelper.requireNonNull(constants$17.clang_EvalResult_getAsLongLong$MH, "clang_EvalResult_getAsLongLong");
        try {
            return (long)mh$.invokeExact(E.address());
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_EvalResult_isUnsignedInt$MH() {
        return RuntimeHelper.requireNonNull(constants$17.clang_EvalResult_isUnsignedInt$MH,"clang_EvalResult_isUnsignedInt");
    }
    public static int clang_EvalResult_isUnsignedInt ( Addressable E) {
        var mh$ = RuntimeHelper.requireNonNull(constants$17.clang_EvalResult_isUnsignedInt$MH, "clang_EvalResult_isUnsignedInt");
        try {
            return (int)mh$.invokeExact(E.address());
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_EvalResult_getAsUnsigned$MH() {
        return RuntimeHelper.requireNonNull(constants$17.clang_EvalResult_getAsUnsigned$MH,"clang_EvalResult_getAsUnsigned");
    }
    public static long clang_EvalResult_getAsUnsigned ( Addressable E) {
        var mh$ = RuntimeHelper.requireNonNull(constants$17.clang_EvalResult_getAsUnsigned$MH, "clang_EvalResult_getAsUnsigned");
        try {
            return (long)mh$.invokeExact(E.address());
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_EvalResult_getAsDouble$MH() {
        return RuntimeHelper.requireNonNull(constants$18.clang_EvalResult_getAsDouble$MH,"clang_EvalResult_getAsDouble");
    }
    public static double clang_EvalResult_getAsDouble ( Addressable E) {
        var mh$ = RuntimeHelper.requireNonNull(constants$18.clang_EvalResult_getAsDouble$MH, "clang_EvalResult_getAsDouble");
        try {
            return (double)mh$.invokeExact(E.address());
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_EvalResult_getAsStr$MH() {
        return RuntimeHelper.requireNonNull(constants$18.clang_EvalResult_getAsStr$MH,"clang_EvalResult_getAsStr");
    }
    public static MemoryAddress clang_EvalResult_getAsStr ( Addressable E) {
        var mh$ = RuntimeHelper.requireNonNull(constants$18.clang_EvalResult_getAsStr$MH, "clang_EvalResult_getAsStr");
        try {
            return (jdk.incubator.foreign.MemoryAddress)mh$.invokeExact(E.address());
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static MethodHandle clang_EvalResult_dispose$MH() {
        return RuntimeHelper.requireNonNull(constants$18.clang_EvalResult_dispose$MH,"clang_EvalResult_dispose");
    }
    public static void clang_EvalResult_dispose ( Addressable E) {
        var mh$ = RuntimeHelper.requireNonNull(constants$18.clang_EvalResult_dispose$MH, "clang_EvalResult_dispose");
        try {
            mh$.invokeExact(E.address());
        } catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
    public static int CXResult_Success() {
        return (int)0L;
    }
    public static int CXResult_Invalid() {
        return (int)1L;
    }
    public static int CXResult_VisitBreak() {
        return (int)2L;
    }
}


