/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.constant.Constable;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DynamicConstantDesc;
import java.util.Optional;
import jdk.internal.MigratedValueClass;
import jdk.internal.ValueBased;
import jdk.internal.misc.CDS;
import jdk.internal.value.DeserializeConstructor;
import jdk.internal.vm.annotation.IntrinsicCandidate;
import jdk.internal.vm.annotation.Stable;

@MigratedValueClass
@ValueBased
public final class Short
extends Number
implements Comparable<Short>,
Constable {
    public static final short MIN_VALUE = Short.MIN_VALUE;
    public static final short MAX_VALUE = Short.MAX_VALUE;
    public static final Class<Short> TYPE = Class.getPrimitiveClass("short");
    private final short value;
    public static final int SIZE = 16;
    public static final int BYTES = 2;
    private static final long serialVersionUID = 7515723908773894738L;

    public static String toString(short s) {
        return Integer.toString(s);
    }

    public static short parseShort(String s, int radix) throws NumberFormatException {
        int i = Integer.parseInt(s, radix);
        if (i < Short.MIN_VALUE || i > Short.MAX_VALUE) {
            throw new NumberFormatException("Value out of range. Value:\"" + s + "\" Radix:" + radix);
        }
        return (short)i;
    }

    public static short parseShort(String s) throws NumberFormatException {
        return Short.parseShort(s, 10);
    }

    public static Short valueOf(String s, int radix) throws NumberFormatException {
        return Short.parseShort(s, radix);
    }

    public static Short valueOf(String s) throws NumberFormatException {
        return Short.valueOf(s, 10);
    }

    public Optional<DynamicConstantDesc<Short>> describeConstable() {
        return Optional.of(DynamicConstantDesc.ofNamed(ConstantDescs.BSM_EXPLICIT_CAST, "_", ConstantDescs.CD_short, Integer.valueOf(this.intValue())));
    }

    @IntrinsicCandidate
    @DeserializeConstructor
    public static Short valueOf(short s) {
        int offset = 128;
        short sAsInt = s;
        if (sAsInt >= -128 && sAsInt <= 127) {
            return ShortCache.cache[sAsInt + 128];
        }
        return new Short(s);
    }

    public static Short decode(String nm) throws NumberFormatException {
        int i = Integer.decode(nm);
        if (i < Short.MIN_VALUE || i > Short.MAX_VALUE) {
            throw new NumberFormatException("Value " + i + " out of range from input " + nm);
        }
        return (short)i;
    }

    @Deprecated(since="9")
    public Short(short value) {
        this.value = value;
    }

    @Deprecated(since="9")
    public Short(String s) throws NumberFormatException {
        this.value = Short.parseShort(s, 10);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    @IntrinsicCandidate
    public short shortValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public int hashCode() {
        return Short.hashCode(this.value);
    }

    public static int hashCode(short value) {
        return value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Short) {
            Short s = (Short)obj;
            return this.value == s;
        }
        return false;
    }

    @Override
    public int compareTo(Short anotherShort) {
        return Short.compare(this.value, anotherShort.value);
    }

    public static int compare(short x, short y) {
        return x - y;
    }

    public static int compareUnsigned(short x, short y) {
        return Short.toUnsignedInt(x) - Short.toUnsignedInt(y);
    }

    @IntrinsicCandidate
    public static short reverseBytes(short i) {
        return (short)((i & 0xFF00) >> 8 | i << 8);
    }

    public static int toUnsignedInt(short x) {
        return x & 0xFFFF;
    }

    public static long toUnsignedLong(short x) {
        return (long)x & 0xFFFFL;
    }

    private static final class ShortCache {
        @Stable
        static final Short[] cache;
        static Short[] archivedCache;

        private ShortCache() {
        }

        static {
            int size = 256;
            CDS.initializeFromArchive(ShortCache.class);
            if (archivedCache == null) {
                Short[] c = new Short[size];
                short value = -128;
                for (int i = 0; i < size; ++i) {
                    short s = value;
                    value = (short)(value + 1);
                    c[i] = new Short(s);
                }
                archivedCache = c;
            }
            cache = archivedCache;
            assert (cache.length == size);
        }
    }
}

