/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.constant.Constable;
import java.lang.constant.ConstantDesc;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import jdk.internal.MigratedValueClass;
import jdk.internal.ValueBased;
import jdk.internal.math.FloatToDecimal;
import jdk.internal.math.FloatingDecimal;
import jdk.internal.value.DeserializeConstructor;
import jdk.internal.vm.annotation.IntrinsicCandidate;

@MigratedValueClass
@ValueBased
public final class Float
extends Number
implements Comparable<Float>,
Constable,
ConstantDesc {
    public static final float POSITIVE_INFINITY = 1.0f / 0.0f;
    public static final float NEGATIVE_INFINITY = -1.0f / 0.0f;
    public static final float NaN = 0.0f / 0.0f;
    public static final float MAX_VALUE = 3.4028235E38f;
    public static final float MIN_NORMAL = 1.1754944E-38f;
    public static final float MIN_VALUE = 1.4E-45f;
    public static final int SIZE = 32;
    public static final int PRECISION = 24;
    public static final int MAX_EXPONENT = 127;
    public static final int MIN_EXPONENT = -126;
    public static final int BYTES = 4;
    public static final Class<Float> TYPE = Class.getPrimitiveClass("float");
    private final float value;
    private static final long serialVersionUID = -2671257302660747028L;

    public static String toString(float f) {
        return FloatToDecimal.toString(f);
    }

    public static String toHexString(float f) {
        if (Math.abs(f) < Float.MIN_NORMAL && f != 0.0f) {
            String s = Double.toHexString(Math.scalb((double)f, -896));
            return s.replaceFirst("p-1022$", "p-126");
        }
        return Double.toHexString(f);
    }

    public static Float valueOf(String s) throws NumberFormatException {
        return new Float(Float.parseFloat(s));
    }

    @IntrinsicCandidate
    @DeserializeConstructor
    public static Float valueOf(float f) {
        return new Float(f);
    }

    public static float parseFloat(String s) throws NumberFormatException {
        return FloatingDecimal.parseFloat(s);
    }

    public static boolean isNaN(float v) {
        return v != v;
    }

    @IntrinsicCandidate
    public static boolean isInfinite(float v) {
        return Math.abs(v) > Float.MAX_VALUE;
    }

    @IntrinsicCandidate
    public static boolean isFinite(float f) {
        return Math.abs(f) <= Float.MAX_VALUE;
    }

    @Deprecated(since="9")
    public Float(float value) {
        this.value = value;
    }

    @Deprecated(since="9")
    public Float(double value) {
        this.value = (float)value;
    }

    @Deprecated(since="9")
    public Float(String s) throws NumberFormatException {
        this.value = Float.parseFloat(s);
    }

    public boolean isNaN() {
        return Float.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Float.isInfinite(this.value);
    }

    public String toString() {
        return Float.toString(this.value);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    @IntrinsicCandidate
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        return Float.hashCode(this.value);
    }

    public static int hashCode(float value) {
        return Float.floatToIntBits(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof Float)) return false;
        Float f = (Float)obj;
        if (Float.floatToIntBits(f.value) != Float.floatToIntBits(this.value)) return false;
        return true;
    }

    @IntrinsicCandidate
    public static int floatToIntBits(float value) {
        if (!Float.isNaN(value)) {
            return Float.floatToRawIntBits(value);
        }
        return 2143289344;
    }

    @IntrinsicCandidate
    public static native int floatToRawIntBits(float var0);

    @IntrinsicCandidate
    public static native float intBitsToFloat(int var0);

    @IntrinsicCandidate
    public static float float16ToFloat(short floatBinary16) {
        short bin16arg = floatBinary16;
        int bin16SignBit = 0x8000 & bin16arg;
        int bin16ExpBits = 0x7C00 & bin16arg;
        int bin16SignifBits = 0x3FF & bin16arg;
        int SIGNIF_SHIFT = 13;
        float sign = bin16SignBit != 0 ? -1.0f : 1.0f;
        int bin16Exp = (bin16ExpBits >> 10) - 15;
        if (bin16Exp == -15) {
            return sign * (5.9604645E-8f * (float)bin16SignifBits);
        }
        if (bin16Exp == 16) {
            return bin16SignifBits == 0 ? sign * Float.POSITIVE_INFINITY : Float.intBitsToFloat(bin16SignBit << 16 | 0x7F800000 | bin16SignifBits << 13);
        }
        assert (-15 < bin16Exp && bin16Exp < 16);
        int floatExpBits = bin16Exp + 127 << 23;
        return Float.intBitsToFloat(bin16SignBit << 16 | floatExpBits | bin16SignifBits << 13);
    }

    @IntrinsicCandidate
    public static short floatToFloat16(float f) {
        int doppel = Float.floatToRawIntBits(f);
        short sign_bit = (short)((doppel & Integer.MIN_VALUE) >> 16);
        if (Float.isNaN(f)) {
            return (short)(sign_bit | 0x7C00 | (doppel & 0x7FE000) >> 13 | (doppel & 0x1FF0) >> 4 | doppel & 0xF);
        }
        float abs_f = Math.abs(f);
        if (abs_f >= 65520.0f) {
            return (short)(sign_bit | 0x7C00);
        }
        if (abs_f <= 2.9802322E-8f) {
            return sign_bit;
        }
        int exp = Math.getExponent(f);
        assert (-25 <= exp && exp <= 15);
        int expdelta = 0;
        int msb = 0;
        if (exp < -14) {
            expdelta = -14 - exp;
            exp = -15;
            msb = 0x800000;
        }
        int f_signif_bits = doppel & 0x7FFFFF | msb;
        short signif_bits = (short)(f_signif_bits >> 13 + expdelta);
        int lsb = f_signif_bits & 1 << 13 + expdelta;
        int round = f_signif_bits & 1 << 12 + expdelta;
        int sticky = f_signif_bits & (1 << 12 + expdelta) - 1;
        if (round != 0 && (lsb | sticky) != 0) {
            signif_bits = (short)(signif_bits + 1);
        }
        assert ((0xF800 & signif_bits) == 0);
        return (short)(sign_bit | (exp + 15 << 10) + signif_bits);
    }

    @Override
    public int compareTo(Float anotherFloat) {
        return Float.compare(this.value, anotherFloat.value);
    }

    public static int compare(float f1, float f2) {
        int anotherBits;
        if (f1 < f2) {
            return -1;
        }
        if (f1 > f2) {
            return 1;
        }
        int thisBits = Float.floatToIntBits(f1);
        return thisBits == (anotherBits = Float.floatToIntBits(f2)) ? 0 : (thisBits < anotherBits ? -1 : 1);
    }

    public static float sum(float a, float b) {
        return a + b;
    }

    public static float max(float a, float b) {
        return Math.max(a, b);
    }

    public static float min(float a, float b) {
        return Math.min(a, b);
    }

    public Optional<Float> describeConstable() {
        return Optional.of(this);
    }

    @Override
    public Float resolveConstantDesc(MethodHandles.Lookup lookup) {
        return this;
    }
}

