/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.constant.Constable;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DynamicConstantDesc;
import java.util.Optional;
import jdk.internal.MigratedValueClass;
import jdk.internal.ValueBased;
import jdk.internal.misc.CDS;
import jdk.internal.value.DeserializeConstructor;
import jdk.internal.vm.annotation.IntrinsicCandidate;
import jdk.internal.vm.annotation.Stable;

@MigratedValueClass
@ValueBased
public final class Byte
extends Number
implements Comparable<Byte>,
Constable {
    public static final byte MIN_VALUE = -128;
    public static final byte MAX_VALUE = 127;
    public static final Class<Byte> TYPE = Class.getPrimitiveClass("byte");
    private final byte value;
    public static final int SIZE = 8;
    public static final int BYTES = 1;
    private static final long serialVersionUID = -7183698231559129828L;

    public static String toString(byte b) {
        return Integer.toString(b);
    }

    public Optional<DynamicConstantDesc<Byte>> describeConstable() {
        return Optional.of(DynamicConstantDesc.ofNamed(ConstantDescs.BSM_EXPLICIT_CAST, "_", ConstantDescs.CD_byte, Integer.valueOf(this.intValue())));
    }

    @IntrinsicCandidate
    @DeserializeConstructor
    public static Byte valueOf(byte b) {
        int offset = 128;
        return ByteCache.cache[b + 128];
    }

    public static byte parseByte(String s, int radix) throws NumberFormatException {
        int i = Integer.parseInt(s, radix);
        if (i < -128 || i > 127) {
            throw new NumberFormatException("Value out of range. Value:\"" + s + "\" Radix:" + radix);
        }
        return (byte)i;
    }

    public static byte parseByte(String s) throws NumberFormatException {
        return Byte.parseByte(s, 10);
    }

    public static Byte valueOf(String s, int radix) throws NumberFormatException {
        return Byte.parseByte(s, radix);
    }

    public static Byte valueOf(String s) throws NumberFormatException {
        return Byte.valueOf(s, 10);
    }

    public static Byte decode(String nm) throws NumberFormatException {
        int i = Integer.decode(nm);
        if (i < -128 || i > 127) {
            throw new NumberFormatException("Value " + i + " out of range from input " + nm);
        }
        return (byte)i;
    }

    @Deprecated(since="9")
    public Byte(byte value) {
        this.value = value;
    }

    @Deprecated(since="9")
    public Byte(String s) throws NumberFormatException {
        this.value = Byte.parseByte(s, 10);
    }

    @Override
    @IntrinsicCandidate
    public byte byteValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public int hashCode() {
        return Byte.hashCode(this.value);
    }

    public static int hashCode(byte value) {
        return value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Byte) {
            Byte b = (Byte)obj;
            return this.value == b;
        }
        return false;
    }

    @Override
    public int compareTo(Byte anotherByte) {
        return Byte.compare(this.value, anotherByte.value);
    }

    public static int compare(byte x, byte y) {
        return x - y;
    }

    public static int compareUnsigned(byte x, byte y) {
        return Byte.toUnsignedInt(x) - Byte.toUnsignedInt(y);
    }

    public static int toUnsignedInt(byte x) {
        return x & 0xFF;
    }

    public static long toUnsignedLong(byte x) {
        return (long)x & 0xFFL;
    }

    private static final class ByteCache {
        @Stable
        static final Byte[] cache;
        static Byte[] archivedCache;

        private ByteCache() {
        }

        static {
            int size = 256;
            CDS.initializeFromArchive(ByteCache.class);
            if (archivedCache == null) {
                Byte[] c = new Byte[256];
                byte value = -128;
                for (int i = 0; i < 256; ++i) {
                    byte by = value;
                    value = (byte)(value + 1);
                    c[i] = new Byte(by);
                }
                archivedCache = c;
            }
            cache = archivedCache;
            assert (cache.length == 256);
        }
    }
}

