/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.constant.Constable;
import java.lang.constant.ConstantDesc;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.Optional;
import jdk.internal.MigratedValueClass;
import jdk.internal.ValueBased;
import jdk.internal.misc.CDS;
import jdk.internal.misc.VM;
import jdk.internal.util.DecimalDigits;
import jdk.internal.value.DeserializeConstructor;
import jdk.internal.vm.annotation.ForceInline;
import jdk.internal.vm.annotation.IntrinsicCandidate;
import jdk.internal.vm.annotation.Stable;

@MigratedValueClass
@ValueBased
public final class Integer
extends Number
implements Comparable<Integer>,
Constable,
ConstantDesc {
    public static final int MIN_VALUE = -2147483648;
    public static final int MAX_VALUE = 0x7FFFFFFF;
    public static final Class<Integer> TYPE = Class.getPrimitiveClass("int");
    @Stable
    static final byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    private final int value;
    public static final int SIZE = 32;
    public static final int BYTES = 4;
    private static final long serialVersionUID = 1360826667806852920L;

    public static String toString(int i, int radix) {
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        if (radix == 10) {
            return Integer.toString(i);
        }
        if (String.COMPACT_STRINGS) {
            byte[] buf = new byte[33];
            boolean negative = i < 0;
            int charPos = 32;
            if (!negative) {
                i = -i;
            }
            while (i <= -radix) {
                buf[charPos--] = digits[-(i % radix)];
                i /= radix;
            }
            buf[charPos] = digits[-i];
            if (negative) {
                buf[--charPos] = 45;
            }
            return StringLatin1.newString(buf, charPos, 33 - charPos);
        }
        return Integer.toStringUTF16(i, radix);
    }

    private static String toStringUTF16(int i, int radix) {
        byte[] buf = new byte[66];
        boolean negative = i < 0;
        int charPos = 32;
        if (!negative) {
            i = -i;
        }
        while (i <= -radix) {
            StringUTF16.putChar(buf, charPos--, digits[-(i % radix)]);
            i /= radix;
        }
        StringUTF16.putChar(buf, charPos, digits[-i]);
        if (negative) {
            StringUTF16.putChar(buf, --charPos, 45);
        }
        return StringUTF16.newString(buf, charPos, 33 - charPos);
    }

    public static String toUnsignedString(int i, int radix) {
        return Long.toUnsignedString(Integer.toUnsignedLong(i), radix);
    }

    public static String toHexString(int i) {
        return Integer.toUnsignedString0(i, 4);
    }

    public static String toOctalString(int i) {
        return Integer.toUnsignedString0(i, 3);
    }

    public static String toBinaryString(int i) {
        return Integer.toUnsignedString0(i, 1);
    }

    private static String toUnsignedString0(int val, int shift) {
        int mag = 32 - Integer.numberOfLeadingZeros(val);
        int chars = Math.max((mag + (shift - 1)) / shift, 1);
        if (String.COMPACT_STRINGS) {
            byte[] buf = new byte[chars];
            Integer.formatUnsignedInt(val, shift, buf, chars);
            return new String(buf, 0);
        }
        byte[] buf = new byte[chars * 2];
        Integer.formatUnsignedIntUTF16(val, shift, buf, chars);
        return new String(buf, 1);
    }

    private static void formatUnsignedInt(int val, int shift, byte[] buf, int len) {
        int charPos = len;
        int radix = 1 << shift;
        int mask = radix - 1;
        do {
            buf[--charPos] = digits[val & mask];
            val >>>= shift;
        } while (charPos > 0);
    }

    private static void formatUnsignedIntUTF16(int val, int shift, byte[] buf, int len) {
        int charPos = len;
        int radix = 1 << shift;
        int mask = radix - 1;
        do {
            StringUTF16.putChar(buf, --charPos, digits[val & mask]);
            val >>>= shift;
        } while (charPos > 0);
    }

    @IntrinsicCandidate
    public static String toString(int i) {
        int size = DecimalDigits.stringSize((int)i);
        if (String.COMPACT_STRINGS) {
            byte[] buf = new byte[size];
            DecimalDigits.uncheckedGetCharsLatin1((int)i, (int)size, (byte[])buf);
            return new String(buf, 0);
        }
        byte[] buf = new byte[size * 2];
        DecimalDigits.uncheckedGetCharsUTF16((int)i, (int)size, (byte[])buf);
        return new String(buf, 1);
    }

    public static String toUnsignedString(int i) {
        return Long.toString(Integer.toUnsignedLong(i));
    }

    public static int parseInt(String s, int radix) throws NumberFormatException {
        char firstChar;
        if (s == null) {
            throw new NumberFormatException("Cannot parse null string");
        }
        if (radix < 2) {
            throw new NumberFormatException(String.format("radix %s less than Character.MIN_RADIX", radix));
        }
        if (radix > 36) {
            throw new NumberFormatException(String.format("radix %s greater than Character.MAX_RADIX", radix));
        }
        int len = s.length();
        if (len == 0) {
            throw NumberFormatException.forInputString("", radix);
        }
        int digit = -256;
        int i = 0;
        if ((firstChar = s.charAt(i++)) != '-' && firstChar != '+') {
            digit = Character.digit(firstChar, radix);
        }
        if (digit >= 0 || digit == -256 && len > 1) {
            int limit = firstChar != '-' ? -2147483647 : Integer.MIN_VALUE;
            int multmin = limit / radix;
            int result = -(digit & 0xFF);
            boolean inRange = true;
            while (i < len && (digit = Character.digit(s.charAt(i++), radix)) >= 0 && (inRange = result > multmin || result == multmin && digit <= radix * multmin - limit)) {
                result = radix * result - digit;
            }
            if (inRange && i == len && digit >= 0) {
                return firstChar != '-' ? -result : result;
            }
        }
        throw NumberFormatException.forInputString(s, radix);
    }

    public static int parseInt(CharSequence s, int beginIndex, int endIndex, int radix) throws NumberFormatException {
        char firstChar;
        Objects.requireNonNull(s);
        Objects.checkFromToIndex(beginIndex, endIndex, s.length());
        if (radix < 2) {
            throw new NumberFormatException(String.format("radix %s less than Character.MIN_RADIX", radix));
        }
        if (radix > 36) {
            throw new NumberFormatException(String.format("radix %s greater than Character.MAX_RADIX", radix));
        }
        if (beginIndex == endIndex) {
            throw NumberFormatException.forInputString("", radix);
        }
        int digit = -256;
        int i = beginIndex;
        if ((firstChar = s.charAt(i++)) != '-' && firstChar != '+') {
            digit = Character.digit(firstChar, radix);
        }
        if (digit >= 0 || digit == -256 && endIndex - beginIndex > 1) {
            int limit = firstChar != '-' ? -2147483647 : Integer.MIN_VALUE;
            int multmin = limit / radix;
            int result = -(digit & 0xFF);
            boolean inRange = true;
            while (i < endIndex && (digit = Character.digit(s.charAt(i++), radix)) >= 0 && (inRange = result > multmin || result == multmin && digit <= radix * multmin - limit)) {
                result = radix * result - digit;
            }
            if (inRange && i == endIndex && digit >= 0) {
                return firstChar != '-' ? -result : result;
            }
        }
        throw NumberFormatException.forCharSequence(s, beginIndex, endIndex, i - (digit < -1 ? 0 : 1));
    }

    public static int parseInt(String s) throws NumberFormatException {
        return Integer.parseInt(s, 10);
    }

    public static int parseUnsignedInt(String s, int radix) throws NumberFormatException {
        char firstChar;
        if (s == null) {
            throw new NumberFormatException("Cannot parse null string");
        }
        if (radix < 2) {
            throw new NumberFormatException(String.format("radix %s less than Character.MIN_RADIX", radix));
        }
        if (radix > 36) {
            throw new NumberFormatException(String.format("radix %s greater than Character.MAX_RADIX", radix));
        }
        int len = s.length();
        if (len == 0) {
            throw NumberFormatException.forInputString(s, radix);
        }
        int i = 0;
        if ((firstChar = s.charAt(i++)) == '-') {
            throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", s));
        }
        int digit = -256;
        if (firstChar != '+') {
            digit = Character.digit(firstChar, radix);
        }
        if (digit >= 0 || digit == -256 && len > 1) {
            int multmax = Integer.divideUnsigned(-1, radix);
            int result = digit & 0xFF;
            boolean inRange = true;
            while (i < len && (digit = Character.digit(s.charAt(i++), radix)) >= 0 && (inRange = Integer.compareUnsigned(result, multmax) < 0 || result == multmax && digit < -radix * multmax)) {
                result = radix * result + digit;
            }
            if (inRange && i == len && digit >= 0) {
                return result;
            }
        }
        if (digit < 0) {
            throw NumberFormatException.forInputString(s, radix);
        }
        throw new NumberFormatException(String.format("String value %s exceeds range of unsigned int.", s));
    }

    public static int parseUnsignedInt(CharSequence s, int beginIndex, int endIndex, int radix) throws NumberFormatException {
        char firstChar;
        Objects.requireNonNull(s);
        Objects.checkFromToIndex(beginIndex, endIndex, s.length());
        if (radix < 2) {
            throw new NumberFormatException(String.format("radix %s less than Character.MIN_RADIX", radix));
        }
        if (radix > 36) {
            throw new NumberFormatException(String.format("radix %s greater than Character.MAX_RADIX", radix));
        }
        if (beginIndex == endIndex) {
            throw NumberFormatException.forInputString("", radix);
        }
        int i = beginIndex;
        if ((firstChar = s.charAt(i++)) == '-') {
            throw new NumberFormatException("Illegal leading minus sign on unsigned string " + s + ".");
        }
        int digit = -256;
        if (firstChar != '+') {
            digit = Character.digit(firstChar, radix);
        }
        if (digit >= 0 || digit == -256 && endIndex - beginIndex > 1) {
            int multmax = Integer.divideUnsigned(-1, radix);
            int result = digit & 0xFF;
            boolean inRange = true;
            while (i < endIndex && (digit = Character.digit(s.charAt(i++), radix)) >= 0 && (inRange = Integer.compareUnsigned(result, multmax) < 0 || result == multmax && digit < -radix * multmax)) {
                result = radix * result + digit;
            }
            if (inRange && i == endIndex && digit >= 0) {
                return result;
            }
        }
        if (digit < 0) {
            throw NumberFormatException.forCharSequence(s, beginIndex, endIndex, i - (digit < -1 ? 0 : 1));
        }
        throw new NumberFormatException(String.format("String value %s exceeds range of unsigned int.", s));
    }

    public static int parseUnsignedInt(String s) throws NumberFormatException {
        return Integer.parseUnsignedInt(s, 10);
    }

    public static Integer valueOf(String s, int radix) throws NumberFormatException {
        return Integer.parseInt(s, radix);
    }

    public static Integer valueOf(String s) throws NumberFormatException {
        return Integer.parseInt(s, 10);
    }

    @IntrinsicCandidate
    @DeserializeConstructor
    public static Integer valueOf(int i) {
        if (i >= -128 && i <= IntegerCache.high) {
            return IntegerCache.cache[i + 128];
        }
        return new Integer(i);
    }

    @Deprecated(since="9")
    public Integer(int value) {
        this.value = value;
    }

    @Deprecated(since="9")
    public Integer(String s) throws NumberFormatException {
        this.value = Integer.parseInt(s, 10);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    @IntrinsicCandidate
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public int hashCode() {
        return Integer.hashCode(this.value);
    }

    public static int hashCode(int value) {
        return value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Integer) {
            Integer i = (Integer)obj;
            return this.value == i;
        }
        return false;
    }

    public static Integer getInteger(String nm) {
        return Integer.getInteger(nm, null);
    }

    public static Integer getInteger(String nm, int val) {
        Integer result = Integer.getInteger(nm, null);
        return result == null ? Integer.valueOf(val) : result;
    }

    public static Integer getInteger(String nm, Integer val) {
        String v;
        String string = v = nm != null && !nm.isEmpty() ? System.getProperty(nm) : null;
        if (v != null) {
            try {
                return Integer.decode(v);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return val;
    }

    public static Integer decode(String nm) throws NumberFormatException {
        int result;
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (nm.isEmpty()) {
            throw new NumberFormatException("Zero length string");
        }
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        if (nm.startsWith("0x", index) || nm.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (nm.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (nm.startsWith("0", index) && nm.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        if (nm.startsWith("-", index) || nm.startsWith("+", index)) {
            throw new NumberFormatException("Sign character in wrong position");
        }
        try {
            result = Integer.parseInt(nm, index, nm.length(), radix);
            result = negative ? -result : result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index) : nm.substring(index);
            result = Integer.parseInt(constant, radix);
        }
        return result;
    }

    @Override
    public int compareTo(Integer anotherInteger) {
        return Integer.compare(this.value, anotherInteger.value);
    }

    public static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    @IntrinsicCandidate
    public static int compareUnsigned(int x, int y) {
        return Integer.compare(x + Integer.MIN_VALUE, y + Integer.MIN_VALUE);
    }

    public static long toUnsignedLong(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    @IntrinsicCandidate
    public static int divideUnsigned(int dividend, int divisor) {
        return (int)(Integer.toUnsignedLong(dividend) / Integer.toUnsignedLong(divisor));
    }

    @IntrinsicCandidate
    public static int remainderUnsigned(int dividend, int divisor) {
        return (int)(Integer.toUnsignedLong(dividend) % Integer.toUnsignedLong(divisor));
    }

    public static int highestOneBit(int i) {
        return i & Integer.MIN_VALUE >>> Integer.numberOfLeadingZeros(i);
    }

    public static int lowestOneBit(int i) {
        return i & -i;
    }

    @IntrinsicCandidate
    public static int numberOfLeadingZeros(int i) {
        if (i <= 0) {
            return i == 0 ? 32 : 0;
        }
        int n = 31;
        if (i >= 65536) {
            n -= 16;
            i >>>= 16;
        }
        if (i >= 256) {
            n -= 8;
            i >>>= 8;
        }
        if (i >= 16) {
            n -= 4;
            i >>>= 4;
        }
        if (i >= 4) {
            n -= 2;
            i >>>= 2;
        }
        return n - (i >>> 1);
    }

    @IntrinsicCandidate
    public static int numberOfTrailingZeros(int i) {
        if ((i = ~i & i - 1) <= 0) {
            return i & 0x20;
        }
        int n = 1;
        if (i > 65536) {
            n += 16;
            i >>>= 16;
        }
        if (i > 256) {
            n += 8;
            i >>>= 8;
        }
        if (i > 16) {
            n += 4;
            i >>>= 4;
        }
        if (i > 4) {
            n += 2;
            i >>>= 2;
        }
        return n + (i >>> 1);
    }

    @IntrinsicCandidate
    public static int bitCount(int i) {
        i -= i >>> 1 & 0x55555555;
        i = (i & 0x33333333) + (i >>> 2 & 0x33333333);
        i = i + (i >>> 4) & 0xF0F0F0F;
        i += i >>> 8;
        i += i >>> 16;
        return i & 0x3F;
    }

    public static int rotateLeft(int i, int distance) {
        return i << distance | i >>> -distance;
    }

    public static int rotateRight(int i, int distance) {
        return i >>> distance | i << -distance;
    }

    @IntrinsicCandidate
    public static int reverse(int i) {
        i = (i & 0x55555555) << 1 | i >>> 1 & 0x55555555;
        i = (i & 0x33333333) << 2 | i >>> 2 & 0x33333333;
        i = (i & 0xF0F0F0F) << 4 | i >>> 4 & 0xF0F0F0F;
        return Integer.reverseBytes(i);
    }

    @IntrinsicCandidate
    public static int compress(int i, int mask) {
        i &= mask;
        int maskCount = ~mask << 1;
        for (int j = 0; j < 5; ++j) {
            int maskPrefix = Integer.parallelSuffix(maskCount);
            int maskMove = maskPrefix & mask;
            mask = mask ^ maskMove | maskMove >>> (1 << j);
            int t = i & maskMove;
            i = i ^ t | t >>> (1 << j);
            maskCount &= ~maskPrefix;
        }
        return i;
    }

    @IntrinsicCandidate
    public static int expand(int i, int mask) {
        int originalMask = mask;
        int maskCount = ~mask << 1;
        int maskPrefix = Integer.parallelSuffix(maskCount);
        int maskMove1 = maskPrefix & mask;
        mask = mask ^ maskMove1 | maskMove1 >>> 1;
        maskCount &= ~maskPrefix;
        maskPrefix = Integer.parallelSuffix(maskCount);
        int maskMove2 = maskPrefix & mask;
        mask = mask ^ maskMove2 | maskMove2 >>> 2;
        maskCount &= ~maskPrefix;
        maskPrefix = Integer.parallelSuffix(maskCount);
        int maskMove3 = maskPrefix & mask;
        mask = mask ^ maskMove3 | maskMove3 >>> 4;
        maskCount &= ~maskPrefix;
        maskPrefix = Integer.parallelSuffix(maskCount);
        int maskMove4 = maskPrefix & mask;
        mask = mask ^ maskMove4 | maskMove4 >>> 8;
        maskCount &= ~maskPrefix;
        maskPrefix = Integer.parallelSuffix(maskCount);
        int maskMove5 = maskPrefix & mask;
        int t = i << 16;
        i = i & ~maskMove5 | t & maskMove5;
        t = i << 8;
        i = i & ~maskMove4 | t & maskMove4;
        t = i << 4;
        i = i & ~maskMove3 | t & maskMove3;
        t = i << 2;
        i = i & ~maskMove2 | t & maskMove2;
        t = i << 1;
        i = i & ~maskMove1 | t & maskMove1;
        return i & originalMask;
    }

    @ForceInline
    private static int parallelSuffix(int maskCount) {
        int maskPrefix = maskCount ^ maskCount << 1;
        maskPrefix ^= maskPrefix << 2;
        maskPrefix ^= maskPrefix << 4;
        maskPrefix ^= maskPrefix << 8;
        maskPrefix ^= maskPrefix << 16;
        return maskPrefix;
    }

    public static int signum(int i) {
        return i >> 31 | -i >>> 31;
    }

    @IntrinsicCandidate
    public static int reverseBytes(int i) {
        return i << 24 | (i & 0xFF00) << 8 | i >>> 8 & 0xFF00 | i >>> 24;
    }

    public static int sum(int a, int b) {
        return a + b;
    }

    public static int max(int a, int b) {
        return Math.max(a, b);
    }

    public static int min(int a, int b) {
        return Math.min(a, b);
    }

    public Optional<Integer> describeConstable() {
        return Optional.of(this);
    }

    @Override
    public Integer resolveConstantDesc(MethodHandles.Lookup lookup) {
        return this;
    }

    private static final class IntegerCache {
        static final int low = -128;
        static final int high;
        @Stable
        static final Integer[] cache;
        static Integer[] archivedCache;

        private IntegerCache() {
        }

        static {
            int h = 127;
            String integerCacheHighPropValue = VM.getSavedProperty("java.lang.Integer.IntegerCache.high");
            if (integerCacheHighPropValue != null) {
                try {
                    h = Math.max(Integer.parseInt(integerCacheHighPropValue), 127);
                    h = Math.min(h, 0x7FFFFF7E);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            high = h;
            CDS.initializeFromArchive(IntegerCache.class);
            int size = high - -128 + 1;
            if (archivedCache == null || size > archivedCache.length) {
                int i;
                Integer[] c = new Integer[size];
                int j = -128;
                int archivedSize = archivedCache == null ? 0 : archivedCache.length;
                for (i = 0; i < archivedSize; ++i) {
                    c[i] = archivedCache[i];
                    assert (j == archivedCache[i]);
                    ++j;
                }
                for (i = archivedSize; i < size; ++i) {
                    c[i] = new Integer(j++);
                }
                archivedCache = c;
            }
            cache = archivedCache;
            assert (high >= 127);
        }
    }
}

