/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.registration.servlet;

import com.sun.management.services.common.Debug;
import com.sun.management.services.logging.ConsoleLogService;
import com.sun.management.services.registration.MgmtAppRegistrationService;
import com.sun.management.services.registration.MgmtAppRegistrationServiceFactory;
import com.sun.management.services.registration.RegistrationException;
import com.sun.management.services.registration.RegistrationInfo;
import com.sun.management.services.registration.RegistrationUtil;
import com.sun.management.services.registration.WebXmlParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xml.sax.InputSource;

public class WebConsoleRegistrarServlet
extends HttpServlet {
    private MgmtAppRegistrationService registrationSvc = null;
    private Logger logger;
    private static final String SERVLET_NAME = "WebConsoleRegistrarServlet";
    private static final String DTD_START = "<!DOCTYPE";
    private static final String DTD_END_DQ = "web-app_2_3.dtd\">";
    private static final String DTD_END_SQ = "web-app_2_3.dtd'>";
    private static final String RESOURCE_PKG = "com.sun.management.services.registration.servlet.resources.Resources";
    private static final String APP_FILTER_CLASS = "com.sun.management.services.session.AppSessionManagerFilter";
    private static final String CONSOLE_FILTER_CLASS = "com.sun.management.services.session.WebConsoleSMFilter";
    private static final String CONSOLE_PLUGIN_NAME = "com.sun.web.console";
    private static final String COMMON_PLUGIN_NAME = "com.sun.web.ui";
    private static final String PLUGIN_NAME = "com_sun_web_console_plugin_name";
    private static final String CONF_DIR_NAME = "conf";
    private static final String WEB_XML_FILE = "web.xml";

    public void init(ServletConfig servletConfig) throws ServletException {
        block10: {
            super.init(servletConfig);
            try {
                Object object;
                int n;
                this.logger = ConsoleLogService.getConsoleLogger();
                ServletContext servletContext = this.getServletContext();
                if (servletContext == null) {
                    Debug.trace1((String)"Servlet context is null");
                    this.writeLogRecord(Level.SEVERE, "init", "log_context_null", null);
                    return;
                }
                String string = "/WEB-INF/lib/registrationservlet.jar";
                String string2 = null;
                URL uRL = servletContext.getResource(string);
                if (uRL != null && (n = ((String)(object = uRL.getPath())).indexOf(string)) > 0 && (n = ((String)(object = ((String)object).substring(0, n))).lastIndexOf(47)) >= 0) {
                    string2 = ((String)object).substring(n + 1);
                }
                object = MgmtAppRegistrationServiceFactory.getRegistrationService();
                InputStream inputStream = servletContext.getResourceAsStream("/WEB-INF/app.xml");
                if (inputStream == null && (inputStream = servletContext.getResourceAsStream("/app.xml")) == null) {
                    Debug.trace1((String)"no app.xml found for this app");
                    this.writeLogRecord(Level.SEVERE, "init", "log_no_app_xml", null);
                    return;
                }
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                RegistrationInfo registrationInfo = null;
                try {
                    registrationInfo = object.parseDescriptor((Reader)inputStreamReader);
                }
                catch (RegistrationException registrationException) {
                    string2 = string2 != null ? string2 : "unknown";
                    StringBuffer stringBuffer = new StringBuffer("Problem parsing application descriptor file for ").append(string2).append(".\n").append(registrationException.getLocalizedMessage());
                    throw new RegistrationException(stringBuffer.toString());
                }
                String string3 = registrationInfo.getManagementApp().getPluginName();
                if (this.checkDefaultContext(servletContext, string2, registrationInfo)) {
                    return;
                }
                if (!this.checkFilterStatus(servletContext, string3)) break block10;
                object.registerApp(registrationInfo, string2);
                servletContext.setAttribute(PLUGIN_NAME, (Object)string3);
                try {
                    ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
                    RegistrationUtil.setAppLoader((String)string3, (ClassLoader)classLoader);
                }
                catch (Exception exception) {
                    Debug.trace1((String)("Exception getting classloader for " + string3), (Throwable)exception);
                }
                Debug.trace1((String)(string3 + " was registered successfully!"));
                this.writeLogRecord(Level.INFO, "init", "log_app_success", string3);
                inputStreamReader.close();
                inputStream.close();
            }
            catch (Exception exception) {
                this.writeLogRecord(Level.SEVERE, "init", "log_cannot_register", exception.getMessage());
            }
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.sendError(404);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.sendError(404);
    }

    public void destroy() {
        ServletConfig servletConfig;
        this.logger = ConsoleLogService.getConsoleLogger();
        String string = null;
        ServletContext servletContext = this.getServletContext();
        if (servletContext != null) {
            string = (String)servletContext.getAttribute(PLUGIN_NAME);
        }
        if (string == null) {
            Debug.trace1((String)"Servlet context is null in destroy...");
            servletConfig = this.getServletConfig();
            if (servletConfig != null) {
                string = servletConfig.getInitParameter("pluginName") + "_" + servletConfig.getInitParameter("version");
            } else {
                Debug.trace1((String)"Servlet config is null in destroy...");
            }
        }
        if (string != null) {
            Debug.trace3((String)("begin unregistering " + string));
            try {
                servletConfig = MgmtAppRegistrationServiceFactory.getRegistrationService();
                if (servletConfig.isAppRegistered(string)) {
                    servletConfig.unregisterApp(string);
                    Debug.trace1((String)(string + " unregistered successfully"));
                    this.writeLogRecord(Level.INFO, "destroy", "log_app_unreg", string);
                }
            }
            catch (Exception exception) {
                Debug.trace1((String)("exception during destroy " + exception));
            }
        }
    }

    private boolean checkDefaultContext(ServletContext servletContext, String string, RegistrationInfo registrationInfo) {
        String string2;
        boolean bl = false;
        String string3 = servletContext.getInitParameter("com.sun.web.console.defaultcontext");
        if (string3 != null && string3.equals("true") && (string2 = registrationInfo.getUrlDesc().getUrl()) != null) {
            int n;
            if (string2.startsWith("/")) {
                string2 = string2.substring(1);
            }
            if ((n = string2.indexOf("/")) >= 0) {
                string2 = string2.substring(0, n);
            }
            if (!(string2 == null || string != null && string.equals(string2))) {
                Debug.trace1((String)("Default context app is " + string2));
                bl = true;
            }
        }
        return bl;
    }

    private boolean checkFilterStatus(ServletContext servletContext, String string) throws Exception {
        BufferedReader bufferedReader = null;
        String string2 = null;
        Object var7_5 = null;
        try {
            Object object;
            InputStream inputStream = servletContext.getResourceAsStream("/WEB-INF/web.xml");
            if (inputStream == null) {
                this.writeLogRecord(Level.SEVERE, "checkFilterStatus", "log_cannot_check_filter", null);
                Debug.trace1((String)("could not read web.xml for " + string));
                return false;
            }
            Debug.trace3((String)"reading web.xml to check for filter...");
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            if (bufferedReader == null) {
                this.writeLogRecord(Level.SEVERE, "checkFilterStatus", "log_cannot_check_filter", null);
                return false;
            }
            StringWriter stringWriter = new StringWriter();
            boolean bl = false;
            string2 = bufferedReader.readLine();
            while (string2 != null) {
                object = string2.trim();
                if (((String)object).startsWith(DTD_START)) {
                    bl = true;
                }
                if (!bl) {
                    stringWriter.write((String)object);
                }
                if (((String)object).endsWith(DTD_END_DQ) || ((String)object).endsWith(DTD_END_SQ)) {
                    bl = false;
                }
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
            object = new StringReader(stringWriter.toString());
            InputSource inputSource = new InputSource((Reader)object);
            WebXmlParser webXmlParser = new WebXmlParser();
            webXmlParser.parse(inputSource);
            if (!webXmlParser.isFilterSet()) {
                Debug.trace1((String)"Filter has not been set properly");
                this.writeLogRecord(Level.SEVERE, "checkFilterStatus", "log_no_filter", string);
                return false;
            }
            String string3 = webXmlParser.getFilterImplClassName();
            if (string.indexOf(CONSOLE_PLUGIN_NAME) != -1 || string.indexOf(COMMON_PLUGIN_NAME) != -1) {
                if (!string3.equals(CONSOLE_FILTER_CLASS)) {
                    this.writeLogRecord(Level.SEVERE, "checkFilterStatus", "log_improper_filter", string);
                    return false;
                }
            } else if (!string3.equals(APP_FILTER_CLASS)) {
                this.writeLogRecord(Level.SEVERE, "checkFilterStatus", "log_improper_filter", string);
                return false;
            }
            try {
                ((StringReader)object).close();
                stringWriter.close();
            }
            catch (IOException iOException) {
                Debug.trace1((String)("error closing web.xml of " + string), (Throwable)iOException);
            }
            return true;
        }
        catch (Exception exception) {
            Debug.trace1((String)("error reading web.xml for " + string), (Throwable)exception);
            this.writeLogRecord(Level.SEVERE, "checkFilterStatus", "log_generic_filter", exception.getMessage());
            return false;
        }
    }

    private void writeLogRecord(Level level, String string, String string2, String string3) {
        try {
            if (string3 == null) {
                this.logger.logrb(level, SERVLET_NAME, string, RESOURCE_PKG, string2);
            } else {
                this.logger.logrb(level, SERVLET_NAME, string, RESOURCE_PKG, string2, (Object)string3);
            }
        }
        catch (Exception exception) {
            Debug.trace1((String)("Error while logging: " + exception.getLocalizedMessage()));
        }
    }
}

