/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.util.Enumeration;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.AVT;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemUse;
import org.apache.xalan.templates.NamespaceAlias;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.templates.XSLTVisitor;
import org.apache.xalan.transformer.ResultTreeHandler;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.StringVector;
import org.apache.xpath.XPathContext;
import org.xml.sax.SAXException;

public class ElemLiteralResult
extends ElemUse {
    private boolean isLiteralResultAsStylesheet = false;
    private Vector m_avts = null;
    private Vector m_xslAttr = null;
    private String m_namespace;
    private String m_localName;
    private String m_rawName;
    private StringVector m_ExtensionElementURIs;
    private String m_version;
    private StringVector m_excludeResultPrefixes;

    public void setIsLiteralResultAsStylesheet(boolean b) {
        this.isLiteralResultAsStylesheet = b;
    }

    public boolean getIsLiteralResultAsStylesheet() {
        return this.isLiteralResultAsStylesheet;
    }

    public void compose(StylesheetRoot sroot) throws TransformerException {
        super.compose(sroot);
        StylesheetRoot.ComposeState cstate = sroot.getComposeState();
        Vector vnames = cstate.getVariableNames();
        if (null != this.m_avts) {
            int nAttrs = this.m_avts.size();
            int i = nAttrs - 1;
            while (i >= 0) {
                AVT avt = (AVT)this.m_avts.elementAt(i);
                avt.fixupVariables(vnames, cstate.getGlobalsSize());
                --i;
            }
        }
    }

    public void addLiteralResultAttribute(AVT avt) {
        if (null == this.m_avts) {
            this.m_avts = new Vector();
        }
        this.m_avts.addElement(avt);
    }

    public void addLiteralResultAttribute(String att) {
        if (null == this.m_xslAttr) {
            this.m_xslAttr = new Vector();
        }
        this.m_xslAttr.addElement(att);
    }

    public void setXmlSpace(AVT avt) {
        this.addLiteralResultAttribute(avt);
        String val = avt.getSimpleString();
        if (val.equals("default")) {
            super.setXmlSpace(2);
        } else if (val.equals("preserve")) {
            super.setXmlSpace(1);
        }
    }

    public AVT getLiteralResultAttribute(String name) {
        if (null != this.m_avts) {
            int nAttrs = this.m_avts.size();
            int i = nAttrs - 1;
            while (i >= 0) {
                AVT avt = (AVT)this.m_avts.elementAt(i);
                if (avt.getRawName().equals(name)) {
                    return avt;
                }
                --i;
            }
        }
        return null;
    }

    public boolean containsExcludeResultPrefix(String prefix, String uri) {
        if (uri == null || null == this.m_excludeResultPrefixes && null == this.m_ExtensionElementURIs) {
            return super.containsExcludeResultPrefix(prefix, uri);
        }
        if (prefix.length() == 0) {
            prefix = "#default";
        }
        if (this.m_excludeResultPrefixes != null) {
            int i = 0;
            while (i < this.m_excludeResultPrefixes.size()) {
                if (uri.equals(this.getNamespaceForPrefix(this.m_excludeResultPrefixes.elementAt(i)))) {
                    return true;
                }
                ++i;
            }
        }
        if (this.m_ExtensionElementURIs != null && this.m_ExtensionElementURIs.contains(uri)) {
            return true;
        }
        return super.containsExcludeResultPrefix(prefix, uri);
    }

    public void resolvePrefixTables() throws TransformerException {
        NamespaceAlias nsa;
        super.resolvePrefixTables();
        StylesheetRoot stylesheet = this.getStylesheetRoot();
        if (null != this.m_namespace && this.m_namespace.length() > 0 && null != (nsa = stylesheet.getNamespaceAliasComposed(this.m_namespace))) {
            this.m_namespace = nsa.getResultNamespace();
            String resultPrefix = nsa.getStylesheetPrefix();
            this.m_rawName = null != resultPrefix && resultPrefix.length() > 0 ? resultPrefix + ":" + this.m_localName : this.m_localName;
        }
        if (null != this.m_avts) {
            int n = this.m_avts.size();
            int i = 0;
            while (i < n) {
                NamespaceAlias nsa2;
                AVT avt = (AVT)this.m_avts.elementAt(i);
                String ns = avt.getURI();
                if (null != ns && ns.length() > 0 && null != (nsa2 = stylesheet.getNamespaceAliasComposed(this.m_namespace))) {
                    String namespace = nsa2.getResultNamespace();
                    String resultPrefix = nsa2.getStylesheetPrefix();
                    String rawName = avt.getName();
                    if (null != resultPrefix && resultPrefix.length() > 0) {
                        rawName = resultPrefix + ":" + rawName;
                    }
                    avt.setURI(namespace);
                    avt.setRawName(rawName);
                }
                ++i;
            }
        }
    }

    boolean needToCheckExclude() {
        if (null == this.m_excludeResultPrefixes && null == this.m_prefixTable && this.m_ExtensionElementURIs == null) {
            return false;
        }
        if (null == this.m_prefixTable) {
            this.m_prefixTable = new Vector();
        }
        return true;
    }

    public void setNamespace(String ns) {
        if (null == ns) {
            ns = "";
        }
        this.m_namespace = ns;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public void setLocalName(String localName) {
        this.m_localName = localName;
    }

    public String getLocalName() {
        return this.m_localName;
    }

    public void setRawName(String rawName) {
        this.m_rawName = rawName;
    }

    public String getRawName() {
        return this.m_rawName;
    }

    public String getPrefix() {
        int len = this.m_rawName.length() - this.m_localName.length() - 1;
        return len > 0 ? this.m_rawName.substring(0, len) : "";
    }

    public void setExtensionElementPrefixes(StringVector v) {
        this.m_ExtensionElementURIs = v;
    }

    public String getExtensionElementPrefix(int i) throws ArrayIndexOutOfBoundsException {
        if (null == this.m_ExtensionElementURIs) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.m_ExtensionElementURIs.elementAt(i);
    }

    public int getExtensionElementPrefixCount() {
        return null != this.m_ExtensionElementURIs ? this.m_ExtensionElementURIs.size() : 0;
    }

    public boolean containsExtensionElementURI(String uri) {
        if (null == this.m_ExtensionElementURIs) {
            return false;
        }
        return this.m_ExtensionElementURIs.contains(uri);
    }

    public int getXSLToken() {
        return 77;
    }

    public String getNodeName() {
        return this.m_rawName;
    }

    public void setVersion(String v) {
        this.m_version = v;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setExcludeResultPrefixes(StringVector v) {
        this.m_excludeResultPrefixes = v;
    }

    private boolean excludeResultNSDecl(String prefix, String uri) throws TransformerException {
        if (null != this.m_excludeResultPrefixes) {
            return this.containsExcludeResultPrefix(prefix, uri);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(TransformerImpl transformer) throws TransformerException {
        try {
            ResultTreeHandler rhandler = transformer.getResultTreeHandler();
            rhandler.startPrefixMapping(this.getPrefix(), this.getNamespace());
            this.executeNSDecls(transformer);
            rhandler.startElement(this.getNamespace(), this.getLocalName(), this.getRawName(), null);
            try {
                super.execute(transformer);
                if (null != this.m_avts) {
                    int nAttrs = this.m_avts.size();
                    int i = nAttrs - 1;
                    while (i >= 0) {
                        int sourceNode;
                        XPathContext xctxt;
                        AVT avt = (AVT)this.m_avts.elementAt(i);
                        String stringedValue = avt.evaluate(xctxt = transformer.getXPathContext(), sourceNode = xctxt.getCurrentNode(), this);
                        if (null != stringedValue) {
                            rhandler.addAttribute(avt.getURI(), avt.getName(), avt.getRawName(), "CDATA", stringedValue);
                        }
                        --i;
                    }
                }
                transformer.executeChildTemplates((ElemTemplateElement)this, true);
            }
            finally {
                rhandler.endElement(this.getNamespace(), this.getLocalName(), this.getRawName());
                this.unexecuteNSDecls(transformer);
                rhandler.endPrefixMapping(this.getPrefix());
            }
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
    }

    public Enumeration enumerateLiteralResultAttributes() {
        return null == this.m_avts ? null : this.m_avts.elements();
    }

    protected boolean accept(XSLTVisitor visitor) {
        return visitor.visitLiteralResultElement(this);
    }

    protected void callChildVisitors(XSLTVisitor visitor, boolean callAttrs) {
        if (callAttrs && null != this.m_avts) {
            int nAttrs = this.m_avts.size();
            int i = nAttrs - 1;
            while (i >= 0) {
                AVT avt = (AVT)this.m_avts.elementAt(i);
                avt.callVisitors(visitor);
                --i;
            }
        }
        super.callChildVisitors(visitor, callAttrs);
    }
}

