/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.SourceFileScanner;
import org.netbeans.nbbuild.L10nTask;

public class GetL9eFiles
extends Task {
    protected String listFile = "l10n.list";
    protected String baseDir = "..";
    protected File grandParent = null;
    protected File targetDir = null;
    protected String excludes = "**/ja/,**/*_ja.*";
    protected FileUtils fileUtils = null;
    static /* synthetic */ Class class$org$netbeans$nbbuild$L10nTask;

    public void setBaseDir(String string) {
        this.baseDir = string;
        File file = new File(this.antBaseDir() + this.baseDir);
        try {
            this.grandParent = new File(file.getCanonicalPath());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BuildException();
        }
    }

    public void setListFile(String string) {
        this.listFile = string;
    }

    public void setTargetDir(File file) {
        this.targetDir = file;
    }

    public void setExcludes(String string) {
        this.excludes = string;
    }

    public void execute() throws BuildException {
        if (this.targetDir == null) {
            this.targetDir = new File(this.antBaseDir() + "src-todo");
        }
        if (this.grandParent == null) {
            this.setBaseDir(this.baseDir);
        }
        LinkedList linkedList = this.getModulesWithListFiles();
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            File file = (File)listIterator.next();
            this.copyL9eFiles(file);
        }
    }

    protected void copyL9eFiles(File file) {
        String[] stringArray;
        if (this.fileUtils == null) {
            this.fileUtils = FileUtils.newFileUtils();
        }
        this.project.addTaskDefinition("l10nTask", class$org$netbeans$nbbuild$L10nTask == null ? (class$org$netbeans$nbbuild$L10nTask = GetL9eFiles.class$("org.netbeans.nbbuild.L10nTask")) : class$org$netbeans$nbbuild$L10nTask);
        L10nTask l10nTask = (L10nTask)this.project.createTask("l10nTask");
        l10nTask.init();
        l10nTask.setLocalizableFile(this.listFile);
        l10nTask.setExcludePattern(this.excludes);
        String[] stringArray2 = l10nTask.getLocalizableFiles(this.grandParent, file.getName());
        if (stringArray2 != null && (stringArray = this.getChangedFiles(stringArray2)) != null && stringArray.length > 0) {
            this.log("Copying " + stringArray.length + " files to " + this.targetDir.getPath());
            int n = 0;
            while (n < stringArray.length) {
                File file2 = new File(stringArray[n]);
                File file3 = new File(GetL9eFiles.mapL9eFile(stringArray[n], this.targetDir.getPath(), this.grandParent.getPath()));
                try {
                    this.fileUtils.copyFile(file2, file3);
                }
                catch (IOException iOException) {
                    String string = "Failed to copy " + file2.getPath() + " to " + file3.getPath() + " due to " + iOException.getMessage();
                    throw new BuildException(string, (Throwable)iOException, this.location);
                }
                ++n;
            }
        }
    }

    protected String[] getChangedFiles(String[] stringArray) {
        L9eMapper l9eMapper = new L9eMapper();
        l9eMapper.setFrom(this.grandParent.getPath());
        l9eMapper.setTo(this.targetDir.getPath());
        SourceFileScanner sourceFileScanner = new SourceFileScanner((Task)this);
        return sourceFileScanner.restrict(stringArray, null, null, (FileNameMapper)l9eMapper);
    }

    protected static String mapL9eFile(String string, String string2, String string3) {
        return string2 + string.substring(string3.length());
    }

    protected LinkedList getModulesWithListFiles() {
        LinkedList<File> linkedList = new LinkedList<File>();
        File[] fileArray = this.grandParent.listFiles(new DirectoryFilter());
        int n = 0;
        while (n < fileArray.length) {
            File file = fileArray[n];
            File file2 = new File(file.getPath() + File.separator + this.listFile);
            if (file2.exists()) {
                linkedList.add(file);
            }
            ++n;
        }
        return linkedList;
    }

    protected String antBaseDir() {
        return this.getProject().getBaseDir().getAbsolutePath() + File.separator;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class L9eMapper
    implements FileNameMapper {
        protected String m_grandParent;
        protected String m_toDir;

        protected L9eMapper() {
        }

        public void setFrom(String string) {
            this.m_grandParent = string;
        }

        public void setTo(String string) {
            this.m_toDir = string;
        }

        public String[] mapFileName(String string) {
            return new String[]{GetL9eFiles.mapL9eFile(string, this.m_toDir, this.m_grandParent)};
        }
    }

    class TarFileFilter
    implements FileFilter {
        TarFileFilter() {
        }

        public boolean accept(File file) {
            return file.getName().endsWith(".tar");
        }
    }

    class DirectoryFilter
    implements FileFilter {
        DirectoryFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory();
        }
    }
}

