/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class NbEnhanceClass
extends Task {
    private Path patchPath;
    private String patchClass = "org.netbeans.PatchByteCode";
    private String enhanceMethod = "enhanceClass";
    private File basedir;
    private ArrayList patches = new ArrayList();
    private static /* synthetic */ Class array$B;
    private static /* synthetic */ Class class$Ljava$util$Map;

    public Path createClasspath() {
        if (this.patchPath == null) {
            this.patchPath = new Path(this.getProject());
        }
        return this.patchPath.createPath();
    }

    public void setPatchClass(String f) {
        this.patchClass = f;
    }

    public void setEnhanceMethod(String f) {
        this.enhanceMethod = f;
    }

    public void setBasedir(File f) {
        this.basedir = f;
    }

    public Patch createPatch() {
        Patch n = new Patch();
        this.patches.add(n);
        return n;
    }

    public void execute() throws BuildException {
        Method m;
        if (this.basedir == null) {
            throw new BuildException("Attribute basedir must be specified");
        }
        if (this.patches.isEmpty()) {
            return;
        }
        AntClassLoader cl = new AntClassLoader(this.getProject(), this.patchPath, false);
        try {
            Class<?> c = cl.loadClass(this.patchClass);
            m = c.getMethod(this.enhanceMethod, array$B != null ? array$B : (array$B = NbEnhanceClass.class$("[B")), class$Ljava$util$Map != null ? class$Ljava$util$Map : (class$Ljava$util$Map = NbEnhanceClass.class$("java.util.Map")));
            if (m.getReturnType() != (array$B != null ? array$B : (array$B = NbEnhanceClass.class$("[B")))) {
                throw new BuildException("Method does not return byte[]: " + m);
            }
        }
        catch (Exception ex) {
            throw new BuildException("Cannot initialize class " + this.patchClass + " and method " + this.enhanceMethod, (Throwable)ex);
        }
        Iterator it = ((AbstractList)this.patches).iterator();
        while (it.hasNext()) {
            byte[] out;
            Patch p = (Patch)it.next();
            if (p.clazz == null) {
                throw new BuildException("Attribute class must be specified");
            }
            File f = new File(this.basedir, p.clazz + ".class");
            if (!f.exists()) {
                throw new BuildException("File " + f + " for class " + p.clazz + " does not exists");
            }
            byte[] arr = new byte[(int)f.length()];
            try {
                FileInputStream is = new FileInputStream(f);
                if (arr.length != is.read(arr)) {
                    throw new BuildException("Not all bytes read");
                }
                is.close();
            }
            catch (IOException ex) {
                throw new BuildException("Cannot read file " + f, (Throwable)ex);
            }
            ArrayList<String> members = null;
            ArrayList<String> rename = null;
            if (p.members != null) {
                members = new ArrayList<String>();
                Iterator myIt = ((AbstractList)p.members).iterator();
                boolean i = false;
                while (myIt.hasNext()) {
                    Patch.Member mem = (Patch.Member)myIt.next();
                    members.add(mem.name);
                    if (mem.rename == null) continue;
                    if (rename == null) {
                        rename = new ArrayList<String>();
                    }
                    rename.add(mem.name);
                    rename.add(mem.rename);
                }
            }
            try {
                HashMap<String, Object> args = new HashMap<String, Object>();
                if (p.nbSuperClass != null) {
                    args.put("netbeans.superclass", p.nbSuperClass);
                }
                if (members != null) {
                    args.put("netbeans.public", members);
                }
                if (rename != null) {
                    args.put("netbeans.rename", rename);
                }
                this.log("Patching " + p.clazz + " with arguments " + args, 3);
                out = (byte[])m.invoke(null, arr, args);
                if (out == null) {
                    continue;
                }
            }
            catch (Exception ex) {
                throw new BuildException((Throwable)ex);
            }
            if (p.nbSuperClass != null) {
                this.log("Enhanced " + f + " to have alternate superclass " + p.nbSuperClass + " and be public");
            } else {
                this.log("Enhanced " + f + " to be public");
            }
            try {
                FileOutputStream os = new FileOutputStream(f);
                os.write(out);
                os.close();
            }
            catch (IOException ex) {
                throw new BuildException("Cannot overwrite file " + f, (Throwable)ex);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Patch {
        String clazz;
        String nbSuperClass;
        ArrayList members;

        public void setClass(String s) {
            this.clazz = s;
        }

        public void setSuper(String s) {
            this.nbSuperClass = s;
        }

        public Object createMember() {
            Member m = new Member();
            if (this.members == null) {
                this.members = new ArrayList();
            }
            this.members.add(m);
            return m;
        }

        public static final class Member {
            String name;
            String rename;

            public void setName(String s) {
                this.name = s;
            }

            public void setRename(String s) {
                this.rename = s;
            }
        }
    }
}

