/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.Mkdir;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Path;
import org.netbeans.nbbuild.JHIndexer;

public class JHIndexer
extends MatchingTask {
    private Path classpath;
    private File db;
    private File basedir;
    private String locale;
    private List brandings = new LinkedList();

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setDb(File db) {
        this.db = db;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void addBrandedFileSet(BrandedFileSet s) {
        this.brandings.add(s);
    }

    public void setJhall(File f) {
        this.log("The 'jhall' attribute to <jhindexer> is deprecated. Use a nested <classpath> instead.", 1);
        this.createClasspath().setLocation(f);
    }

    public void execute() throws BuildException {
        Object os;
        if (this.classpath == null) {
            throw new BuildException("Must specify the classpath attribute to find jhall.jar");
        }
        if (this.db == null) {
            throw new BuildException("Must specify the db attribute");
        }
        if (this.basedir == null) {
            throw new BuildException("Must specify the basedir attribute");
        }
        DirectoryScanner scanner = this.getDirectoryScanner(this.basedir);
        scanner.scan();
        String[] files = scanner.getIncludedFiles();
        if (this.basedir.exists() && this.db.exists()) {
            long lastModified = Long.MIN_VALUE;
            DirectoryScanner output = new DirectoryScanner();
            output.setBasedir(this.db);
            output.scan();
            String[] outfiles = output.getIncludedFiles();
            if (outfiles.length > 0) {
                int i = 0;
                while (i < outfiles.length) {
                    long mod = new File(this.db, outfiles[i]).lastModified();
                    if (mod > lastModified) {
                        lastModified = mod;
                    }
                    ++i;
                }
                boolean ok = true;
                int i2 = 0;
                while (i2 < files.length) {
                    long mod = new File(this.basedir, files[i2]).lastModified();
                    if (mod > lastModified) {
                        ok = false;
                        break;
                    }
                    ++i2;
                }
                if (!this.brandings.isEmpty()) {
                    Iterator it = this.brandings.iterator();
                    block10: while (it.hasNext()) {
                        FileSet fs = (FileSet)it.next();
                        DirectoryScanner scanner2 = fs.getDirectoryScanner(this.getProject());
                        String[] files2 = scanner2.getIncludedFiles();
                        int i3 = 0;
                        while (i3 < files2.length) {
                            long mod = new File(this.basedir, files2[i3]).lastModified();
                            if (mod > lastModified) {
                                ok = false;
                                continue block10;
                            }
                            ++i3;
                        }
                    }
                }
                if (ok) {
                    return;
                }
            }
        }
        Delete delete = (Delete)((ProjectComponent)this).project.createTask("delete");
        delete.setDir(this.db);
        delete.init();
        delete.setLocation(((Task)this).location);
        delete.execute();
        Mkdir mkdir = (Mkdir)((ProjectComponent)this).project.createTask("mkdir");
        mkdir.setDir(this.db);
        mkdir.init();
        mkdir.setLocation(((Task)this).location);
        mkdir.execute();
        String maxbranding = null;
        if (!this.brandings.isEmpty()) {
            File tmp = new File(System.getProperty("java.io.tmpdir"), "jhindexer-branding-merge");
            delete = (Delete)((ProjectComponent)this).project.createTask("delete");
            delete.setDir(tmp);
            delete.init();
            delete.setLocation(((Task)this).location);
            delete.execute();
            tmp.mkdir();
            Copy copy = (Copy)((ProjectComponent)this).project.createTask("copy");
            copy.setTodir(tmp);
            copy.addFileset(this.fileset);
            copy.init();
            copy.setLocation(((Task)this).location);
            copy.execute();
            JHIndexer jHIndexer = this;
            if (jHIndexer == null) {
                throw null;
            }
            class BrandingLengthComparator
            implements Comparator {
                private final /* synthetic */ JHIndexer this$0;

                public int compare(Object a, Object b) {
                    return ((BrandedFileSet)((Object)a)).branding.length() - ((BrandedFileSet)((Object)b)).branding.length();
                }

                /* synthetic */ BrandingLengthComparator(JHIndexer this$0) {
                    this.this$0 = this$0;
                    this.constructor$0(this$0);
                }

                private final void constructor$0(JHIndexer jHIndexer) {
                }
            }
            Collections.sort(this.brandings, new BrandingLengthComparator(jHIndexer));
            Iterator it = this.brandings.iterator();
            while (it.hasNext()) {
                BrandedFileSet s = (BrandedFileSet)((Object)it.next());
                if (maxbranding != null && !s.branding.startsWith(maxbranding + "_")) {
                    throw new BuildException("Illegal branding: " + s.branding, ((Task)this).location);
                }
                maxbranding = s.branding;
                String[] suffixes = new String[]{".html", ".htm", ".xhtml"};
                int i = 0;
                while (i < suffixes.length) {
                    String suffix = suffixes[i];
                    copy = (Copy)((ProjectComponent)this).project.createTask("copy");
                    copy.setTodir(tmp);
                    copy.setOverwrite(true);
                    copy.addFileset((FileSet)s);
                    Mapper m = copy.createMapper();
                    Mapper.MapperType mt = new Mapper.MapperType();
                    mt.setValue("glob");
                    m.setType(mt);
                    m.setFrom("*_" + s.branding + suffix);
                    m.setTo("*" + suffix);
                    copy.init();
                    copy.setLocation(((Task)this).location);
                    copy.execute();
                    if (this.locale != null) {
                        suffix = "_" + this.locale + suffix;
                        copy = (Copy)((ProjectComponent)this).project.createTask("copy");
                        copy.setTodir(tmp);
                        copy.setOverwrite(true);
                        copy.addFileset((FileSet)s);
                        m = copy.createMapper();
                        mt = new Mapper.MapperType();
                        mt.setValue("glob");
                        m.setType(mt);
                        m.setFrom("*_" + s.branding + suffix);
                        m.setTo("*" + suffix);
                        copy.init();
                        copy.setLocation(((Task)this).location);
                        copy.execute();
                    }
                    ++i;
                }
            }
            this.basedir = tmp;
            FileSet tmpf = new FileSet();
            tmpf.setProject(((ProjectComponent)this).project);
            tmpf.setDir(tmp);
            files = tmpf.getDirectoryScanner(((ProjectComponent)this).project).getIncludedFiles();
        }
        this.log("Running JavaHelp search database indexer...");
        try {
            File config = File.createTempFile("jhindexer-config", ".txt");
            try {
                os = new FileOutputStream(config);
                try {
                    PrintWriter pw = new PrintWriter((OutputStream)os);
                    pw.println("IndexRemove " + this.basedir + File.separator);
                    String message = "Files to be indexed:";
                    int i = 0;
                    while (i < files.length) {
                        String path = this.basedir + File.separator + files[i];
                        pw.println("File " + path);
                        message = message + "\n\t" + path;
                        ++i;
                    }
                    this.log(message, 3);
                    pw.flush();
                }
                finally {
                    Object i = null;
                    ((OutputStream)os).close();
                }
                Java java = (Java)((ProjectComponent)this).project.createTask("java");
                java.setClasspath(this.classpath);
                java.setClassname("com.sun.java.help.search.Indexer");
                java.createArg().setValue("-c");
                java.createArg().setFile(config);
                java.createArg().setValue("-db");
                java.createArg().setFile(this.db);
                if (this.locale != null) {
                    java.createArg().setValue("-locale");
                    java.createArg().setValue(this.locale);
                }
                java.setFailonerror(true);
                if (System.getProperty("org.openide.version") != null) {
                    java.setFork(true);
                }
                java.init();
                java.setLocation(((Task)this).location);
                java.execute();
            }
            finally {
                Object it = null;
                config.delete();
            }
        }
        catch (IOException ioe) {
            throw new BuildException("Could not make temporary config file", (Throwable)ioe, ((Task)this).location);
        }
        if (maxbranding != null) {
            String[] dbfiles = this.db.list();
            int i = 0;
            while (i < dbfiles.length) {
                String ext;
                String basename;
                int idx = dbfiles[i].lastIndexOf(46);
                if (idx != -1) {
                    basename = dbfiles[i].substring(0, idx);
                    os = dbfiles[i].substring(idx);
                } else {
                    basename = dbfiles[i];
                    ext = "";
                }
                File old = new File(this.db, dbfiles[i]);
                File nue = new File(this.db, basename + "_" + maxbranding + ext);
                this.log("Moving " + old + " to " + nue, 3);
                old.renameTo(nue);
                ++i;
            }
        }
    }

    public static final class BrandedFileSet
    extends FileSet {
        String branding;

        public void setBranding(String b) {
            this.branding = b;
        }
    }
}

