/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.help.HelpSet;
import javax.help.HelpSetFactory;
import javax.help.IndexItem;
import javax.help.IndexView;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.TOCItem;
import javax.help.TOCView;
import javax.help.TreeItem;
import javax.help.TreeItemFactory;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.netbeans.nbbuild.CheckLinks;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CheckHelpSets
extends Task {
    private List filesets = new ArrayList();

    public void addFileset(FileSet fs) {
        this.filesets.add(fs);
    }

    public void execute() throws BuildException {
        Iterator it = this.filesets.iterator();
        while (it.hasNext()) {
            FileSet fs = (FileSet)it.next();
            DirectoryScanner scanner = fs.getDirectoryScanner(((ProjectComponent)this).project);
            File dir = scanner.getBasedir();
            String[] files = scanner.getIncludedFiles();
            int i = 0;
            while (i < files.length) {
                File helpset = new File(dir, files[i]);
                try {
                    this.checkHelpSet(helpset);
                }
                catch (BuildException be) {
                    throw be;
                }
                catch (Exception e) {
                    throw new BuildException("Error checking helpset", (Throwable)e, new Location(helpset.getAbsolutePath()));
                }
                ++i;
            }
        }
    }

    private void checkHelpSet(File hsfile) throws Exception {
        this.log("Checking helpset: " + hsfile);
        HelpSet hs = new HelpSet(null, hsfile.toURL());
        Map map = hs.getCombinedMap();
        this.log("Parsed helpset, checking map IDs in TOC/Index navigators...");
        NavigatorView[] navs = hs.getNavigatorViews();
        int i = 0;
        while (i < navs.length) {
            String name = navs[i].getName();
            File navfile = new File(hsfile.getParentFile(), (String)navs[i].getParameters().get("data"));
            if (!navfile.exists()) {
                throw new BuildException("Navigator " + name + " not found", new Location(navfile.getAbsolutePath()));
            }
            if (navs[i] instanceof IndexView) {
                this.log("Checking index navigator " + name, 3);
                CheckHelpSets checkHelpSets = this;
                if (checkHelpSets == null) {
                    throw null;
                }
                IndexView.parse((URL)navfile.toURL(), (HelpSet)hs, (Locale)Locale.getDefault(), (TreeItemFactory)checkHelpSets.new VerifyTIFactory(hs, map, navfile, false));
            } else if (navs[i] instanceof TOCView) {
                this.log("Checking TOC navigator " + name, 3);
                CheckHelpSets checkHelpSets = this;
                if (checkHelpSets == null) {
                    throw null;
                }
                TOCView.parse((URL)navfile.toURL(), (HelpSet)hs, (Locale)Locale.getDefault(), (TreeItemFactory)checkHelpSets.new VerifyTIFactory(hs, map, navfile, true));
            } else {
                this.log("Skipping non-TOC/Index view: " + name, 3);
            }
            ++i;
        }
        this.log("Checking for duplicate map IDs...");
        CheckHelpSets checkHelpSets = this;
        if (checkHelpSets == null) {
            throw null;
        }
        HelpSet.parse((URL)hsfile.toURL(), null, (HelpSetFactory)checkHelpSets.new VerifyHSFactory());
        this.log("Checking links from help map and between HTML files...");
        Enumeration e = map.getAllIDs();
        HashSet okurls = new HashSet(1000);
        HashSet badurls = new HashSet(1000);
        HashSet cleanurls = new HashSet(1000);
        while (e.hasMoreElements()) {
            Map.ID id = (Map.ID)e.nextElement();
            URL u = map.getURLFromID(id);
            if (u == null) {
                throw new BuildException("Bogus map ID: " + id.id, new Location(hsfile.getAbsolutePath()));
            }
            this.log("Checking ID " + id.id, 3);
            CheckLinks.scan(this, id.id, u, okurls, badurls, cleanurls, false, 2, Collections.EMPTY_LIST);
        }
    }

    private final class VerifyTIFactory
    implements TreeItemFactory {
        private final HelpSet hs;
        private final Map map;
        private final File navfile;
        private final boolean toc;

        public TreeItem createItem(String str, Hashtable hashtable, HelpSet helpSet, Locale locale) {
            String target = (String)hashtable.get("target");
            if (target != null) {
                if (!this.map.isValidID(target, this.hs)) {
                    CheckHelpSets.this.log(this.navfile + ": invalid map ID: " + target, 1);
                } else {
                    CheckHelpSets.this.log("OK map ID: " + target, 3);
                }
            }
            return this.createItem();
        }

        public Enumeration listMessages() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        public void processPI(HelpSet helpSet, String str, String str2) {
        }

        public void reportMessage(String str, boolean param) {
            CheckHelpSets.this.log(str, param ? 3 : 1);
        }

        public void processDOCTYPE(String str, String str1, String str2) {
        }

        public void parsingStarted(URL uRL) {
        }

        public DefaultMutableTreeNode parsingEnded(DefaultMutableTreeNode defaultMutableTreeNode) {
            return defaultMutableTreeNode;
        }

        public TreeItem createItem() {
            if (this.toc) {
                return new TOCItem();
            }
            return new IndexItem();
        }

        public VerifyTIFactory(HelpSet hs, Map map, File navfile, boolean toc) {
            this.hs = hs;
            this.map = map;
            this.navfile = navfile;
            this.toc = toc;
        }
    }

    private final class VerifyHSFactory
    extends HelpSet.DefaultHelpSetFactory {
        private Set ids = new HashSet(1000);

        public void processMapRef(HelpSet hs, Hashtable attrs) {
            try {
                URL map = new URL(hs.getHelpSetURL(), (String)attrs.get("location"));
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(false);
                factory.setNamespaceAware(false);
                SAXParser parser = factory.newSAXParser();
                VerifyHSFactory verifyHSFactory = this;
                if (verifyHSFactory == null) {
                    throw null;
                }
                parser.parse(new InputSource(map.toExternalForm()), (HandlerBase)verifyHSFactory.new Handler(map.getFile()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        VerifyHSFactory() {
        }

        private final class Handler
        extends HandlerBase {
            private final String map;
            private final /* synthetic */ CheckHelpSets this$1;

            public void startElement(String name, AttributeList attr) {
                String target;
                if (name.equals("mapID") && (target = attr.getValue("target")) != null) {
                    if (VerifyHSFactory.this.ids.add(target)) {
                        this.this$1.log("Found map ID: " + target, 4);
                    } else {
                        this.this$1.log(this.map + ": duplicated ID: " + target, 1);
                    }
                }
            }

            public InputSource resolveEntity(String pub, String sys) throws SAXException {
                if (pub.equals("-//Sun Microsystems Inc.//DTD JavaHelp Map Version 1.0//EN")) {
                    return new InputSource(new ByteArrayInputStream(new byte[0]));
                }
                return super.resolveEntity(pub, sys);
            }

            public Handler(String map) {
                this.this$1 = CheckHelpSets.this;
                this.map = map;
            }
        }
    }
}

