/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/jmx/cmd/TargetCmd.java,v 1.3 2005/12/25 03:45:40 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:45:40 $
 */
 
package com.sun.cli.jmx.cmd;

import javax.management.ObjectName;

import com.sun.cli.util.stringifier.ArrayStringifier;

/*
	Invokes the 'list' commmand on all specified targets
 */
public class TargetCmd extends JMXCmd
{
		public
	TargetCmd( final CmdEnv env )
	{
		super( env );
	}
	
		int
	getNumRequiredOperands()
	{
		// require 1, by default
		return( 0 );
	}
	
		public String
	getUsage()
	{
		return( CmdStrings.TARGET_HELP.toString() );
	}
	
	
		void
	displayExistingTarget()
	{
		println( "Targets:\n" +  envGet( ENV_TARGET ) );
	}
	
		public static String []
	getNames( )
	{
		return( new String [] { "target", "t" } );
	}
	
		void
	warnEmptyTargets( final String [] targets )
		throws Exception
	{
		// issue warning if some targets could not be resolved to anything
		for ( int i = 0; i < targets.length; ++i )
		{
			final String	target	= targets[ i ];
			
			final ObjectName []	objects	=
				getProxy().resolveTargets( new String [] { target } );
				
			if ( objects.length == 0 )
			{
				println( "WARNING: target " +
					target + " does not resolve to any objects" );
			}
		}
	}
	
		void
	setTargets( final String [] targets )
		throws Exception
	{
		putEnvTargets( targets );
		warnEmptyTargets( targets );
	}
	
		void
	executeInternal()
		throws Exception
	{
		final String [] operands	= getOperands();
		
		assert( operands != null );
		
		if ( operands.length == 0 )
		{
			displayExistingTarget();
		}
		else
		{
			establishProxy();
			setTargets( operands );
		}
	}
}



