/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/jmx/support/InspectResultStringifier.java,v 1.3 2005/12/25 03:45:47 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:45:47 $
 */
 


package com.sun.cli.jmx.support;

import com.sun.cli.util.stringifier.*;
import com.sun.cli.jmx.support.*;

import java.lang.reflect.Array;
import javax.management.*;


public final class InspectResultStringifier implements Stringifier
{
		public
	InspectResultStringifier( )
	{
	}
	
	

		private String
	stringifyArray( Object [] a, Stringifier stringifier)
	{
		String	temp	= "";
		
		if ( Array.getLength( a ) != 0 )
		{
			temp	= "\n" + ArrayStringifier.stringify( a, "\n", stringifier);
		}
		return( temp );
	}

		public String
	stringify( Object o)
	{
		String			result	= "";
		final InspectResult	r	= (InspectResult)o;
	
		final MBeanFeatureInfoStringifierOptions options	= new MBeanFeatureInfoStringifierOptions( r.includeDescription, ",");
		
		result	= result + "--- " + r.objectInstance.getObjectName().toString() + " ---";

		if ( r.summary != null )
		{
			if ( result.length() != 0 )
			{
				result	= result + "\n";
			}

			result	= result + r.summary;
		}
		
		// Do formal terms like "Attributes" need to be I18n?  Probabably not as they are part of a specification.
		if ( r.attrInfo != null )
		{
			result	= result + "\n\n- Attributes -" +
						stringifyArray( r.attrInfo, new MBeanAttributeInfoStringifier(options) );
		}
		
		if ( r.operationsInfo != null )
		{
			result	= result + "\n\n- Operations -" +
						stringifyArray( r.operationsInfo, new MBeanOperationInfoStringifier(options) );
		}
		
		if ( r.constructorsInfo != null )
		{
			result	= result + "\n\n- Constructors -" +
						stringifyArray( r.constructorsInfo, new MBeanConstructorInfoStringifier(options) );
		}
		
		if ( r.notificationsInfo != null )
		{
			result	= result + "\n\n- Notifications -" + 
						stringifyArray( r.notificationsInfo, new MBeanNotificationInfoStringifier(options) );
		}
		
		return( result );
			
	}
}



