/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.util.io.StreamFlusher;
import java.io.File;

/**
 *  CLIProcessExecutor
 *  A simple process executor class that is used by CLI.
 *  @author  jane.young@sun.com
 *  @version  $Revision: 1.4 $
 */
public class CLIProcessExecutor
{
    Process process;

    public CLIProcessExecutor() {
        process = null;
    }
    

    /**
     * This method invokes the runtime exec
     */
    public void execute(String[] cmd) throws Exception
    {
        //process=Runtime.getRuntime().exec(cmd);
        process = new ProcessBuilder(cmd).start();
            
        // start stream flusher to push output to parent streams and null.
        StreamFlusher sfErr=new StreamFlusher(process.getErrorStream(), System.err, null);
        sfErr.start();

        // set flusher on stdout also, if not could stop with too much output
        StreamFlusher sfOut=new StreamFlusher(process.getInputStream(), System.out);
        sfOut.start();
        // must sleep for a couple of seconds, so if there is a jvm startup error,
        //the parent process
        //is around to catch and report it when the process in executed in verbose mode.
        try {
            Thread.currentThread().sleep(5000);
        }
        catch (InterruptedException ie) {
        }
    }

   /**
      return the exit value of this process.
      if process is null, then there is no process running
      therefore the return value is 0.
    */
    public int exitValue() {
        if (process == null) return -1;
        return process.exitValue();
    }

}
