/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 *  $Id: ListDomainsCommand.java,v 1.3 2005/12/25 03:46:31 tcfujii Exp $
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainsManager;

// jdk imports

/**
 *  This is a local command that creates a new domain
 *  @version  $Revision: 1.3 $
 */
public class ListDomainsCommand extends BaseLifeCycleCommand
{

    /** Creates new CreateDomainCommand */
    public ListDomainsCommand()
    {
    }


    /**
     *  An abstract method that validates the options 
     *  on the specification in the xml properties file
     *  @return true if successfull
     */
    public boolean validateOptions() throws CommandValidationException
    {
        return super.validateOptions();
    }

    
    /**
     *  An abstract method that executes the command
     *  @throws CommandException
     */
    public void runCommand() 
            throws CommandException, CommandValidationException
    {
        if (!validateOptions())
           throw new CommandValidationException("Validation failed");
        try {
            DomainConfig domainConfig = new DomainConfig(null, 
                getDomainsRoot());
            DomainsManager manager = getFeatureFactory().getDomainsManager();
            String[] domainsList = manager.listDomainsAndStatus(domainConfig);
            if (domainsList.length > 0) {
                //*bug fix for #6158809*
                //CLILogger.getInstance().printDetailMessage(
                //    getLocalizedString("ListOfDomains"));
                //*end of bug fix*
                for (int i = 0; i < domainsList.length; i++) {
                    CLILogger.getInstance().printMessage(domainsList[i]);
                }
            } else {
                CLILogger.getInstance().printDetailMessage(
                   getLocalizedString("NoDomainsToList"));
            }
            CLILogger.getInstance().printDetailMessage(getLocalizedString(
                                                       "CommandSuccessful",
                                                       new Object[] {name}));
        } catch (Exception ex) {
            CLILogger.getInstance().printDetailMessage(ex.getLocalizedMessage());
            throw new CommandException(getLocalizedString("CommandUnSuccessful",
						     new Object[] {name} ), ex);
        }
    }


}
