/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.cli.commands;

import junit.textui.TestRunner;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.framework.Test;
/**
 *
 * @author <a href="mailto:toby.h.ferguson@sun.com">Toby H Ferguson</a>
 * @version $Revision: 1.4 $
 */

public class AllTest
{

    private static final Class []classes = {
        /*
         */
        S1ASCommandTest.class,
        BackupCommandsTest.class,
        BaseLifeCycleCommandTest.class,
        BaseTransformationRuleCommandTest.class,
        CreateMBeanCommandTest.class,
        CreateServiceCommandTest.class,
        DeployCommandTest.class, //53 in total
        DottedNamesCommandTest.class,
        ExportCommandTest.class,
        GenerateJVMReportCommandTest.class,
        GenerateReportCommandTest.class,
        GetClientStubsCommandTest.class,
        ListSubComponentsCommandTest.class,
        NYICommandTest.class,
        SSLCommandTest.class,
        StartAppservCommandTest.class,
        StopAppservCommandTest.class,
        StartDomainCommandTest.class,
        StopDomainCommandTest.class,
        UnsetCommandTest.class,
        VerifyDomainXmlCommandTest.class,
        WebServiceRegistryCommandTest.class,
    };
    
    public static Test suite(){
        TestSuite suite = new TestSuite("CLI Commands tests");
        for (int i = 0; i < classes.length; i++){
            suite.addTest(new TestSuite(classes[i]));
        }
        return suite;
    }
    
        
    public static void main(String args[]) {
        final TestRunner runner= new TestRunner();
        final TestResult result = runner.doRun(AllTest.suite(), false);
        System.exit(result.errorCount() + result.failureCount());
    }
// Local Variables:
// jde-ant-args: "-emacs -Dcover.class=All jcov.static jcov.report"
// End:
}
