/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.framework;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import junit.framework.*;
/**
 *
 * @author <a href="mailto:toby.h.ferguson@sun.com">Toby H Ferguson</a>
 * @version $Revision: 1.4 $
 */

public class UserOutputImplTest extends TestCase {
    public void testNullCOnstruction(){
        final UserOutputImpl ui = new UserOutputImpl(null, true);
        ui.print("message");
        ui.print((Object) "object");
        ui.println("eol");
        ui.println((Object) "eol2");
        ui.flush();
        ui.close();
    }
        
    public void testBasicConstruction() throws IOException {
        final ByteArrayOutputStreamWithClosure s = new ByteArrayOutputStreamWithClosure();
        final UserOutputImpl ui = new UserOutputImpl(s, true);
        ui.print("message");
        ui.print((Object) "object");
        ui.println("eol");
        ui.println((Object) "eol2");
        ui.flush();
        ui.close();
        assertEquals("messageobjecteol"+System.getProperty("line.separator") +"eol2"+System.getProperty("line.separator"), s.toString());
        assertTrue(s.isClosed());
    }

    public UserOutputImplTest(String name){
        super(name);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    private void nyi(){
        fail("Not Yet Implemented");
    }

    public static void main(String args[]){
        if (args.length == 0){
            junit.textui.TestRunner.run(UserOutputImplTest.class);
        } else {
            junit.textui.TestRunner.run(makeSuite(args));
        }
    }
    private static TestSuite makeSuite(String args[]){
        final TestSuite ts = new TestSuite();
        for (int i = 0; i < args.length; i++){
            ts.addTest(new UserOutputImplTest(args[i]));
        }
        return ts;
    }
}
class ByteArrayOutputStreamWithClosure extends ByteArrayOutputStream 
{
    boolean closed = false;
    public void close() throws IOException {
        super.close();
        closed = true;
    }
    public boolean isClosed(){
        return closed;
    }
}


