/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.appserv.management;

import java.util.Map;

import javax.management.ObjectName;

import com.sun.appserv.management.base.*;
import com.sun.appserv.management.ext.wsmgmt.WebServiceMgr;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.ConfigDottedNames;
import com.sun.appserv.management.ext.lb.LoadBalancer;
import com.sun.appserv.management.monitor.MonitoringDottedNames;
import com.sun.appserv.management.monitor.MonitoringRoot;
import com.sun.appserv.management.monitor.JMXMonitorMgr;
import com.sun.appserv.management.deploy.DeploymentMgr;
import com.sun.appserv.management.j2ee.J2EEDomain;

/**
	The top-level interface for an appserver domain. Access to all other
	{@link AMX} begins here.
 */
public interface DomainRoot extends Container
{
    public final static String		J2EE_TYPE	= XTypes.DOMAIN_ROOT;

    /**
      Return the name of this appserver domain.  Not to be confused with the
      JMX domain name, which may be derived from this name and is
      available from any ObjectName in AMX by calling
      {@link Util#getObjectName}

      The domain name is equivalent to the name of
      the directory containing the domain configuration.  This name
      is not part of the configuration and can only be changed by
      using a different directory to house the configuration for the
      domain.
      @return the name of the Appserver domain
     */
    public String	getAppserverDomainName();

    /**
      @return the JSR 77 J2EEDomain.
     */
    public J2EEDomain		getJ2EEDomain();

    /**
        @return the singleton DomainConfig
     */
    public DomainConfig	getDomainConfig();


    /**
        @return the singleton JMXMonitorMgr
     */
    public JMXMonitorMgr		getJMXMonitorMgr() ;

    /**
            Get the NotificationServiceMgr
     */
    public NotificationServiceMgr	getNotificationServiceMgr();

    /**
        @return the singleton SystemInfo
     */
    public SystemInfo		getSystemInfo();
	
    /**
       @return the singleton WebServiceMgr for this domain.
       @since AppServer 9.0
    */
    public WebServiceMgr getWebServiceMgr();

    /**
            Get all {@link NotificationEmitterService} instances.
            Possible kinds include those defined in {@link NotificationEmitterServiceKeys}.
            @since AppServer 9.0
     */
    public Map<String,NotificationEmitterService>
            getNotificationEmitterServiceMap();

    /**
        Get the NotificationEmitterService whose name is 
        {@link NotificationEmitterServiceKeys#DOMAIN_KEY}.  Same
        as calling <code>getNotificationEmitterServiceMap().get( DOMAIN_KEY )</code>.
       @return the singleton {@link NotificationEmitterService}.
     */
    public NotificationEmitterService 	getDomainNotificationEmitterService();


    /**
        @return the singleton {@link QueryMgr}.
     */
    public QueryMgr		getQueryMgr();

    /**
        @return the singleton {@link BulkAccess}.
     */
    public BulkAccess		getBulkAccess();

    /**
       @return the singleton {@link UploadDownloadMgr}.
     */
    public UploadDownloadMgr		getUploadDownloadMgr();

    /**
        @return the singleton {@link ConfigDottedNames}.
     */
    public ConfigDottedNames		getConfigDottedNames() ;

    /**
        @return the singleton {@link MonitoringDottedNames}
     */
    public MonitoringDottedNames	getMonitoringDottedNames() ;
        
    /**
        @return the singleton {@link MonitoringRoot}.
     */
    public MonitoringRoot		getMonitoringRoot() ;

    /**
        @return the singleton {@link DeploymentMgr}.
     */
    public DeploymentMgr		getDeploymentMgr() ;

    /**
        Get all the {@link LoadBalancer} instances
        @return Map of items, keyed by name.
        @see LoadBalancer
        @see com.sun.appserv.management.config.LoadBalancerConfig
        @since AppServer 9.0
     */
    public Map<String,LoadBalancer> getLoadBalancerMap();
    
    
    /**
        Notification type for JMX Notification issued when AMX MBeans are loaded
        and ready for use.  
        @see #getAMXReady
     */
    public static final String  AMX_READY_NOTIFICATION_TYPE =
        AMX.NOTIFICATION_PREFIX + "DomainRoot" + ".AMXReady";
        
    /**
        Poll to see if AMX is ready for use. It is more efficient to instead listen
        for a Notification of type {@link #AMX_READY_NOTIFICATION_TYPE}.  That
        should be done  by first registering the listener, then checking
        just after registration in case the Notification was issued in the ensuing
        interval just before the listener became registered.
        
        @return true if AMX is ready for use, false otherwise.
        @see #AMX_READY_NOTIFICATION_TYPE
     */
    public boolean  getAMXReady();
      
    /**
        Wait (block) until AMX is ready for use. Upon return, AMX is ready for use.
     */
    public void  waitAMXReady();
}














