/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.client;

import java.security.cert.X509Certificate;
import java.security.cert.CertificateException;

import java.security.cert.Certificate;

import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.SSLPeerUnverifiedException;

	
/**
	A default HandshakeCompletedListener which remembers the
	last HandshakeCompletedEvent that occured.  Also supports
	wrapping another HandshakeCompletedListener.
 */
public class HandshakeCompletedListenerImpl implements HandshakeCompletedListener
{
	private HandshakeCompletedListener	mListener;
	private HandshakeCompletedEvent		mEvent;
	
		public
	HandshakeCompletedListenerImpl()
	{
		this( null );
	}
	
	/**
		Create a new instance which chains to the specified 
		HandshakeCompletedListener when handshakeCompleted() is called.
		@param listener
	 */
		public
	HandshakeCompletedListenerImpl( final HandshakeCompletedListener listener )
	{
		mListener	= listener;
		mEvent		= null;
	}
	
	/**
		Remember the HandshakeCompletedEvent, then call the chained
		listener (if any) with the same event.
		
		@param event
	 */
		public synchronized void
	handshakeCompleted( final HandshakeCompletedEvent event) 
	{
		//trace( "handshakeCompleted: " + this + ":\n" +
			//HandshakeCompletedEventStringifier.stringify( event ) );
		mEvent	= event;
		
		if ( mListener != null )
		{
			mListener.handshakeCompleted( event );
		}
	}
	
	/**
		Get the last HandshakeCompletedEvent which occurred, possibly null.
	 */
		public synchronized HandshakeCompletedEvent
	getLastEvent()
	{
		return( mEvent );
	}
	
		
}







