/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/config/AdminServiceConfig.java,v 1.7 2006/03/09 20:30:22 llc Exp $
 * $Revision: 1.7 $
 * $Date: 2006/03/09 20:30:22 $
 */


package com.sun.appserv.management.config;

import java.util.Map;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Container;

/**
	 Configuration for the &lt;admin-service&gt; element.
 */
public interface AdminServiceConfig
	extends AMXConfig, PropertiesAccess, Container
{  
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.ADMIN_SERVICE_CONFIG;
	

	/**
		Calls Container.getContaineeMap( XTypes.JMX_CONNECTOR_CONFIG ).
		@return Map of JMXConnectorConfig proxies, keyed by name.
		@see com.sun.appserv.management.base.Container#getContaineeMap
	 */
	public Map<String,JMXConnectorConfig>		getJMXConnectorConfigMap();

	public String   getSystemJMXConnectorName();

	public void     setSystemJMXConnectorName( String value );

	public String   getType();

	/** Possible value for Type.  See {@link #setType} */
	public final static String	TYPE_DAS			= "das";
	/** Possible value for Type.  See {@link #setType} */
	public final static String	TYPE_SERVER			= "server";
	/** Possible value for Type.  See {@link #setType} */
	public final static String	TYPE_DAS_AND_SERVER	= "das-and-server";
	
	/**
		Valid values are:
		<ul>
		<li>{@link #TYPE_DAS}</li>
		<li>{@link #TYPE_SERVER}</li>
		<li>{@link #TYPE_DAS_AND_SERVER}</li>
		</ul>
		@param value
	*/
	public void     setType( String value );

    /** may return null if not present */
	public DASConfig	getDASConfig();
	
	/**
		Creates a new jmx-connector element.

		@param name		The name (id) of the jmx-connector.
		@param address	The IP address or host-name.
		@param port		The port of the jmx-connector-server.
		@param authRealmName	The name of the auth-realm that represents the 
		special administrative realm. All authentication (from administraive 
		GUI and CLI) will be handled by this realm.
		@param optional	Map of optional attributes
		@return A proxy to the JMXConnectorConfig MBean.
		@see JMXConnectorConfigKeys
        @since Appserver 9.0
	 */
	public JMXConnectorConfig	createJMXConnectorConfig( String name, String address, 
		String port, String authRealmName, Map<String,String> optional );
		
    /**
        @deprecated
     */
	public JMXConnectorConfig	createJMXConnectorConfig( String name, String address, 
		int port, String authRealmName, Map<String,String> optional );

	/**
		Removes a jmx-connector element.

		@param name	The name (id) of the jmx-connector.
	 */
	public void			removeJMXConnectorConfig( String name );
}




