/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.config;

import java.util.Map;
import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.XTypes;

/**
 * Configuration for the &lt;diagnostic-service&gt; for a &lt;config&gt; in
 * a domain. This element controls the output of the diagnostic information
 * collected when requested by the management clients. The actual information
 * collected is documented in product documentation.
 * @since Appserver 9.0
*/
public interface DiagnosticServiceConfig 
    extends PropertiesAccess, ConfigElement
{
    /** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
    public static final String	J2EE_TYPE    = XTypes.DIAGNOSTIC_SERVICE_CONFIG;
    
    /**
        @return true if the diagnostic service is computing the checksum for the data
     */
    public boolean getComputeChecksum();
    
    /**
        See {@link #getComputeChecksum}.
     */
    public void setComputeChecksum(final boolean value);
    
    /**
     @return true if installation log is collected for diagnosis, false otherwise
     */
    public boolean getCaptureInstallLog();
    
    /**
        See {@link #getCaptureInstallLog}.
     */
    public void setCaptureInstallLog(final boolean value);
    
    /**
     @return true if operating system information is being collected, false otherwise
     */
    public boolean getCaptureSystemInfo();
    
    /** Set capturing system information to specified value.
     */
    public void setCaptureSystemInfo(final boolean value);
    
    /**
        @return true if HA data-base information is being collected, false otherwise
     */
    public boolean getCaptureHADBInfo();
    
    /**
        See {@link #getCaptureHADBInfo}.
     */
    public void setCaptureHADBInfo(final boolean value);

    /**
        @return true if app deployment descriptor data is being collected, false otherwise
     */
    public boolean getCaptureAppDD();
    
    /**
        See {@link #getCaptureAppDD}.
     */
    public void setCaptureAppDD(final boolean value);
    
    /**
        The level at which the messages for diagnostic services will
        be retrieved. All the messages at a level equal to or more than this
        level will be captured.
        @return the log level of the messages for diagnostic service
        @see java.util.logging.Level
     */
    public String getMinLogLevel();
    
    /**
        See {@link #getMinLogLevel}.
        The specified value must be a valid {@link java.util.logging.Level}.
     */
    public void setMinLogLevel(final String level);
    
    /**
        @return number of log entries to be read from the log
        file. Defaults to 500.
     */
    public String getMaxLogEntries();
    
    /**
        See {@link #getMaxLogEntries}.
     */
    public void setMaxLogEntries(final String entries);
    
    /**                    
        Indicates whether output of verify-config asadmin command is
        included in the diagnostic report.                                               
     */
    public boolean  getVerifyConfig();
    
    /**
        See {@link #getVerifyConfig}
     */
    public void     setVerifyConfig( boolean verify );
}












