/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/config/EJBModuleConfig.java,v 1.5 2005/12/25 03:49:27 tcfujii Exp $
 * $Revision: 1.5 $
 * $Date: 2005/12/25 03:49:27 $
 */

package com.sun.appserv.management.config;

import java.util.Map;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Container;




/**
	 Configuration for the &lt;ejb-module&gt; element.
*/
public interface EJBModuleConfig
    extends ModuleConfig, Libraries, Container, WebServiceEndpointConfigCR
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.EJB_MODULE_CONFIG;
	


	/**
		This boolean flag controls whether availability is enabled    
		for SFSB checkpointing (and potentially passivation). If this 
		is "false", then all SFSB checkpointing is disabled for       
		either the given j2ee app or the given ejb module. If it is   
		"true" (and providing that all the availability-enabled       
		attributes above in precedence are also "true", then the j2ee 
		app or stand-alone ejb modules may be ha enabled.             
		Finer-grained control exists at lower level inside each bean.
		@see #setAvailabilityEnabled
	 */
	public boolean	getAvailabilityEnabled();

	/**
		@see #getAvailabilityEnabled
	*/       
	public void		setAvailabilityEnabled( boolean enabled );
	
	
    public Map<String,WebServiceEndpointConfig> getWebServiceEndpointConfigMap();
}
