/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.config;


import java.util.Map;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Container;


/**
    Manipulates management rules.
    
	@since Appserver 9.0
*/

public interface ManagementRulesConfig
    extends ConfigElement, Container, Enabled
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType} */
	public static final String	J2EE_TYPE	= XTypes.MANAGEMENT_RULES_CONFIG;
	
	public Map<String,ManagementRuleConfig> getManagementRuleConfigMap();
	
	/** For use with createManagementRuleConfig() specifying description of the rule (String)*/
	public static final String RULE_DESCRIPTION_KEY  = "Description";
	
	/** For use with createManagementRuleConfig() specifying whether the rule is to be enabled (Boolean)*/
	public static final String RULE_ENABLED_KEY      = "Enabled";
	
	/** For use with createManagementRuleConfig() specifying whether event logging is to be enabled (Boolean)*/
	public static final String EVENT_LOG_ENABLED_KEY  = "EventLogEnabled";
	
	/** For use with createManagementRuleConfig() specifying Event Level [default=INFO] (String)*/
	public static final String EVENT_LEVEL_KEY  = "EventLevel";
	
	/** For use with createManagementRuleConfig() specifying Event properties (Properties)*/
	public static final String EVENT_PROPERTIES_KEY  = "EventProperties";
	
	/** For use with createManagementRuleConfig() specifying Event description (String)*/
	public static final String EVENT_DESCRIPTION_KEY  = "EventDescription";
	
    /**
        Create new self management rule. In addition to the formal parameters, the following
        optional parameters may be specified:
        <ul>
        <li>{@link #RULE_DESCRIPTION_KEY}</li>
        <li>{@link #RULE_ENABLED_KEY}</li>
        <li>{@link #EVENT_DESCRIPTION_KEY}</li>
        <li>{@link #EVENT_LOG_ENABLED_KEY}</li>
        <li>{@link #EVENT_LEVEL_KEY}</li>
        <li>{@link #EVENT_PROPERTIES_KEY}</li>
        </ul>
        
        @param ruleName          name of the management rule. Required.
        @param eventType         one of the values defined in {@link EventTypeValues}
        @param actionMBeanName   actionMbeanName associated with rule  (optional)
        @param optional optional additional values

        @return ObjectName of created management-rule
        @throws Exception
        @see EventTypeValues
     */
    public ManagementRuleConfig createManagementRuleConfig(
                String  ruleName,
                String  eventType,
                String  actionMBeanName,
                Map<String,String> optional );
	                                    
	public void removeManagementRuleConfig( String name );
}












