/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/config/MessageSecurityConfig.java,v 1.6 2006/03/09 20:30:24 llc Exp $
 * $Revision: 1.6 $
 * $Date: 2006/03/09 20:30:24 $
 */

package com.sun.appserv.management.config;

import java.util.Map;



import com.sun.appserv.management.base.XTypes;



import com.sun.appserv.management.base.Container;

/**
    Configuration for the &lt;message-security-config&gt; element.
*/
public interface MessageSecurityConfig 
	extends NamedConfigElement, Container
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.MESSAGE_SECURITY_CONFIG;

    /**
        One of the values defined by {@link MessageLayerValues}.
     */
	public String	getAuthLayer();

	public String	getDefaultClientProvider();
	public void	setDefaultClientProvider( final String value );

	public String	getDefaultProvider();
	public void	setDefaultProvider( final String value );
	
	
	/**
	 Create a new &lt;provider-config&gt;
	 
	 @param providerId unique id for this provider
	 @param providerType client or server authentication type
	 @param className implementation class of the provider
	 @param reservedForFutureUse placeholder for future attributes

	 @return The proxy to the ProviderConfig MBean.
	*/
	public ProviderConfig createProviderConfig(String providerId, String providerType, 
	    String className, Map<String,String> reservedForFutureUse);


	/**
	 Removes an existing provider config.
	     
	 @param providerId the id of the provider config to be removed.
	*/
	public void removeProviderConfig(String providerId);


	/**
		@return A map of ProviderConfig MBean proxies keyed on provider-id.
	 */
	public Map<String,ProviderConfig>	getProviderConfigMap();
}
