/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/config/ModuleMonitoringLevelsConfig.java,v 1.4 2006/03/09 20:30:24 llc Exp $
 * $Revision: 1.4 $
 * $Date: 2006/03/09 20:30:24 $
 */


package com.sun.appserv.management.config;

import java.util.Map;

import com.sun.appserv.management.base.XTypes;



/**
	Configuration for the &lt;module-monitoring-levels&gt; element.
	
	Each monitoring level can be one of the values defined in
	{@link ModuleMonitoringLevelValues}.
 */
public interface ModuleMonitoringLevelsConfig extends ConfigElement, PropertiesAccess
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.MODULE_MONITORING_LEVELS_CONFIG;
	
	/**
		Get a Map keyed by Attribute name of all monitoring levels.
		Attribute names correspond to the various get methods eg
		"JVM" for {@link #getJVM},
		"ConnectorService" for {@link #getConnectorService}, etc.
		<p>
		The possible levels are as defined in {@link ModuleMonitoringLevelValues}.
	 */
	public Map<String,String>		getAllLevels();
	
	/**
		Change all monitoring levels to the specified value.
		
		@param value one of the values in {@link ModuleMonitoringLevelValues}
	 */
	public void		changeAll( final String value );
	
	public String	getJVM();
	
	/** @param value one of the values in {@link ModuleMonitoringLevelValues} */
	public void		setJVM( final String value );
	
	public String	getConnectorService();
	/** @param value one of the values in {@link ModuleMonitoringLevelValues} */
	public void		setConnectorService( final String value );
	
	public String	getJMSService();
	/** @param value one of the values in {@link ModuleMonitoringLevelValues} */
	public void		setJMSService( final String value );
	
	public String   getConnectorConnectionPool();
	/** @param value one of the values in {@link ModuleMonitoringLevelValues} */
	public void     setConnectorConnectionPool( final String value );

	public String   getEJBContainer();
	/** @param value one of the values in {@link ModuleMonitoringLevelValues} */
	public void     setEJBContainer( final String value );

	public String   getHTTPService();
	/** @param value one of the values in {@link ModuleMonitoringLevelValues} */
	public void     setHTTPService( final String value );

	public String   getJDBCConnectionPool();
	/** @param value one of the values in {@link ModuleMonitoringLevelValues} */
	public void     setJDBCConnectionPool( final String value );

	public String   getORB();
	/** @param value one of the values in {@link ModuleMonitoringLevelValues} */
	public void     setORB( final String value );

	public String   getThreadPool();
	/** @param value one of the values in {@link ModuleMonitoringLevelValues} */
	public void     setThreadPool( final String value );

	public String   getTransactionService();
	/** @param value one of the values in {@link ModuleMonitoringLevelValues} */
	public void     setTransactionService( final String value );

	public String   getWebContainer();
	/** @param value one of the values in {@link ModuleMonitoringLevelValues} */
	public void     setWebContainer( final String value );




}
