/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.appserv.management.config;

import com.sun.appserv.management.base.XTypes;

/**
	Sub-element of {@link WebServiceEndpointConfig}.
	
	@since AppServer 9.0
 */
public interface TransformationRuleConfig extends NamedConfigElement, Enabled
{
	public static final String	J2EE_TYPE	= XTypes.TRANSFORMATION_RULE_CONFIG;
	
	public static final String  APPLY_TO_REQUEST   = "request";
	public static final String  APPLY_TO_RESPONSE  = "response";
	public static final String  APPLY_TO_BOTH      = "both";
	
	/**
	 One of {@link #APPLY_TO_REQUEST}, {@link #APPLY_TO_RESPONSE}, {@link #APPLY_TO_BOTH}.
	 */
	public String   getApplyTo();
	
	/**
	    @see #getApplyTo
	 */
	public void     setApplyTo( String value );
	
	/**
	* Gets the transformation rule file location.
	*
	* @return File path for this transformation rule
	*/
	public String getRuleFileLocation();
	
	/**
	* Sets the transformation rule file location.
	* WARNING: Rule file must exist in the new location.
	*
	* @param name File path for this transformation rule
	*/
	public void setRuleFileLocation(String name);
}