/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/j2ee/statistics/MapStatistic.java,v 1.4 2006/03/09 20:30:29 llc Exp $
 * $Revision: 1.4 $
 * $Date: 2006/03/09 20:30:29 $
 */

package com.sun.appserv.management.j2ee.statistics;

import java.util.Set;
import java.util.Map;

import javax.management.j2ee.statistics.Statistic;

/**
	A Statistic which contains its members in a Map.
 */
public interface MapStatistic extends Statistic
{
	/**
		Get a Statistic value which is expected to be a Long (long)
	 */
	public long	getlong( String name );
	
	/**
		Get a Statistic value which is expected to be an Integer (int)
	 */
	public int	getint( String name );
	
	
	/**
		Get a Statistic value which is expected to be a String
	 */
	public String	getString( String name );

	
	/**
		Get a Statistic value which is expected to be any Object
	 */
	public Object	getValue( String name );
	
	/**
		Set the name of this Statistic
	 */
	public String	setName( final String newName );

	
	/**
		Get the values associated with this statistic.
		
		Note the name--"get" is avoided so it won't be introspected
		as another Statistic field.
		
		@return an unmodifiableSet of the field names (String)
	 */
	public Set	valueNames();
	
	
	public Map<String,Object> asMap();
	public String	toString();
}





