/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/j2ee/statistics/StringStatisticImpl.java,v 1.4 2006/03/09 20:30:29 llc Exp $
 * $Revision: 1.4 $
 * $Date: 2006/03/09 20:30:29 $
 */

package com.sun.appserv.management.j2ee.statistics;

import java.util.Map;
import java.io.Serializable;

import javax.management.openmbean.CompositeData;

import com.sun.appserv.management.util.jmx.OpenMBeanUtil;

import com.sun.appserv.management.j2ee.statistics.StatisticImpl;

/**
	
 */
public final class StringStatisticImpl
	extends StatisticImpl implements StringStatistic, Serializable
{
	static final long serialVersionUID = 2090185734375468511L;
	
	private final String	mCurrent;
	
		public
	StringStatisticImpl( final CompositeData compositeData )
	{
		this( OpenMBeanUtil.compositeDataToMap( compositeData ) );
	}
	
		public
	StringStatisticImpl( final Map<String,?> m )
	{
		this( new MapStatisticImpl( m ) );
	}
	
		public
	StringStatisticImpl( final StringStatistic s )
	{
		super( s );
		
		mCurrent	= s.getCurrent();
	}
	
		public
	StringStatisticImpl( final MapStatistic m )
	{
		super( m );
		
		mCurrent	= m.getString( "Current" );
	}
	
		public
	StringStatisticImpl(
		final String	name,
		final String	description,
		final String	unit,
		final long		startTime,
		final long		lastSampleTime,
		final String	current )
	{
		super( name, description, unit, startTime, lastSampleTime );
		mCurrent	= current;
	}


 		public String
 	getCurrent()
 	{
 		return( mCurrent );
 	}
}





