/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/util/jmx/AttributeChangeNotificationBuilder.java,v 1.3 2005/12/25 03:51:20 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:51:20 $
 */

package com.sun.appserv.management.util.jmx;

import javax.management.Notification;
import javax.management.AttributeChangeNotification;
import javax.management.ObjectName;

/**
	Base class for building AMX Notifications.
 */
public class AttributeChangeNotificationBuilder extends NotificationBuilder
{
		public
	AttributeChangeNotificationBuilder(
		final ObjectName	source )
	{
		super( AttributeChangeNotification.ATTRIBUTE_CHANGE, source );
	}

		public final Notification
	buildNew()
	{
		throw new IllegalArgumentException();
	}
	
		public final Notification
	buildNew(
		final String	key,
		final Object	value )
	{
		throw new IllegalArgumentException();
	}
	
		public final AttributeChangeNotification
	buildAttributeChange(
		final String	msg,
		final String	attributeName,
		final String	attributeType,
		final Object	oldValue,
		final Object	newValue )
	{
		final AttributeChangeNotification notif	= new AttributeChangeNotification(
			getSource(),
			nextSequenceNumber(),
			now(),
			msg,
			attributeName,
			attributeType,
			oldValue,
			newValue );
		
		return( notif );
	}
}





