/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/util/jmx/MBeanGeneratorHook.java,v 1.3 2005/12/25 03:51:24 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:51:24 $
 */
 

package com.sun.appserv.management.util.jmx;


import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;

import com.sun.appserv.management.util.misc.ClassUtil;

/**
	Hook to be passed to MBeanGenerator
 */
public interface MBeanGeneratorHook
{
	public String		getPackageName( MBeanInfo info );
	public String		getClassname( MBeanInfo info );
	public String		getExceptions( MBeanOperationInfo info );
	public String[]		getParamNames( MBeanOperationInfo info );
	
	public String		getHeaderComment( MBeanInfo info );
	public String		getInterfaceComment( MBeanInfo info );
	public String		getGetterComment( MBeanAttributeInfo info, String actualName );
	public String		getSetterComment( MBeanAttributeInfo info, String actualName );
	public String		getOperationComment( MBeanOperationInfo info, String[] paramNames );
}






